/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.work.ForegroundInfo;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;

public abstract class Worker
extends ListenableWorker {
    SettableFuture<ListenableWorker.Result> mFuture;

    public Worker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @WorkerThread
    @NonNull
    public abstract ListenableWorker.Result doWork();

    @Override
    @NonNull
    public final ListenableFuture<ListenableWorker.Result> startWork() {
        this.mFuture = SettableFuture.create();
        this.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenableWorker.Result result = Worker.this.doWork();
                    Worker.this.mFuture.set(result);
                }
                catch (Throwable throwable) {
                    Worker.this.mFuture.setException(throwable);
                }
            }
        });
        return this.mFuture;
    }

    @Override
    @NonNull
    public ListenableFuture<ForegroundInfo> getForegroundInfoAsync() {
        final SettableFuture<ForegroundInfo> future = SettableFuture.create();
        this.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ForegroundInfo info = Worker.this.getForegroundInfo();
                    future.set(info);
                }
                catch (Throwable throwable) {
                    future.setException(throwable);
                }
            }
        });
        return future;
    }

    @WorkerThread
    @NonNull
    public ForegroundInfo getForegroundInfo() {
        throw new IllegalStateException("Expedited WorkRequests require a Worker to provide an implementation for \n `getForegroundInfo()`");
    }
}

