/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.work.Data;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkProgressDao;
import java.util.Collections;
import java.util.List;

public final class WorkProgressDao_Impl
implements WorkProgressDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WorkProgress> __insertionAdapterOfWorkProgress;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public WorkProgressDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfWorkProgress = new EntityInsertionAdapter<WorkProgress>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WorkProgress` (`work_spec_id`,`progress`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, WorkProgress value) {
                if (value.getWorkSpecId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getWorkSpecId());
                }
                byte[] _tmp = Data.toByteArrayInternal(value.getProgress());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindBlob(2, _tmp);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from WorkProgress where work_spec_id=?";
                return "DELETE from WorkProgress where work_spec_id=?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM WorkProgress";
                return "DELETE FROM WorkProgress";
            }
        };
    }

    @Override
    public void insert(WorkProgress progress) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfWorkProgress.insert((Object)progress);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String workSpecId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (workSpecId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, workSpecId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getProgressForWorkSpecId(String workSpecId) {
        String _sql = "SELECT progress FROM WorkProgress WHERE work_spec_id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT progress FROM WorkProgress WHERE work_spec_id=?", (int)1);
        int _argIndex = 1;
        if (workSpecId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, workSpecId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Data _result;
            if (_cursor.moveToFirst()) {
                byte[] _tmp = _cursor.isNull(0) ? null : _cursor.getBlob(0);
                _result = Data.fromByteArray(_tmp);
            } else {
                _result = null;
            }
            Data data = _result;
            return data;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

