/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/work/lint/InvalidPeriodicWorkRequestIntervalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Companion", "work-runtime-lint"})
public final class InvalidPeriodicWorkRequestIntervalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"androidx.work.PeriodicWorkRequest.Builder");
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        block49: {
            Long interval;
            String source;
            Regex regexp;
            MatchResult matchResult;
            String type;
            block50: {
                Long interval2;
                Pair units;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                if (node.getValueArgumentCount() < 2) break block49;
                PsiType psiType = ((UExpression)node.getValueArguments().get(1)).getExpressionType();
                String string = type = psiType == null ? null : psiType.getCanonicalText();
                if (!Intrinsics.areEqual((Object)"long", (Object)type)) break block50;
                Object object = ((UExpression)node.getValueArguments().get(1)).evaluate();
                Long value = object instanceof Long ? (Long)object : null;
                Object object2 = ((UExpression)node.getValueArguments().get(2)).evaluate();
                Pair pair = units = object2 instanceof Pair ? (Pair)object2 : null;
                if (value == null || units == null) break block49;
                Name timeUnitType = (Name)units.component2();
                switch (timeUnitType.getIdentifier()) {
                    case "NANOSECONDS": {
                        Long l = TimeUnit.MINUTES.convert(value, TimeUnit.NANOSECONDS);
                        break;
                    }
                    case "MICROSECONDS": {
                        Long l = TimeUnit.MINUTES.convert(value, TimeUnit.MICROSECONDS);
                        break;
                    }
                    case "MILLISECONDS": {
                        Long l = TimeUnit.MINUTES.convert(value, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "SECONDS": {
                        Long l = TimeUnit.MINUTES.convert(value, TimeUnit.SECONDS);
                        break;
                    }
                    case "MINUTES": {
                        Long l = value;
                        break;
                    }
                    case "HOURS": {
                        Long l = TimeUnit.MINUTES.convert(value, TimeUnit.HOURS);
                        break;
                    }
                    case "DAYS": {
                        Long l = TimeUnit.MINUTES.convert(value, TimeUnit.DAYS);
                        break;
                    }
                    default: {
                        Long l = interval2 = null;
                    }
                }
                if (interval2 != null && interval2 < 15L) {
                    Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)"Interval duration for `PeriodicWorkRequest`s must be at least 15 \\\nminutes.", null, (int)8, null);
                }
                break block49;
            }
            if (!Intrinsics.areEqual((Object)"java.time.Duration", (Object)type) || (matchResult = (regexp = new Regex("Duration.of(\\w+)\\((\\d+)\\)")).matchEntire((CharSequence)(source = ((UExpression)node.getValueArguments().get(1)).asSourceString()))) == null) break block49;
            String unit = (String)matchResult.getGroupValues().get(1);
            long value = Long.parseLong((String)matchResult.getGroupValues().get(2));
            switch (unit) {
                case "Nanos": {
                    Long l = TimeUnit.MINUTES.convert(value, TimeUnit.NANOSECONDS);
                    break;
                }
                case "Millis": {
                    Long l = TimeUnit.MINUTES.convert(value, TimeUnit.MILLISECONDS);
                    break;
                }
                case "Seconds": {
                    Long l = TimeUnit.MINUTES.convert(value, TimeUnit.SECONDS);
                    break;
                }
                case "Minutes": {
                    Long l = value;
                    break;
                }
                case "Hours": {
                    Long l = TimeUnit.MINUTES.convert(value, TimeUnit.HOURS);
                    break;
                }
                case "Days": {
                    Long l = TimeUnit.MINUTES.convert(value, TimeUnit.DAYS);
                    break;
                }
                default: {
                    Long l = interval = null;
                }
            }
            if (interval != null && interval < 15L) {
                Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)"Interval duration for `PeriodicWorkRequest`s must be at least 15 \\\nminutes.", null, (int)8, null);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(InvalidPeriodicWorkRequestIntervalDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"InvalidPeriodicWorkRequestInterval", (String)"Invalid interval duration", (String)"\n                The interval duration for a `PeriodicWorkRequest` must be at least 15 minutes.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/lint/InvalidPeriodicWorkRequestIntervalDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

