/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.w3c.dom.Element;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/work/lint/SpecifyForegroundServiceTypeIssueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "knownServiceTypes", "", "", "getApplicableConstructorTypes", "", "getApplicableElements", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "work-runtime-lint"})
public final class SpecifyForegroundServiceTypeIssueDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> knownServiceTypes = new LinkedHashSet();
    @NotNull
    private static final Issue ISSUE;
    @NotNull
    private static final Map<Integer, String> SERVICE_TYPE_MAPPING;

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"androidx.work.ForegroundInfo");
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"service");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        String serviceTypes;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (Intrinsics.areEqual((Object)"androidx.work.impl.foreground.SystemForegroundService", (Object)name) && (serviceTypes = element.getAttributeNS("http://schemas.android.com/apk/res/android", "foregroundServiceType")) != null) {
            Collection collection = this.knownServiceTypes;
            String[] stringArray = new String[]{"|"};
            CollectionsKt.addAll((Collection)collection, (Iterable)StringsKt.split$default((CharSequence)serviceTypes, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Object type;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        if (node.getValueArgumentCount() > 2 && (type = ((UExpression)node.getValueArguments().get(2)).evaluate()) != null && type instanceof Integer && ((Number)type).intValue() > 0) {
            for (Map.Entry<Integer, String> entry : SERVICE_TYPE_MAPPING.entrySet()) {
                int mask = ((Number)entry.getKey()).intValue();
                String name = entry.getValue();
                if ((((Number)type).intValue() & mask) <= 0 || this.knownServiceTypes.contains(name)) continue;
                Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)("Missing " + name + " foregroundServiceType in the AndroidManifest.xml"), null, (int)8, null);
            }
        }
    }

    static {
        Pair[] pairArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(SpecifyForegroundServiceTypeIssueDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST));
        ISSUE = Issue.Companion.create$default((Issue.Companion)pairArray, (String)"SpecifyForegroundServiceType", (String)"Specify foreground service type", (String)"\n                When using the setForegroundAsync() API, the application must override <service /> \\\n                entry for `SystemForegroundService` to include the foreground service type in the \\\n                 `AndroidManifest.xml` file.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)"dataSync"), TuplesKt.to((Object)2, (Object)"mediaPlayback"), TuplesKt.to((Object)4, (Object)"phoneCall"), TuplesKt.to((Object)8, (Object)"location"), TuplesKt.to((Object)16, (Object)"connectedDevice"), TuplesKt.to((Object)32, (Object)"mediaProjection")};
        SERVICE_TYPE_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/work/lint/SpecifyForegroundServiceTypeIssueDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "SERVICE_TYPE_MAPPING", "", "", "", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

