/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.Api21Impl;
import androidx.work.impl.WorkDatabasePathHelperKt;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Landroidx/work/impl/WorkDatabasePathHelper;", "", "()V", "getDatabasePath", "Ljava/io/File;", "context", "Landroid/content/Context;", "getDefaultDatabasePath", "getNoBackupPath", "migrateDatabase", "", "migrationPaths", "", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class WorkDatabasePathHelper {
    @NotNull
    public static final WorkDatabasePathHelper INSTANCE = new WorkDatabasePathHelper();

    private WorkDatabasePathHelper() {
    }

    @JvmStatic
    public static final void migrateDatabase(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File defaultDatabasePath = INSTANCE.getDefaultDatabasePath(context);
        if (Build.VERSION.SDK_INT >= 23 && defaultDatabasePath.exists()) {
            Logger.get().debug(WorkDatabasePathHelperKt.access$getTAG$p(), "Migrating WorkDatabase to the no-backup directory");
            Map<File, File> $this$forEach$iv = INSTANCE.migrationPaths(context);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<File, File>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean renamed;
                Map.Entry<File, File> element$iv;
                Map.Entry<File, File> entry = element$iv = iterator.next();
                boolean bl = false;
                File source = entry.getKey();
                File destination = entry.getValue();
                if (!source.exists()) continue;
                if (destination.exists()) {
                    Logger.get().warning(WorkDatabasePathHelperKt.access$getTAG$p(), "Over-writing contents of " + destination);
                }
                String message = (renamed = source.renameTo(destination)) ? "Migrated " + source + "to " + destination : "Renaming " + source + " to " + destination + " failed";
                Logger.get().debug(WorkDatabasePathHelperKt.access$getTAG$p(), message);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<File, File> migrationPaths(@NotNull Context context) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$associateTo$iv$iv;
            File databasePath = this.getDefaultDatabasePath(context);
            File migratedPath = this.getDatabasePath(context);
            String[] $this$associate$iv = WorkDatabasePathHelperKt.access$getDATABASE_EXTRA_FILES$p();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
            String[] stringArray = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                void extra = element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)new File(databasePath.getPath() + (String)extra), (Object)new File(migratedPath.getPath() + (String)extra));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = destination$iv$iv;
            map = MapsKt.plus((Map)map3, (Pair)TuplesKt.to((Object)databasePath, (Object)migratedPath));
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final File getDefaultDatabasePath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getDatabasePath("androidx.work.workdb");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDatabasePath(WORK_DATABASE_NAME)");
        return file;
    }

    @NotNull
    public final File getDatabasePath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 23 ? this.getDefaultDatabasePath(context) : this.getNoBackupPath(context);
    }

    @RequiresApi(value=23)
    private final File getNoBackupPath(Context context) {
        return new File(Api21Impl.INSTANCE.getNoBackupFilesDir(context), "androidx.work.workdb");
    }
}

