/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.work.Operation;
import androidx.work.WorkInfo;
import androidx.work.impl.OperationImpl;
import androidx.work.impl.Processor;
import androidx.work.impl.Scheduler;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.PreferenceUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class CancelWorkRunnable
implements Runnable {
    private final OperationImpl mOperation = new OperationImpl();

    @NonNull
    public Operation getOperation() {
        return this.mOperation;
    }

    @Override
    public void run() {
        try {
            this.runInternal();
            this.mOperation.markState(Operation.SUCCESS);
        }
        catch (Throwable throwable) {
            this.mOperation.markState(new Operation.State.FAILURE(throwable));
        }
    }

    abstract void runInternal();

    void cancel(WorkManagerImpl workManagerImpl, String workSpecId) {
        this.iterativelyCancelWorkAndDependents(workManagerImpl.getWorkDatabase(), workSpecId);
        Processor processor = workManagerImpl.getProcessor();
        processor.stopAndCancelWork(workSpecId);
        for (Scheduler scheduler : workManagerImpl.getSchedulers()) {
            scheduler.cancel(workSpecId);
        }
    }

    void reschedulePendingWorkers(WorkManagerImpl workManagerImpl) {
        Schedulers.schedule(workManagerImpl.getConfiguration(), workManagerImpl.getWorkDatabase(), workManagerImpl.getSchedulers());
    }

    private void iterativelyCancelWorkAndDependents(WorkDatabase workDatabase, String workSpecId) {
        WorkSpecDao workSpecDao = workDatabase.workSpecDao();
        DependencyDao dependencyDao = workDatabase.dependencyDao();
        LinkedList<String> idsToProcess = new LinkedList<String>();
        idsToProcess.add(workSpecId);
        while (!idsToProcess.isEmpty()) {
            String id = (String)idsToProcess.remove();
            WorkInfo.State state = workSpecDao.getState(id);
            if (state != WorkInfo.State.SUCCEEDED && state != WorkInfo.State.FAILED) {
                workSpecDao.setState(WorkInfo.State.CANCELLED, id);
            }
            idsToProcess.addAll(dependencyDao.getDependentWorkIds(id));
        }
    }

    @NonNull
    public static CancelWorkRunnable forId(final @NonNull UUID id, final @NonNull WorkManagerImpl workManagerImpl) {
        return new CancelWorkRunnable(){

            @Override
            @WorkerThread
            void runInternal() {
                WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
                workDatabase.beginTransaction();
                try {
                    this.cancel(workManagerImpl, id.toString());
                    workDatabase.setTransactionSuccessful();
                }
                finally {
                    workDatabase.endTransaction();
                }
                this.reschedulePendingWorkers(workManagerImpl);
            }
        };
    }

    @NonNull
    public static CancelWorkRunnable forTag(final @NonNull String tag, final @NonNull WorkManagerImpl workManagerImpl) {
        return new CancelWorkRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @WorkerThread
            void runInternal() {
                WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
                workDatabase.beginTransaction();
                try {
                    WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                    List<String> workSpecIds = workSpecDao.getUnfinishedWorkWithTag(tag);
                    for (String workSpecId : workSpecIds) {
                        this.cancel(workManagerImpl, workSpecId);
                    }
                    workDatabase.setTransactionSuccessful();
                }
                finally {
                    workDatabase.endTransaction();
                }
                this.reschedulePendingWorkers(workManagerImpl);
            }
        };
    }

    @NonNull
    public static CancelWorkRunnable forName(final @NonNull String name, final @NonNull WorkManagerImpl workManagerImpl, final boolean allowReschedule) {
        return new CancelWorkRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @WorkerThread
            void runInternal() {
                WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
                workDatabase.beginTransaction();
                try {
                    WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                    List<String> workSpecIds = workSpecDao.getUnfinishedWorkWithName(name);
                    for (String workSpecId : workSpecIds) {
                        this.cancel(workManagerImpl, workSpecId);
                    }
                    workDatabase.setTransactionSuccessful();
                }
                finally {
                    workDatabase.endTransaction();
                }
                if (allowReschedule) {
                    this.reschedulePendingWorkers(workManagerImpl);
                }
            }
        };
    }

    @NonNull
    public static CancelWorkRunnable forAll(final @NonNull WorkManagerImpl workManagerImpl) {
        return new CancelWorkRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @WorkerThread
            void runInternal() {
                WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
                workDatabase.beginTransaction();
                try {
                    WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                    List<String> workSpecIds = workSpecDao.getAllUnfinishedWork();
                    for (String workSpecId : workSpecIds) {
                        this.cancel(workManagerImpl, workSpecId);
                    }
                    new PreferenceUtils(workManagerImpl.getWorkDatabase()).setLastCancelAllTimeMillis(workManagerImpl.getConfiguration().getClock().currentTimeMillis());
                    workDatabase.setTransactionSuccessful();
                }
                finally {
                    workDatabase.endTransaction();
                }
            }
        };
    }
}

