/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.workers;

import android.content.Context;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.WorkNameDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.workers.DiagnosticsWorkerKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Landroidx/work/impl/workers/DiagnosticsWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "parameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "work-runtime_release"})
public final class DiagnosticsWorker
extends Worker {
    public DiagnosticsWorker(@NotNull Context context, @NotNull WorkerParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        super(context, parameters);
    }

    @Override
    @NotNull
    public ListenableWorker.Result doWork() {
        WorkManagerImpl workManagerImpl = WorkManagerImpl.getInstance(this.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)workManagerImpl, (String)"getInstance(applicationContext)");
        WorkManagerImpl workManager = workManagerImpl;
        WorkDatabase workDatabase = workManager.getWorkDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workManager.workDatabase");
        WorkDatabase database = workDatabase;
        WorkSpecDao workSpecDao = database.workSpecDao();
        WorkNameDao workNameDao = database.workNameDao();
        WorkTagDao workTagDao = database.workTagDao();
        SystemIdInfoDao systemIdInfoDao = database.systemIdInfoDao();
        long startAt = workManager.getConfiguration().getClock().currentTimeMillis() - TimeUnit.DAYS.toMillis(1L);
        List<WorkSpec> completed = workSpecDao.getRecentlyCompletedWork(startAt);
        List<WorkSpec> running = workSpecDao.getRunningWork();
        List<WorkSpec> enqueued = workSpecDao.getAllEligibleWorkSpecsForScheduling(200);
        if (!((Collection)completed).isEmpty()) {
            Logger.get().info(DiagnosticsWorkerKt.access$getTAG$p(), "Recently completed work:\n\n");
            Logger.get().info(DiagnosticsWorkerKt.access$getTAG$p(), DiagnosticsWorkerKt.access$workSpecRows(workNameDao, workTagDao, systemIdInfoDao, completed));
        }
        if (!((Collection)running).isEmpty()) {
            Logger.get().info(DiagnosticsWorkerKt.access$getTAG$p(), "Running work:\n\n");
            Logger.get().info(DiagnosticsWorkerKt.access$getTAG$p(), DiagnosticsWorkerKt.access$workSpecRows(workNameDao, workTagDao, systemIdInfoDao, running));
        }
        if (!((Collection)enqueued).isEmpty()) {
            Logger.get().info(DiagnosticsWorkerKt.access$getTAG$p(), "Enqueued work:\n\n");
            Logger.get().info(DiagnosticsWorkerKt.access$getTAG$p(), DiagnosticsWorkerKt.access$workSpecRows(workNameDao, workTagDao, systemIdInfoDao, enqueued));
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }
}

