/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.testing;

import androidx.annotation.NonNull;
import androidx.work.impl.utils.SerialExecutor;
import androidx.work.impl.utils.SynchronousExecutor;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.concurrent.Executor;

class InstantWorkTaskExecutor
implements TaskExecutor {
    private Executor mSynchronousExecutor = new SynchronousExecutor();
    private SerialExecutor mSerialExecutor = new SerialExecutor(this.mSynchronousExecutor);

    InstantWorkTaskExecutor() {
    }

    @NonNull
    Executor getSynchronousExecutor() {
        return this.mSynchronousExecutor;
    }

    public void postToMainThread(Runnable runnable) {
        runnable.run();
    }

    public Executor getMainThreadExecutor() {
        return this.mSynchronousExecutor;
    }

    public void executeOnBackgroundThread(Runnable runnable) {
        this.mSerialExecutor.execute(runnable);
    }

    public SerialExecutor getBackgroundExecutor() {
        return this.mSerialExecutor;
    }
}

