/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.testing;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Network;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.ForegroundUpdater;
import androidx.work.ListenableWorker;
import androidx.work.ProgressUpdater;
import androidx.work.WorkRequest;
import androidx.work.WorkerFactory;
import androidx.work.WorkerParameters;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.testing.InstantWorkTaskExecutor;
import androidx.work.testing.TestForegroundUpdater;
import androidx.work.testing.TestProgressUpdater;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

public class TestListenableWorkerBuilder<W extends ListenableWorker> {
    private Context mContext;
    private Class<W> mWorkerClass;
    private String mWorkerName;
    private UUID mId;
    private Data mInputData;
    private List<String> mTags;
    private int mRunAttemptCount;
    private WorkerParameters.RuntimeExtras mRuntimeExtras;
    private WorkerFactory mWorkerFactory;
    private TaskExecutor mTaskExecutor;
    private Executor mExecutor;
    private ProgressUpdater mProgressUpdater;
    private ForegroundUpdater mForegroundUpdater;

    TestListenableWorkerBuilder(@NonNull Context context, @NonNull Class<W> workerClass) {
        this.mContext = context;
        this.mWorkerClass = workerClass;
        this.mWorkerName = this.mWorkerClass.getName();
        this.mId = UUID.randomUUID();
        this.mInputData = Data.EMPTY;
        this.mTags = Collections.emptyList();
        this.mRunAttemptCount = 1;
        this.mRuntimeExtras = new WorkerParameters.RuntimeExtras();
        this.mWorkerFactory = WorkerFactory.getDefaultWorkerFactory();
        this.mTaskExecutor = new InstantWorkTaskExecutor();
        this.mExecutor = this.mTaskExecutor.getBackgroundExecutor();
        this.mProgressUpdater = new TestProgressUpdater();
        this.mForegroundUpdater = new TestForegroundUpdater();
    }

    @NonNull
    Context getApplicationContext() {
        return this.mContext;
    }

    Class<W> getWorkerClass() {
        return this.mWorkerClass;
    }

    @NonNull
    String getWorkerName() {
        return this.mWorkerName;
    }

    @NonNull
    UUID getId() {
        return this.mId;
    }

    @NonNull
    Data getInputData() {
        return this.mInputData;
    }

    @NonNull
    List<String> getTags() {
        return this.mTags;
    }

    int getRunAttemptCount() {
        return this.mRunAttemptCount;
    }

    @NonNull
    WorkerParameters.RuntimeExtras getRuntimeExtras() {
        return this.mRuntimeExtras;
    }

    @NonNull
    WorkerFactory getWorkerFactory() {
        return this.mWorkerFactory;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    TaskExecutor getTaskExecutor() {
        return this.mTaskExecutor;
    }

    @NonNull
    Executor getExecutor() {
        return this.mExecutor;
    }

    @NonNull
    ProgressUpdater getProgressUpdater() {
        return this.mProgressUpdater;
    }

    @NonNull
    @SuppressLint(value={"KotlinPropertyAccess"})
    ForegroundUpdater getForegroundUpdater() {
        return this.mForegroundUpdater;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setId(@NonNull UUID id) {
        this.mId = id;
        return this;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setInputData(@NonNull Data inputData) {
        this.mInputData = inputData;
        return this;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setTags(@NonNull List<String> tags) {
        this.mTags = tags;
        return this;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setRunAttemptCount(int runAttemptCount) {
        this.mRunAttemptCount = runAttemptCount;
        return this;
    }

    @RequiresApi(value=24)
    @NonNull
    public TestListenableWorkerBuilder<W> setTriggeredContentUris(@NonNull List<Uri> contentUris) {
        this.mRuntimeExtras.triggeredContentUris = contentUris;
        return this;
    }

    @RequiresApi(value=24)
    @NonNull
    public TestListenableWorkerBuilder<W> setTriggeredContentAuthorities(@NonNull List<String> authorities) {
        this.mRuntimeExtras.triggeredContentAuthorities = authorities;
        return this;
    }

    @RequiresApi(value=28)
    @NonNull
    public TestListenableWorkerBuilder<W> setNetwork(@NonNull Network network) {
        this.mRuntimeExtras.network = network;
        return this;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setWorkerFactory(@NonNull WorkerFactory workerFactory) {
        this.mWorkerFactory = workerFactory;
        return this;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setProgressUpdater(@NonNull ProgressUpdater updater) {
        this.mProgressUpdater = updater;
        return this;
    }

    @NonNull
    public TestListenableWorkerBuilder<W> setForegroundUpdater(@NonNull ForegroundUpdater updater) {
        this.mForegroundUpdater = updater;
        return this;
    }

    @NonNull
    TestListenableWorkerBuilder<W> setExecutor(@NonNull Executor executor) {
        this.mExecutor = executor;
        return this;
    }

    @NonNull
    public W build() {
        WorkerParameters parameters = new WorkerParameters(this.getId(), this.getInputData(), this.getTags(), this.getRuntimeExtras(), this.getRunAttemptCount(), this.getExecutor(), this.getTaskExecutor(), this.getWorkerFactory(), this.getProgressUpdater(), this.getForegroundUpdater());
        WorkerFactory workerFactory = parameters.getWorkerFactory();
        ListenableWorker worker = workerFactory.createWorkerWithDefaultFallback(this.getApplicationContext(), this.getWorkerName(), parameters);
        if (worker == null) {
            throw new IllegalStateException(String.format("Could not create an instance of ListenableWorker %s", this.getWorkerName()));
        }
        if (!this.getWorkerClass().isAssignableFrom(worker.getClass())) {
            throw new IllegalStateException(String.format("Unexpected worker type %s (expected %s)", worker.getClass(), this.getWorkerClass()));
        }
        return (W)worker;
    }

    @NonNull
    public static TestListenableWorkerBuilder<? extends ListenableWorker> from(@NonNull Context context, @NonNull WorkRequest workRequest) {
        WorkSpec workSpec = workRequest.getWorkSpec();
        String name = workSpec.workerClassName;
        try {
            Class<?> workerClass = Class.forName(name);
            ArrayList<String> tags = new ArrayList<String>(workRequest.getTags().size());
            tags.addAll(workRequest.getTags());
            return new TestListenableWorkerBuilder(context.getApplicationContext(), workerClass).setId(workRequest.getId()).setTags(tags).setInputData(workSpec.input);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("Cannot find class", exception);
        }
    }

    @NonNull
    public static <W extends ListenableWorker> TestListenableWorkerBuilder<W> from(@NonNull Context context, @NonNull Class<W> workerClass) {
        return new TestListenableWorkerBuilder<W>(context, workerClass);
    }
}

