/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.testing;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class TestScheduler
implements Scheduler,
ExecutionListener {
    private final Context mContext;
    private final Map<String, InternalWorkState> mPendingWorkStates;
    private final Map<String, InternalWorkState> mTerminatedWorkStates;

    TestScheduler(@NonNull Context context) {
        this.mContext = context;
        this.mPendingWorkStates = new HashMap<String, InternalWorkState>();
        this.mTerminatedWorkStates = new HashMap<String, InternalWorkState>();
    }

    public boolean hasLimitedSchedulingSlots() {
        return true;
    }

    public void schedule(WorkSpec ... workSpecs) {
        if (workSpecs == null || workSpecs.length <= 0) {
            return;
        }
        ArrayList<String> workSpecIdsToSchedule = new ArrayList<String>(workSpecs.length);
        for (WorkSpec workSpec : workSpecs) {
            if (!this.mPendingWorkStates.containsKey(workSpec.id)) {
                this.mPendingWorkStates.put(workSpec.id, new InternalWorkState(this.mContext, workSpec));
            }
            workSpecIdsToSchedule.add(workSpec.id);
        }
        this.scheduleInternal(workSpecIdsToSchedule);
    }

    public void cancel(@NonNull String workSpecId) {
        InternalWorkState internalWorkState = this.mPendingWorkStates.get(workSpecId);
        WorkManagerImpl.getInstance((Context)this.mContext).stopWork(workSpecId);
        if (internalWorkState != null && !internalWorkState.mWorkSpec.isPeriodic()) {
            this.mPendingWorkStates.remove(workSpecId);
        }
    }

    void setAllConstraintsMet(@NonNull UUID workSpecId) {
        String id = workSpecId.toString();
        if (!this.mTerminatedWorkStates.containsKey(id)) {
            InternalWorkState internalWorkState = this.mPendingWorkStates.get(id);
            if (internalWorkState == null) {
                throw new IllegalArgumentException("Work with id " + workSpecId + " is not enqueued!");
            }
            internalWorkState.mConstraintsMet = true;
            this.scheduleInternal(Collections.singletonList(workSpecId.toString()));
        }
    }

    void setInitialDelayMet(@NonNull UUID workSpecId) {
        String id = workSpecId.toString();
        if (!this.mTerminatedWorkStates.containsKey(id)) {
            InternalWorkState internalWorkState = this.mPendingWorkStates.get(id);
            if (internalWorkState == null) {
                throw new IllegalArgumentException("Work with id " + workSpecId + " is not enqueued!");
            }
            internalWorkState.mInitialDelayMet = true;
            this.scheduleInternal(Collections.singletonList(workSpecId.toString()));
        }
    }

    void setPeriodDelayMet(@NonNull UUID workSpecId) {
        String id = workSpecId.toString();
        InternalWorkState internalWorkState = this.mPendingWorkStates.get(id);
        if (internalWorkState == null) {
            throw new IllegalArgumentException("Work with id " + workSpecId + " is not enqueued!");
        }
        internalWorkState.mPeriodDelayMet = true;
        this.scheduleInternal(Collections.singletonList(workSpecId.toString()));
    }

    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        InternalWorkState internalWorkState = this.mPendingWorkStates.get(workSpecId);
        if (internalWorkState != null) {
            if (internalWorkState.mWorkSpec.isPeriodic()) {
                internalWorkState.reset();
            } else {
                this.mTerminatedWorkStates.put(workSpecId, internalWorkState);
                this.mPendingWorkStates.remove(workSpecId);
            }
        }
    }

    private void scheduleInternal(Collection<String> workSpecIds) {
        for (String workSpecId : workSpecIds) {
            InternalWorkState internalWorkState = this.mPendingWorkStates.get(workSpecId);
            if (!internalWorkState.isRunnable()) continue;
            WorkManagerImpl.getInstance((Context)this.mContext).startWork(workSpecId);
        }
    }

    private static class InternalWorkState {
        @NonNull
        Context mContext;
        @NonNull
        WorkSpec mWorkSpec;
        boolean mConstraintsMet;
        boolean mInitialDelayMet;
        boolean mPeriodDelayMet;

        InternalWorkState(@NonNull Context context, @NonNull WorkSpec workSpec) {
            this.mContext = context;
            this.mWorkSpec = workSpec;
            this.mConstraintsMet = !this.mWorkSpec.hasConstraints();
            this.mInitialDelayMet = this.mWorkSpec.initialDelay == 0L;
            this.mPeriodDelayMet = true;
        }

        void reset() {
            this.mConstraintsMet = !this.mWorkSpec.hasConstraints();
            boolean bl = this.mPeriodDelayMet = !this.mWorkSpec.isPeriodic();
            if (this.mWorkSpec.isPeriodic()) {
                WorkManagerImpl workManager = WorkManagerImpl.getInstance((Context)this.mContext);
                WorkDatabase workDatabase = workManager.getWorkDatabase();
                workDatabase.workSpecDao().setPeriodStartTime(this.mWorkSpec.id, 0L);
            }
        }

        boolean isRunnable() {
            return this.mConstraintsMet && this.mInitialDelayMet && this.mPeriodDelayMet;
        }
    }
}

