/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.testing;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.impl.model.WorkSpec;
import androidx.work.testing.TestListenableWorkerBuilder;
import java.util.ArrayList;
import java.util.concurrent.Executor;

public class TestWorkerBuilder<W extends Worker>
extends TestListenableWorkerBuilder<W> {
    private TestWorkerBuilder(@NonNull Context context, @NonNull Class<W> workerClass, @Nullable Executor executor) {
        super(context, workerClass);
        if (executor != null) {
            this.setExecutor(executor);
        }
    }

    @NonNull
    public static TestWorkerBuilder<? extends Worker> from(@NonNull Context context, @NonNull WorkRequest workRequest, @NonNull Executor executor) {
        WorkSpec workSpec = workRequest.getWorkSpec();
        String name = workSpec.workerClassName;
        Class<Worker> workerClass = TestWorkerBuilder.getWorkerClass(name);
        if (workerClass == null) {
            throw new IllegalArgumentException(String.format("Invalid worker class name or class does not extend Worker (%s)", name));
        }
        ArrayList<String> tags = new ArrayList<String>(workRequest.getTags().size());
        tags.addAll(workRequest.getTags());
        TestWorkerBuilder<Worker> builder = new TestWorkerBuilder<Worker>(context, workerClass, executor);
        builder.setId(workRequest.getId()).setTags(tags).setInputData(workSpec.input);
        return builder;
    }

    @NonNull
    public static <W extends Worker> TestWorkerBuilder<W> from(@NonNull Context context, @NonNull Class<W> workerClass, @NonNull Executor executor) {
        return new TestWorkerBuilder<W>(context, workerClass, executor);
    }

    private static Class<Worker> getWorkerClass(String className) {
        try {
            Class<Worker> klass = Class.forName(className);
            if (!Worker.class.isAssignableFrom(klass)) {
                return null;
            }
            return klass;
        }
        catch (Throwable ignore) {
            return null;
        }
    }
}

