/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.impl.DefaultFileReplicator;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardFileSystemManager
extends DefaultFileSystemManager {
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$vfs$impl$StandardFileSystemManager == null ? (class$org$apache$commons$vfs$impl$StandardFileSystemManager = StandardFileSystemManager.class$("org.apache.commons.vfs.impl.StandardFileSystemManager")) : class$org$apache$commons$vfs$impl$StandardFileSystemManager));
    private static final String CONFIG_RESOURCE = "providers.xml";
    private String configUri;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$commons$vfs$impl$StandardFileSystemManager;

    public void setConfiguration(String configUri) {
        this.configUri = configUri;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void init() throws FileSystemException {
        DefaultFileReplicator replicator = this.createDefaultFileReplicator();
        this.setReplicator(new PrivilegedFileReplicator(replicator));
        this.setTemporaryFileStore(replicator);
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        if (this.configUri == null) {
            URL url = this.getClass().getResource(CONFIG_RESOURCE);
            if (url == null) {
                throw new FileSystemException("vfs.impl/find-config-file.error", CONFIG_RESOURCE);
            }
            this.configUri = url.toExternalForm();
        }
        this.configure(this.configUri);
        super.init();
    }

    protected DefaultFileReplicator createDefaultFileReplicator() {
        return new DefaultFileReplicator();
    }

    private void configure(String configUri) throws FileSystemException {
        try {
            Element provider;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setExpandEntityReferences(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element config = builder.parse(configUri).getDocumentElement();
            NodeList providers = config.getElementsByTagName("provider");
            int count = providers.getLength();
            for (int i = 0; i < count; ++i) {
                provider = (Element)providers.item(i);
                this.addProvider(provider, false);
            }
            NodeList defProviders = config.getElementsByTagName("default-provider");
            if (defProviders.getLength() > 0) {
                provider = (Element)defProviders.item(0);
                this.addProvider(provider, true);
            }
            NodeList mimeTypes = config.getElementsByTagName("mime-type-map");
            for (int i = 0; i < mimeTypes.getLength(); ++i) {
                Element map = (Element)mimeTypes.item(i);
                this.addMimeTypeMap(map);
            }
            NodeList extensions = config.getElementsByTagName("extension-map");
            for (int i = 0; i < extensions.getLength(); ++i) {
                Element map = (Element)extensions.item(i);
                this.addExtensionMap(map);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", configUri, (Throwable)e);
        }
    }

    private void addExtensionMap(Element map) {
        String extension = map.getAttribute("extension");
        String scheme = map.getAttribute("scheme");
        if (scheme != null && scheme.length() > 0) {
            this.addExtensionMap(extension, scheme);
        }
    }

    private void addMimeTypeMap(Element map) {
        String mimeType = map.getAttribute("mime-type");
        String scheme = map.getAttribute("scheme");
        this.addMimeTypeMap(mimeType, scheme);
    }

    private void addProvider(Element providerDef, boolean isDefault) throws FileSystemException {
        String classname = providerDef.getAttribute("class-name");
        String[] requiredSchemes = this.getRequiredSchemes(providerDef);
        for (int i = 0; i < requiredSchemes.length; ++i) {
            String requiredScheme = requiredSchemes[i];
            if (this.hasProvider(requiredScheme)) continue;
            String msg = Messages.getString("vfs.impl/skipping-provider-scheme.debug", new String[]{classname, requiredScheme});
            VfsLog.debug(this.getLogger(), this.log, msg);
            return;
        }
        String[] requiredClasses = this.getRequiredClasses(providerDef);
        for (int i = 0; i < requiredClasses.length; ++i) {
            String requiredClass = requiredClasses[i];
            if (this.findClass(requiredClass)) continue;
            String msg = Messages.getString("vfs.impl/skipping-provider.debug", new String[]{classname, requiredClass});
            VfsLog.debug(this.getLogger(), this.log, msg);
            return;
        }
        FileProvider provider = this.createProvider(classname);
        String[] schemas = this.getSchemas(providerDef);
        if (schemas.length > 0) {
            this.addProvider(schemas, provider);
        }
        if (isDefault) {
            this.setDefaultProvider(provider);
        }
    }

    private boolean findClass(String className) {
        try {
            this.classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String[] getRequiredClasses(Element providerDef) {
        ArrayList<String> classes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String className = dep.getAttribute("class-name");
            if (className == null || className.length() <= 0) continue;
            classes.add(className);
        }
        return classes.toArray(new String[classes.size()]);
    }

    private String[] getRequiredSchemes(Element providerDef) {
        ArrayList<String> schemes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String scheme = dep.getAttribute("scheme");
            if (scheme == null || scheme.length() <= 0) continue;
            schemes.add(scheme);
        }
        return schemes.toArray(new String[schemes.size()]);
    }

    private String[] getSchemas(Element provider) {
        ArrayList<String> schemas = new ArrayList<String>();
        NodeList schemaElements = provider.getElementsByTagName("scheme");
        int count = schemaElements.getLength();
        for (int i = 0; i < count; ++i) {
            Element scheme = (Element)schemaElements.item(i);
            schemas.add(scheme.getAttribute("name"));
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    private FileProvider createProvider(String providerClassName) throws FileSystemException {
        try {
            Class<?> providerClass = this.classLoader.loadClass(providerClassName);
            return (FileProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-provider.error", providerClassName, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

