/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.LayeredFileName;

public abstract class AbstractLayeredFileProvider
extends AbstractFileProvider
implements FileProvider {
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        LayeredFileName name = (LayeredFileName)this.parseUri(uri);
        String fileName = name.getOuterUri();
        FileObject file = this.getContext().resolveFile(baseFile, fileName, properties);
        FileObject rootFile = this.createFileSystem(name.getScheme(), file, properties);
        return rootFile.resolveFile(name.getPath());
    }

    public synchronized FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = file.getName();
        FileSystem fs = this.findFileSystem(rootName, null);
        if (fs == null) {
            fs = this.doCreateFileSystem(scheme, file, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs.getRoot();
    }

    protected abstract FileSystem doCreateFileSystem(String var1, FileObject var2, FileSystemOptions var3) throws FileSystemException;

    protected abstract FileName parseUri(String var1) throws FileSystemException;
}

