/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.local.LocalFileRandomAccessContent;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.apache.commons.vfs.util.RandomAccessMode;

final class LocalFile
extends AbstractFileObject
implements FileObject {
    private File file;
    private final String fileName;

    public LocalFile(LocalFileSystem fileSystem, String fileName, FileName name) {
        super(name, fileSystem);
        this.fileName = fileName;
    }

    public File getLocalFile() {
        return this.file;
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = new File(this.fileName);
        }
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.local/get-type.error", this.file);
    }

    protected String[] doListChildren() throws Exception {
        return this.file.list();
    }

    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", this.file);
        }
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (!this.file.renameTo(((LocalFile)newfile).getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", new String[]{this.file.toString(), newfile.toString()});
        }
    }

    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", this.file);
        }
    }

    protected boolean doIsWriteable() throws FileSystemException {
        return this.file.canWrite();
    }

    protected boolean doIsHidden() {
        return this.file.isHidden();
    }

    protected boolean doIsReadable() throws FileSystemException {
        return this.file.canRead();
    }

    protected long doGetLastModifiedTime() throws FileSystemException {
        return this.file.lastModified();
    }

    protected void doSetLastModifiedTime(long modtime) throws FileSystemException {
        this.file.setLastModified(modtime);
    }

    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new FileOutputStream(this.file.getPath(), bAppend);
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new LocalFileRandomAccessContent(this.file, mode);
    }
}

