/*
 * Decompiled with CFR 0.152.
 */
package cn.apiclub.captcha.audio.noise;

import cn.apiclub.captcha.audio.Mixer;
import cn.apiclub.captcha.audio.Sample;
import cn.apiclub.captcha.audio.noise.NoiseProducer;
import cn.apiclub.captcha.util.FileUtil;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;

public class RandomNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new SecureRandom();
    private static final String[] DEFAULT_NOISES = new String[]{"/sounds/noises/radio_tuning.wav", "/sounds/noises/restaurant.wav", "/sounds/noises/swimming.wav"};
    private final String[] _noiseFiles;

    public RandomNoiseProducer() {
        this(DEFAULT_NOISES);
    }

    public RandomNoiseProducer(String[] noiseFiles) {
        this._noiseFiles = noiseFiles;
    }

    @Override
    public Sample addNoise(List<Sample> samples) {
        Sample appended = Mixer.append(samples);
        String noiseFile = this._noiseFiles[RAND.nextInt(this._noiseFiles.length)];
        Sample noise = FileUtil.readSample(noiseFile);
        return Mixer.mix(appended, 1.0, noise, 0.6);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Noise files: ");
        sb.append(this._noiseFiles);
        sb.append("]");
        return sb.toString();
    }
}

