/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.opt;

import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.opt.HOTP;
import java.time.Duration;
import java.time.Instant;

public class TOPT
extends HOTP {
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Duration timeStep;

    public TOPT(byte[] key) {
        this(DEFAULT_TIME_STEP, key);
    }

    public TOPT(Duration timeStep, byte[] key) {
        this(timeStep, 6, key);
    }

    public TOPT(Duration timeStep, int passwordLength, byte[] key) {
        this(timeStep, passwordLength, HOTP_HMAC_ALGORITHM, key);
    }

    public TOPT(Duration timeStep, int passwordLength, HmacAlgorithm algorithm, byte[] key) {
        super(passwordLength, algorithm, key);
        this.timeStep = timeStep;
    }

    public int generate(Instant timestamp) {
        return this.generate(timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

