/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.json.JSON;
import cn.hutool.json.serialize.JSONArraySerializer;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalSerializeMapping {
    private static Map<Type, JSONSerializer<? extends JSON, ?>> serializerMap;
    private static Map<Type, JSONDeserializer<?>> deserializerMap;

    public static void put(Type type, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type, serializer);
    }

    public static void put(Type type, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type, serializer);
    }

    private static synchronized void putInternal(Type type, JSONSerializer<? extends JSON, ?> serializer) {
        if (null == serializerMap) {
            serializerMap = new ConcurrentHashMap();
        }
        serializerMap.put(type, serializer);
    }

    public static synchronized void put(Type type, JSONDeserializer<?> deserializer) {
        if (null == deserializerMap) {
            deserializerMap = new ConcurrentHashMap();
        }
        deserializerMap.put(type, deserializer);
    }

    public static JSONSerializer<? extends JSON, ?> getSerializer(Type type) {
        if (null == serializerMap) {
            return null;
        }
        return serializerMap.get(type);
    }

    public static JSONDeserializer<?> getDeserializer(Type type) {
        if (null == deserializerMap) {
            return null;
        }
        return deserializerMap.get(type);
    }
}

