/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.WeightRandom;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RandomUtil.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RandomUtil.createSecureRandom(seed);
    }

    public static SecureRandom getSHA1PRNGRandom(byte[] seed) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(e);
        }
        if (null != seed) {
            random.setSeed(seed);
        }
        return random;
    }

    public static SecureRandom getSecureRandomStrong() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(e);
        }
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtil.getSecureRandom() : RandomUtil.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtil.randomInt(2);
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomUtil.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return RandomUtil.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomUtil.getRandom().nextLong();
    }

    public static long randomLong(long limit) {
        return RandomUtil.getRandom().nextLong(limit);
    }

    public static double randomDouble(double min, double max) {
        return RandomUtil.getRandom().nextDouble(min, max);
    }

    public static double randomDouble(double min, double max, int scale, RoundingMode roundingMode) {
        return NumberUtil.round(RandomUtil.randomDouble(min, max), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomUtil.getRandom().nextDouble();
    }

    public static double randomDouble(int scale, RoundingMode roundingMode) {
        return NumberUtil.round(RandomUtil.randomDouble(), scale, roundingMode).doubleValue();
    }

    public static double randomDouble(double limit) {
        return RandomUtil.getRandom().nextDouble(limit);
    }

    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        return NumberUtil.round(RandomUtil.randomDouble(limit), scale, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limit) {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble(limit.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal min, BigDecimal max) {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble(min.doubleValue(), max.doubleValue()));
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RandomUtil.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static <T> T randomEle(List<T> list) {
        return RandomUtil.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        if (list.size() < limit) {
            limit = list.size();
        }
        return list.get(RandomUtil.randomInt(limit));
    }

    public static <T> T randomEle(T[] array) {
        return RandomUtil.randomEle(array, array.length);
    }

    public static <T> T randomEle(T[] array, int limit) {
        if (array.length < limit) {
            limit = array.length;
        }
        return array[RandomUtil.randomInt(limit)];
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomUtil.randomEle(list, limit));
        }
        return result;
    }

    public static <T> List<T> randomEleList(List<T> source, int count) {
        if (count >= source.size()) {
            return ListUtil.toList(source);
        }
        int[] randomList = ArrayUtil.sub(RandomUtil.randomInts(source.size()), 0, count);
        ArrayList<T> result = new ArrayList<T>();
        for (int e : randomList) {
            result.add(source.get(e));
        }
        return result;
    }

    public static <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        ArrayList<T> source = CollUtil.distinct(collection);
        if (count > source.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(count);
        int limit = source.size();
        while (result.size() < count) {
            result.add(RandomUtil.randomEle(source, limit));
        }
        return result;
    }

    public static int[] randomInts(int length) {
        int[] range = ArrayUtil.range(length);
        for (int i = 0; i < length; ++i) {
            int random = RandomUtil.randomInt(i, length);
            ArrayUtil.swap(range, i, random);
        }
        return range;
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomStringUpper(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length).toUpperCase();
    }

    public static String randomStringWithoutStr(int length, String elemData) {
        String baseStr = BASE_CHAR_NUMBER;
        baseStr = StrUtil.removeAll((CharSequence)baseStr, elemData.toCharArray());
        return RandomUtil.randomString(baseStr, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtil.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (StrUtil.isEmpty(baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtil.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static char randomNumber() {
        return RandomUtil.randomChar(BASE_NUMBER);
    }

    public static char randomChar() {
        return RandomUtil.randomChar(BASE_CHAR_NUMBER);
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(RandomUtil.randomInt(baseString.length()));
    }

    @Deprecated
    public static Color randomColor() {
        ThreadLocalRandom random = RandomUtil.getRandom();
        return new Color(((Random)random).nextInt(256), ((Random)random).nextInt(256), ((Random)random).nextInt(256));
    }

    public static <T> WeightRandom<T> weightRandom(WeightRandom.WeightObj<T>[] weightObjs) {
        return new WeightRandom<T>(weightObjs);
    }

    public static <T> WeightRandom<T> weightRandom(Iterable<WeightRandom.WeightObj<T>> weightObjs) {
        return new WeightRandom<T>(weightObjs);
    }

    public static DateTime randomDay(int min, int max) {
        return RandomUtil.randomDate(DateUtil.date(), DateField.DAY_OF_YEAR, min, max);
    }

    public static DateTime randomDate(Date baseDate, DateField dateField, int min, int max) {
        if (null == baseDate) {
            baseDate = DateUtil.date();
        }
        return DateUtil.offset(baseDate, dateField, RandomUtil.randomInt(min, max));
    }
}

