/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class DocValuesPropertyBase
extends CorePropertyBase {
    @Nullable
    private final Boolean docValues;

    protected DocValuesPropertyBase(AbstractBuilder<?> builder) {
        super((CorePropertyBase.AbstractBuilder<?>)builder);
        this.docValues = ((AbstractBuilder)builder).docValues;
    }

    @Nullable
    public final Boolean docValues() {
        return this.docValues;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.docValues != null) {
            generator.writeKey("doc_values");
            generator.write(this.docValues.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupDocValuesPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(AbstractBuilder::docValues, JsonpDeserializer.booleanDeserializer(), "doc_values");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends CorePropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Boolean docValues;

        protected AbstractBuilder() {
        }

        public final BuilderT docValues(@Nullable Boolean value) {
            this.docValues = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

