/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDatafeedsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetDatafeedsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    private final List<String> datafeedId;
    @Nullable
    private final Boolean excludeGenerated;
    public static final Endpoint<GetDatafeedsRequest, GetDatafeedsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetDatafeedsRequest, GetDatafeedsResponse>("es/ml.get_datafeeds", request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.datafeedId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDatafeedsResponse._DESERIALIZER);

    private GetDatafeedsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.datafeedId = ApiTypeHelper.unmodifiable(builder.datafeedId);
        this.excludeGenerated = builder.excludeGenerated;
    }

    public static GetDatafeedsRequest of(Function<Builder, ObjectBuilder<GetDatafeedsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    public final List<String> datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetDatafeedsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private List<String> datafeedId;
        @Nullable
        private Boolean excludeGenerated;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder datafeedId(List<String> list) {
            this.datafeedId = Builder._listAddAll(this.datafeedId, list);
            return this;
        }

        public final Builder datafeedId(String value, String ... values) {
            this.datafeedId = Builder._listAdd(this.datafeedId, value, values);
            return this;
        }

        public final Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDatafeedsRequest build() {
            this._checkSingleUse();
            return new GetDatafeedsRequest(this);
        }
    }
}

