/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TextExpansionQuery
extends QueryBase
implements QueryVariant {
    private final String value;
    private final String modelId;
    private final String modelText;
    public static final JsonpDeserializer<TextExpansionQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextExpansionQuery::setupTextExpansionQueryDeserializer);

    private TextExpansionQuery(Builder builder) {
        super(builder);
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.modelText = ApiTypeHelper.requireNonNull(builder.modelText, this, "modelText");
    }

    public static TextExpansionQuery of(Function<Builder, ObjectBuilder<TextExpansionQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.TextExpansion;
    }

    public final String value() {
        return this.value;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String modelText() {
        return this.modelText;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("model_text");
        generator.write(this.modelText);
    }

    protected static void setupTextExpansionQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::modelText, JsonpDeserializer.stringDeserializer(), "model_text");
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TextExpansionQuery> {
        private String value;
        private String modelId;
        private String modelText;

        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder modelText(String value) {
            this.modelText = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextExpansionQuery build() {
            this._checkSingleUse();
            return new TextExpansionQuery(this);
        }
    }
}

