/* Generated By:JavaCC: Do not edit this line. SQLParser.java */
package flex.messaging.services.messaging.selector;

import java.util.*;

import flex.messaging.messages.Message;
import flex.messaging.MessageException;

/**
 * Subset of SQL-92 used by JMS message selectors. 
 *
 * <p>
 * As a starting point I 
 * used the SQL grammar contributed by 
 * kevinh@empower.com.au to the JAVACC web site http://www.cobase.cs.ucla.edu/pub/javacc/
 *
 * @author Farrukh S. Najmi
 */
public class SQLParser implements SQLParserConstants {

    Message msg = null;
    JMSSelector selector;
    PropertyValueComparator comparator = PropertyValueComparator.getInstance();

    public SQLParser(JMSSelector selector, java.io.InputStream stream) {
           this(stream);
           this.selector = selector;
    }


    public void setMessage(Message msg) {
           this.msg = msg;
    }

/*******************************************************************
 * The SQL-92 grammar starts here
 *******************************************************************/
  final public boolean match(Message msg) throws ParseException {
boolean matchResult = false;
Object res = null;
      if (msg == null)
         {if (true) throw new MessageException("Null Message for Selector");}
      else
         this.msg = msg;
    res = SQLOrExpr();
        if (res != null) {
            if (! (res instanceof java.lang.Boolean)) {
                {if (true) throw new ParseException("Selector must evaluate to a java.lang.Boolean. Instead evaluated to a " + res.getClass().getName());}
            }

            matchResult = ((Boolean)res).booleanValue();
        }
        {if (true) return matchResult;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLOrExpr() throws ParseException {
    Object res1=null;
    Object res2=null;
    res1 = SQLAndExpr();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      res2 = SQLAndExpr();
            if ((res1 != null && !(res1 instanceof java.lang.Boolean)) ||
                (res2 != null && !(res2 instanceof java.lang.Boolean))) {
                {if (true) throw new ParseException("SQLOrExpr requires java.lang.Boolean for opearnds of OR operation");}
            }

            if (res1 != null && res2 != null) {
                res1 = Boolean.valueOf(((Boolean)res1).booleanValue() || ((Boolean)res2).booleanValue());
            } else if (res1 == null && res2 == null) {

                // U || U = U
                res1 = null;
            } else {

               // one of the OR operands are unknown
               Boolean notUnknownValue = (Boolean)(res1 == null ? res2 : res1);
               if (notUnknownValue.booleanValue()) {

                   // T || U = T
                   res1 = notUnknownValue;
               } else {

                   // F || U = U
                   res1 = null;
               }
            }
    }
            {if (true) return (res1);}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLAndExpr() throws ParseException {
    Object res1=null;
    Object res2=null;
    res1 = SQLNotExpr();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      res2 = SQLNotExpr();
            if ((res1 != null && !(res1 instanceof java.lang.Boolean)) ||
                (res2 != null && !(res2 instanceof java.lang.Boolean))) {
                {if (true) throw new ParseException("SQLAndExpr requires java.lang.Boolean for operands of AND operation");}
            }

            if (res1 != null && res2 != null) {
                res1 = Boolean.valueOf(((Boolean)res1).booleanValue() &&
                                   ((Boolean)res2).booleanValue());

            } else if (res1 == null && res2 == null) {

                // U && U = U
               res1 = null;
            } else {
               Boolean notUnknownValue = (Boolean)(res1 == null ? res2 : res1);
               if (notUnknownValue.booleanValue()) {

                   // T && U = U
                   res1 = null;
               } else {

                   // F && U = F
                   res1 = notUnknownValue;
               }
            }
    }
            {if (true) return (res1);}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLNotExpr() throws ParseException {
    boolean isNot=false;
    Object res = null;
    Object obj = null;
    if (jj_2_1(2)) {
      jj_consume_token(NOT);
        isNot = true;
    } else {
      ;
    }
    res = SQLCompareExpr();
        if (isNot) {
            if (res == null) {

                // NOT Unknown = Unknown
                {if (true) return res;}
            } else if (!(res instanceof java.lang.Boolean)) {
                {if (true) throw new ParseException("The NOT operator requires a Boolean to be returned by SQLCompareExpr");} //generateParseException();
            }

            res = Boolean.valueOf(! (((Boolean)res).booleanValue()));
        }
        {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLCompareExpr() throws ParseException {
    Object res = null;
    if (jj_2_2(2)) {
      res = SQLIsClause();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case BOOLEAN_LITERAL:
      case ID:
      case OPENPAREN:
      case PLUS:
      case MINUS:
        res = SQLSumExpr();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BETWEEN:
        case IN:
        case LIKE:
        case NOT:
        case LESS:
        case LESSEQUAL:
        case GREATER:
        case GREATEREQUAL:
        case EQUAL:
        case NOTEQUAL:
          res = SQLCompareExprRight(res);
          break;
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public Boolean SQLCompareExprRight(Object obj1) throws ParseException {
    Boolean res = null;
    Object obj2 = null;
        if (obj1 == null) {
//            return null; //Comparisons with unknowns yield unknown
        }
    if (jj_2_3(2)) {
      res = SQLLikeClause(obj1);
    } else if (jj_2_4(4)) {
      res = SQLInClause(obj1);
    } else if (jj_2_5(2)) {
      res = SQLBetweenClause(obj1);
    } else if (jj_2_6(2)) {
      jj_consume_token(EQUAL);
      obj2 = SQLSumExpr();
            if (obj1 == null) {
                {if (true) return null;}
            }
            res = Boolean.valueOf((comparator.compare(obj1, obj2) == 0));
    } else if (jj_2_7(2)) {
      jj_consume_token(NOTEQUAL);
      obj2 = SQLSumExpr();
            if (obj1 == null) {
                {if (true) return null;}
            }
            res = Boolean.valueOf((comparator.compare(obj1, obj2) != 0));
    } else if (jj_2_8(2)) {
      jj_consume_token(GREATER);
      obj2 = SQLSumExpr();
            if ((obj1 instanceof String) || (obj2 instanceof String) ||
                (obj1 instanceof Boolean) || (obj2 instanceof Boolean) ) {
                {if (true) throw new ParseException("Cannot use > with String or Boolean types");}
            }
            if (obj1 == null) {
                {if (true) return null;}
            }
            res = Boolean.valueOf((comparator.compare(obj1, obj2) > 0));
    } else if (jj_2_9(2)) {
      jj_consume_token(GREATEREQUAL);
      obj2 = SQLSumExpr();
            if ((obj1 instanceof String) || (obj2 instanceof String) ||
                (obj1 instanceof Boolean) || (obj2 instanceof Boolean) ) {
                {if (true) throw new ParseException("Cannot use >= with String or Boolean types");}
            }
            if (obj1 == null) {
                {if (true) return null;}
            }
            res = Boolean.valueOf((comparator.compare(obj1, obj2) >= 0));
    } else if (jj_2_10(2)) {
      jj_consume_token(LESS);
      obj2 = SQLSumExpr();
            if ((obj1 instanceof String) || (obj2 instanceof String) ||
                (obj1 instanceof Boolean) || (obj2 instanceof Boolean) ) {
                {if (true) throw new ParseException("Cannot use < with String or Boolean types");}
            }
            if (obj1 == null) {
                {if (true) return null;}
            }
            //Need to handle the case where comparator may return unknown as a negative value
            int i = comparator.compare(obj1, obj2);
            if (i != PropertyValueComparator.UNKNOWN) {
                res = Boolean.valueOf(i < 0);
            }
    } else if (jj_2_11(2)) {
      jj_consume_token(LESSEQUAL);
      obj2 = SQLSumExpr();
            if ((obj1 instanceof String) || (obj2 instanceof String) ||
                (obj1 instanceof Boolean) || (obj2 instanceof Boolean) ) {
                {if (true) throw new ParseException("Cannot use <= with String or Boolean types");}
            }
            if (obj1 == null) {
                {if (true) return null;}
            }
            //Need to handle the case where comparator may return unknown as a negative value
            int i = comparator.compare(obj1, obj2);
            if (i != PropertyValueComparator.UNKNOWN) {
                res = Boolean.valueOf(i <= 0);
            }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLSumExpr() throws ParseException {
    Object res1 = null;
    Object res2 = null;
    NumericValue num1 = null;
    NumericValue num2 = null;
    boolean doAdd = true;
    res1 = SQLProductExpr();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                     doAdd = true;
        break;
      case MINUS:
        jj_consume_token(MINUS);
                       doAdd = false;
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      res2 = SQLProductExpr();
                num1 = new NumericValue(res1);
                num2 = new NumericValue(res2);

                if (doAdd) {
                    res1 = num1.add(num2);
                } else {
                    res1 = num1.subtract(num2);
                }
    }
        {if (true) return res1;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLProductExpr() throws ParseException {
    Object res1 = null;
    Object res2 = null;
    NumericValue num1 = null;
    NumericValue num2 = null;
    boolean doMultiply = true;
    res1 = SQLUnaryExpr();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
      case SLASH:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
                     doMultiply = true;
        break;
      case SLASH:
        jj_consume_token(SLASH);
                       doMultiply = false;
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      res2 = SQLUnaryExpr();
                num1 = new NumericValue(res1);
                num2 = new NumericValue(res2);

                if (doMultiply) {
                    res1 = num1.multiply(num2);
                } else {
                    res1 = num1.divide(num2);
                }
    }
        {if (true) return res1;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLUnaryExpr() throws ParseException {
    Object res1 = null;
    NumericValue num1 = null;
    boolean negate = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
                       negate = true;
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    res1 = SQLTerm();
        if (negate) {
            num1 = new NumericValue(res1);
            res1 = num1.negate();
        }
        {if (true) return res1;}
    throw new Error("Missing return statement in function");
  }

  final public String SQLColRef() throws ParseException {
  Token x;
  String colName = new String("");
    x = jj_consume_token(ID);
        colName = x.image;
         {if (true) return colName;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLTerm() throws ParseException {
    String colName;
    Object res=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPENPAREN:
      jj_consume_token(OPENPAREN);
      res = SQLOrExpr();
      jj_consume_token(CLOSEPAREN);
        {if (true) return res;}
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case BOOLEAN_LITERAL:
      res = SQLLiteral();
        {if (true) return res;}
      break;
    case ID:
      colName = SQLColRef();
        try {

                res = msg.getHeader(colName);

              //For Numbers we only deal with Long and Double. Promote as needed
              if ((res instanceof java.lang.Byte) ||
                   (res instanceof java.lang.Short) ||
                   (res instanceof java.lang.Integer)) {

                  res = new Long(((Number)res).longValue());
              }
              else if (res instanceof java.lang.Float) {
                  res = new Double(((Number)res).doubleValue());
              }
        }
        catch (Exception e) {
                e.printStackTrace();
                {if (true) throw new MessageException(e.getMessage());}
        }
        {if (true) return res;}
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object SQLLiteral() throws ParseException {
    Token x=null;
    Object obj=null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        x = jj_consume_token(STRING_LITERAL);
            obj = selector.processStringLiteral(x.image);
        break;
      case INTEGER_LITERAL:
        x = jj_consume_token(INTEGER_LITERAL);
                                obj = new NumericValue(x.image,
                                                       NumericValue.LongValue);
        break;
      case FLOATING_POINT_LITERAL:
        x = jj_consume_token(FLOATING_POINT_LITERAL);
                 obj = new NumericValue(x.image, NumericValue.DoubleValue);
        break;
      case BOOLEAN_LITERAL:
        x = jj_consume_token(BOOLEAN_LITERAL);
                             obj = Boolean.valueOf(x.image.toLowerCase());
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return obj;}
    } catch (Exception e) {
    //Cant happen
    {if (true) throw generateParseException();}
    }
    throw new Error("Missing return statement in function");
  }

  final public Boolean SQLLikeClause(Object obj1) throws ParseException {
    Boolean res = null;
    boolean isLike = false;
    boolean isNot=false;
    String colName, propVal=null, pattern;
    char escapeChar=0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
              isNot = true;
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(LIKE);
    pattern = SQLPattern();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
      jj_consume_token(ESCAPE);
      escapeChar = EscapeChar();
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
        if (pattern != null && ! (pattern instanceof java.lang.String)) {
            {if (true) throw new ParseException("The LIKE target must be a string." +
                           " Found " + pattern.getClass());}
        }

        if (obj1 instanceof java.lang.String) {
            isLike = selector.matchPattern(pattern, (String)obj1, escapeChar);

            if (isNot) {
                isLike = !isLike;
            }
            res = Boolean.valueOf(isLike);
      }
      {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public String SQLPattern() throws ParseException {
    Token x;
    String res;
    x = jj_consume_token(STRING_LITERAL);
                           res = x.image;
        {if (true) return selector.processStringLiteral(res);}
    throw new Error("Missing return statement in function");
  }

  final public char EscapeChar() throws ParseException {
    Token x;
    String escapeCharStr = null;
    char escapeChar;
    x = jj_consume_token(STRING_LITERAL);
                             escapeCharStr = x.image;
        //Must be a single char String
        if (escapeCharStr.length() != 3) {
            {if (true) throw new ParseException("Expected single escape character for SQL pattern. Found " + escapeCharStr);}
        }

        escapeChar = escapeCharStr.charAt(1);
        {if (true) return escapeChar;}
    throw new Error("Missing return statement in function");
  }

  final public Boolean SQLIsClause() throws ParseException {
    String colName;
    boolean isNull=false;
    boolean notNull = false;
    Boolean res=null;
    colName = SQLColRef();
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
            notNull = true;
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    jj_consume_token(NULL);
      try {
          isNull = (!msg.headerExists(colName));
      }
      catch (Exception e) {
          {if (true) throw generateParseException();}
      }
      if (notNull) {
        isNull = !isNull;
      }
      res = Boolean.valueOf(isNull);
      {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public Boolean SQLInClause(Object obj1) throws ParseException {
    boolean found=false;
    boolean negate = false;
    Boolean res=null;
    ArrayList list = null;
    Object element = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
              negate = true;
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    jj_consume_token(OPENPAREN);
    list = SQLLValueList();
    jj_consume_token(CLOSEPAREN);
        if (list != null) {
            Iterator iter = list.iterator();
            try {
                while (iter.hasNext()) {
                    element = iter.next();
                    String str = (String)element;
                }
            } catch (ClassCastException cce) {
                {if (true) throw new ParseException("All TARGETS of a IN clause "  +
                     "must be a String. Found a " + element.getClass());}
            }

            if (obj1 == null) {
                {if (true) return null;}
            }
            if (! (obj1 instanceof java.lang.String)) {
                {if (true) throw new ParseException("Source of IN clause must be " +
                           "a String. Found a " + obj1.getClass().getName());}
            }
            found = list.contains(obj1);
        }

        if (negate) {
            found = !found;
        }

        res = Boolean.valueOf(found);
        {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList SQLLValueList() throws ParseException {
    Object elem = null;
    ArrayList list = new ArrayList();
    elem = SQLLValueElement();
                                list.add(elem);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 36:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_5;
      }
      jj_consume_token(36);
      elem = SQLLValueElement();
                                      list.add(elem);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public Object SQLLValueElement() throws ParseException {
    Object res = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
      break;
    default:
      jj_la1[17] = jj_gen;
      if (jj_2_12(3)) {
        res = SQLSumExpr();
      } else if (jj_2_13(3)) {
        res = SQLOrExpr();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        if (res instanceof NumericValue) {
            res = ((NumericValue)res).getValue();
        }
        {if (true) return res;}
    throw new Error("Missing return statement in function");
  }

  final public Boolean SQLBetweenClause(Object obj1) throws ParseException {
    boolean between=false;
    boolean negate = false;
    Object res1 = null;
    Object res2 = null;
    ArrayList list = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
               negate = true;
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
    res1 = SQLSumExpr();
    jj_consume_token(AND);
    res2 = SQLSumExpr();
        if (obj1 instanceof NumericValue) {
            obj1 = ((NumericValue)obj1).getValue();
        }
        if (obj1 != null && !(obj1 instanceof java.lang.Comparable)) {
            {if (true) throw new ParseException("The LValue for BETWEEN must be a java.lang.Comparable. Found " + obj1);}
        }

        if (res1 != null &&
            (res1 instanceof String || res1 instanceof Boolean)) {
            {if (true) throw new ParseException("The START target for BETWEEN must "
                           + "be a numeric value. Found " + res1.getClass());}
        }

        if (res2 != null &&
            (res2 instanceof String || res2 instanceof Boolean)) {
            {if (true) throw new ParseException("The END target for BETWEEN must "
                           + "be a numeric value. Found " + res2.getClass());}
        }

      if (res1 instanceof NumericValue) {
         res1 = ((NumericValue)res1).getValue();
      }
      if (res2 instanceof NumericValue) {
         res2 = ((NumericValue)res2).getValue();
      }

      try {
        if ( (((Comparable)obj1).compareTo(res1) >= 0) && (((Comparable)obj1).compareTo(res2) <= 0) ) {
              between = true;
        }
      } catch (Throwable t) {
        // Comparison between incompatible types results in an unknown  value
        {if (true) return null;}
      }

        if (negate) {
            between = !between;
        }

        res1= Boolean.valueOf(between);
        {if (true) return (Boolean)res1;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) jj_scanpos = xsp;
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_scan_token(LESSEQUAL)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_3R_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_8() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_16()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(BOOLEAN_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_1()) jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(LESS)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(GREATEREQUAL)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    }
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_6() {
    if (jj_3R_12()) return true;
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(GREATER)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_24()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_25()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(36)) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_12()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_7()) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_3R_22()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_23()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    }
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(CLOSEPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_3R_18()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_10()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_6()) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    return false;
  }

  public SQLParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[19];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x2000,0x40,0x1f800d80,0x201d8000,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x201d8000,0xd8000,0x800,0x4000,0x800,0x800,0x0,0x1000,0x800,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x6,0x6,0x6,0x1,0x1,0x6,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[13];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SQLParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQLParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQLParser(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[37];
    for (int i = 0; i < 37; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 19; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 37; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 13; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
