/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import java.util.ArrayList;

public class AutoColor
implements OutlineConsumer {
    public static final int AC_ALLOWEDIT = 1;
    public static final int AC_HINTSUB = 2;
    public static final int AC_FIXWINDING = 4;
    public static final int AC_GENERATEVSTEMS = 8;
    public static final int ZN_VSTEM = 0;
    public static final int ZN_HSTEM = 1;
    public static final int ZN_CHAREXTREME = 2;
    public static final int ZN_CHARZONE = 3;
    public static final int ZN_ZONE = 4;
    private static final int FIXED_POS_INF = Integer.MAX_VALUE;
    private static final int FIXED_NEG_INF = Integer.MIN_VALUE;
    private static final int FIX_SHIFT = 8;
    private static final int FIX_16 = 4096;
    private static final int FIX_ONE = 256;
    private static final int FIX_HALF = 128;
    private static final int FIX_QUARTER = 64;
    private static final int FIX_SIXTEENTH = 16;
    private static final int S_LINE = 0;
    private static final int S_BEND = 1;
    private static final int S_CURVE = 2;
    private static final int S_GHOST = 3;
    private static final int MOVETO = 0;
    private static final int LINETO = 1;
    private static final int CURVETO = 2;
    private static final int CLOSEPATH = 3;
    private static final int CP_START = 0;
    private static final int CP_CURVE1 = 1;
    private static final int CP_CURVE2 = 2;
    private static final int CP_END = 3;
    private static final int BOTGHST = -21;
    private static final int TOPGHST = -20;
    private static final double THETA = 0.38;
    private static final int BEND_TAN = 577;
    private static final int S_CURVE_TAN = 25;
    private static final boolean Y_GOES_UP = true;
    private static final int MAXBLUES = 20;
    private static final int MAXSERIFS = 5;
    private static final int MAXSTEMS = 20;
    private static final int MAXFIXES = 100;
    private static final int X0 = 0;
    private static final int Y0 = 0;
    private static final int SFACTOR = 20;
    private static final int SPCBONUS = 1000;
    private static final int MAXSTEMDIST = 150;
    private static final int MAXF = 32768;
    private static final int PRNFCTR = 3;
    private static final int MUCHFCTR = 50;
    private static final int VERYMUCHFCTR = 100;
    private static final int STARTING = 0;
    private static final int GOINGUP = 1;
    private static final int GOINGDOWN = 2;
    private static final double LENGTHRATIOCUTOFF = 0.11;
    private static final int MAXCNT = 100;
    private static final int WD_CCW = 0;
    private static final int WD_CW = 1;
    private static final int MINIFLTNMAXDEPTH = 6;
    private static final int MINIBLKSZ = 10;
    private static final int FRP_NZWIND = 0;
    private static final int FRP_YEXTREME = 1;
    private static final int FRP_CHKDT = 2;
    private static final int FRP_CHKBBDT = 3;
    private static final int FRP_FPBBOXPT = 4;
    private static final int MAX_NUM_SUBPATHS = 200;
    private static final int MAX_NUM_PATH_ELEMENTS = 1000;
    private static final int AC_GC_VERT_STEM = 1;
    private static final int AC_GC_STEM3_STEM = 4;
    private static final int AC_GC_NEW_HINTS = 8;
    private PathElt mPathStart;
    private PathElt mPathEnd;
    private double mOrigEmSquare;
    private boolean mGenerateVStems;
    private boolean mUseV;
    private boolean mUseH;
    private boolean mAutoVFix;
    private boolean mAutoHFix;
    private boolean mEditChar;
    private boolean mScalinghints;
    private boolean mExtracolor;
    private boolean mFixWinding;
    private boolean mFlexStrict;
    private boolean mFlexOK;
    private boolean mDoSmoothing;
    private boolean mDoCounters;
    private int mHBigDist;
    private int mVBigDist;
    private int mInitBigDist;
    private int mMinDist;
    private int mGhostWidth;
    private int mGhostLength;
    private int mBendLength;
    private int mBandMargin;
    private int mMaxFlare;
    private int mMaxBendMerge;
    private int mMaxMerge;
    private int mMinColorElementLength;
    private int mFlexCand;
    private int mBluefuzz;
    private int mUnicode;
    private int mPruneA;
    private int mPruneB;
    private int mPruneC;
    private int mPruneD;
    private int mPruneValue;
    private int mBonus;
    private double mHBigDistR;
    private double mVBigDistR;
    private double mMaxVal;
    private double mMinVal;
    private int mDMIN;
    private int mCPpercent;
    private ClrVal mHcoloring;
    private ClrVal mHprimary;
    private ClrVal mValList;
    private ClrVal mVcoloring;
    private ClrVal mVprimary;
    private ClrSeg[] mSegLists = new ClrSeg[4];
    private ClrPoint mPointList;
    private ClrPoint[] mPtLstArray;
    private int mPtLstIndex;
    private int mNumPtLsts;
    private int mMaxPtLsts;
    private int[] mTopBands = new int[20];
    private int[] mBotBands = new int[20];
    private int[] mSerifs = new int[5];
    private int mLenTopBands;
    private int mLenBotBands;
    private int mNumSerifs;
    private int[] mVStems = new int[20];
    private int[] mHStems = new int[20];
    private int mNumVStems;
    private int mNumHStems;
    private boolean mDoAligns;
    private boolean mDoWriteGlyph;
    private boolean mCounterFailed;
    private SegLnkLst mHlnks;
    private SegLnkLst mVlnks;
    private int mCpFrom;
    private int mCpTo;
    private int[] mHFixYs = new int[100];
    private int[] mHFixDYs = new int[100];
    private int mHFixCount;
    private int[] mVFixXs = new int[100];
    private int[] mVFixDXs = new int[100];
    private int mVFixCount;
    private boolean mClrBBox;
    private boolean mClrHBounds;
    private boolean mClrVBounds;
    private boolean mHaveHBnds;
    private boolean mMergeMain;
    private boolean mHaveVBnds;
    private ACBBox mBBox = new ACBBox();
    private byte[] mLinks;
    private int mRowCnt;
    private boolean mSubPathOpen;
    private PathElt mInputPathStart;
    private PathElt mInputPathEnd;
    private double mGlyphWidth;
    private int mNumSubPaths;
    private SubPathInfo[] mSubPaths;
    private ACBBox mPathBBox;
    private boolean mAllStems;
    private int[] mTopZones;
    private int[] mBottomZones;
    private HintedOutlineConsumer mOutlineConsumer;
    private int mEltSN;
    private int mCptSN;
    private int mCvlSN;
    private int mCsgSN;
    private double mCurX;
    private double mCurY;
    private ArrayList mZoneData = new ArrayList();
    private short[] VColorList = new short[]{109, 77, 84, 8230, 0};
    private short[] HColorList = new short[]{8712, 8801, 8713, 247, 0};
    private short[] UpperSpecialChars = new short[]{191, 161, 59, 0};
    private short[] LowerSpecialChars = new short[]{63, 33, 58, 0};
    private short[] NoBlueList = new short[]{64, 8226, 169, 164, 174, 0};

    public AutoColor(HintedOutlineConsumer hintedOutlineConsumer, double d, int n, boolean bl, boolean bl2, int[] nArray, int[] nArray2) {
        this.mOutlineConsumer = hintedOutlineConsumer;
        this.mOrigEmSquare = d;
        this.mDoWriteGlyph = bl;
        this.mDoAligns = bl2;
        this.mTopZones = nArray != null ? nArray : new int[]{};
        this.mBottomZones = nArray2 != null ? nArray2 : new int[]{};
        this.mScalinghints = true;
        this.mAllStems = true;
        this.mAutoHFix = false;
        this.mAutoVFix = false;
        this.mSubPathOpen = false;
        this.mExtracolor = (n & 2) != 0;
        this.mEditChar = (n & 1) != 0;
        this.mFixWinding = (n & 4) != 0;
        this.mGenerateVStems = (n & 8) != 0;
        this.copyBands();
        this.initAll();
    }

    public void newGlyph(int n, double d, int n2) {
        this.mGlyphWidth = d;
        this.mUnicode = n2;
        this.mInputPathStart = null;
        this.mInputPathEnd = null;
        this.mZoneData = new ArrayList();
    }

    public int[] reportZones() {
        int[] nArray = new int[this.mZoneData.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)this.mZoneData.get(i);
        }
        return nArray;
    }

    private void initData() {
        this.mDMIN = 50;
        this.mInitBigDist = this.psDist(150);
        this.mMinDist = this.psDist(7);
        this.mGhostWidth = this.psDist(20);
        this.mGhostLength = this.psDist(4);
        this.mBendLength = this.psDist(2);
        this.mPruneA = this.fixInt(50);
        this.mPruneC = 100;
        this.mPruneD = 256;
        double d = 10.24;
        this.mPruneValue = this.mPruneB = this.fltToFix(d);
        this.mCPpercent = 40;
        this.mBandMargin = this.psDist(30);
        this.mMaxFlare = this.psDist(10);
        this.mMaxBendMerge = this.psDist(6);
        this.mMaxMerge = this.psDist(2);
        this.mMinColorElementLength = this.psDist(12);
        this.mFlexCand = this.psDist(4);
        this.mMaxVal = 8000000.0;
        this.mMinVal = 0.00390625;
        this.mAutoVFix = false;
        this.mAutoHFix = false;
        this.mFlexOK = false;
        this.mFlexStrict = false;
        this.mDoSmoothing = false;
        this.mDoCounters = false;
        this.mBluefuzz = (int)(this.mOrigEmSquare / 2000.0);
        this.mPointList = null;
        this.mMaxPtLsts = 5;
        this.mPtLstArray = new ClrPoint[this.mMaxPtLsts];
        this.mPtLstIndex = 0;
        this.mPtLstArray[0] = null;
        this.mNumPtLsts = 1;
        this.mNumSubPaths = 0;
        this.mSubPaths = null;
        this.mPathBBox = null;
        this.mEltSN = 0;
        this.mCptSN = 0;
        this.mCvlSN = 0;
        this.mCsgSN = 0;
    }

    private int scaleAbs(int n) {
        if (!this.mScalinghints) {
            return n;
        }
        return (int)(1000.0 / this.mOrigEmSquare * (double)n);
    }

    private int unScaleAbs(int n) {
        if (!this.mScalinghints) {
            return n;
        }
        int n2 = (int)(this.mOrigEmSquare / 1000.0 * (double)n);
        n2 = this.fRnd(n2);
        return n2;
    }

    private void initAuto() {
        this.mHaveHBnds = false;
        this.mClrHBounds = false;
        this.mClrBBox = false;
        this.mHaveVBnds = false;
        this.mClrVBounds = false;
    }

    private PathElt getSubPathNxt(PathElt pathElt) {
        if (pathElt.type == 3) {
            return this.getDest(pathElt);
        }
        return pathElt.next;
    }

    private PathElt getSubPathPrv(PathElt pathElt) {
        if (pathElt.type == 0) {
            pathElt = this.getClosedBy(pathElt);
        }
        return pathElt.prev;
    }

    private ClrVal findClosestVal(ClrVal clrVal, int n) {
        int n2 = this.fixInt(10000);
        ClrVal clrVal2 = null;
        while (clrVal != null) {
            int n3;
            int n4 = clrVal.vLoc1;
            if (n4 > (n3 = clrVal.vLoc2)) {
                int n5 = n4;
                n4 = n3;
                n3 = n5;
            }
            if (n >= n4 && n <= n3) {
                clrVal2 = clrVal;
                break;
            }
            int n6 = n < n4 ? n4 - n : n - n3;
            if (n6 < n2) {
                n2 = n6;
                clrVal2 = clrVal;
            }
            clrVal = clrVal.vNxt;
        }
        return clrVal2;
    }

    private void cpyHClr(PathElt pathElt) {
        Cd cd = new Cd();
        this.getEndPoint(pathElt, cd);
        ClrVal clrVal = this.findClosestVal(this.mHprimary, cd.y);
        if (clrVal != null) {
            this.addHPair(clrVal, 'b');
        }
    }

    private void cpyVClr(PathElt pathElt) {
        Cd cd = new Cd();
        this.getEndPoint(pathElt, cd);
        ClrVal clrVal = this.findClosestVal(this.mVprimary, cd.x);
        if (clrVal != null) {
            this.addVPair(clrVal, 'y');
        }
    }

    private void pruneColorSegs(PathElt pathElt, boolean bl) {
        SegLnkLst segLnkLst = bl ? pathElt.Hs : pathElt.Vs;
        SegLnkLst segLnkLst2 = null;
        while (segLnkLst != null) {
            ClrSeg clrSeg;
            ClrVal clrVal = null;
            SegLnk segLnk = segLnkLst.lnk;
            if (segLnk != null && (clrSeg = segLnk.seg) != null) {
                clrVal = clrSeg.sLnk;
            }
            SegLnkLst segLnkLst3 = segLnkLst.next;
            if (clrVal == null) {
                if (segLnkLst2 == null) {
                    if (bl) {
                        pathElt.Hs = segLnkLst3;
                    } else {
                        pathElt.Vs = segLnkLst3;
                    }
                } else {
                    segLnkLst2.next = segLnkLst3;
                }
                segLnkLst = segLnkLst3;
                continue;
            }
            segLnkLst2 = segLnkLst;
            segLnkLst = segLnkLst3;
        }
    }

    private void pruneElementColorSegs() {
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            this.pruneColorSegs(pathElt, true);
            this.pruneColorSegs(pathElt, false);
            pathElt = pathElt.next;
        }
    }

    private SegLnkLst elmntClrSegLst(PathElt pathElt, boolean bl) {
        return bl ? pathElt.Hs : pathElt.Vs;
    }

    private void remLnk(PathElt pathElt, boolean bl, SegLnkLst segLnkLst) {
        SegLnkLst segLnkLst2 = bl ? pathElt.Hs : pathElt.Vs;
        SegLnkLst segLnkLst3 = null;
        while (segLnkLst2 != null) {
            SegLnkLst segLnkLst4 = segLnkLst2.next;
            if (segLnkLst2 == segLnkLst) {
                if (segLnkLst3 == null) {
                    if (bl) {
                        pathElt.Hs = segLnkLst4;
                    } else {
                        pathElt.Vs = segLnkLst4;
                    }
                } else {
                    segLnkLst3.next = segLnkLst4;
                }
                return;
            }
            segLnkLst3 = segLnkLst2;
            segLnkLst2 = segLnkLst4;
        }
    }

    private boolean alreadyOnList(ClrVal clrVal, ClrVal clrVal2) {
        while (clrVal2 != null) {
            if (clrVal == clrVal2) {
                return true;
            }
            clrVal2 = clrVal2.vNxt;
        }
        return false;
    }

    private void autoVSeg(ClrVal clrVal) {
        this.addVPair(clrVal, 'y');
    }

    private void autoHSeg(ClrVal clrVal) {
        this.addHPair(clrVal, 'b');
    }

    private void addHColoring(ClrVal clrVal) {
        if (this.mUseH || this.alreadyOnList(clrVal, this.mHcoloring)) {
            return;
        }
        clrVal.vNxt = this.mHcoloring;
        this.mHcoloring = clrVal;
        this.autoHSeg(clrVal);
    }

    private void addVColoring(ClrVal clrVal) {
        if (this.mUseV || this.alreadyOnList(clrVal, this.mVcoloring)) {
            return;
        }
        clrVal.vNxt = this.mVcoloring;
        this.mVcoloring = clrVal;
        this.autoVSeg(clrVal);
    }

    private int testColor(ClrSeg clrSeg, ClrVal clrVal, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (clrSeg == null) {
            return -1;
        }
        ClrVal clrVal2 = clrSeg.sLnk;
        int n3 = clrSeg.sLoc;
        if (clrVal2 == null) {
            return -1;
        }
        int n4 = n2 = clrVal2.vLoc2;
        int n5 = n = clrVal2.vLoc1;
        if (clrVal2.vGhst) {
            if (clrVal2.vSeg1.sType == 3) {
                n = n2;
            } else {
                n2 = n;
            }
        }
        if (clrVal2.vGhst) {
            boolean bl3;
            ClrVal clrVal3 = clrVal;
            if (Math.abs(n3 - n4) < Math.abs(n3 - n5)) {
                bl3 = false;
                n3 = n4;
            } else {
                bl3 = true;
                n3 = n5;
            }
            while (clrVal3 != null) {
                if ((bl3 ? clrVal3.vLoc1 : clrVal3.vLoc2) == n3) {
                    return -1;
                }
                clrVal3 = clrVal3.vNxt;
                if (bl2) continue;
            }
        }
        if (bl) {
            n2 += this.mBandMargin;
            n -= this.mBandMargin;
        } else {
            n2 -= this.mBandMargin;
            n += this.mBandMargin;
        }
        while (clrVal != null) {
            int n6 = clrVal.vLoc2;
            int n7 = clrVal.vLoc1;
            if (n5 == n7 && n4 == n6) {
                return -1;
            }
            if (clrVal.vGhst) {
                if (clrVal.vSeg1.sType == 3) {
                    n7 = n6;
                } else {
                    n6 = n7;
                }
            }
            if (bl && n7 <= n2 && n6 >= n || !bl && n7 >= n2 && n6 <= n) {
                return 0;
            }
            clrVal = clrVal.vNxt;
            if (bl2) continue;
            break;
        }
        return 1;
    }

    private int testColorLst(SegLnkLst segLnkLst, ClrVal clrVal, boolean bl, boolean bl2) {
        int n = -1;
        int n2 = 0;
        while (segLnkLst != null) {
            int n3 = this.testColor(segLnkLst.lnk.seg, clrVal, bl, bl2);
            if (n3 == 0) {
                n = 0;
                break;
            }
            if (n3 == 1) {
                n = 1;
            }
            segLnkLst = segLnkLst.next;
            if (++n2 <= 100) continue;
            return 0;
        }
        return n;
    }

    private boolean resolveConflictBySplit(PathElt pathElt, boolean bl, SegLnkLst segLnkLst, SegLnkLst segLnkLst2) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        Cd cd5 = new Cd();
        Cd cd6 = new Cd();
        Cd cd7 = new Cd();
        Cd cd8 = new Cd();
        if (pathElt.type != 2 || pathElt.isFlex) {
            return false;
        }
        PathElt pathElt2 = new PathElt();
        pathElt2.next = pathElt.next;
        pathElt.next = pathElt2;
        pathElt2.prev = pathElt;
        if (pathElt2.next == null) {
            this.mPathEnd = pathElt2;
        } else {
            pathElt2.next.prev = pathElt2;
        }
        if (bl) {
            pathElt.Hs = segLnkLst;
            pathElt2.Hs = segLnkLst2;
        } else {
            pathElt.Vs = segLnkLst;
            pathElt2.Vs = segLnkLst2;
        }
        if (segLnkLst != null) {
            segLnkLst.next = null;
        }
        if (segLnkLst2 != null) {
            segLnkLst2.next = null;
        }
        pathElt2.type = (short)2;
        this.getEndPoint(pathElt.prev, cd);
        cd2.x = pathElt.x1;
        cd2.y = pathElt.y1;
        cd3.x = pathElt.x2;
        cd3.y = pathElt.y2;
        cd4.x = pathElt.x3;
        cd4.y = pathElt.y3;
        cd5.copyFrom(cd);
        cd6.copyFrom(cd2);
        cd7.copyFrom(cd3);
        cd8.copyFrom(cd4);
        pathElt2.x3 = cd4.x;
        pathElt2.y3 = cd4.y;
        cd3.x = cd7.x + cd8.x >> 1;
        cd3.y = cd7.y + cd8.y >> 1;
        cd8.x = cd6.x + cd7.x >> 1;
        cd8.y = cd6.y + cd7.y >> 1;
        cd6.x = cd5.x + cd6.x >> 1;
        cd6.y = cd5.y + cd6.y >> 1;
        cd7.x = cd6.x + cd8.x >> 1;
        cd7.y = cd6.y + cd8.y >> 1;
        cd2.x = cd8.x + cd3.x >> 1;
        cd2.y = cd8.y + cd3.y >> 1;
        cd8.x = cd7.x + cd2.x >> 1;
        cd8.y = cd7.y + cd2.y >> 1;
        pathElt.x1 = cd6.x;
        pathElt.y1 = cd6.y;
        pathElt.x2 = cd7.x;
        pathElt.y2 = cd7.y;
        pathElt.x3 = cd8.x;
        pathElt.y3 = cd8.y;
        pathElt2.x1 = cd2.x;
        pathElt2.y1 = cd2.y;
        pathElt2.x2 = cd3.x;
        pathElt2.y2 = cd3.y;
        return true;
    }

    private void remDupLnks(PathElt pathElt, boolean bl) {
        SegLnkLst segLnkLst;
        SegLnkLst segLnkLst2 = segLnkLst = bl ? pathElt.Hs : pathElt.Vs;
        while (segLnkLst != null) {
            SegLnkLst segLnkLst3 = segLnkLst.next;
            while (segLnkLst3 != null) {
                SegLnkLst segLnkLst4 = segLnkLst3.next;
                if (segLnkLst.lnk.seg == segLnkLst3.lnk.seg) {
                    this.remLnk(pathElt, bl, segLnkLst3);
                }
                segLnkLst3 = segLnkLst4;
            }
            segLnkLst = segLnkLst.next;
        }
    }

    private boolean okToRemLnk(int n, boolean bl, int n2) {
        if (!bl || n2 == 0) {
            return true;
        }
        if (this.inBlueBand(n, this.mLenTopBands, this.mTopBands)) {
            return false;
        }
        return !this.inBlueBand(n, this.mLenBotBands, this.mBotBands);
    }

    private boolean tryResolveConflict(PathElt pathElt, boolean bl) {
        int n;
        int n2;
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        this.remDupLnks(pathElt, bl);
        short s = pathElt.type;
        if (s == 0) {
            this.getEndPoints(this.getClosedBy(pathElt), cd, cd2);
        } else if (s == 2) {
            cd.x = pathElt.x1;
            cd.y = pathElt.y1;
            cd2.x = pathElt.x3;
            cd2.y = pathElt.y3;
        } else {
            this.getEndPoints(pathElt, cd, cd2);
        }
        int n3 = bl ? cd.y : cd.x;
        int n4 = bl ? cd2.y : cd2.x;
        SegLnkLst segLnkLst = bl ? pathElt.Hs : pathElt.Vs;
        ClrSeg clrSeg = segLnkLst.lnk.seg;
        int n5 = clrSeg.sLoc;
        SegLnkLst segLnkLst2 = segLnkLst;
        segLnkLst = segLnkLst.next;
        ClrSeg clrSeg2 = segLnkLst.lnk.seg;
        int n6 = clrSeg2.sLoc;
        SegLnkLst segLnkLst3 = segLnkLst;
        if (n5 != n3 && n6 != n4 && (Math.abs(n5 - n3) > Math.abs(n5 - n4) || Math.abs(n6 - n4) > Math.abs(n6 - n3))) {
            ClrSeg clrSeg3 = clrSeg;
            clrSeg = clrSeg2;
            clrSeg2 = clrSeg3;
            segLnkLst = segLnkLst2;
            segLnkLst2 = segLnkLst3;
            segLnkLst3 = segLnkLst;
        }
        ClrVal clrVal = clrSeg.sLnk;
        ClrVal clrVal2 = clrSeg2.sLnk;
        if (clrVal.vVal < this.fixInt(50) && this.okToRemLnk(n3, bl, clrVal.vSpc)) {
            this.remLnk(pathElt, bl, segLnkLst2);
            return true;
        }
        if (clrVal2.vVal < this.fixInt(50) && clrVal.vVal > clrVal2.vVal * 20 && this.okToRemLnk(n4, bl, clrVal2.vSpc)) {
            this.remLnk(pathElt, bl, segLnkLst3);
            return true;
        }
        if (s != 2 || (bl && this.isHorizontal(cd.x, cd.y, cd2.x, cd2.y) || !bl && this.isVertical(cd.x, cd.y, cd2.x, cd2.y)) && this.okToRemLnk(n3, bl, clrVal.vSpc)) {
            this.remLnk(pathElt, bl, segLnkLst2);
            return true;
        }
        this.getEndPoints(this.getSubPathPrv(pathElt), cd, cd2);
        int n7 = n2 = bl ? cd.y : cd.x;
        if (this.prodLt0(n4 - n3, n2 - n3)) {
            this.remLnk(pathElt, bl, segLnkLst2);
            return true;
        }
        this.getEndPoint(this.getSubPathNxt(pathElt), cd2);
        int n8 = n = bl ? cd2.y : cd2.x;
        if (this.prodLt0(n - n4, n3 - n4)) {
            this.remLnk(pathElt, bl, segLnkLst3);
            return true;
        }
        if ((n4 == clrVal2.vLoc1 || n4 == clrVal2.vLoc2) && n3 != clrVal.vLoc1 && n3 != clrVal.vLoc2) {
            this.remLnk(pathElt, bl, segLnkLst2);
            return true;
        }
        if ((n3 == clrVal.vLoc1 || n3 == clrVal.vLoc2) && n4 != clrVal2.vLoc1 && n4 != clrVal2.vLoc2) {
            this.remLnk(pathElt, bl, segLnkLst3);
            return true;
        }
        return this.mEditChar && this.resolveConflictBySplit(pathElt, bl, segLnkLst2, segLnkLst3);
    }

    private boolean checkColorSegs(PathElt pathElt, boolean bl, boolean bl2) {
        SegLnkLst segLnkLst;
        SegLnkLst segLnkLst2 = segLnkLst = bl2 ? pathElt.Hs : pathElt.Vs;
        while (segLnkLst != null) {
            ClrSeg clrSeg;
            ClrVal clrVal;
            SegLnkLst segLnkLst3 = segLnkLst.next;
            if (segLnkLst3 != null && (clrVal = (clrSeg = segLnkLst.lnk.seg).sLnk) != null && this.testColorLst(segLnkLst3, clrVal, bl, false) == 0) {
                if (this.tryResolveConflict(pathElt, bl2)) {
                    return this.checkColorSegs(pathElt, bl, bl2);
                }
                if (bl2) {
                    pathElt.Hs = null;
                } else {
                    pathElt.Vs = null;
                }
                return true;
            }
            segLnkLst = segLnkLst3;
        }
        return false;
    }

    private void checkElmntClrSegs() {
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (!this.checkColorSegs(pathElt, true, true)) {
                this.checkColorSegs(pathElt, true, false);
            }
            pathElt = pathElt.next;
        }
    }

    private boolean clrLstsClash(SegLnkLst segLnkLst, SegLnkLst segLnkLst2, boolean bl) {
        while (segLnkLst != null) {
            ClrSeg clrSeg = segLnkLst.lnk.seg;
            ClrVal clrVal = clrSeg.sLnk;
            if (clrVal != null) {
                SegLnkLst segLnkLst3 = segLnkLst2;
                while (segLnkLst3 != null) {
                    if (this.testColorLst(segLnkLst3, clrVal, bl, false) == 0) {
                        return true;
                    }
                    segLnkLst3 = segLnkLst3.next;
                }
            }
            segLnkLst = segLnkLst.next;
        }
        return false;
    }

    private SegLnkLst bestFromLsts(SegLnkLst segLnkLst, SegLnkLst segLnkLst2) {
        SegLnkLst segLnkLst3 = null;
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            SegLnkLst segLnkLst4;
            SegLnkLst segLnkLst5 = segLnkLst4 = i != 0 ? segLnkLst : segLnkLst2;
            while (segLnkLst4 != null) {
                ClrSeg clrSeg = segLnkLst4.lnk.seg;
                ClrVal clrVal = clrSeg.sLnk;
                if (clrVal != null && clrVal.vVal > n) {
                    segLnkLst3 = segLnkLst4;
                    n = clrVal.vVal;
                }
                segLnkLst4 = segLnkLst4.next;
            }
        }
        return segLnkLst3;
    }

    private boolean clrsClash(PathElt pathElt, PathElt pathElt2, SegLnkLst[] segLnkLstArray, SegLnkLst[] segLnkLstArray2, SegLnkLst[] segLnkLstArray3, SegLnkLst[] segLnkLstArray4) {
        SegLnkLst segLnkLst;
        SegLnkLst segLnkLst2;
        boolean bl = false;
        if (this.clrLstsClash(segLnkLstArray[0], segLnkLstArray3[0], true)) {
            bl = true;
            segLnkLst2 = this.bestFromLsts(segLnkLstArray[0], segLnkLstArray3[0]);
            if (segLnkLst2 != null) {
                segLnkLst = new SegLnkLst();
                segLnkLst.next = null;
                segLnkLst.lnk = segLnkLst2.lnk;
            } else {
                segLnkLst = null;
            }
            segLnkLstArray[0] = segLnkLstArray3[0] = segLnkLst;
            pathElt.Hs = (pathElt2.Hs = segLnkLstArray3[0]);
        }
        if (this.clrLstsClash(segLnkLstArray2[0], segLnkLstArray4[0], true)) {
            bl = true;
            segLnkLst2 = this.bestFromLsts(segLnkLstArray2[0], segLnkLstArray4[0]);
            if (segLnkLst2 != null) {
                segLnkLst = new SegLnkLst();
                segLnkLst.next = null;
                segLnkLst.lnk = segLnkLst2.lnk;
            } else {
                segLnkLst = null;
            }
            segLnkLstArray2[0] = segLnkLstArray4[0] = segLnkLst;
            pathElt.Vs = (pathElt2.Vs = segLnkLstArray4[0]);
        }
        return bl;
    }

    private void getColorLsts(PathElt pathElt, SegLnkLst[] segLnkLstArray, SegLnkLst[] segLnkLstArray2, int[] nArray, int[] nArray2) {
        int n;
        SegLnkLst segLnkLst;
        int n2;
        SegLnkLst segLnkLst2;
        if (this.mUseH) {
            segLnkLst2 = null;
            n2 = -1;
        } else {
            segLnkLst2 = pathElt.Hs;
            n2 = segLnkLst2 == null ? -1 : this.testColorLst(segLnkLst2, this.mHcoloring, true, true);
        }
        if (this.mUseV) {
            segLnkLst = null;
            n = -1;
        } else {
            segLnkLst = pathElt.Vs;
            n = segLnkLst == null ? -1 : this.testColorLst(segLnkLst, this.mVcoloring, true, true);
        }
        segLnkLstArray2[0] = segLnkLst;
        segLnkLstArray[0] = segLnkLst2;
        nArray[0] = n2;
        nArray2[0] = n;
    }

    private void reClrBounds(PathElt pathElt) {
        if (!this.mUseH) {
            if (this.mClrHBounds && this.mHcoloring == null && !this.mHaveHBnds) {
                this.reClrHBnds(this.mBBox);
            } else if (!this.mClrBBox) {
                if (this.mHcoloring == null) {
                    this.cpyHClr(pathElt);
                }
                if (this.mMergeMain) {
                    this.mergeFromMainColors('b');
                }
            }
        }
        if (!this.mUseV) {
            if (this.mClrVBounds && this.mVcoloring == null && !this.mHaveVBnds) {
                this.reClrVBnds(this.mBBox);
            } else if (!this.mClrBBox) {
                if (this.mVcoloring == null) {
                    this.cpyVClr(pathElt);
                }
                if (this.mMergeMain) {
                    this.mergeFromMainColors('y');
                }
            }
        }
    }

    private void addColorLst(SegLnkLst segLnkLst, boolean bl) {
        while (segLnkLst != null) {
            ClrSeg clrSeg = segLnkLst.lnk.seg;
            ClrVal clrVal = clrSeg.sLnk;
            if (bl) {
                this.addVColoring(clrVal);
            } else {
                this.addHColoring(clrVal);
            }
            segLnkLst = segLnkLst.next;
        }
    }

    private void startNewColoring(PathElt pathElt, SegLnkLst segLnkLst, SegLnkLst segLnkLst2) {
        this.reClrBounds(pathElt);
        this.xtraClrs(pathElt);
        this.mClrBBox = false;
        if (this.mDoCounters && this.mUseV) {
            this.copyMainV();
        }
        this.mVcoloring = null;
        if (this.mDoCounters && this.mUseH) {
            this.copyMainH();
        }
        this.mHcoloring = null;
        if (!this.mUseH) {
            this.addColorLst(segLnkLst, false);
        }
        if (!this.mUseV) {
            this.addColorLst(segLnkLst2, true);
        }
    }

    private boolean isIn(int n, int n2) {
        return n == -1 && n2 == -1;
    }

    private boolean isOk(int n, int n2) {
        return n != 0 && n2 != 0;
    }

    private void addIfNeedV(int n, SegLnkLst segLnkLst) {
        if (!this.mUseV && n == 1) {
            this.addColorLst(segLnkLst, true);
        }
    }

    private void addIfNeedH(int n, SegLnkLst segLnkLst) {
        if (!this.mUseH && n == 1) {
            this.addColorLst(segLnkLst, false);
        }
    }

    private void setHColors(ClrVal clrVal) {
        if (this.mUseH) {
            return;
        }
        this.mHcoloring = clrVal;
        while (clrVal != null) {
            this.autoHSeg(clrVal);
            clrVal = clrVal.vNxt;
        }
    }

    private void setVColors(ClrVal clrVal) {
        if (this.mUseV) {
            return;
        }
        this.mVcoloring = clrVal;
        while (clrVal != null) {
            this.autoVSeg(clrVal);
            clrVal = clrVal.vNxt;
        }
    }

    private ClrVal copyClrs(ClrVal clrVal) {
        ClrVal clrVal2 = null;
        int n = 0;
        while (clrVal != null) {
            ClrVal clrVal3 = (ClrVal)clrVal.clone();
            clrVal3.vNxt = clrVal2;
            clrVal2 = clrVal3;
            if (++n > 100) {
                return clrVal2;
            }
            clrVal = clrVal.vNxt;
        }
        return clrVal2;
    }

    private boolean isFlare(int n, PathElt pathElt, PathElt pathElt2, boolean bl) {
        Cd cd = new Cd();
        while (pathElt != pathElt2) {
            this.getEndPoint(pathElt, cd);
            if (bl && Math.abs(cd.y - n) > this.mMaxFlare || !bl && Math.abs(cd.x - n) > this.mMaxFlare) {
                return false;
            }
            pathElt = this.getSubPathNxt(pathElt);
        }
        return true;
    }

    private boolean isTopSegOfVal(int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n3 - n;
        return Math.abs(n4) <= Math.abs(n5);
    }

    private void remFlareLnk(PathElt pathElt, boolean bl, SegLnkLst segLnkLst, PathElt pathElt2, int n) {
        this.remLnk(pathElt, bl, segLnkLst);
    }

    private boolean compareValues(ClrVal clrVal, ClrVal clrVal2, int n, int n2) {
        int n3;
        int n4 = clrVal.vVal;
        int n5 = n4 > (n3 = clrVal2.vVal) ? n4 : n3;
        n5 <<= 1;
        while (n5 > 0) {
            n5 <<= 1;
            n4 <<= 1;
            n3 <<= 1;
        }
        if (n2 > 0 && clrVal.vGhst != clrVal2.vGhst) {
            if (clrVal.vGhst) {
                n4 >>= n2;
            }
            if (clrVal2.vGhst) {
                n3 >>= n2;
            }
        }
        if (clrVal.vSpc > 0 && clrVal2.vSpc > 0 || clrVal.vSpc == 0 && clrVal2.vSpc == 0) {
            return n4 > n3;
        }
        if (clrVal.vSpc > 0) {
            return n4 < Integer.MAX_VALUE / n ? n4 * n > n3 : n4 > n3 / n;
        }
        return n3 < Integer.MAX_VALUE / n ? n4 > n3 * n : n4 / n > n3;
    }

    private void remFlares(boolean bl) {
        boolean bl2;
        boolean bl3;
        if (bl) {
            bl3 = true;
            bl2 = false;
        } else {
            bl3 = false;
            bl2 = true;
        }
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (bl3 ? pathElt.Hs == null : pathElt.Vs == null) {
                pathElt = pathElt.next;
                continue;
            }
            PathElt pathElt2 = this.getSubPathNxt(pathElt);
            boolean bl4 = false;
            while (pathElt2 != pathElt && !bl4) {
                if (bl3 ? pathElt2.Hs != null : pathElt2.Vs != null) {
                    SegLnkLst segLnkLst = this.elmntClrSegLst(pathElt, bl3);
                    while (segLnkLst != null) {
                        ClrSeg clrSeg = segLnkLst.lnk.seg;
                        SegLnkLst segLnkLst2 = segLnkLst.next;
                        SegLnkLst segLnkLst3 = this.elmntClrSegLst(pathElt2, bl3);
                        while (segLnkLst3 != null) {
                            ClrSeg clrSeg2 = segLnkLst3.lnk.seg;
                            SegLnkLst segLnkLst4 = segLnkLst3.next;
                            if (clrSeg != null && clrSeg2 != null) {
                                int n = clrSeg.sLoc - clrSeg2.sLoc;
                                if (Math.abs(n) > this.mMaxFlare || !this.isFlare(clrSeg.sLoc, pathElt, pathElt2, bl)) {
                                    bl4 = true;
                                    segLnkLst3 = segLnkLst4;
                                    continue;
                                }
                                ClrVal clrVal = clrSeg.sLnk;
                                ClrVal clrVal2 = clrSeg2.sLnk;
                                if (n != 0 && this.isTopSegOfVal(clrSeg.sLoc, clrVal.vLoc2, clrVal.vLoc1) == this.isTopSegOfVal(clrSeg2.sLoc, clrVal2.vLoc2, clrVal2.vLoc1)) {
                                    if (this.compareValues(clrVal, clrVal2, 1000, 0)) {
                                        if (clrVal2.vSpc == 0 && clrVal2.vVal < this.fixInt(1000)) {
                                            this.remFlareLnk(pathElt2, bl3, segLnkLst3, pathElt, 1);
                                        }
                                    } else if (clrVal.vSpc == 0 && clrVal.vVal < this.fixInt(1000)) {
                                        this.remFlareLnk(pathElt, bl3, segLnkLst, pathElt2, 2);
                                        break;
                                    }
                                }
                            }
                            segLnkLst3 = segLnkLst4;
                        }
                        segLnkLst = segLnkLst2;
                    }
                }
                if (bl2 ? pathElt2.Hs != null : pathElt2.Vs != null) break;
                pathElt2 = this.getSubPathNxt(pathElt2);
            }
            pathElt = pathElt.next;
        }
    }

    private void carryIfNeed(int n, boolean bl, ClrVal clrVal) {
        if (bl && this.mUseV || !bl && this.mUseH) {
            return;
        }
        int n2 = this.fixHalfMul(this.mBandMargin);
        if (n2 > this.fixInt(10)) {
            n2 = this.fixInt(10);
        }
        while (clrVal != null) {
            ClrSeg clrSeg = clrVal.vSeg1;
            if (clrVal.vGhst && clrSeg.sType == 3) {
                clrSeg = clrVal.vSeg2;
            }
            if (clrSeg != null) {
                int n3;
                int n4 = clrVal.vLoc2;
                if (n4 > (n3 = clrVal.vLoc1)) {
                    int n5 = n3;
                    n3 = n4;
                    n4 = n5;
                }
                if (n > (n4 -= n2) && n < (n3 += n2)) {
                    ClrVal clrVal2 = clrSeg.sLnk;
                    clrSeg.sLnk = clrVal;
                    if (bl) {
                        if (this.testColor(clrSeg, this.mVcoloring, true, true) == 1) {
                            this.addVColoring(clrVal);
                            clrSeg.sLnk = clrVal2;
                            break;
                        }
                    } else if (this.testColor(clrSeg, this.mHcoloring, true, true) == 1) {
                        this.addHColoring(clrVal);
                        clrSeg.sLnk = clrVal2;
                        break;
                    }
                    clrSeg.sLnk = clrVal2;
                }
            }
            clrVal = clrVal.vNxt;
        }
    }

    private void proClrs(PathElt pathElt, boolean bl, int n) {
        Cd cd = new Cd();
        SegLnkLst segLnkLst = this.elmntClrSegLst(pathElt, bl);
        if (segLnkLst == null) {
            return;
        }
        if (bl ? pathElt.Hcopy : pathElt.Vcopy) {
            return;
        }
        PathElt pathElt2 = pathElt;
        SegLnkLst segLnkLst2;
        while ((segLnkLst2 = this.elmntClrSegLst(pathElt2 = this.getSubPathPrv(pathElt2), bl)) == null) {
            this.getEndPoint(pathElt2, cd);
            int n2 = (bl ? cd.y : cd.x) - n;
            if (Math.abs(n2) > this.fixInt(50)) {
                return;
            }
            if (bl) {
                pathElt2.Hs = segLnkLst;
                pathElt2.Hcopy = true;
                continue;
            }
            pathElt2.Vs = segLnkLst;
            pathElt2.Vcopy = true;
        }
        return;
    }

    private void promoteColors() {
        Cd cd = new Cd();
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            this.getEndPoint(pathElt, cd);
            this.proClrs(pathElt, true, cd.y);
            this.proClrs(pathElt, false, cd.x);
            pathElt = pathElt.next;
        }
    }

    private void remPromotedClrs() {
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (pathElt.Hcopy) {
                pathElt.Hs = null;
                pathElt.Hcopy = false;
            }
            if (pathElt.Vcopy) {
                pathElt.Vs = null;
                pathElt.Vcopy = false;
            }
            pathElt = pathElt.next;
        }
    }

    private void remShortColors() {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            this.getEndPoint(pathElt, cd2);
            if (Math.abs(cd.x - cd2.x) < this.mMinColorElementLength && Math.abs(cd.y - cd2.y) < this.mMinColorElementLength) {
                pathElt.Hs = null;
                pathElt.Vs = null;
            }
            pathElt = pathElt.next;
            cd.x = cd2.x;
            cd.y = cd2.y;
        }
    }

    private void autoExtraColors(boolean bl) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        SegLnkLst[] segLnkLstArray = new SegLnkLst[1];
        SegLnkLst[] segLnkLstArray2 = new SegLnkLst[1];
        SegLnkLst[] segLnkLstArray3 = new SegLnkLst[1];
        SegLnkLst[] segLnkLstArray4 = new SegLnkLst[1];
        boolean bl2 = true;
        Cd cd = new Cd();
        this.mClrHBounds = false;
        this.mClrVBounds = false;
        this.mClrBBox = false;
        this.mMergeMain = this.countSubPaths(null) <= 5;
        PathElt pathElt = this.mPathStart;
        this.remFlares(true);
        this.remFlares(false);
        this.checkElmntClrSegs();
        this.promoteColors();
        this.remShortColors();
        this.mHaveVBnds = this.mClrVBounds;
        this.mHaveHBnds = this.mClrHBounds;
        PathElt pathElt2 = null;
        boolean bl3 = false;
        ClrVal clrVal = null;
        ClrVal clrVal2 = null;
        while (pathElt != null) {
            boolean bl4;
            PathElt pathElt3;
            short s = pathElt.type;
            if (bl && s == 0) {
                this.startNewColoring(pathElt, null, null);
                bl3 = false;
            }
            if (bl2 && pathElt == pathElt2) {
                this.startNewColoring(pathElt, null, null);
                this.setHColors(clrVal2);
                if (this.mGenerateVStems) {
                    this.setVColors(clrVal);
                }
                bl3 = true;
            }
            this.getColorLsts(pathElt, segLnkLstArray, segLnkLstArray2, nArray, nArray2);
            if (s == 0 && this.isShort(pathElt3 = this.getClosedBy(pathElt))) {
                pathElt2 = pathElt3.prev;
                this.getColorLsts(pathElt2, segLnkLstArray3, segLnkLstArray4, nArray3, nArray4);
                if (this.clrsClash(pathElt, pathElt2, segLnkLstArray, segLnkLstArray2, segLnkLstArray3, segLnkLstArray4)) {
                    this.getColorLsts(pathElt, segLnkLstArray, segLnkLstArray2, nArray, nArray2);
                    this.getColorLsts(pathElt2, segLnkLstArray3, segLnkLstArray4, nArray3, nArray4);
                }
                boolean bl5 = bl3 ? !this.isIn(nArray3[0], nArray4[0]) || !this.isIn(nArray[0], nArray2[0]) : (bl4 = !this.isOk(nArray3[0], nArray4[0]) || !this.isOk(nArray[0], nArray2[0]));
                if (bl4) {
                    this.startNewColoring(pathElt, segLnkLstArray[0], segLnkLstArray2[0]);
                    bl3 = false;
                    nArray4[0] = 1;
                    nArray3[0] = 1;
                } else {
                    this.addIfNeedH(nArray[0], segLnkLstArray[0]);
                    this.addIfNeedV(nArray2[0], segLnkLstArray2[0]);
                }
                this.addIfNeedH(nArray3[0], segLnkLstArray3[0]);
                this.addIfNeedV(nArray4[0], segLnkLstArray4[0]);
                bl2 = false;
            } else {
                boolean bl6 = bl3 ? !this.isIn(nArray[0], nArray2[0]) : (bl4 = !this.isOk(nArray[0], nArray2[0]));
                if (bl4) {
                    if (s == 3) {
                        pathElt = pathElt.prev;
                        this.getColorLsts(pathElt, segLnkLstArray, segLnkLstArray2, nArray, nArray2);
                    }
                    ClrVal clrVal3 = null;
                    ClrVal clrVal4 = this.copyClrs(this.mHcoloring);
                    if (this.mGenerateVStems) {
                        clrVal3 = this.copyClrs(this.mVcoloring);
                    }
                    if (!bl2) {
                        bl2 = true;
                        if (this.mGenerateVStems) {
                            clrVal = this.copyClrs(clrVal3);
                        }
                        clrVal2 = this.copyClrs(clrVal4);
                    }
                    this.startNewColoring(pathElt, segLnkLstArray[0], segLnkLstArray2[0]);
                    bl3 = false;
                    if (s == 2) {
                        cd.x = pathElt.x1;
                        cd.y = pathElt.y1;
                    } else {
                        this.getEndPoint(pathElt, cd);
                    }
                    this.carryIfNeed(cd.y, false, clrVal4);
                    if (this.mGenerateVStems) {
                        this.carryIfNeed(cd.x, true, clrVal3);
                    }
                } else {
                    this.addIfNeedH(nArray[0], segLnkLstArray[0]);
                    this.addIfNeedV(nArray2[0], segLnkLstArray2[0]);
                }
            }
            pathElt = pathElt.next;
        }
        this.reClrBounds(this.mPathEnd);
        this.remPromotedClrs();
    }

    private void initGen() {
        for (int i = 0; i < 4; ++i) {
            this.mSegLists[i] = null;
        }
        this.mHlnks = null;
        this.mVlnks = null;
    }

    private void linkSegment(PathElt pathElt, boolean bl, ClrSeg clrSeg) {
        SegLnk segLnk = new SegLnk();
        segLnk.seg = clrSeg;
        SegLnkLst segLnkLst = new SegLnkLst();
        SegLnkLst segLnkLst2 = new SegLnkLst();
        segLnkLst2.lnk = segLnk;
        segLnkLst.lnk = segLnk;
        if (bl) {
            segLnkLst.next = pathElt.Hs;
            pathElt.Hs = segLnkLst;
            segLnkLst2.next = this.mHlnks;
            this.mHlnks = segLnkLst2;
        } else {
            segLnkLst.next = pathElt.Vs;
            pathElt.Vs = segLnkLst;
            segLnkLst2.next = this.mVlnks;
            this.mVlnks = segLnkLst2;
        }
    }

    private void copySegmentLink(PathElt pathElt, PathElt pathElt2, boolean bl) {
        SegLnkLst segLnkLst = new SegLnkLst();
        if (bl) {
            segLnkLst.lnk = pathElt.Hs.lnk;
            segLnkLst.next = pathElt2.Hs;
            pathElt2.Hs = segLnkLst;
        } else {
            segLnkLst.lnk = pathElt.Vs.lnk;
            segLnkLst.next = pathElt2.Vs;
            pathElt2.Vs = segLnkLst;
        }
    }

    private void addSegment(int n, int n2, int n3, int n4, int n5, PathElt pathElt, PathElt pathElt2, boolean bl, int n6) {
        ClrSeg clrSeg = new ClrSeg();
        clrSeg.csgSN = ++this.mCsgSN;
        if (clrSeg.csgSN == 0) {
            ++this.mCsgSN;
        }
        clrSeg.sLoc = n3;
        if (n > n2) {
            clrSeg.sMax = n;
            clrSeg.sMin = n2;
        } else {
            clrSeg.sMax = n2;
            clrSeg.sMin = n;
        }
        clrSeg.sBonus = this.mBonus;
        clrSeg.sType = (short)n6;
        if (pathElt != null) {
            if (pathElt.type == 3) {
                pathElt = this.getDest(pathElt);
            }
            this.linkSegment(pathElt, bl, clrSeg);
            clrSeg.sElt = pathElt;
        }
        if (pathElt2 != null) {
            if (pathElt2.type == 3) {
                pathElt2 = this.getDest(pathElt2);
            }
            this.copySegmentLink(pathElt, pathElt2, bl);
            if (pathElt == null || pathElt2 == pathElt.prev) {
                clrSeg.sElt = pathElt2;
            }
        }
        int n7 = n > n2 ? n4 : n5;
        ClrSeg clrSeg2 = this.mSegLists[n7];
        ClrSeg clrSeg3 = null;
        while (true) {
            if (clrSeg2 == null) {
                if (clrSeg3 == null) {
                    this.mSegLists[n7] = clrSeg;
                    break;
                }
                clrSeg3.sNxt = clrSeg;
                break;
            }
            if (clrSeg2.sLoc >= n3) {
                if (clrSeg3 == null) {
                    this.mSegLists[n7] = clrSeg;
                } else {
                    clrSeg3.sNxt = clrSeg;
                }
                clrSeg.sNxt = clrSeg2;
                break;
            }
            clrSeg3 = clrSeg2;
            clrSeg2 = clrSeg2.sNxt;
        }
    }

    private void addVSegment(int n, int n2, int n3, PathElt pathElt, PathElt pathElt2, int n4, int n5) {
        this.addSegment(n, n2, n3, 0, 1, pathElt, pathElt2, false, n4);
    }

    private void addHSegment(int n, int n2, int n3, PathElt pathElt, PathElt pathElt2, int n4, int n5) {
        this.addSegment(n, n2, n3, 2, 3, pathElt, pathElt2, true, n4);
    }

    private int cpFrom(int n, int n2) {
        return (n2 - n) * this.mCpFrom / 100 + n;
    }

    private int cpTo(int n, int n2) {
        return (n2 - n) * this.mCpTo / 100 + n;
    }

    private boolean testBend(int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        double d2;
        double d3 = this.fixToFlt(n3 - n);
        double d4 = this.fixToFlt(n4 - n2);
        double d5 = this.fixToFlt(n5 - n3);
        double d6 = d3 * d5 + d4 * (d2 = this.fixToFlt(n6 - n4));
        return d6 * d6 / (d = (d3 * d3 + d4 * d4) * (d5 * d5 + d2 * d2)) <= 0.5;
    }

    private boolean testTan(int n, int n2) {
        return Math.abs(n) > Math.abs(n2) * 577 / 1000;
    }

    private int fRound(int n) {
        return this.fTrunc(this.fRnd(n));
    }

    private boolean isCCW(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.fRound(n3 - n);
        int n8 = this.fRound(n4 - n2);
        int n9 = this.fRound(n5 - n3);
        int n10 = this.fRound(n6 - n4);
        boolean bl = n7 * n10 >= n9 * n8;
        return bl;
    }

    private void doHBendsNxt(int n, int n2, int n3, int n4, PathElt pathElt) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        if (n2 == n4) {
            return;
        }
        this.nxtForBend(pathElt, cd, cd2);
        boolean bl = this.prodLt0(cd.y - n4, n4 - n2);
        if (bl || this.testTan(n3 - cd.x, n4 - cd.y) && (this.prodLt0(cd.x - n3, n3 - n) || this.isVertical(n, n2, n3, n4) && this.testBend(n, n2, n3, n4, cd.x, cd.y))) {
            int n5 = this.fixHalfMul(this.mBendLength);
            boolean bl2 = false;
            if (!(n <= n3 && n3 < cd.x || n < n3 && n3 <= cd.x)) {
                if (cd.x < n3 && n3 <= n || cd.x <= n3 && n3 < n) {
                    n5 = -n5;
                } else if (bl) {
                    boolean bl3;
                    boolean bl4 = n2 > n4;
                    if (bl4 != (bl3 = this.isCCW(n, n2, n3, n4, cd.x, cd.y))) {
                        n5 = -n5;
                    }
                } else {
                    bl2 = true;
                }
            }
            int n6 = n3 - n5;
            int n7 = n3 + n5;
            this.addHSegment(n6, n7, n4, pathElt, null, 1, 0);
            if (bl2) {
                this.addHSegment(n7, n6, n4, pathElt, null, 1, 1);
            }
        }
    }

    private void doHBendsPrv(int n, int n2, int n3, int n4, PathElt pathElt) {
        Cd cd = new Cd();
        if (n2 == n4) {
            return;
        }
        this.prvForBend(pathElt, cd);
        boolean bl = this.prodLt0(cd.y - n2, n2 - n4);
        if (bl || this.testTan(n - cd.x, n2 - cd.y) && (this.prodLt0(cd.x - n, n - n3) || this.isVertical(n, n2, n3, n4) && this.testBend(cd.x, cd.y, n, n2, n3, n4))) {
            int n5 = this.fixHalfMul(this.mBendLength);
            boolean bl2 = false;
            if (!(cd.x < n && n <= n3 || cd.x <= n && n < n3)) {
                boolean bl3;
                boolean bl4;
                if (n3 < n && n <= cd.x || n3 <= n && n < cd.x) {
                    n5 = -n5;
                } else if (bl && (bl4 = cd.y > n2) != (bl3 = this.isCCW(cd.x, cd.y, n, n2, n3, n4))) {
                    n5 = -n5;
                }
            }
            int n6 = n - n5;
            int n7 = n + n5;
            this.addHSegment(n6, n7, n2, pathElt.prev, null, 1, 2);
            if (bl2) {
                this.addHSegment(n7, n6, n2, pathElt.prev, null, 1, 3);
            }
        }
    }

    private void doVBendsNxt(int n, int n2, int n3, int n4, PathElt pathElt) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        if (n == n3) {
            return;
        }
        this.nxtForBend(pathElt, cd, cd2);
        boolean bl = this.prodLt0(cd.x - n3, n3 - n);
        if (bl || this.testTan(n4 - cd.y, n3 - cd.x) && (this.prodLt0(cd.y - n4, n4 - n2) || this.isHorizontal(n, n2, n3, n4) && this.testBend(n, n2, n3, n4, cd.x, cd.y))) {
            int n5 = this.fixHalfMul(this.mBendLength);
            boolean bl2 = false;
            if (!(n2 <= n4 && n4 < cd.y || n2 < n4 && n4 <= cd.y)) {
                if (cd.y < n4 && n4 <= n2 || cd.y <= n4 && n4 < n2) {
                    n5 = -n5;
                } else if (bl) {
                    boolean bl3;
                    boolean bl4 = n > n3;
                    if (bl4 != (bl3 = this.isCCW(n, n2, n3, n4, cd.x, cd.y))) {
                        n5 = -n5;
                    }
                } else {
                    bl2 = true;
                }
            }
            int n6 = n4 - n5;
            int n7 = n4 + n5;
            this.addVSegment(n6, n7, n3, pathElt, null, 1, 0);
            if (bl2) {
                this.addVSegment(n7, n6, n3, pathElt, null, 1, 1);
            }
        }
    }

    private void doVBendsPrv(int n, int n2, int n3, int n4, PathElt pathElt) {
        Cd cd = new Cd();
        if (n == n3) {
            return;
        }
        this.prvForBend(pathElt, cd);
        boolean bl = this.prodLt0(cd.x - n, n - n3);
        if (bl || this.testTan(n2 - cd.y, n - cd.x) && (this.prodLt0(cd.y - n2, n2 - n4) || this.isHorizontal(n, n2, n3, n4) && this.testBend(cd.x, cd.y, n, n2, n3, n4))) {
            int n5 = this.fixHalfMul(this.mBendLength);
            boolean bl2 = false;
            if (!(cd.y < n2 && n2 <= n4 || cd.y <= n2 && n2 < n4)) {
                boolean bl3;
                boolean bl4;
                if (n4 < n2 && n2 <= cd.y || n4 <= n2 && n2 < cd.y) {
                    n5 = -n5;
                } else if (bl && (bl4 = n > n3) != (bl3 = this.isCCW(cd.x, cd.y, n, n2, n3, n4))) {
                    n5 = -n5;
                }
            }
            int n6 = n2 - n5;
            int n7 = n2 + n5;
            this.addVSegment(n6, n7, n, pathElt.prev, null, 1, 2);
            if (bl2) {
                this.addVSegment(n7, n6, n, pathElt.prev, null, 1, 3);
            }
        }
    }

    private void MergeLnkSegs(ClrSeg clrSeg, ClrSeg clrSeg2, SegLnkLst segLnkLst) {
        while (segLnkLst != null) {
            SegLnk segLnk = segLnkLst.lnk;
            if (segLnk.seg == clrSeg) {
                segLnk.seg = clrSeg2;
            }
            segLnkLst = segLnkLst.next;
        }
    }

    private void mergeHSegs(ClrSeg clrSeg, ClrSeg clrSeg2) {
        this.MergeLnkSegs(clrSeg, clrSeg2, this.mHlnks);
    }

    private void mergeVSegs(ClrSeg clrSeg, ClrSeg clrSeg2) {
        this.MergeLnkSegs(clrSeg, clrSeg2, this.mVlnks);
    }

    private void remExtraBends(int n, int n2) {
        ClrSeg clrSeg = this.mSegLists[n];
        ClrSeg clrSeg2 = null;
        while (clrSeg != null) {
            ClrSeg clrSeg3 = clrSeg.sNxt;
            int n3 = clrSeg.sLoc;
            ClrSeg clrSeg4 = this.mSegLists[n2];
            ClrSeg clrSeg5 = null;
            while (clrSeg4 != null) {
                ClrSeg clrSeg6 = clrSeg4.sNxt;
                int n4 = clrSeg4.sLoc;
                if (n4 > n3) break;
                if (n4 == n3 && clrSeg4.sMin < clrSeg.sMax && clrSeg4.sMax > clrSeg.sMin) {
                    if (clrSeg.sType == 1 && clrSeg4.sType != 1 && clrSeg4.sType != 3 && clrSeg4.sMax - clrSeg4.sMin > (clrSeg.sMax - clrSeg.sMin) * 3) {
                        if (clrSeg2 == null) {
                            this.mSegLists[n] = clrSeg3;
                        } else {
                            clrSeg2.sNxt = clrSeg3;
                        }
                        clrSeg = clrSeg2;
                        break;
                    }
                    if (clrSeg4.sType == 1 && clrSeg.sType != 1 && clrSeg.sType != 3 && clrSeg.sMax - clrSeg.sMin > (clrSeg4.sMax - clrSeg4.sMin) * 3) {
                        if (clrSeg5 == null) {
                            this.mSegLists[n2] = clrSeg6;
                        } else {
                            clrSeg5.sNxt = clrSeg6;
                        }
                        clrSeg4 = clrSeg5;
                    }
                }
                clrSeg5 = clrSeg4;
                clrSeg4 = clrSeg6;
            }
            clrSeg2 = clrSeg;
            clrSeg = clrSeg3;
        }
    }

    private void compactList(int n, boolean bl) {
        ClrSeg clrSeg = this.mSegLists[n];
        ClrSeg clrSeg2 = null;
        while (clrSeg != null) {
            boolean bl2;
            ClrSeg clrSeg3 = clrSeg.sNxt;
            ClrSeg clrSeg4 = clrSeg;
            while (true) {
                if (clrSeg3 == null || clrSeg3.sLoc > clrSeg.sLoc) {
                    bl2 = true;
                    break;
                }
                int n2 = clrSeg.sMin;
                int n3 = clrSeg.sMax;
                int n4 = clrSeg3.sMin;
                int n5 = clrSeg3.sMax;
                if (n3 >= n4 && n2 <= n5) {
                    if (Math.abs(n3 - n2) > Math.abs(n5 - n4)) {
                        if (bl) {
                            this.mergeVSegs(clrSeg3, clrSeg);
                        } else {
                            this.mergeHSegs(clrSeg3, clrSeg);
                        }
                        clrSeg.sMin = Math.min(n2, n4);
                        clrSeg.sMax = Math.max(n3, n5);
                        clrSeg.sBonus = Math.max(clrSeg.sBonus, clrSeg3.sBonus);
                        clrSeg4.sNxt = clrSeg3.sNxt;
                    } else {
                        if (bl) {
                            this.mergeVSegs(clrSeg, clrSeg3);
                        } else {
                            this.mergeHSegs(clrSeg, clrSeg3);
                        }
                        clrSeg3.sMin = Math.min(n2, n4);
                        clrSeg3.sMax = Math.max(n3, n5);
                        clrSeg3.sBonus = Math.max(clrSeg.sBonus, clrSeg3.sBonus);
                        clrSeg = clrSeg.sNxt;
                        if (clrSeg2 == null) {
                            this.mSegLists[n] = clrSeg;
                        } else {
                            clrSeg2.sNxt = clrSeg;
                        }
                    }
                    bl2 = false;
                    break;
                }
                clrSeg4 = clrSeg3;
                clrSeg3 = clrSeg3.sNxt;
            }
            if (!bl2) continue;
            clrSeg2 = clrSeg;
            clrSeg = clrSeg.sNxt;
        }
    }

    private int pickVSpot(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13;
        if (n == n5 && n3 != n7) {
            return n;
        }
        if (n != n5 && n3 == n7) {
            return n3;
        }
        if (n == n9 && n3 != n11) {
            return n;
        }
        if (n != n9 && n3 == n11) {
            return n3;
        }
        int n14 = Math.abs(n6 - n2);
        if (n14 > (n13 = Math.abs(n8 - n4))) {
            return n;
        }
        n14 = Math.abs(n8 - n4);
        if (n14 > (n13 = Math.abs(n6 - n2))) {
            return n3;
        }
        if (n == n9 && n3 == n11) {
            n14 = Math.abs(n2 - n10);
            if (n14 > (n13 = Math.abs(n4 - n12))) {
                return n;
            }
            return n3;
        }
        return this.fixHalfMul(n + n3);
    }

    private int adjDist(int n, int n2) {
        if (n2 == 256) {
            return n;
        }
        return this.fTrunc(n * n2);
    }

    private boolean tstFlat(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 >= this.psDist(50) && n <= this.psDist(4);
    }

    private boolean nxtHorz(int n, int n2, PathElt pathElt) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        this.nxtForBend(pathElt, cd, cd2);
        return this.tstFlat(cd.y - n2, cd.x - n);
    }

    private boolean prvHorz(int n, int n2, PathElt pathElt) {
        Cd cd = new Cd();
        this.prvForBend(pathElt, cd);
        return this.tstFlat(cd.y - n2, cd.x - n);
    }

    private boolean nxtVert(int n, int n2, PathElt pathElt) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        this.nxtForBend(pathElt, cd, cd2);
        return this.tstFlat(cd.x - n, cd.y - n2);
    }

    private boolean prvVert(int n, int n2, PathElt pathElt) {
        Cd cd = new Cd();
        this.prvForBend(pathElt, cd);
        return this.tstFlat(cd.x - n, cd.y - n2);
    }

    private boolean tstSameDir(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.prodLt0(n2 - n4, n4 - n6) || this.prodLt0(n - n3, n3 - n5)) {
            return false;
        }
        return !this.testBend(n, n2, n3, n4, n5, n6);
    }

    private boolean prvSameDir(int n, int n2, int n3, int n4, PathElt pathElt) {
        Cd cd = new Cd();
        if ((pathElt = this.prvForBend(pathElt, cd)) != null && pathElt.type == 2 && pathElt.prev != null) {
            this.getEndPoint(pathElt.prev, cd);
        }
        return this.tstSameDir(n, n2, n3, n4, cd.x, cd.y);
    }

    private boolean nxtSameDir(int n, int n2, int n3, int n4, PathElt pathElt) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        if ((pathElt = this.nxtForBend(pathElt, cd, cd2)) != null && pathElt.type == 2) {
            cd.x = pathElt.x3;
            cd.y = pathElt.y3;
        }
        return this.tstSameDir(n, n2, n3, n4, cd.x, cd.y);
    }

    private void genVPts(int n) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        Cd cd5 = new Cd();
        PathElt pathElt = this.mPathStart;
        boolean bl = false;
        boolean bl2 = false;
        this.mCpTo = this.mCPpercent;
        this.mCpFrom = 100 - this.mCpTo;
        int n2 = 0;
        int n3 = 0;
        PathElt pathElt2 = null;
        while (pathElt != null) {
            int n4;
            int n5;
            int n6;
            Cd cd6 = new Cd();
            Cd cd7 = new Cd();
            this.getEndPoints(pathElt, cd6, cd7);
            if (pathElt.type == 2) {
                int n7;
                int n8;
                boolean bl3 = false;
                if (pathElt.isFlex) {
                    if (bl2) {
                        if (this.isVertical(n3, n2, cd7.x, cd7.y)) {
                            this.addVSegment(n2, cd7.y, cd7.x, pathElt2.prev, pathElt, 0, 4);
                        }
                        bl2 = false;
                        bl = true;
                    } else {
                        bl2 = true;
                        bl = false;
                        n3 = cd6.x;
                        n2 = cd6.y;
                        pathElt2 = pathElt;
                    }
                } else {
                    bl = false;
                    bl2 = false;
                }
                int n9 = pathElt.x1;
                int n10 = pathElt.y1;
                int n11 = pathElt.x2;
                int n12 = pathElt.y2;
                if (!bl) {
                    n6 = this.vertQuo(n9, n10, cd6.x, cd6.y);
                    if (n6 == 0) {
                        this.doVBendsPrv(cd6.x, cd6.y, n9, n10, pathElt);
                    } else {
                        bl3 = true;
                        if (n9 == cd6.x || n11 != cd7.x && (this.prvVert(n9, n10, pathElt) || !this.prvSameDir(cd7.x, cd7.y, cd6.x, cd6.y, pathElt))) {
                            n8 = this.vertQuo(n11, n12, cd6.x, cd6.y);
                            if (n8 > 0 && this.prodGe0(n10 - cd6.y, n12 - cd6.y) && Math.abs(n12 - cd6.y) > Math.abs(n10 - cd6.y)) {
                                n5 = this.adjDist(this.cpTo(n10, n12) - cd6.y, n8);
                                n7 = this.adjDist(this.cpTo(cd6.y, n10) - cd6.y, n6);
                                if (Math.abs(n7) > Math.abs(n5)) {
                                    n5 = n7;
                                }
                                this.addVSegment(cd6.y, cd6.y + n5, cd6.x, pathElt.prev, pathElt, 2, 5);
                            } else {
                                n5 = this.adjDist(this.cpTo(cd6.y, n10) - cd6.y, n6);
                                this.addVSegment(cd6.y, this.cpTo(cd6.y, n10), cd6.x, pathElt.prev, pathElt, 2, 6);
                            }
                        }
                    }
                }
                if (!bl2) {
                    n6 = this.vertQuo(n11, n12, cd7.x, cd7.y);
                    if (n6 == 0) {
                        this.doVBendsNxt(n11, n12, cd7.x, cd7.y, pathElt);
                    } else if (n11 == cd7.x || n9 != cd6.x && (this.nxtVert(n11, n12, pathElt) || !this.nxtSameDir(cd6.x, cd6.y, cd7.x, cd7.y, pathElt))) {
                        int n13;
                        n5 = this.adjDist(cd7.y - this.cpFrom(n12, cd7.y), n6);
                        bl3 = true;
                        n8 = this.vertQuo(cd6.x, cd6.y, cd7.x, cd7.y);
                        int n14 = n13 = n8 > 0 ? this.adjDist(cd7.y - cd6.y, n8) : 0;
                        if (bl3 && n8 > 0 && Math.abs(n13) > Math.abs(n5)) {
                            n5 = this.fixHalfMul(n13);
                            n4 = this.fixHalfMul(cd6.y + cd7.y);
                            this.prvForBend(pathElt, cd);
                            this.nxtForBend(pathElt, cd2, cd3);
                            this.addVSegment(n4 - n5, n4 + n5, this.pickVSpot(cd6.x, cd6.y, cd7.x, cd7.y, n9, n10, n11, n12, cd.x, cd.y, cd2.x, cd2.y), pathElt, null, 2, 7);
                        } else {
                            n8 = this.vertQuo(n9, n10, cd7.x, cd7.y);
                            if (n8 > 0 && this.prodGe0(n10 - cd7.y, n12 - cd7.y) && Math.abs(n12 - cd7.y) < Math.abs(n10 - cd7.y)) {
                                n7 = this.adjDist(cd7.y - this.cpFrom(n10, n12), n8);
                                if (Math.abs(n7) > Math.abs(n5)) {
                                    n5 = n7;
                                }
                                this.addVSegment(cd7.y - n5, cd7.y, cd7.x, pathElt, null, 2, 8);
                            } else {
                                this.addVSegment(cd7.y - n5, cd7.y, cd7.x, pathElt, null, 2, 9);
                            }
                        }
                    }
                }
                if (!bl2 && !bl) {
                    int n15 = Math.max(cd6.x, cd7.x);
                    int n16 = Math.min(cd6.x, cd7.x);
                    if (n9 - n15 >= 256 || n11 - n15 >= 256 || n9 - n16 <= 256 || n11 - n16 <= 256) {
                        this.findCurveBBox(cd6.x, cd6.y, n9, n10, n11, n12, cd7.x, cd7.y, cd4, cd5);
                        if (cd5.x - n15 > 256 || n16 - cd4.x > 256) {
                            int[] nArray = new int[1];
                            int[] nArray2 = new int[1];
                            int n17 = n16 - cd4.x > cd5.x - n15 ? cd4.x : cd5.x;
                            this.checkBBoxEdge(pathElt, true, n17, nArray, nArray2);
                            n4 = this.fixHalfMul(nArray[0] + nArray2[0]);
                            int n18 = n5 = nArray[0] == nArray2[0] ? (cd7.y - cd6.y) / 10 : this.fixHalfMul(nArray2[0] - nArray[0]);
                            if (Math.abs(n5) < this.mBendLength) {
                                n5 = n5 > 0 ? this.fixHalfMul(this.mBendLength) : this.fixHalfMul(-this.mBendLength);
                            }
                            this.addVSegment(n4 - n5, n4 + n5, n17, pathElt, null, 2, 10);
                        }
                    }
                }
            } else if (pathElt.type == 0) {
                this.mBonus = 0;
                if (n == -1) {
                    if (this.isLower(pathElt)) {
                        this.mBonus = this.fixInt(200);
                    }
                } else if (n == 1 && this.isUpper(pathElt)) {
                    this.mBonus = this.fixInt(200);
                }
            } else if (!this.isTiny(pathElt)) {
                n6 = this.vertQuo(cd6.x, cd6.y, cd7.x, cd7.y);
                if (n6 > 0) {
                    if (cd6.x == cd7.x) {
                        this.addVSegment(cd6.y, cd7.y, cd6.x, pathElt.prev, pathElt, 0, 11);
                    } else {
                        if (n6 < 64) {
                            n6 = 64;
                        }
                        n5 = this.fixHalfMul(this.adjDist(cd7.y - cd6.y, n6));
                        n4 = this.fixHalfMul(cd6.y + cd7.y);
                        this.prvForBend(pathElt, cd);
                        this.nxtForBend(pathElt, cd2, cd3);
                        this.addVSegment(n4 - n5, n4 + n5, this.pickVSpot(cd6.x, cd6.y, cd7.x, cd7.y, cd6.x, cd6.y, cd7.x, cd7.y, cd.x, cd.y, cd2.x, cd2.y), pathElt, null, 0, 12);
                    }
                } else {
                    this.doVBendsNxt(cd6.x, cd6.y, cd7.x, cd7.y, pathElt);
                    this.doVBendsPrv(cd6.x, cd6.y, cd7.x, cd7.y, pathElt);
                }
            }
            pathElt = pathElt.next;
        }
        this.compactList(0, true);
        this.compactList(1, true);
        this.remExtraBends(0, 1);
    }

    private boolean inBlueBand(int n, int n2, int[] nArray) {
        if (n2 <= 0) {
            return false;
        }
        int n3 = this.itfmy(n);
        for (int i = 0; i < n2; i += 2) {
            if (nArray[i] - this.mBluefuzz > n3 || nArray[i + 1] + this.mBluefuzz < n3) continue;
            return true;
        }
        return false;
    }

    private int pickHSpot(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = n5 < 0;
        if (bl3) {
            bl2 = this.inBlueBand(n2, this.mLenTopBands, this.mTopBands);
            bl = this.inBlueBand(n4, this.mLenTopBands, this.mTopBands);
        } else {
            bl2 = this.inBlueBand(n2, this.mLenBotBands, this.mBotBands);
            bl = this.inBlueBand(n4, this.mLenBotBands, this.mBotBands);
        }
        if (bl2 && !bl) {
            return n2;
        }
        if (bl && !bl2) {
            return n4;
        }
        if (n2 == n7 && n4 != n9) {
            return n2;
        }
        if (n2 != n7 && n4 == n9) {
            return n4;
        }
        if (n2 == n11 && n4 != n13) {
            return n2;
        }
        if (n2 != n11 && n4 == n13) {
            return n4;
        }
        if (bl2 && bl) {
            int n14;
            int n15;
            if (n2 > n4) {
                n15 = n2;
                n14 = n4;
            } else {
                n15 = n4;
                n14 = n2;
            }
            return bl3 ? n15 : n14;
        }
        if (Math.abs(n6 - n) > Math.abs(n8 - n3)) {
            return n2;
        }
        if (Math.abs(n8 - n3) > Math.abs(n6 - n)) {
            return n4;
        }
        if (n2 == n11 && n4 == n13) {
            if (Math.abs(n - n10) > Math.abs(n3 - n12)) {
                return n2;
            }
            return n4;
        }
        return this.fixHalfMul(n2 + n4);
    }

    private void genHPts() {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        Cd cd5 = new Cd();
        PathElt pathElt = this.mPathStart;
        this.mBonus = 0;
        int n = 0;
        int n2 = 0;
        PathElt pathElt2 = null;
        boolean bl = false;
        boolean bl2 = false;
        this.mCpTo = this.mCPpercent;
        this.mCpFrom = 100 - this.mCpTo;
        while (pathElt != null) {
            int n3;
            int n4;
            int n5;
            Cd cd6 = new Cd();
            Cd cd7 = new Cd();
            this.getEndPoints(pathElt, cd6, cd7);
            if (pathElt.type == 2) {
                int n6;
                int n7;
                int n8;
                boolean bl3 = false;
                if (pathElt.isFlex) {
                    if (bl2) {
                        bl2 = false;
                        bl = true;
                        if (this.isHorizontal(n2, n, cd7.x, cd7.y)) {
                            this.addHSegment(n2, cd7.x, cd7.y, pathElt2.prev, pathElt, 0, 4);
                        }
                    } else {
                        bl2 = true;
                        bl = false;
                        n2 = cd6.x;
                        n = cd6.y;
                        pathElt2 = pathElt;
                    }
                } else {
                    bl = false;
                    bl2 = false;
                }
                int n9 = pathElt.x1;
                int n10 = pathElt.y1;
                int n11 = pathElt.x2;
                int n12 = pathElt.y2;
                if (!bl) {
                    n5 = this.horzQuo(n9, n10, cd6.x, cd6.y);
                    if (n5 == 0) {
                        this.doHBendsPrv(cd6.x, cd6.y, n9, n10, pathElt);
                    } else {
                        bl3 = true;
                        if (n10 == cd6.y || n12 != cd7.y && (this.prvHorz(n9, n10, pathElt) || !this.prvSameDir(cd7.x, cd7.y, cd6.x, cd6.y, pathElt))) {
                            n8 = this.horzQuo(n11, n12, cd6.x, cd6.y);
                            if (n8 > 0 && this.prodGe0(n9 - cd6.x, n11 - cd6.x) && Math.abs(n11 - cd6.x) > Math.abs(n9 - cd6.x)) {
                                n4 = this.adjDist(this.cpTo(n9, n11) - cd6.x, n8);
                                n7 = this.adjDist(this.cpTo(cd6.x, n9) - cd6.x, n5);
                                if (Math.abs(n7) > Math.abs(n4)) {
                                    n4 = n7;
                                }
                                this.addHSegment(cd6.x, cd6.x + n4, cd6.y, pathElt.prev, pathElt, 2, 5);
                            } else {
                                n4 = this.adjDist(this.cpTo(cd6.x, n9) - cd6.x, n5);
                                this.addHSegment(cd6.x, cd6.x + n4, cd6.y, pathElt.prev, pathElt, 2, 6);
                            }
                        }
                    }
                }
                if (!bl2) {
                    n5 = this.horzQuo(n11, n12, cd7.x, cd7.y);
                    if (n5 == 0) {
                        this.doHBendsNxt(n11, n12, cd7.x, cd7.y, pathElt);
                    } else if (n12 == cd7.y || n10 != cd6.y && (this.nxtHorz(n11, n12, pathElt) || !this.nxtSameDir(cd6.x, cd6.y, cd7.x, cd7.y, pathElt))) {
                        int n13;
                        n4 = this.adjDist(cd7.x - this.cpFrom(n11, cd7.x), n5);
                        n8 = this.horzQuo(cd6.x, cd6.y, cd7.x, cd7.y);
                        bl3 = true;
                        int n14 = n13 = n8 > 0 ? this.adjDist(cd7.x - cd6.x, n8) : 0;
                        if (bl3 && n8 > 0 && Math.abs(n13) > Math.abs(n4)) {
                            this.prvForBend(pathElt, cd);
                            this.nxtForBend(pathElt, cd2, cd3);
                            n4 = this.fixHalfMul(n13);
                            n3 = this.fixHalfMul(cd6.x + cd7.x);
                            n6 = this.pickHSpot(cd6.x, cd6.y, cd7.x, cd7.y, n4, n9, n10, n11, n12, cd.x, cd.y, cd2.x, cd2.y);
                            this.addHSegment(n3 - n4, n3 + n4, n6, pathElt, null, 2, 7);
                        } else {
                            n8 = this.horzQuo(n9, n10, cd7.x, cd7.y);
                            if (n8 > 0 && this.prodGe0(n9 - cd7.x, n11 - cd7.x) && Math.abs(n11 - cd7.x) < Math.abs(n9 - cd7.x)) {
                                n7 = this.adjDist(cd7.x - this.cpFrom(n9, n11), n8);
                                if (Math.abs(n7) > Math.abs(n4)) {
                                    n4 = n7;
                                }
                                this.addHSegment(cd7.x - n4, cd7.x, cd7.y, pathElt, null, 2, 8);
                            } else {
                                this.addHSegment(cd7.x - n4, cd7.x, cd7.y, pathElt, null, 2, 9);
                            }
                        }
                    }
                }
                if (!bl2 && !bl) {
                    int n15 = Math.max(cd6.y, cd7.y);
                    n6 = Math.min(cd6.y, cd7.y);
                    if (n10 - n15 >= 256 || n12 - n15 >= 256 || n10 - n6 <= 256 || n12 - n6 <= 256) {
                        this.findCurveBBox(cd6.x, cd6.y, n9, n10, n11, n12, cd7.x, cd7.y, cd4, cd5);
                        if (cd5.y - n15 > 256 || n6 - cd4.y > 256) {
                            int[] nArray = new int[1];
                            int[] nArray2 = new int[1];
                            int n16 = n6 - cd4.y > cd5.y - n15 ? cd4.y : cd5.y;
                            this.checkBBoxEdge(pathElt, false, n16, nArray, nArray2);
                            n3 = this.fixHalfMul(nArray[0] + nArray2[0]);
                            int n17 = n4 = nArray[0] == nArray2[0] ? (cd7.x - cd6.x) / 10 : this.fixHalfMul(nArray2[0] - nArray[0]);
                            if (Math.abs(n4) < this.mBendLength) {
                                n4 = (double)n4 > 0.0 ? this.fixHalfMul(this.mBendLength) : this.fixHalfMul(-this.mBendLength);
                            }
                            this.addHSegment(n3 - n4, n3 + n4, n16, pathElt, null, 2, 10);
                        }
                    }
                }
            } else if (pathElt.type != 0 && !this.isTiny(pathElt)) {
                n5 = this.horzQuo(cd6.x, cd6.y, cd7.x, cd7.y);
                if (n5 > 0) {
                    if (cd6.y == cd7.y) {
                        this.addHSegment(cd6.x, cd7.x, cd6.y, pathElt.prev, pathElt, 0, 11);
                    } else {
                        if (n5 < 64) {
                            n5 = 64;
                        }
                        n4 = this.fixHalfMul(this.adjDist(cd7.x - cd6.x, n5));
                        n3 = this.fixHalfMul(cd6.x + cd7.x);
                        this.prvForBend(pathElt, cd);
                        this.nxtForBend(pathElt, cd2, cd3);
                        cd3.y = this.pickHSpot(cd6.x, cd6.y, cd7.x, cd7.y, n4, cd6.x, cd6.y, cd7.x, cd7.y, cd.x, cd.y, cd2.x, cd2.y);
                        this.addHSegment(n3 - n4, n3 + n4, cd3.y, pathElt.prev, pathElt, 0, 12);
                    }
                } else {
                    this.doHBendsNxt(cd6.x, cd6.y, cd7.x, cd7.y, pathElt);
                    this.doHBendsPrv(cd6.x, cd6.y, cd7.x, cd7.y, pathElt);
                }
            }
            pathElt = pathElt.next;
        }
        this.compactList(2, false);
        this.compactList(3, false);
        this.remExtraBends(2, 3);
    }

    private void preGenPts() {
        this.mHlnks = null;
        this.mSegLists[2] = null;
        this.mSegLists[3] = null;
        this.mVlnks = null;
        this.mSegLists[0] = null;
        this.mSegLists[1] = null;
    }

    private void initAll() {
        this.initData();
        this.initAuto();
        this.initFix();
        this.initGen();
        this.initPick();
    }

    private int ptLstLen(ClrPoint clrPoint) {
        int n = 0;
        while (clrPoint != null) {
            ++n;
            clrPoint = clrPoint.next;
        }
        return n;
    }

    private int pointListCheck(ClrPoint clrPoint, ClrPoint clrPoint2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char c = clrPoint.c;
        int n6 = this.fixHalfMul(this.mBandMargin);
        switch (c) {
            case 'm': 
            case 'y': {
                n4 = clrPoint.x0;
                n5 = clrPoint.x1;
                break;
            }
            case 'b': 
            case 'v': {
                n4 = clrPoint.y0;
                n5 = clrPoint.y1;
            }
        }
        if (n4 > n5) {
            n = n4;
            n4 = n5;
            n5 = n;
        }
        while (clrPoint2 != null) {
            if (clrPoint2.c == c) {
                switch (c) {
                    case 'm': 
                    case 'y': {
                        n2 = clrPoint2.x0;
                        n3 = clrPoint2.x1;
                        break;
                    }
                    case 'b': 
                    case 'v': {
                        n2 = clrPoint2.y0;
                        n3 = clrPoint2.y1;
                    }
                }
                if (n2 > n3) {
                    n = n2;
                    n2 = n3;
                    n3 = n;
                }
                if (n2 == n4 && n3 == n5) {
                    return 1;
                }
                if ((n2 -= n6) <= n5 && n4 <= (n3 += n6)) {
                    return 0;
                }
            }
            clrPoint2 = clrPoint2.next;
        }
        return -1;
    }

    private boolean sameColorLists(ClrPoint clrPoint, ClrPoint clrPoint2) {
        if (this.ptLstLen(clrPoint) != this.ptLstLen(clrPoint2)) {
            return false;
        }
        while (clrPoint != null) {
            if (this.pointListCheck(clrPoint, clrPoint2) != 1) {
                return false;
            }
            clrPoint = clrPoint.next;
        }
        return true;
    }

    private boolean sameColors(int n, int n2) {
        if (n == n2) {
            return true;
        }
        return this.sameColorLists(this.mPtLstArray[n], this.mPtLstArray[n2]);
    }

    private void mergeFromMainColors(char c) {
        ClrPoint clrPoint = this.mPtLstArray[0];
        while (clrPoint != null) {
            if (clrPoint.c == c && this.pointListCheck(clrPoint, this.mPointList) == -1) {
                if (c == 'b') {
                    this.addColorPoint(0, clrPoint.y0, 0, clrPoint.y1, c, clrPoint.p0, clrPoint.p1);
                } else {
                    this.addColorPoint(clrPoint.x0, 0, clrPoint.x1, 0, c, clrPoint.p0, clrPoint.p1);
                }
            }
            clrPoint = clrPoint.next;
        }
    }

    private void addColorPoint(int n, int n2, int n3, int n4, char c, PathElt pathElt, PathElt pathElt2) {
        ClrPoint clrPoint = new ClrPoint();
        clrPoint.cptSN = ++this.mCptSN;
        if (clrPoint.cptSN == 0) {
            clrPoint.cptSN++;
        }
        clrPoint.x0 = n;
        clrPoint.y0 = n2;
        clrPoint.x1 = n3;
        clrPoint.y1 = n4;
        clrPoint.c = c;
        clrPoint.done = false;
        clrPoint.next = null;
        clrPoint.p0 = pathElt;
        clrPoint.p1 = pathElt2;
        int n5 = this.pointListCheck(clrPoint, this.mPointList);
        if (n5 == -1) {
            clrPoint.next = this.mPointList;
            this.mPointList = clrPoint;
        }
    }

    private void copyClrFromLst(char c, ClrPoint clrPoint) {
        boolean bl;
        boolean bl2 = bl = c == 'b' || c == 'v';
        while (clrPoint != null) {
            if (clrPoint.c == c) {
                if (bl) {
                    this.addColorPoint(0, clrPoint.y0, 0, clrPoint.y1, c, clrPoint.p0, clrPoint.p1);
                } else {
                    this.addColorPoint(clrPoint.x0, 0, clrPoint.x1, 0, c, clrPoint.p0, clrPoint.p1);
                }
            }
            clrPoint = clrPoint.next;
        }
    }

    private void copyMainV() {
        this.copyClrFromLst('m', this.mPtLstArray[0]);
    }

    private void copyMainH() {
        this.copyClrFromLst('v', this.mPtLstArray[0]);
    }

    private void addHPair(ClrVal clrVal, char c) {
        int n = this.itfmy(clrVal.vLoc1);
        int n2 = this.itfmy(clrVal.vLoc2);
        PathElt pathElt = clrVal.vBst.vSeg1.sElt;
        PathElt pathElt2 = clrVal.vBst.vSeg2.sElt;
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
            PathElt pathElt3 = pathElt;
            pathElt = pathElt2;
            pathElt2 = pathElt3;
        }
        if (clrVal.vGhst) {
            if (clrVal.vSeg1.sType == 3) {
                n = n2;
                pathElt = pathElt2;
                pathElt2 = null;
                n2 = n + this.fixInt(-20);
            } else {
                n2 = n;
                pathElt2 = pathElt;
                pathElt = null;
                n = n2 - this.fixInt(-21);
            }
        }
        this.addColorPoint(0, n, 0, n2, c, pathElt, pathElt2);
    }

    private void addVPair(ClrVal clrVal, char c) {
        int n = this.itfmx(clrVal.vLoc1);
        int n2 = this.itfmx(clrVal.vLoc2);
        PathElt pathElt = clrVal.vBst.vSeg1.sElt;
        PathElt pathElt2 = clrVal.vBst.vSeg2.sElt;
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
            PathElt pathElt3 = pathElt;
            pathElt = pathElt2;
            pathElt2 = pathElt3;
        }
        this.addColorPoint(n, 0, n2, 0, c, pathElt, pathElt2);
    }

    private boolean useCounter(ClrVal clrVal, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = n = this.fixInt(20000);
        int n4 = n;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ClrVal clrVal2 = clrVal;
        while (clrVal2 != null) {
            ++n2;
            clrVal2 = clrVal2.vNxt;
        }
        if (n2 < 3) {
            return false;
        }
        n2 -= 3;
        int n8 = 0;
        while (n2 > 0) {
            if (--n2 == 0) {
                n8 = clrVal.vVal;
            }
            clrVal = clrVal.vNxt;
        }
        int n9 = clrVal.vVal;
        if (n8 > this.fixInt(1000) || n9 < n8 * 10) {
            return false;
        }
        ClrVal clrVal3 = clrVal;
        while (clrVal != null) {
            int n10;
            int n11 = clrVal.vLoc1;
            if ((n11 += this.fixHalfMul(n10 = clrVal.vLoc2 - n11)) < n4) {
                n = n3;
                n5 = n6;
                n3 = n4;
                n6 = n7;
                n4 = n11;
                n7 = n10;
            } else if (n11 < n3) {
                n = n3;
                n5 = n6;
                n3 = n11;
                n6 = n10;
            } else {
                n = n11;
                n5 = n10;
            }
            clrVal = clrVal.vNxt;
        }
        int n12 = this.fixInt(5) / 100;
        if (Math.abs(n7 - n5) < n12 && Math.abs(n - n3 - (n3 - n4)) < n12) {
            if (bl) {
                this.mVcoloring = clrVal3;
            } else {
                this.mHcoloring = clrVal3;
            }
            return true;
        }
        return false;
    }

    private void getNewPtLst() {
        if (this.mNumPtLsts >= this.mMaxPtLsts) {
            this.mMaxPtLsts += 5;
            ClrPoint[] clrPointArray = new ClrPoint[this.mMaxPtLsts];
            for (int i = 0; i < this.mMaxPtLsts - 5; ++i) {
                clrPointArray[i] = this.mPtLstArray[i];
            }
            this.mPtLstArray = clrPointArray;
        }
        this.mPtLstIndex = this.mNumPtLsts++;
        this.mPointList = null;
        this.mPtLstArray[this.mPtLstIndex] = null;
    }

    private void xtraClrs(PathElt pathElt) {
        this.mPtLstArray[this.mPtLstIndex] = this.mPointList;
        if (pathElt.newcolors == 0) {
            this.getNewPtLst();
            pathElt.newcolors = (short)this.mPtLstIndex;
        }
        this.mPtLstIndex = pathElt.newcolors;
        this.mPointList = this.mPtLstArray[this.mPtLstIndex];
    }

    private void blues() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.noBlueChar(this.mUnicode)) {
            this.mLenBotBands = 0;
            this.mLenTopBands = 0;
        }
        this.genHPts();
        if (this.mDoCounters && !this.mCounterFailed && this.hColorChar(this.mUnicode)) {
            n = this.mPruneValue;
            this.mPruneValue = this.fltToFix(this.mMinVal);
            n5 = this.mPruneA;
            this.mPruneA = this.fltToFix(this.mMinVal);
            n2 = this.mPruneD;
            this.mPruneD = this.fltToFix(this.mMinVal);
            n3 = this.mPruneC;
            this.mPruneC = this.fltToFix(this.mMaxVal);
            n4 = this.mPruneB;
            this.mPruneB = this.fltToFix(this.mMinVal);
        }
        this.evalH();
        this.pruneHVals();
        this.findBestHVals();
        this.mergeVals(false);
        this.markLinks(this.mValList, true);
        this.checkVals(this.mValList, false);
        this.doHStems(this.mValList);
        this.pickHVals(this.mValList);
        if (this.mDoCounters && !this.mCounterFailed && this.hColorChar(this.mUnicode)) {
            this.mPruneValue = n;
            this.mPruneD = n2;
            this.mPruneC = n3;
            this.mPruneB = n4;
            this.mPruneA = n5;
            this.mUseH = this.useCounter(this.mHcoloring, false);
            if (!this.mUseH) {
                this.addBBoxHV(true, true);
                this.mUseH = this.useCounter(this.mHcoloring, false);
                if (!this.mUseH) {
                    this.mCounterFailed = true;
                }
            }
        } else {
            this.mUseH = false;
        }
        if (this.mHcoloring == null) {
            this.addBBoxHV(true, false);
        }
        ClrVal clrVal = this.mHcoloring;
        while (clrVal != null) {
            this.addHPair(clrVal, this.mUseH ? (char)'v' : 'b');
            clrVal = clrVal.vNxt;
        }
    }

    private void doHStems(ClrVal clrVal) {
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        ACBBox aCBBox = new ACBBox();
        if (!this.mDoAligns) {
            return;
        }
        this.findPathBBox(aCBBox);
        this.addCharExtreme(this.unScaleAbs(this.itfmy(aCBBox.ymin)), this.unScaleAbs(this.itfmy(aCBBox.ymax)));
        while (clrVal != null) {
            int n3 = this.itfmy(clrVal.vLoc1);
            int n4 = this.itfmy(clrVal.vLoc2);
            if (n4 < n3) {
                int n5 = n4;
                n4 = n3;
                n3 = n5;
            }
            if (n4 > n) {
                n = n4;
            }
            if (n3 < n2) {
                n2 = n3;
            }
            if (clrVal.vGhst) {
                clrVal = clrVal.vNxt;
                continue;
            }
            boolean bl = !this.findLineSeg(clrVal.vLoc1, this.botList()) && !this.findLineSeg(clrVal.vLoc2, this.topList());
            this.addHStem(this.unScaleAbs(n4), this.unScaleAbs(n3), bl);
            clrVal = clrVal.vNxt;
            if (n4 == Integer.MIN_VALUE && n3 == Integer.MAX_VALUE) continue;
            this.addZone(this.unScaleAbs(n3), this.unScaleAbs(n4));
        }
        if (n != Integer.MIN_VALUE || n2 != Integer.MAX_VALUE) {
            this.addCharZone(this.unScaleAbs(n2), this.unScaleAbs(n));
        }
    }

    private void yellows() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.genVPts(this.specialCharType(this.mUnicode));
        if (this.mDoCounters && !this.mCounterFailed && this.vColorChar(this.mUnicode)) {
            n = this.mPruneValue;
            this.mPruneValue = this.fltToFix(this.mMinVal);
            n5 = this.mPruneA;
            this.mPruneA = this.fltToFix(this.mMinVal);
            n2 = this.mPruneD;
            this.mPruneD = this.fltToFix(this.mMinVal);
            n3 = this.mPruneC;
            this.mPruneC = this.fltToFix(this.mMaxVal);
            n4 = this.mPruneB;
            this.mPruneB = this.fltToFix(this.mMinVal);
        }
        this.evalV();
        this.pruneVVals();
        this.findBestVVals();
        this.mergeVals(true);
        this.markLinks(this.mValList, false);
        this.checkVals(this.mValList, true);
        this.doVStems(this.mValList);
        this.pickVVals(this.mValList);
        if (this.mDoCounters && !this.mCounterFailed && this.vColorChar(this.mUnicode)) {
            this.mPruneValue = n;
            this.mPruneD = n2;
            this.mPruneC = n3;
            this.mPruneB = n4;
            this.mPruneA = n5;
            this.mUseV = this.useCounter(this.mVcoloring, true);
            if (!this.mUseV) {
                this.addBBoxHV(false, true);
                this.mUseV = this.useCounter(this.mVcoloring, true);
                if (!this.mUseV) {
                    this.mCounterFailed = true;
                }
            }
        } else {
            this.mUseV = false;
        }
        if (this.mVcoloring == null) {
            this.addBBoxHV(false, false);
        }
        ClrVal clrVal = this.mVcoloring;
        while (clrVal != null) {
            this.addVPair(clrVal, this.mUseV ? (char)'m' : 'y');
            clrVal = clrVal.vNxt;
        }
    }

    private void doVStems(ClrVal clrVal) {
        if (!this.mDoAligns) {
            return;
        }
        while (clrVal != null) {
            int n;
            boolean bl = !this.findLineSeg(clrVal.vLoc1, this.leftList()) && !this.findLineSeg(clrVal.vLoc2, this.rightList());
            int n2 = this.itfmx(clrVal.vLoc1);
            if (n2 > (n = this.itfmx(clrVal.vLoc2))) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            this.addVStem(this.unScaleAbs(n), this.unScaleAbs(n2), bl);
            clrVal = clrVal.vNxt;
        }
    }

    private void removeRedundantFirstColors() {
        if (this.mNumPtLsts < 2) {
            return;
        }
        if (!this.sameColors(0, 1)) {
            return;
        }
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (pathElt.newcolors == 1) {
                pathElt.newcolors = (short)0;
                return;
            }
            pathElt = pathElt.next;
        }
    }

    private void addColorsSetup() throws ACException {
        int n;
        this.mVBigDist = 0;
        for (n = 0; n < this.mNumVStems; ++n) {
            if (this.mVStems[n] <= this.mVBigDist) continue;
            this.mVBigDist = this.mVStems[n];
        }
        this.mVBigDist = this.dtfmx(this.mVBigDist);
        if (this.mVBigDist < this.mInitBigDist) {
            this.mVBigDist = this.mInitBigDist;
        }
        this.mVBigDist = this.mVBigDist * 23 / 20;
        this.mVBigDistR = this.fixToFlt(this.mVBigDist);
        this.mHBigDist = 0;
        for (n = 0; n < this.mNumHStems; ++n) {
            if (this.mHStems[n] <= this.mHBigDist) continue;
            this.mHBigDist = this.mHStems[n];
        }
        this.mHBigDist = Math.abs(this.dtfmy(this.mHBigDist));
        if (this.mHBigDist < this.mInitBigDist) {
            this.mHBigDist = this.mInitBigDist;
        }
        this.mHBigDist = this.mHBigDist * 23 / 20;
        this.mHBigDistR = this.fixToFlt(this.mHBigDist);
        if (!this.mScalinghints) {
            this.roundPathCoords();
        }
        this.checkForMultiMoveTo();
        this.collectSubPathInfo();
        if (this.mFixWinding) {
            this.fixPathWind(true);
        }
    }

    private void addColorsInnerLoop() throws ACException {
        int n = 0;
        while (true) {
            this.preGenPts();
            if (this.mDoSmoothing) {
                this.checkSmooth();
            }
            this.initShuffleSubpaths();
            this.blues();
            if (this.mGenerateVStems) {
                this.yellows();
            }
            if (!this.mDoWriteGlyph) {
                return;
            }
            if (this.mEditChar) {
                this.doShuffleSubpaths();
            }
            this.mHprimary = this.copyClrs(this.mHcoloring);
            if (this.mGenerateVStems) {
                this.mVprimary = this.copyClrs(this.mVcoloring);
            }
            this.pruneElementColorSegs();
            if (this.mExtracolor) {
                this.autoExtraColors(this.moveToNewClrs(this.mUnicode));
            }
            this.mPtLstArray[this.mPtLstIndex] = this.mPointList;
            if (!(this.mCounterFailed && ++n == 1 || this.doFixes() && n <= 2)) break;
            this.initAll();
            this.resetGlyph();
            this.addColorsSetup();
            if (!this.preCheckForColoring()) break;
            if (!this.mFlexOK) continue;
            this.autoAddFlex();
        }
    }

    private void addColorsCleanup() {
        this.removeRedundantFirstColors();
        if (this.mPathStart != null && this.mPathStart != this.mPathEnd) {
            this.writeGlyph();
        }
        this.initAll();
    }

    private void addColors() throws ACException {
        if (this.mPathStart == null || this.mPathStart == this.mPathEnd) {
            this.writeGlyph();
            return;
        }
        this.mCounterFailed = false;
        this.addColorsSetup();
        if (!this.preCheckForColoring()) {
            this.writeGlyph();
            return;
        }
        if (this.mFlexOK) {
            this.autoAddFlex();
        }
        this.addColorsInnerLoop();
        this.addColorsCleanup();
    }

    private boolean doGlyph() throws ACException {
        this.resetGlyph();
        this.addColors();
        return true;
    }

    private boolean lePruneValue(int n) {
        return n < 256 && n << 10 <= this.mPruneValue;
    }

    private void adjustVal(int[] nArray, int n, int n2, int n3, int n4, boolean bl) {
        double d;
        double d2;
        double d3;
        if (n3 < 256) {
            n3 = 256;
        }
        if (n < 256) {
            n = 256;
        }
        if (n2 < 256) {
            n2 = 256;
        }
        if (Math.abs(n) < 32768) {
            d3 = n * n;
        } else {
            d3 = n;
            d3 *= d3;
        }
        if (Math.abs(n2) < 32768) {
            d2 = n2 * n2;
        } else {
            d2 = n2;
            d2 *= d2;
        }
        if (Math.abs(n3) < 32768) {
            d = n3 * n3;
        } else {
            d = n3;
            d *= d;
        }
        double d4 = 1000.0 * d3 * d2 / (d * d);
        if (n4 > (bl ? this.mHBigDist : this.mVBigDist)) {
            double d5 = this.fixToFlt(n4);
            double d6 = d = bl ? this.mHBigDistR : this.mVBigDistR;
            if (d + d <= d5) {
                d4 = 0.0;
            } else {
                d /= d5;
                d *= d;
                d *= d;
                d *= d;
                d4 *= d;
            }
        }
        if (d4 > this.mMaxVal) {
            d4 = this.mMaxVal;
        } else if (d4 > 0.0 && d4 < this.mMinVal) {
            d4 = this.mMinVal;
        }
        nArray[0] = this.fltToFix(d4);
    }

    private int calcOverlapDist(int n, int n2, int n3) {
        double d = n;
        double d2 = n2;
        double d3 = n3;
        n = (int)(d *= 1.0 + 0.4 * (1.0 - d2 / d3));
        return n;
    }

    private int gapDist(int n) {
        if (n < this.fixInt(127)) {
            return this.fTrunc(n * n / 20);
        }
        return this.fTrunc(n * (n / 20));
    }

    private void evalHPair(ClrSeg clrSeg, ClrSeg clrSeg2, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        nArray[0] = 0;
        int n3 = clrSeg.sMax;
        int n4 = clrSeg.sMin;
        int n5 = clrSeg2.sMax;
        int n6 = clrSeg2.sMin;
        int n7 = clrSeg.sLoc;
        int n8 = Math.abs(n7 - (n2 = clrSeg2.sLoc));
        if (n8 < this.mMinDist) {
            nArray2[0] = 0;
            return;
        }
        boolean bl = this.inBlueBand(n7, this.mLenBotBands, this.mBotBands);
        boolean bl2 = this.inBlueBand(n2, this.mLenTopBands, this.mTopBands);
        if (bl && bl2) {
            nArray2[0] = 0;
            return;
        }
        if (bl || bl2) {
            nArray[0] = this.fixInt(2);
        }
        if (n6 <= n3 && n5 >= n4) {
            int n9 = Math.min(n5, n3) - Math.max(n6, n4);
            int n10 = Math.min(n5 - n6, n3 - n4);
            n = n10 == n9 ? n8 : this.calcOverlapDist(n8, n9, n10);
        } else {
            int n11 = Math.abs(n6 - n3);
            int n12 = Math.abs(n5 - n4);
            int n13 = Math.min(n11, n12);
            n = this.gapDist(n13) + 7 * n8 / 5;
            if (n13 > n8) {
                n *= n13 / n8;
            }
        }
        int n14 = this.fixTwoMul(this.mMinDist);
        n = Math.max(n, n14);
        if (this.mNumHStems > 0) {
            int n15 = this.idtfmy(n8);
            n15 = Math.abs(n15);
            for (int i = 0; i < this.mNumHStems; ++i) {
                if (n15 != this.mHStems[i]) continue;
                nArray[0] = nArray[0] + 256;
                break;
            }
        }
        this.adjustVal(nArray2, n3 - n4, n5 - n6, n, n8, true);
    }

    private void evalVPair(ClrSeg clrSeg, ClrSeg clrSeg2, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        nArray[0] = 0;
        int n3 = clrSeg.sMax;
        int n4 = clrSeg.sMin;
        int n5 = clrSeg2.sMax;
        int n6 = clrSeg2.sMin;
        int n7 = clrSeg.sLoc;
        int n8 = Math.abs(n7 - (n2 = clrSeg2.sLoc));
        if (n8 < this.mMinDist) {
            nArray2[0] = 0;
            return;
        }
        if (n3 >= n6 && n4 <= n5) {
            int n9 = Math.min(n3, n5) - Math.max(n4, n6);
            int n10 = Math.min(n3 - n4, n5 - n6);
            n = n10 == n9 ? n8 : this.calcOverlapDist(n8, n9, n10);
        } else {
            int n11 = Math.abs(n3 - n6);
            int n12 = Math.abs(n4 - n5);
            int n13 = Math.min(n11, n12);
            n = 7 * n8 / 5 + this.gapDist(n13);
            if (n13 > n8) {
                n *= n13 / n8;
            }
        }
        int n14 = this.fixTwoMul(this.mMinDist);
        n = Math.max(n, n14);
        int n15 = clrSeg.sBonus;
        int n16 = clrSeg2.sBonus;
        int n17 = Math.min(n15, n16);
        int n18 = nArray[0] = n17 > 0 ? this.fixInt(2) : 0;
        if (this.mNumVStems > 0) {
            int n19 = this.idtfmx(n8);
            n19 = Math.abs(n19);
            for (int i = 0; i < this.mNumVStems; ++i) {
                if (n19 != this.mVStems[i]) continue;
                nArray[0] = nArray[0] + 256;
                break;
            }
        }
        this.adjustVal(nArray2, n3 - n4, n5 - n6, n, n8, false);
    }

    private void insertVValue(int n, int n2, int n3, int n4, ClrSeg clrSeg, ClrSeg clrSeg2) {
        ClrVal clrVal = new ClrVal();
        clrVal.cvlSN = ++this.mCvlSN;
        if (clrVal.cvlSN == 0) {
            clrVal.cvlSN++;
        }
        clrVal.vVal = n3;
        clrVal.initVal = n3;
        clrVal.vLoc1 = n;
        clrVal.vLoc2 = n2;
        clrVal.vSpc = n4;
        clrVal.vSeg1 = clrSeg;
        clrVal.vSeg2 = clrSeg2;
        clrVal.vGhst = false;
        ClrVal clrVal2 = this.mValList;
        ClrVal clrVal3 = null;
        while (clrVal2 != null && clrVal2.vLoc1 < n) {
            clrVal3 = clrVal2;
            clrVal2 = clrVal2.vNxt;
        }
        while (clrVal2 != null && clrVal2.vLoc1 == n && clrVal2.vLoc2 < n2) {
            clrVal3 = clrVal2;
            clrVal2 = clrVal2.vNxt;
        }
        if (clrVal3 == null) {
            this.mValList = clrVal;
        } else {
            clrVal3.vNxt = clrVal;
        }
        clrVal.vNxt = clrVal2;
    }

    private void addVValue(int n, int n2, int n3, int n4, ClrSeg clrSeg, ClrSeg clrSeg2) {
        if (n3 == 0) {
            return;
        }
        if (this.lePruneValue(n3) && n4 <= 0) {
            return;
        }
        if (clrSeg != null && clrSeg.sType == 1 && clrSeg2 != null && clrSeg2.sType == 1) {
            return;
        }
        if (!(n3 > this.mPruneD || n4 > 0 || clrSeg == null || clrSeg2 == null || clrSeg.sType != 1 && clrSeg2.sType != 1 && this.checkBBoxes(clrSeg.sElt, clrSeg2.sElt))) {
            return;
        }
        this.insertVValue(n, n2, n3, n4, clrSeg, clrSeg2);
    }

    private void insertHValue(int n, int n2, int n3, int n4, ClrSeg clrSeg, ClrSeg clrSeg2, boolean bl) {
        ClrVal clrVal = this.mValList;
        ClrVal clrVal2 = null;
        while (clrVal != null && clrVal.vLoc2 < n2) {
            clrVal2 = clrVal;
            clrVal = clrVal.vNxt;
        }
        while (clrVal != null && clrVal.vLoc2 == n2 && clrVal.vLoc1 < n) {
            clrVal2 = clrVal;
            clrVal = clrVal.vNxt;
        }
        ClrVal clrVal3 = clrVal;
        while (bl && clrVal3 != null && clrVal3.vLoc2 == n2 && clrVal3.vLoc1 == n) {
            if (!(clrVal3.vGhst || clrVal3.vSeg1 != clrSeg && clrVal3.vSeg2 != clrSeg2 || clrVal3.vVal <= n3)) {
                return;
            }
            clrVal3 = clrVal3.vNxt;
        }
        ClrVal clrVal4 = new ClrVal();
        clrVal4.cvlSN = ++this.mCvlSN;
        clrVal4.vVal = n3;
        clrVal4.initVal = n3;
        clrVal4.vSpc = n4;
        clrVal4.vLoc1 = n;
        clrVal4.vLoc2 = n2;
        clrVal4.vSeg1 = clrSeg;
        clrVal4.vSeg2 = clrSeg2;
        clrVal4.vGhst = bl;
        if (clrVal2 == null) {
            this.mValList = clrVal4;
        } else {
            clrVal2.vNxt = clrVal4;
        }
        clrVal4.vNxt = clrVal;
    }

    private void addHValue(int n, int n2, int n3, int n4, ClrSeg clrSeg, ClrSeg clrSeg2) {
        boolean bl;
        if (n3 == 0) {
            return;
        }
        if (this.lePruneValue(n3) && n4 <= 0) {
            return;
        }
        if (clrSeg.sType == 1 && clrSeg2.sType == 1) {
            return;
        }
        boolean bl2 = bl = clrSeg.sType == 3 || clrSeg2.sType == 3;
        if (!(bl || n3 > this.mPruneD || n4 > 0 || clrSeg.sType != 1 && clrSeg2.sType != 1 && this.checkBBoxes(clrSeg.sElt, clrSeg2.sElt))) {
            return;
        }
        this.insertHValue(n, n2, n3, n4, clrSeg, clrSeg2, bl);
    }

    private double mfabs(double d) {
        if (d > 0.0) {
            return d;
        }
        return -d;
    }

    private int combVals(int n, int n2) {
        double d;
        double d2 = 0.0;
        double d3 = this.fixToFlt(n);
        double d4 = this.fixToFlt(n2);
        double d5 = d = d3 * d4;
        for (int i = 0; i < 16; ++i) {
            d2 = 0.5 * (d5 + d / d5);
            if (i >= 8 && this.mfabs(d2 - d5) <= this.mfabs(d2) * 1.0E-7) break;
            d5 = d2;
        }
        if ((d3 += d4 + 2.0 * d2) > this.mMaxVal) {
            d3 = this.mMaxVal;
        } else if (d3 > 0.0 && d3 < this.mMinVal) {
            d3 = this.mMinVal;
        }
        return this.fltToFix(d3);
    }

    private void combineValues() {
        ClrVal clrVal = this.mValList;
        while (clrVal != null) {
            ClrVal clrVal2 = clrVal.vNxt;
            int n = clrVal.vLoc1;
            int n2 = clrVal.vLoc2;
            int n3 = clrVal.vVal;
            boolean bl = false;
            while (clrVal2 != null && clrVal2.vLoc1 == n && clrVal2.vLoc2 == n2) {
                n3 = clrVal2.vGhst ? clrVal2.vVal : this.combVals(n3, clrVal2.vVal);
                bl = true;
                clrVal2 = clrVal2.vNxt;
            }
            if (bl) {
                while (clrVal != clrVal2) {
                    clrVal.vVal = n3;
                    clrVal = clrVal.vNxt;
                }
                continue;
            }
            clrVal = clrVal2;
        }
    }

    private void evalV() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.mValList = null;
        ClrSeg clrSeg = this.leftList();
        while (clrSeg != null) {
            ClrSeg clrSeg2 = this.rightList();
            while (clrSeg2 != null) {
                int n;
                int n2 = clrSeg.sLoc;
                if (n2 < (n = clrSeg2.sLoc)) {
                    this.evalVPair(clrSeg, clrSeg2, nArray2, nArray);
                    this.addVValue(n2, n, nArray[0], nArray2[0], clrSeg, clrSeg2);
                }
                clrSeg2 = clrSeg2.sNxt;
            }
            clrSeg = clrSeg.sNxt;
        }
        this.combineValues();
    }

    private void evalH() {
        int n;
        int n2;
        Object object;
        int n3;
        this.mValList = null;
        ClrSeg clrSeg = this.botList();
        while (clrSeg != null) {
            ClrSeg clrSeg2 = this.topList();
            while (clrSeg2 != null) {
                int n4 = clrSeg.sLoc;
                if (n4 >= (n3 = clrSeg2.sLoc)) {
                    if (n4 > n3) {
                        // empty if block
                    }
                } else {
                    int[] nArray = new int[1];
                    object = new int[1];
                    this.evalHPair(clrSeg, clrSeg2, nArray, (int[])object);
                    n2 = nArray[0];
                    n = object[0];
                    this.addHValue(n4, n3, n, n2, clrSeg, clrSeg2);
                }
                clrSeg2 = clrSeg2.sNxt;
            }
            clrSeg = clrSeg.sNxt;
        }
        ClrSeg clrSeg3 = new ClrSeg();
        clrSeg3.csgSN = ++this.mCsgSN;
        clrSeg3.sType = (short)3;
        clrSeg3.sElt = null;
        if (this.mLenBotBands >= 2 || this.mLenTopBands >= 2) {
            int n5;
            int n6;
            int n7;
            ClrSeg clrSeg4 = this.botList();
            while (clrSeg4 != null) {
                n7 = clrSeg4.sLoc;
                if (this.inBlueBand(n7, this.mLenBotBands, this.mBotBands)) {
                    n6 = n7;
                    clrSeg3.sLoc = (n6 += this.mGhostWidth);
                    n5 = (clrSeg4.sMax + clrSeg4.sMin) / 2;
                    clrSeg3.sMax = n5 + this.mGhostLength / 2;
                    clrSeg3.sMin = n5 - this.mGhostLength / 2;
                    n2 = this.fixInt(2);
                    n = this.fixInt(20);
                    this.addHValue(n7, n6, n, n2, clrSeg4, clrSeg3);
                }
                clrSeg4 = clrSeg4.sNxt;
            }
            clrSeg4 = this.topList();
            while (clrSeg4 != null) {
                n7 = clrSeg4.sLoc;
                if (this.inBlueBand(n7, this.mLenTopBands, this.mTopBands)) {
                    n6 = n7;
                    clrSeg3.sLoc = (n6 -= this.mGhostWidth);
                    n5 = (clrSeg4.sMin + clrSeg4.sMax) / 2;
                    clrSeg3.sMax = n5 + this.mGhostLength / 2;
                    clrSeg3.sMin = n5 - this.mGhostLength / 2;
                    n2 = this.fixInt(2);
                    n = this.fixInt(20);
                    this.addHValue(n6, n7, n, n2, clrSeg3, clrSeg4);
                }
                clrSeg4 = clrSeg4.sNxt;
            }
            if (this.mLenTopBands != 0 || this.mLenBotBands != 0) {
                ACBBox aCBBox = new ACBBox();
                this.findPathBBox(aCBBox);
                n3 = aCBBox.ymax;
                int n8 = aCBBox.ymin;
                object = new ClrSeg();
                ((ClrSeg)object).csgSN = ++this.mCsgSN;
                ((ClrSeg)object).sType = (short)0;
                ((ClrSeg)object).sElt = null;
                ((ClrSeg)object).sMin = Integer.MIN_VALUE;
                ((ClrSeg)object).sMax = Integer.MAX_VALUE;
                clrSeg3.sMax = this.mGhostLength / 2;
                clrSeg3.sMin = -this.mGhostLength / 2;
                n2 = this.fixInt(2);
                n = this.fixInt(20);
                if (this.inBlueBand(n8, this.mLenBotBands, this.mBotBands)) {
                    ((ClrSeg)object).sLoc = n8;
                    n6 = n8;
                    clrSeg3.sLoc = (n6 += this.mGhostWidth);
                    this.addHValue(n8, n6, n, n2, (ClrSeg)object, clrSeg3);
                }
                if (this.inBlueBand(n3, this.mLenTopBands, this.mTopBands)) {
                    ((ClrSeg)object).sLoc = n3;
                    n6 = n3;
                    clrSeg3.sLoc = (n6 -= this.mGhostWidth);
                    this.addHValue(n6, n3, n, n2, clrSeg3, (ClrSeg)object);
                }
            }
        }
        this.combineValues();
    }

    private boolean inRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private void flatReportProc(int n, Object object, Cd cd) {
        switch (n) {
            case 0: {
                this.nzWindProc(object, cd);
                break;
            }
            case 1: {
                this.findYExtremeProc(object, cd);
                break;
            }
            case 2: {
                this.chkDT(object, cd);
                break;
            }
            case 3: {
                this.chkBBDT(object, cd);
                break;
            }
            case 4: {
                this.fpBBoxPt(object, cd);
            }
        }
    }

    private void walkSubPath(PathElt pathElt, boolean bl, Object object) {
        PathElt pathElt2 = pathElt;
        Cd cd = new Cd();
        FltnRec fltnRec = new FltnRec();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        while (pathElt2 != null) {
            switch (pathElt2.type) {
                case 2: {
                    boolean bl2;
                    this.flatReportProc(bl ? 1 : 0, object, cd);
                    fltnRec.param = object;
                    cd2.x = pathElt2.x1;
                    cd2.y = pathElt2.y1;
                    cd3.x = pathElt2.x2;
                    cd3.y = pathElt2.y2;
                    cd4.x = pathElt2.x3;
                    cd4.y = pathElt2.y3;
                    if (bl) {
                        fltnRec.report = 1;
                        bl2 = this.yExtremeShortCutProc(cd, cd2, cd3, cd4, object, fltnRec.report);
                    } else {
                        fltnRec.report = 0;
                        bl2 = this.nzWindShortCutProc(cd, cd2, cd3, cd4, object, fltnRec.report);
                    }
                    if (!bl2) {
                        this.fltnCurve(cd, cd2, cd3, cd4, fltnRec);
                    }
                    cd.copyFrom(cd4);
                    break;
                }
                case 1: {
                    this.flatReportProc(bl ? 1 : 0, object, cd);
                    cd.x = pathElt2.x;
                    cd.y = pathElt2.y;
                    break;
                }
                case 0: {
                    cd.x = pathElt2.x;
                    cd.y = pathElt2.y;
                    break;
                }
                case 3: {
                    this.flatReportProc(bl ? 1 : 0, object, cd);
                    return;
                }
            }
            pathElt2 = pathElt2.next;
        }
    }

    private int windTest(Cd cd, Cd cd2, Cd cd3) {
        double d;
        double d2;
        if (cd.x > cd2.x && cd2.x > cd3.x) {
            return 0;
        }
        if (cd.x < cd2.x && cd2.x < cd3.x) {
            return 1;
        }
        if (cd.y == cd2.y) {
            if (cd.x >= cd2.x) {
                return 0;
            }
            return 1;
        }
        if (cd2.y == cd3.y) {
            if (cd2.x >= cd3.x) {
                return 0;
            }
            return 1;
        }
        double d3 = this.fixToFlt(cd.x);
        double d4 = this.fixToFlt(cd.y);
        double d5 = this.fixToFlt(cd2.x);
        double d6 = this.fixToFlt(cd2.y);
        double d7 = this.fixToFlt(cd3.x);
        if (d7 <= (d2 = ((d5 - d3) * (d = this.fixToFlt(cd3.y)) + (d3 * d6 - d5 * d4)) / (d6 - d4))) {
            return 0;
        }
        return 1;
    }

    private void findYExtremeProc(Object object, Cd cd) {
        FindExParam findExParam = (FindExParam)object;
        if (findExParam.hasLastPt && findExParam.lastPt.x == cd.x && findExParam.lastPt.y == cd.y) {
            return;
        }
        if (findExParam.lastWasExtreme && cd.y < findExParam.yMax) {
            findExParam.plaeauEnded = true;
            if (findExParam.hasRisePt) {
                if (findExParam.risePt.x != findExParam.lastPt.x) {
                    findExParam.windDir = findExParam.risePt.x > findExParam.lastPt.x ? 0 : 1;
                } else if (findExParam.hasPrerisePt) {
                    findExParam.windDir = this.windTest(findExParam.prerisePt, findExParam.risePt, cd);
                    findExParam.firstWasExtreme = false;
                }
            } else if (!findExParam.firstWasExtreme) {
                findExParam.firstWasExtreme = true;
                findExParam.risePt.copyFrom(findExParam.firstPt);
                findExParam.beforeFirstSinkPt.copyFrom(findExParam.lastPt);
                findExParam.firstSinkPt.copyFrom(cd);
            }
        }
        if (findExParam.hasLastPt) {
            if (cd.y > findExParam.yMax || findExParam.plaeauEnded && cd.y == findExParam.yMax) {
                findExParam.plaeauEnded = false;
                findExParam.risePt.copyFrom(cd);
                findExParam.hasRisePt = true;
                findExParam.prerisePt.copyFrom(findExParam.lastPt);
                findExParam.hasPrerisePt = true;
                findExParam.firstWasExtreme = false;
            }
        } else {
            findExParam.firstSinkPt.copyFrom(cd);
            findExParam.firstPt.copyFrom(cd);
        }
        if (findExParam.firstWasExtreme) {
            if (cd.y < findExParam.yMax) {
                findExParam.prerisePt.copyFrom(cd);
                findExParam.hasPrerisePt = true;
            }
            if (findExParam.hasPrerisePt && cd.y == findExParam.yMax && !findExParam.hasRisePtForFirst) {
                findExParam.risePt.copyFrom(cd);
                findExParam.hasRisePtForFirst = true;
            }
        }
        findExParam.lastPt.copyFrom(cd);
        findExParam.hasLastPt = true;
        findExParam.lastWasExtreme = cd.y >= findExParam.yMax;
        if (findExParam.lastWasExtreme) {
            findExParam.yMax = cd.y;
        }
    }

    private boolean yExtremeShortCutProc(Cd cd, Cd cd2, Cd cd3, Cd cd4, Object object, int n) {
        FindExParam findExParam = (FindExParam)object;
        int n2 = findExParam.yMax;
        if (cd.y < n2 && cd2.y < n2 && cd3.y < n2 && cd4.y < n2) {
            this.flatReportProc(n, object, cd4);
            return true;
        }
        return false;
    }

    private void collectSubPathInfo() throws ACException {
        Cd cd = new Cd();
        int[] nArray = new int[1];
        this.mNumSubPaths = this.countSubPaths(nArray);
        if (this.mNumSubPaths > 200 || nArray[0] > 1000) {
            throw new ACException("Glyph too complex");
        }
        this.mSubPaths = new SubPathInfo[this.mNumSubPaths];
        int n = 0;
        PathElt pathElt = this.mPathEnd;
        while (n < this.mNumSubPaths && pathElt != null) {
            if ((pathElt = this.getDest(pathElt)) == null) continue;
            ACBBox aCBBox = new ACBBox();
            this.calcSubpathBBox(aCBBox, pathElt);
            int n2 = n++;
            SubPathInfo subPathInfo = new SubPathInfo();
            this.mSubPaths[n2] = subPathInfo;
            SubPathInfo subPathInfo2 = subPathInfo;
            subPathInfo2.head = pathElt;
            subPathInfo2.startPt.x = pathElt.x;
            subPathInfo2.startPt.y = pathElt.y;
            subPathInfo2.bbox = aCBBox;
            subPathInfo2.tail = this.getClosedBy(pathElt);
            if (subPathInfo2.tail == null) continue;
            this.getEndPoint(subPathInfo2.tail.prev, cd);
            subPathInfo2.endPt.x = cd.x;
            subPathInfo2.endPt.y = cd.y;
            pathElt = pathElt.prev;
        }
    }

    private void determineCurrentWind(SubPathInfo[] subPathInfoArray, int n) {
        for (int i = 0; i < n; ++i) {
            SubPathInfo subPathInfo = subPathInfoArray[i];
            PathElt pathElt = subPathInfo.head;
            FindExParam findExParam = new FindExParam();
            findExParam.yMax = Integer.MIN_VALUE;
            this.walkSubPath(pathElt, true, findExParam);
            if (findExParam.firstWasExtreme) {
                if (findExParam.risePt.x != findExParam.beforeFirstSinkPt.x) {
                    subPathInfo.currentWind = findExParam.risePt.x > findExParam.beforeFirstSinkPt.x ? 0 : 1;
                    continue;
                }
                subPathInfo.currentWind = this.windTest(findExParam.prerisePt, findExParam.beforeFirstSinkPt, findExParam.firstSinkPt);
                continue;
            }
            if (findExParam.lastWasExtreme) {
                if (findExParam.risePt.x != findExParam.lastPt.x) {
                    subPathInfo.currentWind = findExParam.risePt.x > findExParam.lastPt.x ? 0 : 1;
                    continue;
                }
                subPathInfo.currentWind = this.windTest(findExParam.prerisePt, findExParam.lastPt, findExParam.firstSinkPt);
                continue;
            }
            subPathInfo.currentWind = findExParam.windDir;
        }
    }

    private int testHighLow(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return 1;
        }
        return -1;
    }

    private void nzWindProc(Object object, Cd cd) {
        NZWindParam nZWindParam = (NZWindParam)object;
        if (nZWindParam.hasLastPt) {
            int n;
            int n2 = this.testHighLow(nZWindParam.testPt.y, nZWindParam.lastPt.y);
            if (n2 * (n = this.testHighLow(nZWindParam.testPt.y, cd.y)) <= 0 && (nZWindParam.testToRight && (nZWindParam.lastPt.x > nZWindParam.testPt.x || cd.x > nZWindParam.testPt.x) || !nZWindParam.testToRight && (nZWindParam.lastPt.x < nZWindParam.testPt.x || cd.x < nZWindParam.testPt.x)) && nZWindParam.lastPt.y != cd.y) {
                if (cd.y == nZWindParam.testPt.y && !(nZWindParam.testToRight ^ cd.x > nZWindParam.testPt.x)) {
                    nZWindParam.onLine = true;
                    nZWindParam.fromAbove = nZWindParam.lastPt.y > nZWindParam.testPt.y;
                    nZWindParam.lastPt.copyFrom(cd);
                    nZWindParam.hasLastPt = true;
                    return;
                }
                if (nZWindParam.onLine) {
                    if (nZWindParam.fromAbove && n < 0 || !nZWindParam.fromAbove && n > 0) {
                        nZWindParam.windCount += nZWindParam.testToRight ^ n < 0 ? 1 : -1;
                    }
                    nZWindParam.onLine = false;
                    nZWindParam.lastPt.copyFrom(cd);
                    nZWindParam.hasLastPt = true;
                    return;
                }
                double d = this.fixToFlt(nZWindParam.lastPt.x);
                double d2 = this.fixToFlt(nZWindParam.lastPt.y);
                double d3 = this.fixToFlt(cd.x);
                double d4 = this.fixToFlt(cd.y);
                double d5 = (nZWindParam.testy * (d3 - d) + d * d4 - d3 * d2) / (d4 - d2);
                if (!(nZWindParam.testToRight ^ d5 > nZWindParam.testx)) {
                    nZWindParam.windCount += nZWindParam.testToRight ^ d2 > d4 ? 1 : -1;
                }
            }
        } else {
            nZWindParam.firstPt.copyFrom(cd);
        }
        nZWindParam.lastPt.copyFrom(cd);
        nZWindParam.hasLastPt = true;
    }

    private boolean nzWindShortCutProc(Cd cd, Cd cd2, Cd cd3, Cd cd4, Object object, int n) {
        NZWindParam nZWindParam = (NZWindParam)object;
        int n2 = nZWindParam.testPt.y;
        if (cd.y > n2 && cd2.y > n2 && cd3.y > n2 && cd4.y > n2 || cd.y < n2 && cd2.y < n2 && cd3.y < n2 && cd4.y < n2) {
            this.flatReportProc(n, object, cd4);
            return true;
        }
        return false;
    }

    private int nzWindTest(Cd cd, SubPathInfo subPathInfo) {
        NZWindParam nZWindParam = new NZWindParam();
        nZWindParam.testPt.copyFrom(cd);
        nZWindParam.testx = this.fixToFlt(cd.x);
        nZWindParam.testy = this.fixToFlt(cd.y);
        nZWindParam.testToRight = subPathInfo.startPt.x < cd.x;
        this.walkSubPath(subPathInfo.head, false, nZWindParam);
        if (nZWindParam.hasLastPt) {
            this.nzWindProc(nZWindParam, nZWindParam.firstPt);
        }
        return nZWindParam.windCount;
    }

    private void determineFillOrUnfill(SubPathInfo[] subPathInfoArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            Cd cd = (Cd)subPathInfoArray[i].startPt.clone();
            for (int j = 0; j < n; ++j) {
                if (i == j || !this.inRange(cd.x, subPathInfoArray[j].bbox.xmin, subPathInfoArray[j].bbox.xmax) || !this.inRange(cd.y, subPathInfoArray[j].bbox.ymin, subPathInfoArray[j].bbox.ymax)) continue;
                n2 += this.nzWindTest(cd, subPathInfoArray[j]);
            }
            n2 = subPathInfoArray[i].currentWind == 0 ? ++n2 : --n2;
            subPathInfoArray[i].filled = n2 != 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void flipSubPath(SubPathInfo subPathInfo) {
        int n = 0;
        int n2 = 0;
        PathElt pathElt = subPathInfo.head;
        PathElt pathElt2 = pathElt.prev;
        PathElt pathElt3 = subPathInfo.tail.next;
        PathElt pathElt4 = null;
        PathElt pathElt5 = null;
        while (true) {
            PathElt pathElt6;
            block12: {
                if (pathElt == null) {
                    subPathInfo.head = pathElt4;
                    subPathInfo.tail = pathElt5;
                    return;
                }
                pathElt6 = pathElt.next;
                PathElt pathElt7 = pathElt.prev;
                switch (pathElt.type) {
                    case 2: {
                        int n3 = pathElt.x1;
                        int n4 = pathElt.y1;
                        int n5 = pathElt.x3;
                        int n6 = pathElt.y3;
                        pathElt.x1 = pathElt.x2;
                        pathElt.y1 = pathElt.y2;
                        pathElt.x2 = n3;
                        pathElt.y2 = n4;
                        pathElt.x3 = n;
                        pathElt.y3 = n2;
                        n = n5;
                        n2 = n6;
                        break;
                    }
                    case 1: {
                        int n5 = pathElt.x;
                        int n6 = pathElt.y;
                        pathElt.x = n;
                        pathElt.y = n2;
                        n = n5;
                        n2 = n6;
                        break;
                    }
                    case 0: {
                        pathElt5 = pathElt;
                        n = pathElt.x;
                        n2 = pathElt.y;
                        pathElt.type = (short)3;
                        pathElt.next = pathElt3;
                        if (pathElt3 != null) {
                            pathElt3.prev = pathElt;
                        } else {
                            this.mPathEnd = pathElt;
                        }
                        pathElt.prev = pathElt6;
                        pathElt.next = pathElt3;
                        break block12;
                    }
                    case 3: {
                        pathElt4 = pathElt;
                        pathElt.type = (short)0;
                        pathElt.x = n;
                        pathElt.y = n2;
                        pathElt.x = subPathInfo.tail.x;
                        pathElt.y = subPathInfo.tail.y;
                        if (pathElt2 != null) {
                            pathElt2.next = pathElt;
                        } else {
                            this.mPathStart = pathElt;
                        }
                        pathElt.next = pathElt7;
                        pathElt.prev = pathElt2;
                        subPathInfo.head = pathElt4;
                        subPathInfo.tail = pathElt5;
                        return;
                    }
                }
                pathElt.next = pathElt7;
                pathElt.prev = pathElt6;
            }
            pathElt = pathElt6;
        }
    }

    private void flipSubPaths(SubPathInfo[] subPathInfoArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            SubPathInfo subPathInfo = subPathInfoArray[i];
            boolean bl2 = subPathInfo.currentWind == 0 ^ subPathInfo.filled ^ bl;
            if (bl2) continue;
            this.flipSubPath(subPathInfo);
        }
    }

    private void fixPathWind(boolean bl) {
        this.determineCurrentWind(this.mSubPaths, this.mNumSubPaths);
        this.determineFillOrUnfill(this.mSubPaths, this.mNumSubPaths);
        this.flipSubPaths(this.mSubPaths, this.mNumSubPaths, bl);
    }

    private boolean closeElements(PathElt pathElt, PathElt pathElt2, int n, int n2, boolean bl) {
        int n3;
        Cd cd = new Cd();
        if (pathElt == pathElt2) {
            return true;
        }
        int n4 = this.psDist(20);
        if (n < n2) {
            n -= n4;
            n2 += n4;
        } else {
            n3 = n;
            n = n2 - n4;
            n2 = n3 + n4;
        }
        PathElt pathElt3 = pathElt;
        do {
            if (pathElt3 == pathElt2) {
                return true;
            }
            this.getEndPoint(pathElt3, cd);
            int n5 = n3 = bl ? cd.x : cd.y;
            if (n3 <= n2 && n3 >= n) continue;
            return false;
        } while ((pathElt3 = pathElt3.type == 3 ? this.getDest(pathElt3) : pathElt3.next) != pathElt);
        return false;
    }

    private boolean closeSegs(ClrSeg clrSeg, ClrSeg clrSeg2, boolean bl) {
        int n;
        if (clrSeg == clrSeg2) {
            return true;
        }
        PathElt pathElt = clrSeg.sElt;
        PathElt pathElt2 = clrSeg2.sElt;
        if (pathElt == null || pathElt2 == null) {
            return true;
        }
        int n2 = clrSeg.sLoc;
        return this.closeElements(pathElt, pathElt2, n2, n = clrSeg2.sLoc, bl) || this.closeElements(pathElt2, pathElt, n, n2, bl);
    }

    private void doPrune() {
        ClrVal clrVal = this.mValList;
        while (clrVal != null && clrVal.pruned) {
            clrVal = clrVal.vNxt;
        }
        this.mValList = clrVal;
        if (clrVal == null) {
            return;
        }
        ClrVal clrVal2 = clrVal;
        clrVal = clrVal.vNxt;
        while (clrVal != null) {
            if (clrVal.pruned) {
                clrVal = clrVal.vNxt;
                clrVal2.vNxt = clrVal;
                continue;
            }
            clrVal2 = clrVal;
            clrVal = clrVal.vNxt;
        }
    }

    private ClrVal pruneOne(ClrVal clrVal, boolean bl, ClrVal clrVal2, int n) {
        clrVal.pruned = true;
        return clrVal.vNxt;
    }

    private boolean pruneLt(int n, int n2) {
        if (n2 < 0xCCCCCCC && n < 0x2AAAAAAA) {
            return n * 3 < n2 * 10;
        }
        return n / 10 < n2 / 3;
    }

    private boolean pruneLe(int n, int n2) {
        if (n < 0x2AAAAAAA) {
            return n2 <= n * 3;
        }
        return n2 / 3 <= n;
    }

    private boolean pruneGt(int n, int n2) {
        if (n < 0x2AAAAAAA) {
            return n2 > n * 3;
        }
        return n2 / 3 > n;
    }

    private boolean pruneMuchGt(int n, int n2) {
        if (n < 42949672) {
            return n2 > n * 50;
        }
        return n2 / 50 > n;
    }

    private boolean pruneVeryMuchGt(int n, int n2) {
        if (n < 21474836) {
            return n2 > n * 100;
        }
        return n2 / 100 > n;
    }

    private void pruneVVals() {
        ClrVal clrVal = this.mValList;
        int n = this.psDist(10);
        while (clrVal != null) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = clrVal.vVal;
            int n3 = clrVal.vLoc1;
            int n4 = clrVal.vLoc2;
            ClrSeg clrSeg = clrVal.vSeg1;
            ClrSeg clrSeg2 = clrVal.vSeg2;
            ClrVal clrVal2 = this.mValList;
            while (clrVal2 != null) {
                int n5 = clrVal2.vVal;
                ClrSeg clrSeg3 = clrVal2.vSeg1;
                ClrSeg clrSeg4 = clrVal2.vSeg2;
                int n6 = clrVal2.vLoc1;
                int n7 = clrVal2.vLoc2;
                if (!(n6 == n3 && n7 == n4 || this.pruneLe(n2, n5))) {
                    if (n4 + n >= n7 && n3 - n <= n6 && (n2 < this.fixInt(100) && this.pruneMuchGt(n2, n5) ? this.closeSegs(clrSeg, clrSeg3, true) || this.closeSegs(clrSeg2, clrSeg4, true) : this.closeSegs(clrSeg, clrSeg3, true) && this.closeSegs(clrSeg2, clrSeg4, true))) {
                        clrVal = this.pruneOne(clrVal, false, clrVal2, 1);
                        bl = false;
                        break;
                    }
                    if (clrSeg != null && clrSeg2 != null) {
                        if (Math.abs(n6 - n3) < 256) {
                            if (!bl3 && this.pruneLt(n2, n5) && Math.abs(n6 - n7) < Math.abs(n3 - n4) && this.closeSegs(clrSeg, clrSeg3, true)) {
                                bl3 = true;
                            }
                            if (clrSeg2.sType == 1 && this.closeSegs(clrSeg, clrSeg3, true)) {
                                clrVal = this.pruneOne(clrVal, false, clrVal2, 2);
                                bl = false;
                                break;
                            }
                        }
                        if (Math.abs(n7 - n4) < 256) {
                            if (!bl2 && this.pruneLt(n2, n5) && Math.abs(n6 - n7) < Math.abs(n3 - n4) && this.closeSegs(clrSeg2, clrSeg4, true)) {
                                bl2 = true;
                            }
                            if (clrSeg.sType == 1 && this.closeSegs(clrSeg2, clrSeg4, true)) {
                                clrVal = this.pruneOne(clrVal, false, clrVal2, 3);
                                bl = false;
                                break;
                            }
                        }
                        if (bl3 && bl2) {
                            clrVal = this.pruneOne(clrVal, false, clrVal2, 4);
                            bl = false;
                            break;
                        }
                    }
                }
                clrVal2 = clrVal2.vNxt;
            }
            if (!bl) continue;
            clrVal = clrVal.vNxt;
        }
        this.doPrune();
    }

    private void pruneHVals() {
        ClrVal clrVal = this.mValList;
        int n = this.psDist(10);
        while (clrVal != null) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            ClrSeg clrSeg = clrVal.vSeg1;
            ClrSeg clrSeg2 = clrVal.vSeg2;
            boolean bl4 = clrVal.vGhst;
            int n2 = clrVal.vVal;
            int n3 = clrVal.vLoc1;
            int n4 = clrVal.vLoc2;
            boolean bl5 = this.inBlueBand(n4, this.mLenTopBands, this.mTopBands);
            boolean bl6 = this.inBlueBand(n3, this.mLenBotBands, this.mBotBands);
            ClrVal clrVal2 = this.mValList;
            while (clrVal2 != null) {
                ClrSeg clrSeg3 = clrVal2.vSeg1;
                ClrSeg clrSeg4 = clrVal2.vSeg2;
                int n5 = clrVal2.vVal;
                if (!bl4 && clrVal2.vGhst && !this.pruneVeryMuchGt(n2, n5)) {
                    clrVal2 = clrVal2.vNxt;
                    continue;
                }
                int n6 = clrVal2.vLoc1;
                int n7 = clrVal2.vLoc2;
                if (n7 == n4 && n6 == n3) {
                    clrVal2 = clrVal2.vNxt;
                    continue;
                }
                if (!(!this.pruneGt(n2, n5) || n4 + n < n7 || n3 - n > n6 || !(n2 < this.fixInt(100) && this.pruneMuchGt(n2, n5) ? this.closeSegs(clrSeg, clrSeg3, false) || this.closeSegs(clrSeg2, clrSeg4, false) : this.closeSegs(clrSeg, clrSeg3, false) && this.closeSegs(clrSeg2, clrSeg4, false)) || n2 >= 4096 && (bl5 && n4 != n7 || bl6 && n3 != n6))) {
                    clrVal = this.pruneOne(clrVal, true, clrVal2, 5);
                    bl = false;
                    break;
                }
                if (clrSeg != null && clrSeg2 != null) {
                    if (Math.abs(n6 - n3) < 256) {
                        if (this.pruneGt(n2, n5) && !bl5 && clrSeg2.sType == 1 && this.closeSegs(clrSeg, clrSeg3, false)) {
                            clrVal = this.pruneOne(clrVal, true, clrVal2, 6);
                            bl = false;
                            break;
                        }
                        if (!bl2 && this.pruneLt(n2, n5) && Math.abs(n7 - n6) < Math.abs(n4 - n3) && this.closeSegs(clrSeg, clrSeg3, false)) {
                            bl2 = true;
                        }
                    }
                    if (Math.abs(n7 - n4) < 256) {
                        if (this.pruneGt(n2, n5) && !bl6 && clrSeg2.sType == 1 && this.closeSegs(clrSeg, clrSeg3, false)) {
                            clrVal = this.pruneOne(clrVal, true, clrVal2, 7);
                            bl = false;
                            break;
                        }
                        if (!bl3 && this.pruneLt(n2, n5) && Math.abs(n7 - n6) < Math.abs(n4 - n3) && this.closeSegs(clrSeg2, clrSeg4, false)) {
                            bl3 = true;
                        }
                    }
                    if (bl2 && bl3) {
                        clrVal = this.pruneOne(clrVal, true, clrVal2, 8);
                        bl = false;
                        break;
                    }
                }
                clrVal2 = clrVal2.vNxt;
            }
            if (!bl) continue;
            clrVal = clrVal.vNxt;
        }
        this.doPrune();
    }

    private void findBestVals(ClrVal clrVal) {
        while (clrVal != null) {
            if (clrVal.vBst == null) {
                int n = clrVal.vVal;
                int n2 = clrVal.vSpc;
                ClrVal clrVal2 = clrVal;
                int n3 = clrVal.vLoc1;
                int n4 = clrVal.vLoc2;
                ClrVal clrVal3 = clrVal.vNxt;
                ClrVal clrVal4 = clrVal;
                while (clrVal3 != null) {
                    if (clrVal3.vBst == null && clrVal3.vLoc1 == n3 && clrVal3.vLoc2 == n4) {
                        if (clrVal3.vSpc == n2 && clrVal3.vVal > n || clrVal3.vSpc > n2) {
                            n2 = clrVal3.vSpc;
                            n = clrVal3.vVal;
                            clrVal2 = clrVal3;
                        }
                        clrVal3.vBst = clrVal4;
                        clrVal4 = clrVal3;
                    }
                    clrVal3 = clrVal3.vNxt;
                }
                while (clrVal4 != null) {
                    clrVal3 = clrVal4.vBst;
                    clrVal4.vBst = clrVal2;
                    clrVal4 = clrVal3;
                }
            }
            clrVal = clrVal.vNxt;
        }
    }

    private void replaceVals(int n, int n2, int n3, int n4, ClrVal clrVal, boolean bl) {
        ClrVal clrVal2 = this.mValList;
        while (clrVal2 != null) {
            if (clrVal2.vLoc1 == n && clrVal2.vLoc2 == n2 && !clrVal2.merge) {
                clrVal2.vLoc1 = n3;
                clrVal2.vLoc2 = n4;
                clrVal2.vVal = clrVal.vVal;
                clrVal2.vSpc = clrVal.vSpc;
                clrVal2.vBst = clrVal;
                clrVal2.merge = true;
            }
            clrVal2 = clrVal2.vNxt;
        }
    }

    private void mergeVals(boolean bl) {
        this.findBestVals(this.mValList);
        ClrVal clrVal = this.mValList;
        while (clrVal != null) {
            clrVal.merge = false;
            clrVal = clrVal.vNxt;
        }
        while (true) {
            ClrVal clrVal2 = this.mValList;
            clrVal = null;
            while (clrVal2 != null) {
                if (!clrVal2.merge && (clrVal == null || this.compareValues(clrVal2.vBst, clrVal.vBst, 20, 0))) {
                    clrVal = clrVal2;
                }
                clrVal2 = clrVal2.vNxt;
            }
            if (clrVal == null) break;
            clrVal.merge = true;
            boolean bl2 = clrVal.vGhst;
            int n = clrVal.vLoc1;
            int n2 = clrVal.vLoc2;
            ClrSeg clrSeg = clrVal.vSeg1;
            ClrSeg clrSeg2 = clrVal.vSeg2;
            ClrVal clrVal3 = clrVal.vBst;
            int n3 = clrVal3.vVal;
            int n4 = clrVal3.vSpc;
            clrVal2 = this.mValList;
            while (clrVal2 != null) {
                if (!clrVal2.merge && bl2 == clrVal2.vGhst) {
                    int n5 = clrVal2.vLoc1;
                    int n6 = clrVal2.vLoc2;
                    if (n5 != n || n6 != n2) {
                        ClrVal clrVal4 = clrVal2.vBst;
                        int n7 = clrVal4.vVal;
                        int n8 = clrVal4.vSpc;
                        if (n6 == n2 && this.closeSegs(clrSeg2, clrVal2.vSeg2, bl) && (bl || !this.inBlueBand(n2, this.mLenTopBands, this.mTopBands) && !this.inBlueBand(n5, this.mLenBotBands, this.mBotBands) && !this.inBlueBand(n, this.mLenBotBands, this.mBotBands)) || n5 == n && this.closeSegs(clrSeg, clrVal2.vSeg1, bl) && (bl || !this.inBlueBand(n, this.mLenBotBands, this.mBotBands) && !this.inBlueBand(n2, this.mLenTopBands, this.mTopBands) && !this.inBlueBand(n6, this.mLenTopBands, this.mTopBands)) || Math.abs(n6 - n2) <= this.mMaxMerge && Math.abs(n5 - n) <= this.mMaxMerge && (bl || n2 == n6 || !this.inBlueBand(n6, this.mLenTopBands, this.mTopBands)) && (bl || n == n5 || !this.inBlueBand(n5, this.mLenBotBands, this.mBotBands))) {
                            if (n4 == n8 && n7 == n3 && !bl) {
                                if (this.inBlueBand(n2, this.mLenTopBands, this.mTopBands)) {
                                    if (n2 > n6) {
                                        this.replaceVals(n5, n6, n, n2, clrVal3, bl);
                                    }
                                } else if (this.inBlueBand(n, this.mLenBotBands, this.mBotBands) && n < n5) {
                                    this.replaceVals(n5, n6, n, n2, clrVal3, bl);
                                }
                            } else {
                                this.replaceVals(n5, n6, n, n2, clrVal3, bl);
                            }
                        } else if (n4 == n8 && clrSeg != null && clrSeg2 != null) {
                            ClrSeg clrSeg3 = clrVal2.vSeg1;
                            ClrSeg clrSeg4 = clrVal2.vSeg2;
                            if (clrSeg3 != null && clrSeg4 != null) {
                                if (Math.abs(n5 - n) <= 256 && Math.abs(n6 - n2) <= this.mMaxBendMerge) {
                                    if (clrSeg4.sType == 1 && (bl || !this.inBlueBand(n6, this.mLenTopBands, this.mTopBands))) {
                                        this.replaceVals(n5, n6, n, n2, clrVal3, bl);
                                    }
                                } else if (Math.abs(n6 - n2) <= 256 && Math.abs(n5 - n) <= this.mMaxBendMerge && n3 > n7 && clrSeg3.sType == 1 && (bl || !this.inBlueBand(n5, this.mLenBotBands, this.mBotBands))) {
                                    this.replaceVals(n5, n6, n, n2, clrVal3, bl);
                                }
                            }
                        }
                    }
                }
                clrVal2 = clrVal2.vNxt;
            }
            clrVal = clrVal.vNxt;
        }
    }

    private void initCheckData(CheckData checkData) {
        checkData.forMultiMaster = false;
    }

    private void chkBad(CheckData checkData) {
        checkData.reCheckSmooth = this.resolveConflictBySplit(checkData.e, false, null, null);
    }

    private boolean grTan(int n, int n2) {
        return Math.abs(n) * 100 > Math.abs(n2) * 25;
    }

    private boolean lsTan(int n, int n2) {
        return Math.abs(n) * 100 < Math.abs(n2) * 25;
    }

    private void chkYDIR(CheckData checkData) {
        if (checkData.y > checkData.yloc) {
            if (checkData.ystate == 1) {
                return;
            }
            if (checkData.ystate == 0) {
                checkData.ystart = (checkData.ystate = 1);
            } else {
                if (checkData.ystart == 1) {
                    checkData.yflatendx = checkData.xloc;
                    checkData.yflatendy = checkData.yloc;
                } else if (!checkData.yflat) {
                    checkData.yflatstartx = checkData.xloc;
                    checkData.yflatstarty = checkData.yloc;
                    checkData.yflat = true;
                }
                checkData.ystate = 1;
            }
        } else if (checkData.y < checkData.yloc) {
            if (checkData.ystate == 2) {
                return;
            }
            if (checkData.ystate == 0) {
                checkData.ystart = (checkData.ystate = 2);
            } else {
                if (checkData.ystart == 2) {
                    checkData.yflatendx = checkData.xloc;
                    checkData.yflatendy = checkData.yloc;
                } else if (!checkData.yflat) {
                    checkData.yflatstartx = checkData.xloc;
                    checkData.yflatstarty = checkData.yloc;
                    checkData.yflat = true;
                }
                checkData.ystate = 2;
            }
        }
    }

    private void chkYFLAT(CheckData checkData) {
        if (!checkData.yflat) {
            if (this.lsTan(checkData.y - checkData.yloc, checkData.x - checkData.xloc)) {
                checkData.yflat = true;
                checkData.yflatstartx = checkData.xloc;
                checkData.yflatstarty = checkData.yloc;
            }
            return;
        }
        if (checkData.ystate != checkData.ystart) {
            return;
        }
        if (this.grTan(checkData.y - checkData.yloc, checkData.x - checkData.xloc)) {
            checkData.yflatendx = checkData.xloc;
            checkData.yflatendy = checkData.yloc;
            checkData.ydone = true;
        }
    }

    private void chkXFLAT(CheckData checkData) {
        if (!checkData.xflat) {
            if (this.lsTan(checkData.x - checkData.xloc, checkData.y - checkData.yloc)) {
                checkData.xflat = true;
                checkData.xflatstartx = checkData.xloc;
                checkData.xflatstarty = checkData.yloc;
            }
            return;
        }
        if (checkData.xstate != checkData.xstart) {
            return;
        }
        if (this.grTan(checkData.x - checkData.xloc, checkData.y - checkData.yloc)) {
            checkData.xflatendx = checkData.xloc;
            checkData.xflatendy = checkData.yloc;
            checkData.xdone = true;
        }
    }

    private void chkXDIR(CheckData checkData) {
        if (checkData.x > checkData.xloc) {
            if (checkData.xstate == 1) {
                return;
            }
            if (checkData.xstate == 0) {
                checkData.xstart = (checkData.xstate = 1);
            } else {
                if (checkData.xstart == 1) {
                    checkData.xflatendx = checkData.xloc;
                    checkData.xflatendy = checkData.yloc;
                } else if (!checkData.xflat) {
                    checkData.xflatstartx = checkData.xloc;
                    checkData.xflatstarty = checkData.yloc;
                    checkData.xflat = true;
                }
                checkData.xstate = 1;
            }
        } else if (checkData.x < checkData.xloc) {
            if (checkData.xstate == 2) {
                return;
            }
            if (checkData.xstate == 0) {
                checkData.xstart = (checkData.xstate = 2);
            } else {
                if (checkData.xstart == 2) {
                    checkData.xflatendx = checkData.xloc;
                    checkData.xflatendy = checkData.yloc;
                } else if (!checkData.xflat) {
                    checkData.xflatstartx = checkData.xloc;
                    checkData.xflatstarty = checkData.yloc;
                    checkData.xflat = true;
                }
                checkData.xstate = 2;
            }
        }
    }

    private void chkDT(Object object, Cd cd) {
        CheckData checkData = (CheckData)object;
        checkData.x = cd.x;
        checkData.y = cd.y;
        checkData.ynxt = checkData.y;
        checkData.xnxt = checkData.x;
        if (!checkData.ydone) {
            this.chkYDIR(checkData);
            this.chkYFLAT(checkData);
            if (checkData.ydone && checkData.yflat && Math.abs(checkData.yflatstarty - checkData.cy0) > this.fixInt(4) && Math.abs(checkData.cy1 - checkData.yflatendy) > this.fixInt(4)) {
                if (checkData.ystart == 1 && checkData.yflatstarty - checkData.yflatendy > this.fixInt(4) || checkData.ystart == 2 && checkData.yflatendy - checkData.yflatstarty > this.fixInt(4)) {
                    if (this.mEditChar && !checkData.forMultiMaster) {
                        this.chkBad(checkData);
                    }
                    return;
                }
                if (Math.abs(checkData.yflatstartx - checkData.yflatendx) > this.fixInt(5) && !checkData.forMultiMaster) {
                    this.addHSegment(checkData.yflatstartx, checkData.yflatendx, (checkData.yflatstarty + checkData.yflatendy) / 2, checkData.e, null, 2, 13);
                }
            }
        }
        if (!checkData.xdone) {
            this.chkXDIR(checkData);
            this.chkXFLAT(checkData);
            if (checkData.xdone && checkData.xflat && Math.abs(checkData.xflatstartx - checkData.x0) > this.fixInt(4) && Math.abs(checkData.x1 - checkData.xflatendx) > this.fixInt(4)) {
                if (checkData.xstart == 1 && checkData.xflatstartx - checkData.xflatendx > this.fixInt(4) || checkData.xstart == 2 && checkData.xflatendx - checkData.xflatstartx > this.fixInt(4)) {
                    if (this.mEditChar && !checkData.forMultiMaster) {
                        this.chkBad(checkData);
                    }
                    return;
                }
                if (Math.abs(checkData.xflatstarty - checkData.xflatendy) > this.fixInt(5) && !checkData.forMultiMaster) {
                    this.addVSegment(checkData.xflatstarty, checkData.xflatendy, (checkData.xflatstartx + checkData.xflatendx) / 2, checkData.e, null, 2, 13);
                }
            }
        }
        checkData.xloc = checkData.xnxt;
        checkData.yloc = checkData.ynxt;
    }

    private int cpDirection(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n3 >> 6) * (n6 - n2 >> 6);
        int n8 = (n >> 6) * (n4 - n6 >> 6);
        int n9 = (n5 >> 6) * (n2 - n4 >> 6);
        int n10 = n7 + n8 + n9;
        if (n10 > 0) {
            return 1;
        }
        if (n10 < 0) {
            return -1;
        }
        return 0;
    }

    private void rMovePoint(int n, int n2, int n3, PathElt pathElt) {
        if (n3 == 0) {
            pathElt = pathElt.prev;
            n3 = 3;
        }
        if (n3 == 3) {
            if (pathElt.type == 3) {
                pathElt = this.getDest(pathElt);
            }
            if (pathElt.type == 2) {
                pathElt.x3 += n;
                pathElt.y3 += n2;
            } else {
                pathElt.x += n;
                pathElt.y += n2;
            }
            return;
        }
        if (n3 == 1) {
            pathElt.x1 += n;
            pathElt.y1 += n2;
            return;
        }
        if (n3 == 2) {
            pathElt.x2 += n;
            pathElt.y2 += n2;
            return;
        }
    }

    private void delete(PathElt pathElt) {
        PathElt pathElt2 = pathElt.next;
        PathElt pathElt3 = pathElt.prev;
        if (pathElt2 != null) {
            pathElt2.prev = pathElt3;
        } else {
            this.mPathEnd = pathElt3;
        }
        if (pathElt3 != null) {
            pathElt3.next = pathElt2;
        } else {
            this.mPathStart = pathElt2;
        }
    }

    private void checkSCurve(CheckData checkData, PathElt pathElt) {
        FltnRec fltnRec = new FltnRec();
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        this.getEndPoint(pathElt.prev, cd);
        fltnRec.report = 2;
        fltnRec.param = checkData;
        cd2.x = pathElt.x1;
        cd2.y = pathElt.y1;
        cd3.x = pathElt.x2;
        cd3.y = pathElt.y2;
        cd4.x = pathElt.x3;
        cd4.y = pathElt.y3;
        checkData.xstate = (checkData.ystate = 0);
        checkData.xdone = (checkData.ydone = (checkData.xflat = (checkData.yflat = false)));
        checkData.x0 = cd.x;
        checkData.cy0 = cd.y;
        checkData.x1 = cd4.x;
        checkData.cy1 = cd4.y;
        checkData.xloc = checkData.x0;
        checkData.yloc = checkData.cy0;
        checkData.e = pathElt;
        checkData.forMultiMaster = false;
        this.fltnCurve(cd, cd2, cd3, cd4, fltnRec);
    }

    private void checkZeroLength(CheckData checkData) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            PathElt pathElt2 = pathElt.next;
            this.getEndPoints(pathElt, cd, cd2);
            if (pathElt.type == 1 && cd.x == cd2.x && cd.y == cd2.y) {
                this.delete(pathElt);
            } else if (pathElt.type == 2) {
                int n = pathElt.x1;
                int n2 = pathElt.y1;
                int n3 = pathElt.x2;
                int n4 = pathElt.y2;
                if (cd.x == cd2.x && cd.y == cd2.y && n == cd2.x && n3 == cd2.x && n2 == cd2.y && n4 == cd2.y) {
                    this.delete(pathElt);
                }
            }
            pathElt = pathElt2;
        }
    }

    private void checkSmooth() {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        CheckData checkData = new CheckData();
        this.initCheckData(checkData);
        this.checkZeroLength(checkData);
        do {
            checkData.reCheckSmooth = false;
            PathElt pathElt = this.mPathStart;
            while (pathElt != null) {
                PathElt pathElt2 = pathElt.next;
                if (pathElt.type != 0 && !this.isTiny(pathElt) && !pathElt.isFlex) {
                    PathElt pathElt3;
                    this.getEndPoint(pathElt, cd2);
                    if (pathElt.type == 2) {
                        cd3.x = pathElt.x1;
                        cd3.y = pathElt.y1;
                        int n = pathElt.x2;
                        int n2 = pathElt.y2;
                        this.getEndPoint(pathElt.prev, cd);
                        int n3 = this.cpDirection(cd.x, cd.y, cd3.x, cd3.y, n, n2);
                        int n4 = this.cpDirection(cd3.x, cd3.y, n, n2, cd2.x, cd2.y);
                        if (this.prodLt0(n3, n4)) {
                            this.checkSCurve(checkData, pathElt);
                        }
                    }
                    if (!(pathElt3 = this.nxtForBend(pathElt, cd3, cd4)).isFlex) {
                        this.prvForBend(pathElt3, cd);
                    }
                }
                pathElt = pathElt2;
            }
        } while (checkData.reCheckSmooth);
    }

    private void chkBBDT(Object object, Cd cd) {
        CheckData checkData = (CheckData)object;
        int n = cd.x;
        int n2 = cd.y;
        if (checkData.bbquit) {
            return;
        }
        if (checkData.vert) {
            checkData.lst = n2;
            if (!checkData.started && Math.abs(n - checkData.loc) <= this.fixInt(10)) {
                checkData.started = true;
                checkData.frst = n2;
            } else if (checkData.started && Math.abs(n - checkData.loc) > this.fixInt(10)) {
                checkData.bbquit = true;
            }
        } else {
            checkData.lst = n;
            if (!checkData.started && Math.abs(n2 - checkData.loc) <= this.fixInt(10)) {
                checkData.started = true;
                checkData.frst = n;
            } else if (checkData.started && Math.abs(n2 - checkData.loc) > this.fixInt(10)) {
                checkData.bbquit = true;
            }
        }
    }

    private void checkForMultiMoveTo() {
        PathElt pathElt = this.mPathStart;
        boolean bl = false;
        while (pathElt != null) {
            if (pathElt.type != 0) {
                bl = false;
            } else if (!bl) {
                bl = true;
            } else {
                this.delete(pathElt.prev);
            }
            pathElt = pathElt.next;
        }
    }

    private void checkBBoxEdge(PathElt pathElt, boolean bl, int n, int[] nArray, int[] nArray2) {
        CheckData checkData = new CheckData();
        FltnRec fltnRec = new FltnRec();
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        this.getEndPoint(pathElt.prev, cd);
        fltnRec.report = 3;
        fltnRec.param = checkData;
        checkData.bbquit = false;
        cd2.x = pathElt.x1;
        cd2.y = pathElt.y1;
        cd3.x = pathElt.x2;
        cd3.y = pathElt.y2;
        cd4.x = pathElt.x3;
        cd4.y = pathElt.y3;
        checkData.loc = n;
        checkData.vert = bl;
        checkData.started = false;
        this.chkBBDT(checkData, cd);
        this.fltnCurve(cd, cd2, cd3, cd4, fltnRec);
        nArray[0] = checkData.frst;
        nArray2[0] = checkData.lst;
    }

    private void moveSubpathToEnd(PathElt pathElt) {
        PathElt pathElt2 = pathElt.type == 3 ? pathElt : this.getClosedBy(pathElt);
        PathElt pathElt3 = this.getDest(pathElt2);
        if (pathElt2 == this.mPathEnd) {
            return;
        }
        PathElt pathElt4 = pathElt2.next;
        if (pathElt3 == this.mPathStart) {
            this.mPathStart = pathElt4;
            pathElt4.prev = null;
        } else {
            PathElt pathElt5 = pathElt3.prev;
            pathElt5.next = pathElt4;
            pathElt4.prev = pathElt5;
        }
        this.mPathEnd.next = pathElt3;
        pathElt3.prev = this.mPathEnd;
        pathElt2.next = null;
        this.mPathEnd = pathElt2;
    }

    private void initPick() {
    }

    private boolean ltPruneB(int n) {
        return n < 256 && n << 10 < this.mPruneB;
    }

    private boolean considerPicking(int n, int n2, ClrVal clrVal, int n3) {
        if (n > 0) {
            return true;
        }
        if (clrVal == null) {
            return n2 >= this.mPruneD;
        }
        if (n2 > this.mPruneA) {
            return true;
        }
        if (this.ltPruneB(n2)) {
            return false;
        }
        return n2 < Integer.MAX_VALUE / this.mPruneC ? n3 <= n2 * this.mPruneC : n3 / this.mPruneC <= n2;
    }

    private void pickVVals(ClrVal clrVal) {
        ClrVal clrVal2;
        ClrVal clrVal3;
        int n = 0;
        ClrVal clrVal4 = null;
        ClrVal clrVal5 = null;
        int n2 = 0;
        block0: while (true) {
            clrVal3 = clrVal;
            ClrVal clrVal6 = null;
            ClrVal clrVal7 = null;
            ClrVal clrVal8 = null;
            while (clrVal3 != null) {
                if ((clrVal6 == null || this.compareValues(clrVal3, clrVal6, 1000, 0)) && this.considerPicking(clrVal3.vSpc, clrVal3.vVal, clrVal5, n2)) {
                    clrVal6 = clrVal3;
                    clrVal7 = clrVal8;
                    n = clrVal3.vVal;
                }
                clrVal8 = clrVal3;
                clrVal3 = clrVal3.vNxt;
            }
            if (clrVal6 == null) break;
            if (clrVal7 == null) {
                clrVal = clrVal6.vNxt;
            } else {
                clrVal7.vNxt = clrVal6.vNxt;
            }
            clrVal6.vNxt = clrVal5;
            clrVal5 = clrVal6;
            n2 = n;
            int n3 = clrVal6.vLoc1 - this.mBandMargin;
            int n4 = clrVal6.vLoc2 + this.mBandMargin;
            clrVal3 = clrVal;
            clrVal8 = null;
            while (true) {
                if (clrVal3 == null) continue block0;
                int n5 = clrVal3.vLoc1;
                int n6 = clrVal3.vLoc2;
                if (n5 <= n4 && n6 >= n3) {
                    clrVal2 = clrVal3.vNxt;
                    clrVal3.vNxt = clrVal4;
                    clrVal4 = clrVal3;
                    clrVal3 = clrVal2;
                    if (clrVal8 == null) {
                        clrVal = clrVal3;
                        continue;
                    }
                    clrVal8.vNxt = clrVal3;
                    continue;
                }
                clrVal8 = clrVal3;
                clrVal3 = clrVal3.vNxt;
            }
            break;
        }
        clrVal3 = clrVal;
        while (clrVal3 != null) {
            clrVal2 = clrVal3.vNxt;
            clrVal3.vNxt = clrVal4;
            clrVal4 = clrVal3;
            clrVal3 = clrVal2;
        }
        if (clrVal5 == null) {
            this.clrVBnds(this.mBBox);
        }
        this.mVcoloring = clrVal5;
    }

    private boolean inSerifBand(int n, int n2, int n3, int[] nArray) {
        if (n3 <= 0) {
            return false;
        }
        if ((n = this.itfmy(n)) > (n2 = this.itfmy(n2))) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        for (int i = 0; i < n3; i += 2) {
            if (nArray[i] > n || nArray[i + 1] < n2) continue;
            return true;
        }
        return false;
    }

    private boolean considerValForSeg(ClrVal clrVal, ClrSeg clrSeg, int n, int n2, int[] nArray, int n3, int[] nArray2, boolean bl) {
        if (bl && (double)clrVal.vSpc > 0.0) {
            return true;
        }
        if (this.inBlueBand(n, n2, nArray)) {
            return true;
        }
        if ((double)clrVal.vSpc <= 0.0 && this.inSerifBand(clrSeg.sMax, clrSeg.sMin, n3, nArray2)) {
            return false;
        }
        return !this.ltPruneB(clrVal.vVal);
    }

    private ClrVal fndBstVal(ClrSeg clrSeg, boolean bl, ClrVal clrVal, ClrVal clrVal2, int n, int[] nArray, int n2, int[] nArray2, boolean bl2, boolean bl3) {
        ClrVal clrVal3 = null;
        int n3 = clrSeg.sLoc;
        ClrVal clrVal4 = clrVal;
        while (true) {
            ClrVal clrVal5 = clrVal4;
            while (clrVal4 != null) {
                int n4;
                ClrSeg clrSeg2;
                if (bl) {
                    clrSeg2 = clrVal4.vSeg1;
                    n4 = clrVal4.vLoc1;
                } else {
                    clrSeg2 = clrVal4.vSeg2;
                    n4 = clrVal4.vLoc2;
                }
                if (Math.abs(n3 - n4) <= this.mMaxMerge && (bl2 ? !clrVal4.vGhst : clrSeg2 == clrSeg || this.closeSegs(clrSeg, clrSeg2, !bl3)) && (clrVal3 == null || clrVal4.vVal == clrVal3.vVal && clrVal4.vSpc == clrVal3.vSpc && clrVal4.initVal > clrVal3.initVal || this.compareValues(clrVal4, clrVal3, 1000, 3)) && this.considerValForSeg(clrVal4, clrSeg, n3, n, nArray, n2, nArray2, true)) {
                    clrVal3 = clrVal4;
                }
                clrVal4 = clrVal4.vNxt;
            }
            if (clrVal5 == clrVal2) break;
            clrVal4 = clrVal2;
        }
        return clrVal3;
    }

    private ClrVal findBestValForSeg(ClrSeg clrSeg, boolean bl, ClrVal clrVal, ClrVal clrVal2, int n, int[] nArray, int n2, int[] nArray2, boolean bl2) {
        ClrVal clrVal3;
        ClrVal clrVal4 = null;
        ClrVal clrVal5 = this.fndBstVal(clrSeg, bl, clrVal, clrVal2, n, nArray, n2, nArray2, false, bl2);
        if (clrVal5 != null && clrVal5.vGhst && (clrVal3 = this.fndBstVal(clrSeg, bl, clrVal, clrVal2, n, nArray, n2, nArray2, true, bl2)) != null && clrVal3.vVal >= this.fixInt(2)) {
            clrVal4 = clrVal5;
            clrVal5 = clrVal3;
        }
        if (clrVal5 != null) {
            if (clrVal5.vVal < 16 && (clrVal4 == null || clrVal4.vVal < 16)) {
                clrVal5 = null;
            } else {
                clrVal5.pruned = false;
            }
        }
        return clrVal5;
    }

    private boolean membValList(ClrVal clrVal, ClrVal clrVal2) {
        while (clrVal2 != null) {
            if (clrVal == clrVal2) {
                return true;
            }
            clrVal2 = clrVal2.vNxt;
        }
        return false;
    }

    private ClrVal prevVal(ClrVal clrVal, ClrVal clrVal2) {
        if (clrVal == clrVal2) {
            return null;
        }
        ClrVal clrVal3 = clrVal2;
        while ((clrVal2 = clrVal2.vNxt) != clrVal) {
            clrVal3 = clrVal2;
        }
        return clrVal3;
    }

    private void pickHVals(ClrVal clrVal) {
        ClrVal clrVal2;
        ClrVal clrVal3;
        int n = 0;
        ClrVal clrVal4 = null;
        ClrVal clrVal5 = null;
        int n2 = 0;
        block0: while (true) {
            clrVal3 = clrVal;
            ClrVal clrVal6 = null;
            ClrVal clrVal7 = null;
            ClrVal clrVal8 = null;
            while (clrVal3 != null) {
                if ((clrVal6 == null || this.compareValues(clrVal3, clrVal6, 1000, 0)) && this.considerPicking(clrVal3.vSpc, clrVal3.vVal, clrVal5, n2)) {
                    clrVal6 = clrVal3;
                    clrVal7 = clrVal8;
                    n = clrVal3.vVal;
                }
                clrVal8 = clrVal3;
                clrVal3 = clrVal3.vNxt;
            }
            if (clrVal6 != null) {
                ClrVal clrVal9;
                ClrSeg clrSeg = clrVal6.vSeg1;
                ClrSeg clrSeg2 = clrVal6.vSeg2;
                if (clrVal6.vGhst) {
                    clrVal3 = clrVal;
                    while (clrVal3 != null) {
                        if (clrVal3.vLoc2 == clrVal6.vLoc2 && clrVal3.vLoc1 == clrVal6.vLoc1 && !clrVal3.vGhst) {
                            clrSeg = clrVal3.vSeg1;
                            clrSeg2 = clrVal3.vSeg2;
                            break;
                        }
                        clrVal3 = clrVal3.vNxt;
                    }
                }
                if (clrSeg.sType == 3) {
                    clrVal9 = clrSeg2.sLnk;
                    if (clrVal9 != null && clrVal9 != clrVal6 && this.membValList(clrVal9, clrVal)) {
                        clrVal6 = clrVal9;
                        clrVal7 = this.prevVal(clrVal6, clrVal);
                    }
                } else if (clrSeg2.sType == 3 && (clrVal9 = clrSeg2.sLnk) != null && clrVal9 != clrVal6 && this.membValList(clrVal9, clrVal)) {
                    clrVal6 = clrVal9;
                    clrVal7 = this.prevVal(clrVal6, clrVal);
                }
            }
            if (clrVal6 == null) break;
            n2 = n;
            if (clrVal7 == null) {
                clrVal = clrVal6.vNxt;
            } else {
                clrVal7.vNxt = clrVal6.vNxt;
            }
            clrVal6.vNxt = clrVal5;
            clrVal5 = clrVal6;
            int n3 = clrVal6.vLoc1;
            int n4 = clrVal6.vLoc2;
            if (clrVal6.vGhst) {
                if (clrVal6.vSeg1.sType == 3) {
                    n3 = n4;
                } else {
                    n4 = n3;
                }
            }
            n3 -= this.mBandMargin;
            n4 += this.mBandMargin;
            clrVal3 = clrVal;
            clrVal8 = null;
            while (true) {
                if (clrVal3 == null) continue block0;
                int n5 = clrVal3.vLoc1;
                int n6 = clrVal3.vLoc2;
                if (clrVal3.vGhst) {
                    if (clrVal3.vSeg1.sType == 3) {
                        n5 = n6;
                    } else {
                        n6 = n5;
                    }
                }
                if (n5 <= n4 && n6 >= n3) {
                    clrVal2 = clrVal3.vNxt;
                    clrVal3.vNxt = clrVal4;
                    clrVal4 = clrVal3;
                    clrVal3 = clrVal2;
                    if (clrVal8 == null) {
                        clrVal = clrVal3;
                        continue;
                    }
                    clrVal8.vNxt = clrVal3;
                    continue;
                }
                clrVal8 = clrVal3;
                clrVal3 = clrVal3.vNxt;
            }
            break;
        }
        clrVal3 = clrVal;
        while (clrVal3 != null) {
            clrVal2 = clrVal3.vNxt;
            clrVal3.vNxt = clrVal4;
            clrVal4 = clrVal3;
            clrVal3 = clrVal2;
        }
        if (clrVal5 == null) {
            this.clrHBnds(this.mBBox);
        }
        this.mHcoloring = clrVal5;
    }

    private void findBestValForSegs(ClrSeg clrSeg, boolean bl, ClrVal clrVal, ClrVal clrVal2, int n, int[] nArray, int n2, int[] nArray2, boolean bl2) {
        while (clrSeg != null) {
            ClrVal clrVal3 = this.findBestValForSeg(clrSeg, bl, clrVal, clrVal2, n, nArray, n2, nArray2, bl2);
            clrSeg.sLnk = clrVal3;
            clrSeg = clrSeg.sNxt;
        }
    }

    private void setPruned() {
        ClrVal clrVal = this.mValList;
        while (clrVal != null) {
            clrVal.pruned = true;
            clrVal = clrVal.vNxt;
        }
    }

    private void findBestHVals() {
        this.setPruned();
        this.findBestValForSegs(this.topList(), false, this.mValList, null, this.mLenTopBands, this.mTopBands, 0, null, true);
        this.findBestValForSegs(this.botList(), true, this.mValList, null, this.mLenBotBands, this.mBotBands, 0, null, true);
        this.doPrune();
    }

    private void findBestVVals() {
        this.setPruned();
        this.findBestValForSegs(this.leftList(), true, this.mValList, null, 0, null, this.mNumSerifs, this.mSerifs, false);
        this.findBestValForSegs(this.rightList(), false, this.mValList, null, 0, null, this.mNumSerifs, this.mSerifs, false);
        this.doPrune();
    }

    private void fpBBoxPt(Object object, Cd cd) {
        ACBBox aCBBox = (ACBBox)object;
        if (cd.x < aCBBox.xmin) {
            aCBBox.xmin = cd.x;
            aCBBox.pxmn = aCBBox.pe;
        }
        if (cd.x > aCBBox.xmax) {
            aCBBox.xmax = cd.x;
            aCBBox.pxmx = aCBBox.pe;
        }
        if (cd.y < aCBBox.ymin) {
            aCBBox.ymin = cd.y;
            aCBBox.pymn = aCBBox.pe;
        }
        if (cd.y > aCBBox.ymax) {
            aCBBox.ymax = cd.y;
            aCBBox.pymx = aCBBox.pe;
        }
    }

    private boolean fpBBoxCurveShortCut(Cd cd, Cd cd2, Cd cd3, Cd cd4, Object object) {
        ACBBox aCBBox = (ACBBox)object;
        this.fpBBoxPt(object, cd);
        this.fpBBoxPt(object, cd4);
        return this.inRange(cd2.x, aCBBox.xmin, aCBBox.xmax) && this.inRange(cd2.y, aCBBox.ymin, aCBBox.ymax) && this.inRange(cd3.x, aCBBox.xmin, aCBBox.xmax) && this.inRange(cd3.y, aCBBox.ymin, aCBBox.ymax);
    }

    private void findPathBBox(ACBBox aCBBox) {
        if (this.mPathBBox != null) {
            aCBBox.copyFrom(this.mPathBBox);
            return;
        }
        FltnRec fltnRec = new FltnRec();
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        if (this.mPathStart == null) {
            aCBBox.xmin = (aCBBox.ymin = (aCBBox.xmax = (aCBBox.ymax = 0)));
            aCBBox.pxmn = (aCBBox.pxmx = (aCBBox.pymn = (aCBBox.pymx = null)));
            return;
        }
        fltnRec.report = 4;
        fltnRec.param = aCBBox;
        aCBBox.xmin = (aCBBox.ymin = this.fixInt(10000));
        aCBBox.xmax = (aCBBox.ymax = -aCBBox.xmin);
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            switch (pathElt.type) {
                case 0: 
                case 1: {
                    cd.x = pathElt.x;
                    cd.y = pathElt.y;
                    aCBBox.pe = pathElt;
                    this.fpBBoxPt(aCBBox, cd);
                    break;
                }
                case 2: {
                    cd2.x = pathElt.x1;
                    cd2.y = pathElt.y1;
                    cd3.x = pathElt.x2;
                    cd3.y = pathElt.y2;
                    cd4.x = pathElt.x3;
                    cd4.y = pathElt.y3;
                    aCBBox.pe = pathElt;
                    if (!this.fpBBoxCurveShortCut(cd, cd2, cd3, cd4, aCBBox)) {
                        this.fltnCurve(cd, cd2, cd3, cd4, fltnRec);
                    }
                    cd.copyFrom(cd4);
                    break;
                }
            }
            pathElt = pathElt.next;
        }
        aCBBox.xmin = this.fHalfRnd(aCBBox.xmin);
        aCBBox.ymin = this.fHalfRnd(aCBBox.ymin);
        aCBBox.xmax = this.fHalfRnd(aCBBox.xmax);
        aCBBox.ymax = this.fHalfRnd(aCBBox.ymax);
        this.mPathBBox = new ACBBox();
        this.mPathBBox.copyFrom(aCBBox);
    }

    private PathElt calcSubpathBBox(ACBBox aCBBox, PathElt pathElt) {
        FltnRec fltnRec = new FltnRec();
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        if (pathElt == null) {
            aCBBox.xmin = (aCBBox.ymin = (aCBBox.xmax = (aCBBox.ymax = 0)));
            aCBBox.pxmn = (aCBBox.pxmx = (aCBBox.pymn = (aCBBox.pymx = null)));
            return null;
        }
        fltnRec.report = 4;
        fltnRec.param = aCBBox;
        aCBBox.xmin = (aCBBox.ymin = this.fixInt(10000));
        aCBBox.xmax = (aCBBox.ymax = -aCBBox.xmin);
        if (pathElt.type != 0) {
            pathElt = this.getDest(pathElt);
        }
        while (pathElt != null) {
            switch (pathElt.type) {
                case 0: 
                case 1: {
                    cd.x = pathElt.x;
                    cd.y = pathElt.y;
                    aCBBox.pe = pathElt;
                    this.fpBBoxPt(aCBBox, cd);
                    break;
                }
                case 2: {
                    cd2.x = pathElt.x1;
                    cd2.y = pathElt.y1;
                    cd3.x = pathElt.x2;
                    cd3.y = pathElt.y2;
                    cd4.x = pathElt.x3;
                    cd4.y = pathElt.y3;
                    aCBBox.pe = pathElt;
                    if (!this.fpBBoxCurveShortCut(cd, cd2, cd3, cd4, aCBBox)) {
                        this.fltnCurve(cd, cd2, cd3, cd4, fltnRec);
                    }
                    cd.copyFrom(cd4);
                    break;
                }
                case 3: {
                    pathElt = pathElt.next;
                    aCBBox.xmin = this.fHalfRnd(aCBBox.xmin);
                    aCBBox.ymin = this.fHalfRnd(aCBBox.ymin);
                    aCBBox.xmax = this.fHalfRnd(aCBBox.xmax);
                    aCBBox.ymax = this.fHalfRnd(aCBBox.ymax);
                    return pathElt;
                }
            }
            pathElt = pathElt.next;
        }
        aCBBox.xmin = this.fHalfRnd(aCBBox.xmin);
        aCBBox.ymin = this.fHalfRnd(aCBBox.ymin);
        aCBBox.xmax = this.fHalfRnd(aCBBox.xmax);
        aCBBox.ymax = this.fHalfRnd(aCBBox.ymax);
        return pathElt;
    }

    private PathElt findSubpathBBox(ACBBox aCBBox, PathElt pathElt) {
        if (this.mSubPaths != null) {
            for (int i = 0; i < this.mNumSubPaths; ++i) {
                if (this.mSubPaths[i].head != pathElt) continue;
                aCBBox.copyFrom(this.mSubPaths[i].bbox);
                pathElt = this.mSubPaths[i].tail;
                if (pathElt != null) {
                    pathElt = pathElt.next;
                }
                return pathElt;
            }
        }
        return this.calcSubpathBBox(aCBBox, pathElt);
    }

    private void findCurveBBox(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Cd cd, Cd cd2) {
        FltnRec fltnRec = new FltnRec();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        Cd cd5 = new Cd();
        Cd cd6 = new Cd();
        ACBBox aCBBox = new ACBBox();
        fltnRec.report = 4;
        fltnRec.param = aCBBox;
        aCBBox.xmin = (aCBBox.ymin = this.fixInt(10000));
        aCBBox.xmax = (aCBBox.ymax = -aCBBox.xmin);
        cd3.x = n;
        cd3.y = n2;
        cd4.x = n3;
        cd4.y = n4;
        cd5.x = n5;
        cd5.y = n6;
        cd6.x = n7;
        cd6.y = n8;
        this.fpBBoxPt(aCBBox, cd3);
        this.fltnCurve(cd3, cd4, cd5, cd6, fltnRec);
        cd.x = this.fHalfRnd(aCBBox.xmin);
        cd.y = this.fHalfRnd(aCBBox.ymin);
        cd2.x = this.fHalfRnd(aCBBox.xmax);
        cd2.y = this.fHalfRnd(aCBBox.ymax);
    }

    private void clrVBnds(ACBBox aCBBox) {
        if (this.mPathStart == null || this.mDoCounters && this.vColorChar(this.mUnicode)) {
            return;
        }
        this.findPathBBox(aCBBox);
        aCBBox.vMn = this.itfmx(aCBBox.xmin);
        aCBBox.vMx = this.itfmx(aCBBox.xmax);
        aCBBox.pvMn = aCBBox.pxmn;
        aCBBox.pvMx = aCBBox.pxmx;
        if (aCBBox.vMn > aCBBox.vMx) {
            int n = aCBBox.vMn;
            aCBBox.vMn = aCBBox.vMx;
            aCBBox.vMx = n;
            PathElt pathElt = aCBBox.pvMn;
            aCBBox.pvMn = aCBBox.pvMx;
            aCBBox.pvMx = pathElt;
        }
        this.addColorPoint(aCBBox.vMn, 0, aCBBox.vMx, 0, 'y', aCBBox.pvMn, aCBBox.pvMx);
    }

    private void reClrVBnds(ACBBox aCBBox) {
        this.addColorPoint(aCBBox.vMn, 0, aCBBox.vMx, 0, 'y', aCBBox.pvMn, aCBBox.pvMx);
    }

    private void clrHBnds(ACBBox aCBBox) {
        if (this.mPathStart == null || this.mDoCounters && this.hColorChar(this.mUnicode)) {
            return;
        }
        this.findPathBBox(aCBBox);
        aCBBox.hMn = this.itfmy(aCBBox.ymin);
        aCBBox.hMx = this.itfmy(aCBBox.ymax);
        aCBBox.phMn = aCBBox.pymn;
        aCBBox.phMx = aCBBox.pymx;
        if (aCBBox.hMn > aCBBox.hMx) {
            int n = aCBBox.hMn;
            aCBBox.hMn = aCBBox.hMx;
            aCBBox.hMx = n;
            PathElt pathElt = aCBBox.phMn;
            aCBBox.phMn = aCBBox.phMx;
            aCBBox.phMx = pathElt;
        }
        this.addColorPoint(0, aCBBox.hMn, 0, aCBBox.hMx, 'b', aCBBox.phMn, aCBBox.phMx);
    }

    private void reClrHBnds(ACBBox aCBBox) {
        this.addColorPoint(0, aCBBox.hMn, 0, aCBBox.hMx, 'b', aCBBox.phMn, aCBBox.phMx);
    }

    private boolean checkValOverlaps(int n, int n2, ClrVal clrVal, boolean bl) {
        int n3;
        if (bl) {
            n = this.itfmx(n);
            n2 = this.itfmx(n2);
        } else {
            n = this.itfmy(n);
            n2 = this.itfmy(n2);
        }
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (clrVal != null) {
            int n4 = clrVal.vLoc1;
            int n5 = clrVal.vLoc2;
            if (bl) {
                n4 = this.itfmx(n4);
                n5 = this.itfmx(n5);
            } else {
                n4 = this.itfmy(n4);
                n5 = this.itfmy(n5);
            }
            if (n4 > n5) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
            if (n4 <= n2 && n <= n5) {
                return true;
            }
            clrVal = clrVal.vNxt;
        }
        return false;
    }

    private void addBBoxHV(boolean bl, boolean bl2) {
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            ClrSeg clrSeg;
            ClrSeg clrSeg2;
            ClrVal clrVal;
            ACBBox aCBBox = new ACBBox();
            if (bl2) {
                pathElt = this.findSubpathBBox(aCBBox, pathElt);
            } else {
                this.findPathBBox(aCBBox);
                pathElt = null;
            }
            if (!bl) {
                if (this.checkValOverlaps(aCBBox.xmin, aCBBox.xmax, this.mVcoloring, true)) continue;
                clrVal = new ClrVal();
                clrVal.cvlSN = ++this.mCvlSN;
                clrSeg2 = new ClrSeg();
                clrSeg2.csgSN = ++this.mCsgSN;
                clrSeg2.sLoc = aCBBox.xmin;
                clrSeg2.sElt = aCBBox.pxmn;
                clrSeg2.sBonus = 0;
                clrSeg2.sType = (short)0;
                clrSeg2.sMin = aCBBox.ymin;
                clrSeg2.sMax = aCBBox.ymax;
                clrSeg2.sNxt = null;
                clrSeg2.sLnk = null;
                clrSeg = new ClrSeg();
                clrSeg.csgSN = ++this.mCsgSN;
                clrSeg.sLoc = aCBBox.xmax;
                clrSeg.sElt = aCBBox.pxmx;
                clrSeg.sBonus = 0;
                clrSeg.sType = (short)0;
                clrSeg.sMin = aCBBox.ymin;
                clrSeg.sMax = aCBBox.ymax;
                clrSeg.sNxt = null;
                clrSeg.sLnk = null;
                clrVal.vVal = 100;
                clrVal.vSpc = 0;
                clrVal.vLoc1 = aCBBox.xmin;
                clrVal.vLoc2 = aCBBox.xmax;
                clrVal.vSeg1 = clrSeg2;
                clrVal.vSeg2 = clrSeg;
                clrVal.vGhst = false;
                clrVal.vNxt = this.mVcoloring;
                clrVal.vBst = clrVal;
                this.mVcoloring = clrVal;
                continue;
            }
            if (this.checkValOverlaps(aCBBox.ymin, aCBBox.ymax, this.mHcoloring, false)) continue;
            clrVal = new ClrVal();
            clrVal.cvlSN = ++this.mCvlSN;
            clrSeg2 = new ClrSeg();
            clrSeg2.csgSN = ++this.mCsgSN;
            clrSeg2.sLoc = aCBBox.ymax;
            clrSeg2.sElt = aCBBox.pymx;
            clrSeg2.sBonus = 0;
            clrSeg2.sType = (short)0;
            clrSeg2.sMin = aCBBox.xmin;
            clrSeg2.sMax = aCBBox.xmax;
            clrSeg2.sNxt = null;
            clrSeg2.sLnk = null;
            clrSeg = new ClrSeg();
            clrSeg.csgSN = ++this.mCsgSN;
            clrSeg.sLoc = aCBBox.ymin;
            clrSeg.sElt = aCBBox.pymn;
            clrSeg.sBonus = 0;
            clrSeg.sType = (short)0;
            clrSeg.sMin = aCBBox.xmin;
            clrSeg.sMax = aCBBox.xmax;
            clrSeg.sNxt = null;
            clrSeg.sLnk = null;
            clrVal.vVal = 100;
            clrVal.vSpc = 0;
            clrVal.vLoc1 = aCBBox.ymax;
            clrVal.vLoc2 = aCBBox.ymin;
            clrVal.vSeg1 = clrSeg2;
            clrVal.vSeg2 = clrSeg;
            clrVal.vGhst = false;
            clrVal.vNxt = this.mHcoloring;
            clrVal.vBst = clrVal;
            this.mHcoloring = clrVal;
        }
    }

    private boolean checkBBoxes(PathElt pathElt, PathElt pathElt2) {
        ACBBox aCBBox = new ACBBox();
        if ((pathElt = this.getDest(pathElt)) == (pathElt2 = this.getDest(pathElt2))) {
            return true;
        }
        this.findSubpathBBox(aCBBox, pathElt);
        int n = aCBBox.xmin;
        int n2 = aCBBox.xmax;
        int n3 = aCBBox.ymin;
        int n4 = aCBBox.ymax;
        this.findSubpathBBox(aCBBox, pathElt2);
        return n <= aCBBox.xmin && aCBBox.xmax <= n2 && n3 <= aCBBox.ymin && aCBBox.ymax <= n4 || n >= aCBBox.xmin && aCBBox.xmax >= n2 && n3 >= aCBBox.ymin && aCBBox.ymax >= n4;
    }

    private void newBest(WriteData writeData, ClrPoint clrPoint) {
        writeData.bst = clrPoint;
        writeData.bch = clrPoint.c;
        if (writeData.bch == 'y' || writeData.bch == 'm') {
            writeData.bstB = true;
            int n = clrPoint.x0;
            int n2 = clrPoint.x1;
            writeData.bx = Math.min(n, n2);
        } else {
            writeData.bstB = false;
            int n = clrPoint.y0;
            int n3 = clrPoint.y1;
            writeData.by = Math.min(n, n3);
        }
    }

    private void writePointItem(WriteData writeData, ClrPoint clrPoint) {
        int n;
        int n2;
        int n3 = 0;
        switch (clrPoint.c) {
            case 'v': {
                n3 = 4;
                n2 = clrPoint.y0;
                n = clrPoint.y1;
                break;
            }
            case 'b': {
                n2 = clrPoint.y0;
                n = clrPoint.y1;
                break;
            }
            case 'm': {
                n3 = 5;
                n2 = clrPoint.x0;
                n = clrPoint.x1;
                break;
            }
            case 'y': {
                n3 = 1;
                n2 = clrPoint.x0;
                n = clrPoint.x1;
                break;
            }
            default: {
                return;
            }
        }
        int n4 = n - n2;
        if (n4 == this.fixInt(-20)) {
            n2 = this.unScaleAbs(n2);
            n = n2 + n4;
        } else if (n4 == this.fixInt(-21)) {
            n = this.unScaleAbs(n);
            n2 = n - n4;
        } else {
            n2 = this.unScaleAbs(n2);
            n = this.unScaleAbs(n);
        }
        if (writeData.hintArray == null) {
            writeData.hintArray = new ArrayList();
        }
        HintData hintData = new HintData();
        hintData.flags = n3;
        hintData.v1 = n2;
        hintData.v2 = n;
        writeData.hintArray.add(hintData);
    }

    private void flushHintArray(ArrayList arrayList) {
        if (this.mOutlineConsumer != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                HintData hintData = (HintData)arrayList.get(i);
                int n = hintData.flags;
                if (i == 0) {
                    n |= 8;
                }
                double d = this.fixToFlt(hintData.v1);
                double d2 = this.fixToFlt(hintData.v2);
                this.mOutlineConsumer.stem(d, d2, (n & 8) != 0, (n & 1) != 0, false);
            }
        }
    }

    private boolean compareHintArray(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int n2 = arrayList == null ? 0 : arrayList.size();
        int n3 = n = arrayList2 == null ? 0 : arrayList2.size();
        if (n2 != n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            HintData hintData = (HintData)arrayList.get(i);
            HintData hintData2 = (HintData)arrayList2.get(i);
            if (hintData.flags == hintData2.flags && hintData.v1 == hintData2.v1 && hintData.v2 == hintData2.v2) continue;
            return false;
        }
        return true;
    }

    private void wrtPntLst(WriteData writeData, ClrPoint clrPoint) {
        ClrPoint clrPoint2 = clrPoint;
        while (clrPoint != null) {
            clrPoint.done = false;
            clrPoint = clrPoint.next;
        }
        while (true) {
            clrPoint = clrPoint2;
            writeData.bst = null;
            while (clrPoint != null) {
                if (!clrPoint.done) {
                    this.newBest(writeData, clrPoint);
                    break;
                }
                clrPoint = clrPoint.next;
            }
            if (writeData.bst == null) break;
            clrPoint = writeData.bst.next;
            while (clrPoint != null) {
                if (!clrPoint.done) {
                    char c = clrPoint.c;
                    if (c > writeData.bch) {
                        this.newBest(writeData, clrPoint);
                    } else if (c == writeData.bch) {
                        if (writeData.bstB) {
                            int n;
                            int n2 = clrPoint.x0;
                            if (Math.min(n2, n = clrPoint.x1) < writeData.bx) {
                                this.newBest(writeData, clrPoint);
                            }
                        } else {
                            int n;
                            int n3 = clrPoint.y0;
                            if (Math.min(n3, n = clrPoint.y1) < writeData.by) {
                                this.newBest(writeData, clrPoint);
                            }
                        }
                    }
                }
                clrPoint = clrPoint.next;
            }
            writeData.bst.done = true;
            this.writePointItem(writeData, writeData.bst);
        }
    }

    private void wrtNewClrs(WriteData writeData, PathElt pathElt) {
        if (!writeData.wrtColorInfo) {
            return;
        }
        writeData.hintArray = null;
        this.wrtPntLst(writeData, this.mPtLstArray[pathElt.newcolors]);
        if (!this.compareHintArray(writeData.prevHintArray, writeData.hintArray)) {
            this.flushHintArray(writeData.hintArray);
            writeData.prevHintArray = new ArrayList(writeData.hintArray);
        }
    }

    private boolean isFlex(WriteData writeData, PathElt pathElt) {
        PathElt pathElt2;
        PathElt pathElt3;
        if (writeData.firstFlex) {
            pathElt3 = pathElt;
            pathElt2 = pathElt.next;
        } else {
            pathElt3 = pathElt.prev;
            pathElt2 = pathElt;
        }
        return pathElt3 != null && pathElt3.isFlex && pathElt2 != null && pathElt2.isFlex;
    }

    private void mt(WriteData writeData, Cd cd, PathElt pathElt) {
        if (this.mOutlineConsumer != null) {
            if (pathElt.newcolors != 0) {
                this.wrtNewClrs(writeData, pathElt);
            }
            double d = this.fixToFlt(cd.x);
            double d2 = this.fixToFlt(cd.y);
            this.mOutlineConsumer.moveto(d, d2);
        }
    }

    private void dt(WriteData writeData, Cd cd, PathElt pathElt) {
        if (this.mOutlineConsumer != null) {
            if (pathElt.newcolors != 0) {
                this.wrtNewClrs(writeData, pathElt);
            }
            double d = this.fixToFlt(cd.x);
            double d2 = this.fixToFlt(cd.y);
            this.mOutlineConsumer.lineto(d, d2);
        }
    }

    private void wrtFlex(WriteData writeData, Cd cd, Cd cd2, Cd cd3, PathElt pathElt) {
        if (this.mOutlineConsumer != null) {
            if (writeData.firstFlex) {
                writeData.fc1.copyFrom(cd);
                writeData.fc2.copyFrom(cd2);
                writeData.fc3.copyFrom(cd3);
                writeData.firstFlex = false;
                return;
            }
            double d = this.fixToFlt(this.mDMIN);
            double d2 = this.fixToFlt(writeData.fc1.x);
            double d3 = this.fixToFlt(writeData.fc1.y);
            double d4 = this.fixToFlt(writeData.fc2.x);
            double d5 = this.fixToFlt(writeData.fc2.y);
            double d6 = this.fixToFlt(writeData.fc3.x);
            double d7 = this.fixToFlt(writeData.fc3.y);
            double d8 = this.fixToFlt(cd.x);
            double d9 = this.fixToFlt(cd.y);
            double d10 = this.fixToFlt(cd2.x);
            double d11 = this.fixToFlt(cd2.y);
            double d12 = this.fixToFlt(cd3.x);
            double d13 = this.fixToFlt(cd3.y);
            this.mOutlineConsumer.flex(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
            writeData.firstFlex = true;
        }
    }

    private void ct(WriteData writeData, Cd cd, Cd cd2, Cd cd3, PathElt pathElt) {
        if (this.mOutlineConsumer != null) {
            if (pathElt.newcolors != 0) {
                this.wrtNewClrs(writeData, pathElt);
            }
            if (pathElt.isFlex && this.isFlex(writeData, pathElt)) {
                this.wrtFlex(writeData, cd, cd2, cd3, pathElt);
            }
            double d = this.fixToFlt(cd.x);
            double d2 = this.fixToFlt(cd.y);
            double d3 = this.fixToFlt(cd2.x);
            double d4 = this.fixToFlt(cd2.y);
            double d5 = this.fixToFlt(cd3.x);
            double d6 = this.fixToFlt(cd3.y);
            this.mOutlineConsumer.curveto(d, d2, d3, d4, d5, d6);
        }
    }

    private void cp(WriteData writeData, PathElt pathElt) {
        if (pathElt.newcolors != 0) {
            this.wrtNewClrs(writeData, pathElt);
        }
    }

    private void beginGlyph() {
    }

    private void endGlyph() {
        if (this.mOutlineConsumer != null) {
            this.mOutlineConsumer.endchar();
        }
    }

    private boolean writeWidth() {
        if (this.mOutlineConsumer != null) {
            return this.mOutlineConsumer.width(this.mGlyphWidth);
        }
        return true;
    }

    private void numberPath() {
        PathElt pathElt = this.mPathStart;
        short s = 1;
        while (pathElt != null) {
            short s2 = s;
            s = (short)(s + 1);
            pathElt.count = s2;
            pathElt = pathElt.next;
        }
    }

    private void writeGlyph() {
        if (this.mDoWriteGlyph) {
            PathElt pathElt = this.mPathStart;
            Cd cd = new Cd();
            Cd cd2 = new Cd();
            Cd cd3 = new Cd();
            WriteData writeData = new WriteData();
            writeData.wrtColorInfo = this.mPathStart != null && this.mPathStart != this.mPathEnd;
            this.numberPath();
            this.beginGlyph();
            if (!this.writeWidth()) {
                return;
            }
            if (writeData.wrtColorInfo && pathElt.newcolors == 0) {
                this.wrtPntLst(writeData, this.mPtLstArray[0]);
                this.flushHintArray(writeData.hintArray);
                writeData.prevHintArray = new ArrayList(writeData.hintArray);
            }
            writeData.firstFlex = true;
            while (pathElt != null) {
                switch (pathElt.type) {
                    case 2: {
                        cd.x = this.unScaleAbs(this.itfmx(pathElt.x1));
                        cd.y = this.unScaleAbs(this.itfmy(pathElt.y1));
                        cd2.x = this.unScaleAbs(this.itfmx(pathElt.x2));
                        cd2.y = this.unScaleAbs(this.itfmy(pathElt.y2));
                        cd3.x = this.unScaleAbs(this.itfmx(pathElt.x3));
                        cd3.y = this.unScaleAbs(this.itfmy(pathElt.y3));
                        this.ct(writeData, cd, cd2, cd3, pathElt);
                        break;
                    }
                    case 1: {
                        cd.x = this.unScaleAbs(this.itfmx(pathElt.x));
                        cd.y = this.unScaleAbs(this.itfmy(pathElt.y));
                        this.dt(writeData, cd, pathElt);
                        break;
                    }
                    case 0: {
                        cd.x = this.unScaleAbs(this.itfmx(pathElt.x));
                        cd.y = this.unScaleAbs(this.itfmy(pathElt.y));
                        this.mt(writeData, cd, pathElt);
                        break;
                    }
                    case 3: {
                        this.cp(writeData, pathElt);
                    }
                }
                pathElt = pathElt.next;
            }
            this.endGlyph();
            writeData.hintArray = null;
            writeData.prevHintArray = null;
        }
    }

    private void initFix() {
        this.mVFixCount = 0;
        this.mHFixCount = 0;
    }

    private void recordHFix(int n, int n2) {
        this.mHFixYs[this.mHFixCount] = n;
        this.mHFixDYs[this.mHFixCount] = n2;
        ++this.mHFixCount;
    }

    private void recordVFix(int n, int n2) {
        this.mVFixXs[this.mVFixCount] = n;
        this.mVFixDXs[this.mVFixCount] = n2;
        ++this.mVFixCount;
    }

    private void recordForFix(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 < n4) {
            n6 = n3;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n3;
        }
        if (!bl && this.mHFixCount + 4 < 100 && this.mAutoHFix) {
            int n7 = n - n2;
            if (Math.abs(n7) <= 256) {
                this.recordHFix(n6, n7);
                this.recordHFix(n5 - n7, n7);
            } else {
                int n8 = this.fixHalfMul(n7);
                this.recordHFix(n6, n8);
                this.recordHFix(n6 + n7, -n8);
                this.recordHFix(n5, -n8);
                this.recordHFix(n5 - n7, n8);
            }
        } else if (bl && this.mVFixCount + 4 < 100 && this.mAutoVFix) {
            int n9 = n - n2;
            if (Math.abs(n9) <= 256) {
                this.recordVFix(n6, n9);
                this.recordVFix(n5 - n9, n9);
            } else {
                int n10 = this.fixHalfMul(n9);
                this.recordVFix(n6, n10);
                this.recordVFix(n6 + n9, -n10);
                this.recordVFix(n5, -n10);
                this.recordVFix(n5 - n9, n10);
            }
        }
    }

    private boolean findLineSeg(int n, ClrSeg clrSeg) {
        while (clrSeg != null) {
            if (clrSeg.sLoc == n && clrSeg.sType == 0) {
                return true;
            }
            clrSeg = clrSeg.sNxt;
        }
        return false;
    }

    private void checkVal(ClrVal clrVal, boolean bl) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        if (bl) {
            nArray = this.mVStems;
            n3 = this.mNumVStems;
            n2 = this.itfmx(clrVal.vLoc1);
            n = this.itfmx(clrVal.vLoc2);
        } else {
            nArray = this.mHStems;
            n3 = this.mNumHStems;
            n2 = this.itfmy(clrVal.vLoc1);
            n = this.itfmy(clrVal.vLoc2);
        }
        int n4 = Math.abs(n - n2);
        int n5 = this.fixInt(1000);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7 = nArray[i];
            int n8 = Math.abs(n7 - n4);
            if (n8 >= n5) continue;
            n5 = n8;
            n6 = n7;
            if (n5 == 0) break;
        }
        if (n5 == 0 || n5 > this.fixInt(2)) {
            return;
        }
        if (bl && this.mAutoVFix || !bl && this.mAutoHFix) {
            this.recordForFix(bl, n4, n6, n2, n);
        }
    }

    private void checkVals(ClrVal clrVal, boolean bl) {
        while (clrVal != null) {
            this.checkVal(clrVal, bl);
            clrVal = clrVal.vNxt;
        }
    }

    private void fixH(PathElt pathElt, int n, int n2) {
        PathElt pathElt2;
        this.rMovePoint(0, n2, 0, pathElt);
        this.rMovePoint(0, n2, 3, pathElt);
        PathElt pathElt3 = pathElt.prev;
        if (pathElt3 != null && pathElt3.type == 2 && pathElt3.y2 == n) {
            this.rMovePoint(0, n2, 2, pathElt3);
        }
        if (pathElt.type == 3) {
            pathElt = this.getDest(pathElt);
        }
        if ((pathElt2 = pathElt.next) != null && pathElt2.type == 2 && pathElt2.y1 == n) {
            this.rMovePoint(0, n2, 1, pathElt2);
        }
    }

    private void fixHs(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n = this.tfmy(n);
        n2 = this.dtfmy(n2);
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            switch (pathElt.type) {
                case 0: {
                    n3 = n5 = pathElt.x;
                    n4 = n6 = pathElt.y;
                    break;
                }
                case 1: {
                    if (pathElt.y == n && n4 == n) {
                        this.fixH(pathElt, n, n2);
                    }
                    n3 = pathElt.x;
                    n4 = pathElt.y;
                    break;
                }
                case 2: {
                    n3 = pathElt.x3;
                    n4 = pathElt.y3;
                    break;
                }
                case 3: {
                    if (n6 != n || n4 != n || n5 == n3) break;
                    this.fixH(pathElt, n, n2);
                }
            }
            pathElt = pathElt.next;
        }
    }

    private void fixV(PathElt pathElt, int n, int n2) {
        PathElt pathElt2;
        this.rMovePoint(n2, 0, 0, pathElt);
        this.rMovePoint(n2, 0, 3, pathElt);
        PathElt pathElt3 = pathElt.prev;
        if (pathElt3 != null && pathElt3.type == 2 && pathElt3.x2 == n) {
            this.rMovePoint(n2, 0, 2, pathElt3);
        }
        if (pathElt.type == 3) {
            pathElt = this.getDest(pathElt);
        }
        if ((pathElt2 = pathElt.next) != null && pathElt2.type == 2 && pathElt2.x1 == n) {
            this.rMovePoint(n2, 0, 1, pathElt2);
        }
    }

    private void fixVs(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n = this.tfmx(n);
        n2 = this.dtfmx(n2);
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            switch (pathElt.type) {
                case 0: {
                    n3 = n5 = pathElt.x;
                    n4 = n6 = pathElt.y;
                    break;
                }
                case 1: {
                    if (pathElt.x == n && n3 == n) {
                        this.fixV(pathElt, n, n2);
                    }
                    n3 = pathElt.x;
                    n4 = pathElt.y;
                    break;
                }
                case 2: {
                    n3 = pathElt.x3;
                    n4 = pathElt.y3;
                    break;
                }
                case 3: {
                    if (n5 != n || n3 != n || n6 == n4) break;
                    this.fixV(pathElt, n, n2);
                }
            }
            pathElt = pathElt.next;
        }
    }

    private boolean doFixes() {
        int n;
        boolean bl = false;
        if (this.mHFixCount > 0 && this.mAutoHFix) {
            bl = true;
            for (n = 0; n < this.mHFixCount; ++n) {
                this.fixHs(this.mHFixYs[n], this.mHFixDYs[n]);
            }
        }
        if (this.mVFixCount > 0 && this.mAutoVFix) {
            bl = true;
            for (n = 0; n < this.mVFixCount; ++n) {
                this.fixVs(this.mVFixXs[n], this.mVFixDXs[n]);
            }
        }
        return bl;
    }

    private PathElt getDest(PathElt pathElt) {
        if (pathElt == null) {
            return null;
        }
        do {
            if ((pathElt = pathElt.prev) != null) continue;
            return this.mPathStart;
        } while (pathElt.type != 0);
        return pathElt;
    }

    private PathElt getClosedBy(PathElt pathElt) {
        if (pathElt == null) {
            return null;
        }
        if (pathElt.type == 3) {
            return pathElt;
        }
        do {
            if ((pathElt = pathElt.next) == null) {
                return null;
            }
            if (pathElt.type != 0) continue;
            return null;
        } while (pathElt.type != 3);
        return pathElt;
    }

    private void getEndPoint(PathElt pathElt, Cd cd) {
        if (pathElt == null) {
            cd.x = 0;
            cd.y = 0;
            return;
        }
        block5: while (true) {
            switch (pathElt.type) {
                case 0: 
                case 1: {
                    cd.x = pathElt.x;
                    cd.y = pathElt.y;
                    return;
                }
                case 2: {
                    cd.x = pathElt.x3;
                    cd.y = pathElt.y3;
                    return;
                }
                case 3: {
                    pathElt = this.getDest(pathElt);
                    continue block5;
                }
            }
        }
    }

    private void getEndPoints(PathElt pathElt, Cd cd, Cd cd2) {
        this.getEndPoint(pathElt, cd2);
        this.getEndPoint(pathElt.prev, cd);
    }

    private double interpolate(double d, double d2, double d3, double d4, double d5) {
        return d2 + (d - d3) * ((d4 - d2) / (d5 - d3));
    }

    private int hvNess(double d) {
        double d2 = d < 0.25 ? this.interpolate(d, 1.0, 0.0, 0.841, 0.25) : (d < 0.5 ? this.interpolate(d, 0.841, 0.25, 0.707, 0.5) : (d < 1.0 ? this.interpolate(d, 0.707, 0.5, 0.5, 1.0) : (d < 2.0 ? this.interpolate(d, 0.5, 1.0, 0.25, 2.0) : (d < 4.0 ? this.interpolate(d, 0.25, 2.0, 0.0, 4.0) : 0.0))));
        return this.fltToFix(d2);
    }

    private int vertQuo(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 == 0) {
            return 256;
        }
        int n6 = n2 - n4;
        if (n6 < 0) {
            n6 = -n6;
        }
        if (n6 == 0) {
            return 0;
        }
        double d = this.fixToFlt(n5);
        double d2 = this.fixToFlt(n6);
        double d3 = 2.0 * d * d / (0.38 * d2);
        return this.hvNess(d3);
    }

    private int horzQuo(int n, int n2, int n3, int n4) {
        int n5 = n2 - n4;
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 == 0) {
            return 256;
        }
        int n6 = n - n3;
        if (n6 < 0) {
            n6 = -n6;
        }
        if (n6 == 0) {
            return 0;
        }
        double d = this.fixToFlt(n6);
        double d2 = this.fixToFlt(n5);
        double d3 = 2.0 * d2 * d2 / (0.38 * d);
        return this.hvNess(d3);
    }

    private boolean isTiny(PathElt pathElt) {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        this.getEndPoints(pathElt, cd, cd2);
        return Math.abs(cd.x - cd2.x) < 256 && Math.abs(cd.y - cd2.y) < 256;
    }

    private boolean isShort(PathElt pathElt) {
        int n;
        int n2;
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        this.getEndPoints(pathElt, cd, cd2);
        int n3 = Math.abs(cd.x - cd2.x);
        int n4 = Math.abs(cd.y - cd2.y);
        if (n3 > n4) {
            n2 = n4;
            n = n3;
        } else {
            n2 = n3;
            n = n4;
        }
        return n + n2 * 42 / 125 < this.fixInt(3);
    }

    private PathElt nxtForBend(PathElt pathElt, Cd cd, Cd cd2) {
        PathElt pathElt2 = null;
        Cd cd3 = new Cd();
        PathElt pathElt3 = pathElt;
        this.getEndPoint(pathElt, cd3);
        do {
            if (pathElt3.type == 3) {
                pathElt3 = this.getDest(pathElt3);
                if (pathElt2 != null && pathElt2 == pathElt3) {
                    pathElt3 = null;
                } else {
                    pathElt2 = pathElt3;
                    pathElt3 = pathElt3.next;
                }
            } else {
                pathElt3 = pathElt3.next;
            }
            if (pathElt3 != null) continue;
            cd.x = (cd.y = (cd2.x = (cd2.y = this.fixInt(-9999))));
            return pathElt3;
        } while (this.isTiny(pathElt3));
        if (pathElt3.type == 2) {
            int n = pathElt3.x1;
            int n2 = pathElt3.y1;
            if (n == cd3.x && n2 == cd3.y) {
                n = pathElt3.x2;
                n2 = pathElt3.y2;
            }
            cd.x = n;
            cd.y = n2;
        } else {
            this.getEndPoint(pathElt3, cd);
        }
        this.getEndPoint(pathElt3, cd2);
        return pathElt3;
    }

    private PathElt prvForBend(PathElt pathElt, Cd cd) {
        PathElt pathElt2 = null;
        PathElt pathElt3 = pathElt;
        do {
            if ((pathElt3 = pathElt3.prev) == null) {
                cd.x = (cd.y = this.fixInt(-9999));
                return pathElt3;
            }
            if (pathElt3.type != 0) continue;
            if ((pathElt3 = this.getClosedBy(pathElt3)) == null || pathElt2 != null && pathElt2 == pathElt3) {
                cd.x = (cd.y = this.fixInt(-9999));
                return pathElt3;
            }
            pathElt2 = pathElt3;
        } while (this.isTiny(pathElt3));
        if (pathElt3.type == 2) {
            int n = pathElt3.x2;
            int n2 = pathElt3.y2;
            if (n == pathElt3.x3 && n2 == pathElt3.y3) {
                n = pathElt3.x1;
                n2 = pathElt3.y1;
            }
            cd.x = n;
            cd.y = n2;
        } else {
            pathElt = pathElt3.prev;
            if (pathElt == null) {
                cd.x = (cd.y = this.fixInt(-9999));
                return pathElt3;
            }
            this.getEndPoint(pathElt, cd);
        }
        return pathElt3;
    }

    private boolean checkHeight(boolean bl, PathElt pathElt) {
        PathElt pathElt2 = this.mPathStart;
        int n = this.itfmy(pathElt.y);
        while (pathElt2 != null) {
            if (pathElt2.type == 0 && pathElt2 != pathElt) {
                int n2 = this.itfmy(pathElt2.y);
                if (bl && n2 > n || !bl && n2 < n) {
                    return false;
                }
            }
            pathElt2 = pathElt2.next;
        }
        return true;
    }

    private boolean isLower(PathElt pathElt) {
        return this.checkHeight(false, pathElt);
    }

    private boolean isUpper(PathElt pathElt) {
        return this.checkHeight(true, pathElt);
    }

    private short sh_abs(short s) {
        return s < 0 ? (short)(-s) : s;
    }

    private short mdpt(int n, int n2) {
        int n3 = n + n2 >> 1;
        return (short)n3;
    }

    private void fMiniFltn(Cd cd, Cd cd2, Cd cd3, Cd cd4, FltnRec fltnRec, boolean bl) {
        int n;
        short[] sArray = new short[60];
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        int n2 = 0;
        int n3 = 1;
        sArray[n2++] = bl ? (short)1 : 0;
        sArray[n2++] = 0;
        int n4 = fltnRec.llx;
        int n5 = fltnRec.lly;
        sArray[n2++] = (short)(cd.x - n4);
        sArray[n2++] = (short)(cd.y - n5);
        sArray[n2++] = (short)(cd2.x - n4);
        sArray[n2++] = (short)(cd2.y - n5);
        sArray[n2++] = (short)(cd3.x - n4);
        sArray[n2++] = (short)(cd3.y - n5);
        sArray[n2++] = (short)(cd4.x - n4);
        sArray[n2++] = (short)(cd4.y - n5);
        if (sArray[n2 - 10] == 0) {
            n4 = fltnRec.ll.x;
            s = n4 <= 0 ? (short)0 : (short)n4;
            n4 = fltnRec.ll.y;
            s2 = n4 <= 0 ? (short)0 : (short)n4;
            n5 = this.fixInt(128);
            n4 = fltnRec.ur.x;
            s3 = (short)(n4 >= n5 ? Short.MAX_VALUE : (short)n4);
            n4 = fltnRec.ur.y;
            short s5 = s4 = (short)(n4 >= n5 ? Short.MAX_VALUE : (short)n4);
        }
        if ((n = (int)fltnRec.feps) < 8) {
            n = 8;
        }
        while (true) {
            block38: {
                int n6;
                int n7;
                int n8;
                int n9;
                block40: {
                    block39: {
                        if (n3 == 6) break block38;
                        if (sArray[n2 - 10] != 0) break block39;
                        n9 = sArray[n2 - 6];
                        n8 = sArray[n2 - 8];
                        n4 = n8;
                        if (n9 < n4) {
                            n4 = n9;
                        } else if (n9 > n8) {
                            n8 = n9;
                        }
                        n9 = sArray[n2 - 4];
                        if (n9 < n4) {
                            n4 = n9;
                        } else if (n9 > n8) {
                            n8 = n9;
                        }
                        n9 = sArray[n2 - 2];
                        if (n9 < n4) {
                            n4 = n9;
                        } else if (n9 > n8) {
                            n8 = n9;
                        }
                        if (n8 < s || n4 > s3) break block38;
                        n9 = sArray[n2 - 5];
                        n7 = sArray[n2 - 7];
                        n5 = n7;
                        if (n9 < n5) {
                            n5 = n9;
                        } else if (n9 > n7) {
                            n7 = n9;
                        }
                        n9 = sArray[n2 - 3];
                        if (n9 < n5) {
                            n5 = n9;
                        } else if (n9 > n7) {
                            n7 = n9;
                        }
                        n9 = sArray[n2 - 1];
                        if (n9 < n5) {
                            n5 = n9;
                        } else if (n9 > n7) {
                            n7 = n9;
                        }
                        if (n7 < s2 || n5 > s4) break block38;
                        if (n8 <= s3 && n7 <= s4 && n4 >= s && n5 >= s2) {
                            sArray[n2 - 10] = 1;
                        }
                    }
                    if (sArray[n2 - 9] == 0) {
                        n4 = n;
                        n5 = sArray[n2 - 8];
                        n8 = sArray[n2 - 2];
                        if (n5 < n8) {
                            n7 = (short)(n5 - n4);
                            n9 = (short)(n8 + n4);
                        } else {
                            n7 = (short)(n8 - n4);
                            n9 = (short)(n5 + n4);
                        }
                        if (n9 < 0) {
                            n9 = Short.MAX_VALUE;
                        }
                        if ((n6 = sArray[n2 - 6]) > n7 && n6 < n9 && (n6 = sArray[n2 - 4]) > n7 && n6 < n9) {
                            n5 = sArray[n2 - 7];
                            n8 = sArray[n2 - 1];
                            if (n5 < n8) {
                                n7 = (short)(n5 - n4);
                                n9 = (short)(n8 + n4);
                            } else {
                                n7 = (short)(n8 - n4);
                                n9 = (short)(n5 + n4);
                            }
                            if (n9 < 0) {
                                n9 = Short.MAX_VALUE;
                            }
                            if ((n6 = sArray[n2 - 5]) > n7 && n6 < n9 && (n6 = sArray[n2 - 3]) > n7 && n6 < n9) {
                                sArray[n2 - 9] = 1;
                            }
                        }
                    }
                    if (sArray[n2 - 9] == 0) break block40;
                    n8 = sArray[n2 - 8];
                    n7 = sArray[n2 - 7];
                    n4 = (short)(sArray[n2 - 1] - n7);
                    n5 = (short)(n8 - sArray[n2 - 2]);
                    if (n4 == 0 && n5 == 0) break block38;
                    n9 = (this.sh_abs((short)n4) > this.sh_abs((short)n5) ? n4 : n5) * n;
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    n6 = n4 * (sArray[n2 - 6] - n8);
                    if (Math.abs(n6 += n5 * (sArray[n2 - 5] - n7)) >= n9) break block40;
                    n6 = n4 * (sArray[n2 - 4] - n8);
                    if (Math.abs(n6 += n5 * (sArray[n2 - 3] - n7)) < n9) break block38;
                }
                sArray[n2 + 2] = n4 = sArray[n2 - 8];
                n5 = sArray[n2 - 6];
                n8 = sArray[n2 - 4];
                sArray[n2 + 4] = n7 = this.mdpt(n4, n5);
                n6 = this.mdpt(n5, n8);
                short s6 = this.mdpt(n7, n6);
                n9 = s6;
                sArray[n2 + 6] = s6;
                short s7 = this.mdpt(n8, sArray[n2 - 2]);
                n8 = s7;
                sArray[n2 - 4] = s7;
                short s8 = this.mdpt(n6, n8);
                n5 = s8;
                sArray[n2 - 6] = s8;
                short s9 = this.mdpt(n9, n5);
                sArray[n2 + 8] = s9;
                sArray[n2 - 8] = s9;
                sArray[n2 + 3] = n4 = sArray[n2 - 7];
                n5 = sArray[n2 - 5];
                n8 = sArray[n2 - 3];
                short s10 = this.mdpt(n4, n5);
                n7 = s10;
                sArray[n2 + 5] = s10;
                n6 = this.mdpt(n5, n8);
                short s11 = this.mdpt(n7, n6);
                n9 = s11;
                sArray[n2 + 7] = s11;
                short s12 = this.mdpt(n8, sArray[n2 - 1]);
                n8 = s12;
                sArray[n2 - 3] = s12;
                short s13 = this.mdpt(n6, n8);
                n5 = s13;
                sArray[n2 - 5] = s13;
                short s14 = this.mdpt(n9, n5);
                sArray[n2 + 9] = s14;
                sArray[n2 - 7] = s14;
                sArray[n2 + 1] = sArray[n2 - 9];
                sArray[n2 + 0] = sArray[n2 - 10];
                n2 += 10;
                n3 = (short)(n3 + 1);
                continue;
            }
            Cd cd5 = new Cd();
            if ((n3 = (int)((short)(n3 - 1))) == 0) {
                cd5.copyFrom(cd4);
            } else {
                cd5.x = sArray[n2 - 2] + fltnRec.llx;
                cd5.y = sArray[n2 - 1] + fltnRec.lly;
            }
            this.flatReportProc(fltnRec.report, fltnRec.param, cd5);
            if (n3 == 0) {
                return;
            }
            n2 -= 10;
        }
    }

    private void fFltnCurve(Cd cd, Cd cd2, Cd cd3, Cd cd4, FltnRec fltnRec, boolean bl) {
        int n;
        int n2;
        cd = (Cd)cd.clone();
        cd2 = (Cd)cd2.clone();
        cd3 = (Cd)cd3.clone();
        cd4 = (Cd)cd4.clone();
        Cd cd5 = new Cd();
        Cd cd6 = new Cd();
        Cd cd7 = new Cd();
        Cd cd8 = new Cd();
        if (cd.x == cd2.x && cd.y == cd2.y && cd3.x == cd4.x && cd3.y == cd4.y || fltnRec.limit <= 0) {
            this.flatReportProc(fltnRec.report, fltnRec.param, cd4);
            return;
        }
        int n3 = n2 = cd.x;
        int n4 = cd2.x;
        if (n4 < n3) {
            n3 = n4;
        } else if (n4 > n2) {
            n2 = n4;
        }
        n4 = cd3.x;
        if (n4 < n3) {
            n3 = n4;
        } else if (n4 > n2) {
            n2 = n4;
        }
        n4 = cd4.x;
        if (n4 < n3) {
            n3 = n4;
        } else if (n4 > n2) {
            n2 = n4;
        }
        int n5 = n = cd.y;
        n4 = cd2.y;
        if (n4 < n5) {
            n5 = n4;
        } else if (n4 > n) {
            n = n4;
        }
        n4 = cd3.y;
        if (n4 < n5) {
            n5 = n4;
        } else if (n4 > n) {
            n = n4;
        }
        n4 = cd4.y;
        if (n4 < n5) {
            n5 = n4;
        } else if (n4 > n) {
            n = n4;
        }
        if (!bl) {
            if (n2 < fltnRec.ll.x || n3 > fltnRec.ur.x || n < fltnRec.ll.y || n5 > fltnRec.ur.y) {
                this.flatReportProc(fltnRec.report, fltnRec.param, cd4);
                return;
            }
            if (n2 <= fltnRec.ur.x && n <= fltnRec.ur.y && n3 >= fltnRec.ll.x && n5 >= fltnRec.ll.y) {
                bl = true;
            }
        }
        if (n2 - n3 >= (n4 = this.fixInt(127)) || n - n5 >= n4) {
            cd8.copyFrom(cd4);
            cd7.x = cd3.x + cd4.x >> 1;
            cd7.y = cd3.y + cd4.y >> 1;
            cd4.x = cd2.x + cd3.x >> 1;
            cd4.y = cd2.y + cd3.y >> 1;
            cd2.x = cd.x + cd2.x >> 1;
            cd2.y = cd.y + cd2.y >> 1;
            cd3.x = cd2.x + cd4.x >> 1;
            cd3.y = cd2.y + cd4.y >> 1;
            cd6.x = cd4.x + cd7.x >> 1;
            cd6.y = cd4.y + cd7.y >> 1;
            cd5.x = cd3.x + cd6.x >> 1;
            cd5.y = cd3.y + cd6.y >> 1;
            cd4.copyFrom(cd5);
            FltnRec.access$17710(fltnRec);
            this.fFltnCurve(cd, cd2, cd3, cd4, fltnRec, bl);
            this.fFltnCurve(cd5, cd6, cd7, cd8, fltnRec, bl);
            FltnRec.access$17708(fltnRec);
            return;
        }
        fltnRec.llx = n3;
        fltnRec.lly = n5;
        if (!bl) {
            fltnRec.ll.x -= n3;
            fltnRec.ur.x -= n3;
            fltnRec.ll.y -= n5;
            fltnRec.ur.y -= n5;
        }
        this.fMiniFltn(cd, cd2, cd3, cd4, fltnRec, bl);
        if (!bl) {
            fltnRec.ll.x += n3;
            fltnRec.ur.x += n3;
            fltnRec.ll.y += n5;
            fltnRec.ur.y += n5;
        }
    }

    private void fltnCurve(Cd cd, Cd cd2, Cd cd3, Cd cd4, FltnRec fltnRec) {
        fltnRec.limit = (short)6;
        fltnRec.feps = 128;
        this.fFltnCurve(cd, cd2, cd3, cd4, fltnRec, true);
    }

    private int countSubPaths(int[] nArray) {
        int n = 0;
        int n2 = 0;
        PathElt pathElt = this.mPathEnd;
        while (pathElt != null) {
            do {
                pathElt = pathElt.prev;
                ++n2;
            } while (pathElt != null && pathElt.type != 0);
            ++n;
            if (pathElt == null) continue;
            pathElt = pathElt.prev;
        }
        if (nArray != null) {
            nArray[0] = n2;
        }
        return n;
    }

    private void roundPathCoords() {
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (pathElt.type == 2) {
                pathElt.x1 = this.fHalfRnd(pathElt.x1);
                pathElt.y1 = this.fHalfRnd(pathElt.y1);
                pathElt.x2 = this.fHalfRnd(pathElt.x2);
                pathElt.y2 = this.fHalfRnd(pathElt.y2);
                pathElt.x3 = this.fHalfRnd(pathElt.x3);
                pathElt.y3 = this.fHalfRnd(pathElt.y3);
            } else if (pathElt.type == 1 || pathElt.type == 0) {
                pathElt.x = this.fHalfRnd(pathElt.x);
                pathElt.y = this.fHalfRnd(pathElt.y);
            }
            pathElt = pathElt.next;
        }
    }

    private int checkForClr() {
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            PathElt pathElt2 = this.getClosedBy(pathElt);
            pathElt = pathElt2.next;
        }
        return 0;
    }

    private boolean preCheckForColoring() {
        int n;
        int n2 = 0;
        while (this.mPathEnd != null) {
            if (this.mPathEnd.type == 0) {
                this.delete(this.mPathEnd);
                continue;
            }
            if (this.mPathEnd.type == 3) break;
            return false;
        }
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (pathElt.type == 3) {
                if (pathElt == this.mPathEnd) break;
                PathElt pathElt2 = pathElt.next;
                if (pathElt2.type == 0) {
                    pathElt = pathElt2;
                    continue;
                }
                if (pathElt2.type == 3) {
                    this.delete(pathElt2);
                    continue;
                }
            }
            pathElt = pathElt.next;
        }
        do {
            if ((n = this.checkForClr()) != -1) continue;
            return false;
        } while (n != 0 && ++n2 <= 10);
        return true;
    }

    private PathElt getSubpathNext(PathElt pathElt) {
        do {
            if (pathElt.type != 3) continue;
            pathElt = this.getDest(pathElt);
        } while ((pathElt = pathElt.next) != null && this.isTiny(pathElt));
        return pathElt;
    }

    private PathElt getSubpathPrev(PathElt pathElt) {
        while ((pathElt = pathElt.prev) != null) {
            if (pathElt.type == 0) {
                pathElt = this.getClosedBy(pathElt);
            }
            if (this.isTiny(pathElt)) continue;
            break;
        }
        return pathElt;
    }

    private boolean addAutoFlexProp(PathElt pathElt, boolean bl) {
        PathElt pathElt2 = pathElt;
        PathElt pathElt3 = pathElt.next;
        if (bl && pathElt2.y3 == pathElt3.y1 && pathElt3.y1 == pathElt3.y2 && pathElt3.y2 == pathElt3.y3) {
            return false;
        }
        if (pathElt2.x3 == pathElt3.x1 && pathElt3.x1 == pathElt3.x2 && pathElt3.x2 == pathElt3.x3) {
            return false;
        }
        pathElt2.isFlex = true;
        pathElt3.isFlex = true;
        return true;
    }

    private void tryYFlex(PathElt pathElt, PathElt pathElt2, int n, int n2, int n3, int n4) {
        double d;
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        this.getEndPoint(pathElt2, cd);
        if (Math.abs(n2 - cd.y) > this.mFlexCand) {
            return;
        }
        if (this.prodLt0(n4 - n2, n4 - cd.y)) {
            return;
        }
        double d2 = n3 - n;
        double d3 = n4 - n2;
        double d4 = d2 * d2 + d3 * d3;
        double d5 = (d2 = (double)(cd.x - n3)) * d2 + (d3 = (double)(cd.y - n4)) * d3;
        double d6 = d = d4 > d5 ? d5 / d4 : d4 / d5;
        if (d < 0.11) {
            return;
        }
        if (this.mFlexStrict) {
            boolean bl;
            PathElt pathElt3 = this.getSubpathNext(pathElt2);
            this.getEndPoint(pathElt3, cd2);
            if (this.prodLt0(cd2.y - cd.y, n4 - cd.y)) {
                return;
            }
            PathElt pathElt4 = this.getSubpathPrev(pathElt);
            this.getEndPoint(pathElt4.prev, cd3);
            if (this.prodLt0(cd3.y - n2, n4 - n2)) {
                return;
            }
            boolean bl2 = n > n3;
            boolean bl3 = bl = n4 < n2;
            if (bl2 && !bl || !bl2 && bl) {
                return;
            }
        }
        if (pathElt2 != pathElt.next) {
            return;
        }
        if (n2 != cd.y) {
            return;
        }
        this.addAutoFlexProp(pathElt, true);
    }

    private void tryXFlex(PathElt pathElt, PathElt pathElt2, int n, int n2, int n3, int n4) {
        double d;
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        this.getEndPoint(pathElt2, cd);
        if (Math.abs(n - cd.x) > this.mFlexCand) {
            return;
        }
        if (this.prodLt0(n3 - n, n3 - cd.x)) {
            return;
        }
        double d2 = n3 - n;
        double d3 = n4 - n2;
        double d4 = d2 * d2 + d3 * d3;
        double d5 = (d2 = (double)(cd.x - n3)) * d2 + (d3 = (double)(cd.y - n4)) * d3;
        double d6 = d = d4 > d5 ? d5 / d4 : d4 / d5;
        if (d < 0.11) {
            return;
        }
        if (this.mFlexStrict) {
            boolean bl;
            PathElt pathElt3 = this.getSubpathNext(pathElt2);
            this.getEndPoint(pathElt3, cd2);
            if (this.prodLt0(cd2.x - cd.x, n3 - cd.x)) {
                return;
            }
            PathElt pathElt4 = this.getSubpathPrev(pathElt);
            this.getEndPoint(pathElt4.prev, cd3);
            if (this.prodLt0(cd3.x - n, n3 - n)) {
                return;
            }
            boolean bl2 = bl = n2 > cd.y;
            if (bl && n > n3 || !bl && n < n3) {
                return;
            }
        }
        if (pathElt2 != pathElt.next) {
            return;
        }
        if (n != cd.x) {
            return;
        }
        this.addAutoFlexProp(pathElt, false);
    }

    private void autoAddFlex() {
        Cd cd = new Cd();
        Cd cd2 = new Cd();
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            PathElt pathElt2;
            if (pathElt.type == 2 && !pathElt.isFlex && (pathElt2 = this.getSubpathNext(pathElt)).type == 2) {
                this.getEndPoints(pathElt, cd, cd2);
                if (Math.abs(cd.y - cd2.y) <= this.psDist(20)) {
                    this.tryYFlex(pathElt, pathElt2, cd.x, cd.y, cd2.x, cd2.y);
                }
                if (Math.abs(cd.x - cd2.x) <= this.psDist(20)) {
                    this.tryXFlex(pathElt, pathElt2, cd.x, cd.y, cd2.x, cd2.y);
                }
            }
            pathElt = pathElt.next;
        }
    }

    private boolean findCodeInList(int n, short[] sArray) {
        short s;
        int n2 = 0;
        do {
            if ((s = sArray[n2++]) != 0) continue;
            return false;
        } while (n != s);
        return true;
    }

    private int specialCharType(int n) {
        if (this.findCodeInList(n, this.UpperSpecialChars)) {
            return 1;
        }
        if (this.findCodeInList(n, this.LowerSpecialChars)) {
            return -1;
        }
        return 0;
    }

    private boolean hColorChar(int n) {
        return this.findCodeInList(n, this.HColorList);
    }

    private boolean vColorChar(int n) {
        return this.findCodeInList(n, this.VColorList);
    }

    private boolean noBlueChar(int n) {
        return this.findCodeInList(n, this.NoBlueList);
    }

    private boolean moveToNewClrs(int n) {
        return n == 37 || n == 8240;
    }

    private void initShuffleSubpaths() {
        int n = -1;
        PathElt pathElt = this.mPathStart;
        while (pathElt != null) {
            if (pathElt.type == 0) {
                ++n;
            }
            pathElt.count = (short)n;
            pathElt = pathElt.next;
        }
        this.mRowCnt = ++n;
        this.mLinks = n < 4 || n >= 100 ? null : new byte[n * n];
    }

    private void markLinks(ClrVal clrVal, boolean bl) {
        if (this.mLinks == null) {
            return;
        }
        while (clrVal != null) {
            PathElt pathElt;
            ClrSeg clrSeg;
            if (clrVal != null && (clrSeg = clrVal.vSeg1) != null && (pathElt = clrSeg.sElt) != null) {
                short s;
                short s2 = pathElt.count;
                clrSeg = clrVal.vSeg2;
                if (clrSeg != null && (pathElt = clrSeg.sElt) != null && s2 != (s = pathElt.count)) {
                    this.mLinks[this.mRowCnt * s2 + s] = 1;
                    this.mLinks[this.mRowCnt * s + s2] = 1;
                }
            }
            clrVal = clrVal.vNxt;
        }
    }

    private void outPath(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2 = n;
        PathElt pathElt = this.mPathStart;
        while (pathElt != null && pathElt.count != n2) {
            pathElt = pathElt.next;
        }
        if (pathElt != null) {
            this.moveSubpathToEnd(pathElt);
        }
        byArray3[n] = 1;
        int n3 = n * this.mRowCnt;
        n2 = 0;
        while (n2 < this.mRowCnt) {
            int n4 = n2++;
            byArray2[n4] = (byte)(byArray2[n4] + byArray[n3 + 1]);
        }
    }

    private void doShuffleSubpaths() {
        int n;
        byte[] byArray = new byte[100];
        byte[] byArray2 = new byte[100];
        byte[] byArray3 = new byte[100];
        if (this.mLinks == null) {
            return;
        }
        for (n = 0; n < this.mRowCnt; ++n) {
            byArray3[n] = 0;
            byArray[n] = 0;
            byArray2[n] = 0;
        }
        int n2 = 0;
        for (n = 0; n < this.mRowCnt; ++n) {
            for (int i = 0; i < this.mRowCnt; ++i) {
                if (this.mLinks[n2++] == 0) continue;
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] + 1);
            }
        }
        block3: while (true) {
            int n4 = -1;
            byte by = 0;
            for (n = 0; n < this.mRowCnt; ++n) {
                if (byArray2[n] != 0 || n4 != -1 && byArray[n] <= by) continue;
                by = byArray[n];
                n4 = n;
            }
            if (n4 == -1) break;
            this.outPath(this.mLinks, byArray3, byArray2, n4);
            while (true) {
                n4 = -1;
                by = 0;
                byte by2 = 0;
                for (n = 0; n < this.mRowCnt; ++n) {
                    if (byArray2[n] != 0 || byArray3[n] < by2 || byArray3[n] <= 0 || n4 != -1 && byArray3[n] <= by2 && (byArray3[n] != by2 || byArray[n] <= by)) continue;
                    by2 = byArray3[n];
                    n4 = n;
                    by = byArray[n];
                }
                if (n4 == -1) continue block3;
                this.outPath(this.mLinks, byArray3, byArray2, n4);
            }
            break;
        }
    }

    private void addVStem(int n, int n2, boolean bl) {
        if (!bl || this.mAllStems) {
            this.mZoneData.add(0);
            this.mZoneData.add(this.fTrunc(this.fRnd(n)));
            this.mZoneData.add(this.fTrunc(this.fRnd(n2)));
        }
    }

    private void addHStem(int n, int n2, boolean bl) {
        if (!bl || this.mAllStems) {
            this.mZoneData.add(1);
            this.mZoneData.add(this.fTrunc(this.fRnd(n)));
            this.mZoneData.add(this.fTrunc(this.fRnd(n2)));
        }
    }

    private void addCharExtreme(int n, int n2) {
        this.mZoneData.add(2);
        this.mZoneData.add(this.fTrunc(this.fRnd(n2)));
        this.mZoneData.add(this.fTrunc(this.fRnd(n)));
    }

    private void addCharZone(int n, int n2) {
        this.mZoneData.add(3);
        this.mZoneData.add(this.fTrunc(this.fRnd(n2)));
        this.mZoneData.add(this.fTrunc(this.fRnd(n)));
    }

    private void addZone(int n, int n2) {
        this.mZoneData.add(4);
        this.mZoneData.add(this.fTrunc(this.fRnd(n2)));
        this.mZoneData.add(this.fTrunc(this.fRnd(n)));
    }

    private double fixToFlt(int n) {
        return (double)n / 256.0;
    }

    private int fltToFix(double d) {
        if (d >= 8388607.99609375) {
            return Integer.MAX_VALUE;
        }
        if (d <= -8388608.0) {
            return Integer.MIN_VALUE;
        }
        return (int)(d * 256.0);
    }

    private PathElt appendElement(int n) {
        PathElt pathElt = new PathElt();
        pathElt.eltSN = ++this.mEltSN;
        if (pathElt.eltSN == 0) {
            pathElt.eltSN++;
        }
        pathElt.type = (short)n;
        if (this.mInputPathEnd != null) {
            this.mInputPathEnd.next = pathElt;
            pathElt.prev = this.mInputPathEnd;
        } else {
            this.mInputPathStart = pathElt;
        }
        this.mInputPathEnd = pathElt;
        return pathElt;
    }

    private void closeSubPath() {
        if (this.mSubPathOpen) {
            this.mSubPathOpen = false;
            this.appendElement(3);
        }
    }

    public void moveto(double d, double d2) {
        this.closeSubPath();
        PathElt pathElt = this.appendElement(0);
        pathElt.x = this.tfmx(this.scaleAbs(this.fltToFix(d)));
        pathElt.y = this.tfmy(this.scaleAbs(this.fltToFix(d2)));
        this.mCurX = d;
        this.mCurY = d2;
        this.mSubPathOpen = true;
    }

    public void lineto(double d, double d2) {
        PathElt pathElt = this.appendElement(1);
        pathElt.x = this.tfmx(this.scaleAbs(this.fltToFix(d)));
        pathElt.y = this.tfmy(this.scaleAbs(this.fltToFix(d2)));
        this.mCurX = d;
        this.mCurY = d2;
    }

    public void curveto(double d, double d2, double d3, double d4) {
        this.curveto(Math.round((this.mCurX + 2.0 * d) / 3.0), Math.round((this.mCurY + 2.0 * d2) / 3.0), Math.round((2.0 * d + d3) / 3.0), Math.round((2.0 * d2 + d4) / 3.0), Math.round(d3), Math.round(d4));
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        PathElt pathElt = this.appendElement(2);
        pathElt.x1 = this.tfmx(this.scaleAbs(this.fltToFix(d)));
        pathElt.y1 = this.tfmy(this.scaleAbs(this.fltToFix(d2)));
        pathElt.x2 = this.tfmx(this.scaleAbs(this.fltToFix(d3)));
        pathElt.y2 = this.tfmy(this.scaleAbs(this.fltToFix(d4)));
        pathElt.x3 = this.tfmx(this.scaleAbs(this.fltToFix(d5)));
        pathElt.y3 = this.tfmy(this.scaleAbs(this.fltToFix(d6)));
        this.mCurX = d5;
        this.mCurY = d6;
    }

    public void endchar() {
        this.closeSubPath();
        try {
            this.doGlyph();
        }
        catch (ACException aCException) {
            this.emitRawPath();
        }
    }

    public void setMatrix(Matrix matrix) {
        if (this.mOutlineConsumer != null) {
            this.mOutlineConsumer.setMatrix(matrix);
        }
    }

    private void emitRawPath() {
        if (this.mOutlineConsumer != null) {
            PathElt pathElt = this.mPathStart;
            while (pathElt != null) {
                switch (pathElt.type) {
                    case 0: {
                        double d = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.x)));
                        double d2 = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.y)));
                        this.mOutlineConsumer.moveto(d, d2);
                        break;
                    }
                    case 1: {
                        double d = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.x)));
                        double d2 = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.y)));
                        this.mOutlineConsumer.lineto(d, d2);
                        break;
                    }
                    case 2: {
                        double d = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.x1)));
                        double d2 = this.fixToFlt(this.unScaleAbs(this.itfmy(pathElt.y1)));
                        double d3 = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.x2)));
                        double d4 = this.fixToFlt(this.unScaleAbs(this.itfmy(pathElt.y2)));
                        double d5 = this.fixToFlt(this.unScaleAbs(this.itfmx(pathElt.x3)));
                        double d6 = this.fixToFlt(this.unScaleAbs(this.itfmy(pathElt.y3)));
                        this.mOutlineConsumer.curveto(d, d2, d3, d4, d5, d6);
                        break;
                    }
                }
                pathElt = pathElt.next;
            }
            this.mOutlineConsumer.endchar();
        }
    }

    private void resetGlyph() {
        this.mPathEnd = null;
        this.mPathStart = null;
        this.mCurY = 0.0;
        this.mCurX = 0.0;
        PathElt pathElt = this.mInputPathStart;
        while (pathElt != null) {
            PathElt pathElt2 = (PathElt)pathElt.clone();
            if (this.mPathEnd != null) {
                this.mPathEnd.next = pathElt2;
                pathElt2.prev = this.mPathEnd;
            } else {
                this.mPathStart = pathElt2;
            }
            this.mPathEnd = pathElt2;
            pathElt = pathElt.next;
        }
    }

    private void copyBands() {
        int n;
        this.mLenTopBands = Math.min(this.mTopZones.length, 20);
        for (n = 0; n < this.mLenTopBands; ++n) {
            this.mTopBands[n] = this.scaleAbs(this.fixInt(this.mTopZones[n]));
        }
        this.mLenBotBands = Math.min(this.mBottomZones.length, 20);
        for (n = 0; n < this.mLenBotBands; ++n) {
            this.mBotBands[n] = this.scaleAbs(this.fixInt(this.mBottomZones[n]));
        }
    }

    private int fixInt(int n) {
        return n << 8;
    }

    private int fRnd(int n) {
        return n + 128 & 0xFFFFFF00;
    }

    private int fHalfRnd(int n) {
        return n + 64 & 0xFFFFFF80;
    }

    private int fTrunc(int n) {
        return n >> 8;
    }

    private int fixHalfMul(int n) {
        return n >> 1;
    }

    private int fixTwoMul(int n) {
        return n << 1;
    }

    private int tfmx(int n) {
        return this.fixHalfMul(n) + 0;
    }

    private int tfmy(int n) {
        return this.fixHalfMul(n) + 0;
    }

    private int itfmx(int n) {
        return this.fixTwoMul(n) - 0;
    }

    private int itfmy(int n) {
        return this.fixTwoMul(n) - 0;
    }

    private int dtfmx(int n) {
        return this.fixHalfMul(n);
    }

    private int dtfmy(int n) {
        return this.fixHalfMul(n);
    }

    private int idtfmx(int n) {
        return this.fixTwoMul(n);
    }

    private int idtfmy(int n) {
        return this.fixTwoMul(n);
    }

    private int psDist(int n) {
        return this.dtfmx(this.fixInt(n));
    }

    private boolean isVertical(int n, int n2, int n3, int n4) {
        return this.vertQuo(n, n2, n3, n4) > 0;
    }

    private boolean isHorizontal(int n, int n2, int n3, int n4) {
        return this.horzQuo(n, n2, n3, n4) > 0;
    }

    private boolean prodLt0(int n, int n2) {
        return n < 0 && n2 > 0 || n > 0 && n2 < 0;
    }

    private boolean prodGe0(int n, int n2) {
        return !this.prodLt0(n, n2);
    }

    private ClrSeg leftList() {
        return this.mSegLists[0];
    }

    private ClrSeg rightList() {
        return this.mSegLists[1];
    }

    private ClrSeg topList() {
        return this.mSegLists[2];
    }

    private ClrSeg botList() {
        return this.mSegLists[3];
    }

    private static final class WriteData {
        private boolean firstFlex;
        private boolean wrtColorInfo;
        private ClrPoint bst;
        private char bch;
        private int bx;
        private int by;
        private boolean bstB;
        private Cd fc1 = new Cd();
        private Cd fc2 = new Cd();
        private Cd fc3 = new Cd();
        private ArrayList hintArray;
        private ArrayList prevHintArray;

        private WriteData() {
        }
    }

    private static final class HintData {
        private int flags;
        private int v1;
        private int v2;

        private HintData() {
        }
    }

    private static final class CheckData {
        private boolean xflat;
        private boolean yflat;
        private boolean xdone;
        private boolean ydone;
        private boolean bbquit;
        private int xstate;
        private int ystate;
        private int xstart;
        private int ystart;
        private int x0;
        private int cy0;
        private int x1;
        private int cy1;
        private int xloc;
        private int yloc;
        private int x;
        private int y;
        private int xnxt;
        private int ynxt;
        private int yflatstartx;
        private int yflatstarty;
        private int yflatendx;
        private int yflatendy;
        private int xflatstarty;
        private int xflatstartx;
        private int xflatendx;
        private int xflatendy;
        private boolean vert;
        private boolean started;
        private boolean reCheckSmooth;
        private int loc;
        private int frst;
        private int lst;
        private PathElt e;
        private boolean forMultiMaster;

        private CheckData() {
        }
    }

    private static final class NZWindParam {
        private int windCount;
        private double testx;
        private double testy;
        private Cd testPt = new Cd();
        private Cd lastPt = new Cd();
        private Cd firstPt = new Cd();
        private boolean onLine;
        private boolean fromAbove;
        private boolean hasLastPt;
        private boolean testToRight;

        private NZWindParam() {
        }
    }

    private static final class FindExParam {
        private int yMax;
        private int windDir;
        private Cd prerisePt = new Cd();
        private Cd risePt = new Cd();
        private Cd lastPt = new Cd();
        private Cd firstPt = new Cd();
        private Cd beforeFirstSinkPt = new Cd();
        private Cd firstSinkPt = new Cd();
        private boolean hasPrerisePt;
        private boolean hasRisePt;
        private boolean hasLastPt;
        private boolean lastWasExtreme;
        private boolean firstWasExtreme;
        private boolean hasRisePtForFirst;
        private boolean plaeauEnded;

        private FindExParam() {
        }
    }

    private static final class SubPathInfo {
        private PathElt head;
        private PathElt tail;
        private Cd startPt = new Cd();
        private Cd endPt = new Cd();
        private ACBBox bbox = new ACBBox();
        private int currentWind;
        private boolean filled;

        private SubPathInfo() {
        }
    }

    private static final class ACBBox {
        private int xmin;
        private int ymin;
        private int xmax;
        private int ymax;
        private int vMn;
        private int vMx;
        private int hMn;
        private int hMx;
        private PathElt pxmn;
        private PathElt pxmx;
        private PathElt pymn;
        private PathElt pymx;
        private PathElt pe;
        private PathElt pvMn;
        private PathElt pvMx;
        private PathElt phMn;
        private PathElt phMx;

        private ACBBox() {
        }

        void copyFrom(ACBBox aCBBox) {
            this.xmin = aCBBox.xmin;
            this.ymin = aCBBox.ymin;
            this.xmax = aCBBox.xmax;
            this.ymax = aCBBox.ymax;
            this.vMn = aCBBox.vMn;
            this.vMx = aCBBox.vMx;
            this.hMn = aCBBox.hMn;
            this.hMx = aCBBox.hMx;
            this.pxmn = aCBBox.pxmn;
            this.pxmx = aCBBox.pxmx;
            this.pymn = aCBBox.pymn;
            this.pymx = aCBBox.pymx;
            this.pe = aCBBox.pe;
            this.pvMn = aCBBox.pvMn;
            this.pvMx = aCBBox.pvMx;
            this.phMn = aCBBox.phMn;
            this.phMx = aCBBox.phMx;
        }
    }

    private static final class ClrPoint {
        private int cptSN;
        private ClrPoint next;
        private int x0;
        private int y0;
        private int x1;
        private int y1;
        private PathElt p0;
        private PathElt p1;
        private char c;
        private boolean done;

        private ClrPoint() {
        }
    }

    private static final class PathElt
    implements Cloneable {
        private int eltSN;
        private PathElt prev;
        private PathElt next;
        private short type;
        private SegLnkLst Hs;
        private SegLnkLst Vs;
        private boolean Hcopy;
        private boolean Vcopy;
        private boolean isFlex;
        private short count;
        private short newcolors;
        private int x;
        private int y;
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int x3;
        private int y3;

        private PathElt() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private static final class ClrVal
    implements Cloneable {
        private int cvlSN;
        private ClrVal vNxt;
        private int vVal;
        private int vSpc;
        private int initVal;
        private int vLoc1;
        private int vLoc2;
        private boolean vGhst;
        private boolean pruned;
        private boolean merge;
        private ClrSeg vSeg1;
        private ClrSeg vSeg2;
        private ClrVal vBst;

        private ClrVal() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private static final class SegLnkLst {
        private SegLnkLst next;
        private SegLnk lnk;

        private SegLnkLst() {
        }
    }

    private static final class SegLnk {
        private ClrSeg seg;

        private SegLnk() {
        }
    }

    private static final class ClrSeg {
        private int csgSN;
        private ClrSeg sNxt;
        private int sLoc;
        private int sMax;
        private int sMin;
        private int sBonus;
        private ClrVal sLnk;
        private PathElt sElt;
        private short sType;

        private ClrSeg() {
        }
    }

    private static final class FltnRec {
        private short limit;
        private int feps;
        private int report;
        private Object param;
        private Cd ll = new Cd();
        private Cd ur = new Cd();
        private int llx;
        private int lly;

        private FltnRec() {
        }

        static /* synthetic */ short access$17710(FltnRec fltnRec) {
            short s = fltnRec.limit;
            fltnRec.limit = (short)(s - 1);
            return s;
        }

        static /* synthetic */ short access$17708(FltnRec fltnRec) {
            short s = fltnRec.limit;
            fltnRec.limit = (short)(s + 1);
            return s;
        }
    }

    private static final class Cd
    implements Cloneable {
        private int x;
        private int y;

        private Cd() {
        }

        private void copyFrom(Cd cd) {
            this.x = cd.x;
            this.y = cd.y;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private static final class ACException
    extends Exception {
        static final long serialVersionUID = 1L;

        public ACException() {
        }

        public ACException(String string) {
            super(string);
        }

        public ACException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ACException(Throwable throwable) {
            super(throwable);
        }
    }
}

