/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;

class Index {
    public final CFFByteArray data;
    public final int offset;
    protected final int size;
    protected final int entryCount;
    protected final int[] entryOffsets;

    Index(CFFByteArray cFFByteArray, int n) throws InvalidFontException, UnsupportedFontException {
        this.data = cFFByteArray;
        this.offset = n;
        this.entryCount = cFFByteArray.getcard16(n + 0);
        this.entryOffsets = new int[this.entryCount + 1];
        if (this.entryCount == 0) {
            this.size = 2;
            return;
        }
        int n2 = cFFByteArray.getOffSize(n + 2);
        int n3 = n + 3 + n2 * (this.entryCount + 1);
        for (int i = 0; i < this.entryCount + 1; ++i) {
            this.entryOffsets[i] = n3 + cFFByteArray.getOffset(n + 3 + n2 * i, n2, "INDEX offset too big") - 1;
        }
        this.size = this.entryOffsets[this.entryCount] - n;
    }

    public int size() {
        return this.size;
    }

    public int getCount() {
        return this.entryCount;
    }

    public int offsetOf(int n) {
        return this.entryOffsets[n];
    }

    public int offsetFollowing(int n) {
        return this.entryOffsets[n + 1];
    }

    public int sizeOf(int n) {
        return this.entryOffsets[n + 1] - this.entryOffsets[n];
    }

    public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder) throws InvalidFontException {
        cFFByteArrayBuilder.addBytes(this.data, this.offset, this.size);
    }

    public static Cursor startIndex(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, int n) {
        if (n == 0) {
            cFFByteArrayBuilder.addCard16(0);
            return null;
        }
        cFFByteArrayBuilder.addCard16(n);
        cFFByteArrayBuilder.addCard8(4);
        cFFByteArrayBuilder.addCard32(1);
        Cursor cursor = new Cursor();
        cursor.offset = cFFByteArrayBuilder.getSize();
        for (int i = 0; i < n; ++i) {
            cFFByteArrayBuilder.addCard32(1);
        }
        cursor.base = cFFByteArrayBuilder.getSize() - 1;
        return cursor;
    }

    public static Cursor elementEntered(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, Cursor cursor) {
        cFFByteArrayBuilder.setCard32(cursor.offset, cFFByteArrayBuilder.getSize() - cursor.base);
        cursor.offset += 4;
        return cursor;
    }

    public static class Cursor {
        int base;
        int offset;
    }
}

