/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.cff.Type2ConsumerDefaultImpl;

class Type2UnhintedRedirector
extends Type2ConsumerDefaultImpl {
    protected double x;
    protected double y;
    private boolean pathStarted;
    private double pathStartX;
    private double pathStartY;
    protected OutlineConsumer outlineConsumer;

    Type2UnhintedRedirector() {
    }

    void reset(OutlineConsumer outlineConsumer) {
        this.outlineConsumer = outlineConsumer;
        this.x = 0.0;
        this.y = 0.0;
        this.pathStarted = false;
    }

    void startPathIfNeeded(double d, double d2) {
        if (!this.pathStarted) {
            this.pathStarted = true;
            this.pathStartX = d;
            this.pathStartY = d2;
        }
    }

    public void endchar(double[] dArray, int n) {
        if (this.pathStarted && (Double.compare(this.x, this.pathStartX) != 0 || Double.compare(this.y, this.pathStartY) != 0)) {
            this.outlineConsumer.lineto(this.pathStartX, this.pathStartY);
        }
        this.outlineConsumer.endchar();
        this.pathStarted = false;
    }

    public void rmoveto(double[] dArray, int n) {
        this.pathStarted = false;
        this.x += dArray[n - 2];
        this.y += dArray[n - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void hmoveto(double[] dArray, int n) {
        this.pathStarted = false;
        this.x += dArray[n - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void vmoveto(double[] dArray, int n) {
        this.pathStarted = false;
        this.y += dArray[n - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void moveto(double[] dArray, int n) {
        this.pathStarted = false;
        this.x = dArray[n - 2];
        this.y = dArray[n - 1];
        this.outlineConsumer.moveto(this.x, this.y);
    }

    public void rlineto(double[] dArray, int n) {
        for (int i = 0; i < n; i += 2) {
            this.startPathIfNeeded(this.x, this.y);
            this.x += dArray[i];
            this.y += dArray[i + 1];
            this.outlineConsumer.lineto(this.x, this.y);
        }
    }

    public void hlineto(double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (i % 2 == 0) {
                this.startPathIfNeeded(this.x, this.y);
                this.x += dArray[i];
                this.outlineConsumer.lineto(this.x, this.y);
                continue;
            }
            this.startPathIfNeeded(this.x, this.y);
            this.y += dArray[i];
            this.outlineConsumer.lineto(this.x, this.y);
        }
    }

    public void vlineto(double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (i % 2 == 1) {
                this.startPathIfNeeded(this.x, this.y);
                this.x += dArray[i];
                this.outlineConsumer.lineto(this.x, this.y);
                continue;
            }
            this.startPathIfNeeded(this.x, this.y);
            this.y += dArray[i];
            this.outlineConsumer.lineto(this.x, this.y);
        }
    }

    public void rrcurveto(double[] dArray, int n) {
        for (int i = 0; i < n; i += 6) {
            this.startPathIfNeeded(this.x, this.y);
            this.x += dArray[i];
            this.y += dArray[i + 1];
            double d = this.x;
            double d2 = this.y;
            this.x += dArray[i + 2];
            this.y += dArray[i + 3];
            double d3 = this.x;
            double d4 = this.y;
            this.x += dArray[i + 4];
            this.y += dArray[i + 5];
            this.outlineConsumer.curveto(d, d2, d3, d4, this.x, this.y);
        }
    }

    public void hhcurveto(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        if (n % 2 == 1) {
            this.y += dArray[n2++];
        }
        while (n2 < n) {
            this.x += dArray[n2++];
            double d3 = this.x;
            double d4 = this.y;
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            double d5 = this.x;
            double d6 = this.y;
            this.x += dArray[n2++];
            this.startPathIfNeeded(d, d2);
            this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
            d = this.x;
            d2 = this.y;
        }
    }

    public void hvcurveto(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        if (n % 8 == 4 || n % 8 == 5) {
            this.x += dArray[n2++];
            double d3 = this.x;
            double d4 = this.y;
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            double d5 = this.x;
            double d6 = this.y;
            this.y += dArray[n2++];
            if (n2 + 1 == n) {
                this.x += dArray[n2++];
            }
            this.startPathIfNeeded(d, d2);
            this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
            d = this.x;
            d2 = this.y;
            while (n2 + 8 <= n) {
                this.y += dArray[n2++];
                d3 = this.x;
                d4 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                d5 = this.x;
                d6 = this.y;
                this.x += dArray[n2++];
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
                d = this.x;
                d2 = this.y;
                this.x += dArray[n2++];
                d3 = this.x;
                d4 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                d5 = this.x;
                d6 = this.y;
                this.y += dArray[n2++];
                if (n2 + 1 == n) {
                    this.x += dArray[n2++];
                }
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
                d = this.x;
                d2 = this.y;
            }
        } else {
            while (n2 + 8 <= n) {
                this.x += dArray[n2++];
                double d7 = this.x;
                double d8 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                double d9 = this.x;
                double d10 = this.y;
                this.y += dArray[n2++];
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d7, d8, d9, d10, this.x, this.y);
                d = this.x;
                d2 = this.y;
                this.y += dArray[n2++];
                d7 = this.x;
                d8 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                d9 = this.x;
                d10 = this.y;
                this.x += dArray[n2++];
                if (n2 + 1 == n) {
                    this.y += dArray[n2++];
                }
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d7, d8, d9, d10, this.x, this.y);
                d = this.x;
                d2 = this.y;
            }
        }
    }

    public void rcurveline(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        while (n2 + 6 <= n) {
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            double d3 = this.x;
            double d4 = this.y;
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            double d5 = this.x;
            double d6 = this.y;
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            this.startPathIfNeeded(d, d2);
            this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
            d = this.x;
            d2 = this.y;
        }
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        this.startPathIfNeeded(d, d2);
        this.outlineConsumer.lineto(this.x, this.y);
    }

    public void rlinecurve(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        while (n2 + 6 < n) {
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            this.startPathIfNeeded(d, d2);
            this.outlineConsumer.lineto(this.x, this.y);
            d = this.x;
            d2 = this.y;
        }
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d3 = this.x;
        double d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d5 = this.x;
        double d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        this.startPathIfNeeded(d, d2);
        this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
    }

    public void vvcurveto(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        if (n % 2 == 1) {
            this.x += dArray[n2++];
        }
        while (n2 < n) {
            this.y += dArray[n2++];
            double d3 = this.x;
            double d4 = this.y;
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            double d5 = this.x;
            double d6 = this.y;
            this.y += dArray[n2++];
            this.startPathIfNeeded(d, d2);
            this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
            d = this.x;
            d2 = this.y;
        }
    }

    public void vhcurveto(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        if (n % 8 == 4 || n % 8 == 5) {
            this.y += dArray[n2++];
            double d3 = this.x;
            double d4 = this.y;
            this.x += dArray[n2++];
            this.y += dArray[n2++];
            double d5 = this.x;
            double d6 = this.y;
            this.x += dArray[n2++];
            if (n2 + 1 == n) {
                this.y += dArray[n2++];
            }
            this.startPathIfNeeded(d, d2);
            this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
            d = this.x;
            d2 = this.y;
            while (n2 + 8 <= n) {
                this.x += dArray[n2++];
                d3 = this.x;
                d4 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                d5 = this.x;
                d6 = this.y;
                this.y += dArray[n2++];
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
                d = this.x;
                d2 = this.y;
                this.y += dArray[n2++];
                d3 = this.x;
                d4 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                d5 = this.x;
                d6 = this.y;
                this.x += dArray[n2++];
                if (n2 + 1 == n) {
                    this.y += dArray[n2++];
                }
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
                d = this.x;
                d2 = this.y;
            }
        } else {
            while (n2 + 8 <= n) {
                this.y += dArray[n2++];
                double d7 = this.x;
                double d8 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                double d9 = this.x;
                double d10 = this.y;
                this.x += dArray[n2++];
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d7, d8, d9, d10, this.x, this.y);
                d = this.x;
                d2 = this.y;
                this.x += dArray[n2++];
                d7 = this.x;
                d8 = this.y;
                this.x += dArray[n2++];
                this.y += dArray[n2++];
                d9 = this.x;
                d10 = this.y;
                this.y += dArray[n2++];
                if (n2 + 1 == n) {
                    this.x += dArray[n2++];
                }
                this.startPathIfNeeded(d, d2);
                this.outlineConsumer.curveto(d7, d8, d9, d10, this.x, this.y);
                d = this.x;
                d2 = this.y;
            }
        }
    }

    public void hflex(double[] dArray, int n) {
        double d;
        int n2 = 0;
        double d2 = this.x;
        double d3 = d = this.y;
        this.x += dArray[n2++];
        double d4 = this.x;
        double d5 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d6 = this.x;
        double d7 = this.y;
        this.x += dArray[n2++];
        this.startPathIfNeeded(d2, d);
        this.outlineConsumer.curveto(d4, d5, d6, d7, this.x, this.y);
        d2 = this.x;
        d = this.y;
        this.x += dArray[n2++];
        d4 = this.x;
        d5 = this.y;
        this.x += dArray[n2++];
        d6 = this.x;
        d7 = d3;
        this.x += dArray[n2++];
        this.y = d3;
        this.startPathIfNeeded(d2, d);
        this.outlineConsumer.curveto(d4, d5, d6, d7, this.x, d3);
    }

    public void flex(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d3 = this.x;
        double d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d5 = this.x;
        double d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        this.startPathIfNeeded(d, d2);
        this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
        d = this.x;
        d2 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        d3 = this.x;
        d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        d5 = this.x;
        d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        this.startPathIfNeeded(d, d2);
        this.outlineConsumer.curveto(d3, d4, d5, d6, this.x, this.y);
    }

    public void hflex1(double[] dArray, int n) {
        double d;
        int n2 = 0;
        double d2 = this.x;
        double d3 = d = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d4 = this.x;
        double d5 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d6 = this.x;
        double d7 = this.y;
        this.x += dArray[n2++];
        this.startPathIfNeeded(d2, d);
        this.outlineConsumer.curveto(d4, d5, d6, d7, this.x, this.y);
        d2 = this.x;
        d = this.y;
        this.x += dArray[n2++];
        d4 = this.x;
        d5 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        d6 = this.x;
        d7 = this.y;
        this.x += dArray[n2++];
        this.y = d3;
        this.startPathIfNeeded(d2, d);
        this.outlineConsumer.curveto(d4, d5, d6, d7, this.x, this.y);
    }

    public void flex1(double[] dArray, int n) {
        int n2 = 0;
        double d = this.x;
        double d2 = this.y;
        double d3 = this.x;
        double d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d5 = this.x;
        double d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        double d7 = this.x;
        double d8 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        this.startPathIfNeeded(d3, d4);
        this.outlineConsumer.curveto(d5, d6, d7, d8, this.x, this.y);
        d3 = this.x;
        d4 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        d5 = this.x;
        d6 = this.y;
        this.x += dArray[n2++];
        this.y += dArray[n2++];
        d7 = this.x;
        d8 = this.y;
        if (Math.abs(this.x - d) > Math.abs(this.y - d2)) {
            this.x += dArray[n2++];
            this.y = d2;
        } else {
            this.y += dArray[n2++];
            this.x = d;
        }
        this.startPathIfNeeded(d3, d4);
        this.outlineConsumer.curveto(d5, d6, d7, d8, this.x, this.y);
    }
}

