/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Orientation;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.Tag;
import java.io.IOException;
import java.util.Map;

public final class Base
extends Table {
    protected Base(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        int n = this.getTableMajorVersion();
        if (n != 1) {
            throw new UnsupportedFontException("'BASE' tables with major version " + n + "are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getBaselinePosition(Orientation orientation, int n, int n2) throws InvalidFontException {
        int n3;
        int n4;
        int n5 = this.data.getOffset(0, orientation == Orientation.HORIZONTAL ? 4 : 6);
        if (n5 == 0) {
            return Integer.MAX_VALUE;
        }
        int n6 = this.data.getOffset(n5, 0);
        if (n6 == 0) {
            return Integer.MAX_VALUE;
        }
        int n7 = -1;
        int n8 = this.data.getuint16(n6);
        for (n4 = 0; n4 < n8; ++n4) {
            if (this.data.getuint32(n6 + 2 + 4 * n4) != (long)n2) continue;
            n7 = n4;
            break;
        }
        if (n7 == -1) {
            return Integer.MAX_VALUE;
        }
        n4 = this.data.getOffset(n5, 2);
        int n9 = this.data.getuint16(n4);
        int n10 = -1;
        for (n3 = 0; n3 < n9; ++n3) {
            if (Tag.script_DFLT == n || this.data.getuint32(n4 + 2 + 6 * n3) == (long)n) {
                n10 = n3;
                break;
            }
            if (n10 != -1 || this.data.getuint32(n4 + 2 + 6 * n3) != (long)Tag.script_DFLT) continue;
            n10 = n3;
            break;
        }
        if (n10 == -1) {
            return Integer.MAX_VALUE;
        }
        n3 = this.data.getOffset(n4, 2 + 6 * n10 + 4);
        int n11 = this.data.getOffset(n3, 0);
        if (n11 == 0) {
            return Integer.MAX_VALUE;
        }
        int n12 = this.data.getOffset(n11, 4 + 2 * n7);
        return this.data.getint16(n12 + 2);
    }

    private boolean baseCoordNeedsRegenerated(int n) throws InvalidFontException {
        return n != 0 && this.data.getuint16(n) == 2;
    }

    private boolean minMaxNeedsRegenerated(int n) throws InvalidFontException {
        if (n == 0) {
            return false;
        }
        if (this.baseCoordNeedsRegenerated(this.data.getOffset(n, 0))) {
            return true;
        }
        if (this.baseCoordNeedsRegenerated(this.data.getOffset(n, 2))) {
            return true;
        }
        int n2 = this.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            if (this.baseCoordNeedsRegenerated(this.data.getOffset(n, 6 + 8 * i + 4))) {
                return true;
            }
            if (!this.baseCoordNeedsRegenerated(this.data.getOffset(n, 6 + 8 * i + 6))) continue;
            return true;
        }
        return false;
    }

    private boolean axisNeedsRegenerated(int n) throws InvalidFontException {
        if (n == 0) {
            return false;
        }
        int n2 = this.data.getOffset(n, 2);
        int n3 = this.data.getuint16(n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            int n6;
            int n7 = this.data.getOffset(n2, 2 + 6 * i + 4);
            int n8 = this.data.getOffset(n7, 0);
            if (n8 != 0) {
                n6 = this.data.getuint16(n8 + 2);
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = this.data.getOffset(n8, 4 + 2 * n5);
                    if (!this.baseCoordNeedsRegenerated(n4)) continue;
                    return true;
                }
            }
            if (this.minMaxNeedsRegenerated(n6 = this.data.getOffset(n7, 2))) {
                return true;
            }
            n5 = this.data.getuint16(n7 + 4);
            for (n4 = 0; n4 < n5; ++n4) {
                int n9 = this.data.getOffset(n7, 6 + 6 * n4 + 4);
                if (!this.minMaxNeedsRegenerated(n9)) continue;
                return true;
            }
        }
        return false;
    }

    boolean baseNeedsRegenerated() throws InvalidFontException {
        return this.axisNeedsRegenerated(this.data.getOffset(0, 4)) || this.axisNeedsRegenerated(this.data.getOffset(0, 6));
    }

    private int generateBaseCoord(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws InvalidFontException {
        oTByteArrayBuilder.ensureCapacity(n2 + 4);
        oTByteArrayBuilder.setuint16(n2, 1);
        oTByteArrayBuilder.setint16(n2 + 2, this.data.getint16(n + 2));
        return 4;
    }

    private int generateMinMax(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n + 4);
        int n4 = 6 + 8 * n3;
        oTByteArrayBuilder.ensureCapacity(n2 + n4);
        int n5 = this.data.getOffset(n, 0);
        if (n5 != 0) {
            oTByteArrayBuilder.setuint16(n2, n4);
            n4 += this.generateBaseCoord(oTByteArrayBuilder, n5, n2 + n4);
        } else {
            oTByteArrayBuilder.setuint16(n2, 0);
        }
        int n6 = this.data.getOffset(n, 2);
        if (n6 != 0) {
            oTByteArrayBuilder.setuint16(n2 + 2, n4);
            n4 += this.generateBaseCoord(oTByteArrayBuilder, n6, n2 + n4);
        } else {
            oTByteArrayBuilder.setuint16(n2 + 2, 0);
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < 4; ++j) {
                oTByteArrayBuilder.setuint8(n2 + 6 + 8 * i + j, this.data.getuint8(n + 6 + i * 8 + j));
            }
            n5 = this.data.getOffset(n, 6 + 8 * i + 4);
            if (n5 != 0) {
                oTByteArrayBuilder.setuint16(n2 + 6 + 8 * i + 4, n4);
                n4 += this.generateBaseCoord(oTByteArrayBuilder, n5, n2 + n4);
            } else {
                oTByteArrayBuilder.setuint16(n2 + 6 + 8 * i + 4, 0);
            }
            n6 = this.data.getOffset(n, 6 + 8 * i + 6);
            if (n6 != 0) {
                oTByteArrayBuilder.setuint16(n2 + 6 + 8 * i + 6, n4);
                n4 += this.generateBaseCoord(oTByteArrayBuilder, n6, n2 + n4);
                continue;
            }
            oTByteArrayBuilder.setuint16(n2 + 6 + 8 * i + 6, 0);
        }
        return n4;
    }

    private int generateBaseValues(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n + 2);
        int n4 = 4 + 2 * n3;
        oTByteArrayBuilder.ensureCapacity(n2 + n4);
        oTByteArrayBuilder.setuint16(n2, this.data.getuint16(n));
        oTByteArrayBuilder.setuint16(n2 + 2, n3);
        for (int i = 0; i < n3; ++i) {
            oTByteArrayBuilder.setuint16(n2 + 4 + 2 * i, n4);
            n4 += this.generateBaseCoord(oTByteArrayBuilder, this.data.getOffset(n, 4 + 2 * i), n2 + n4);
        }
        return n4;
    }

    private int generateBaseScript(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n2 + 4);
        int n4 = 6 + 6 * n3;
        oTByteArrayBuilder.ensureCapacity(n + n4);
        int n5 = this.data.getOffset(n2, 0);
        if (n5 != 0) {
            oTByteArrayBuilder.setuint16(n, n4);
            n4 += this.generateBaseValues(oTByteArrayBuilder, n5, n + n4);
        } else {
            oTByteArrayBuilder.setuint16(n, 0);
        }
        int n6 = this.data.getOffset(n2, 2);
        if (n6 != 0) {
            oTByteArrayBuilder.setuint16(n + 2, n4);
            n4 += this.generateMinMax(oTByteArrayBuilder, n6, n + n4);
        } else {
            oTByteArrayBuilder.setuint16(n + 2, 0);
        }
        oTByteArrayBuilder.setuint16(n + 4, n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < 4; ++j) {
                oTByteArrayBuilder.setuint8(n + 6 + 6 * i + j, this.data.getuint8(n2 + 6 + i * 6 + j));
            }
            oTByteArrayBuilder.setuint16(n + 6 + 6 * i + 4, n4);
            n4 += this.generateMinMax(oTByteArrayBuilder, this.data.getOffset(n2, 6 + 6 * i + 4), n + n4);
        }
        return n4;
    }

    private int generateAxis(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws InvalidFontException {
        int n3;
        int n4;
        int n5;
        int n6 = this.data.getOffset(n, 0);
        int n7 = this.data.getOffset(n, 2);
        int n8 = 4;
        oTByteArrayBuilder.ensureCapacity(n2 + n8);
        if (n6 != 0) {
            oTByteArrayBuilder.setuint16(n2, 4);
            n5 = this.data.getuint16(n6);
            n4 = 2 + n5 * 4;
            oTByteArrayBuilder.ensureCapacity(n2 + (n8 += n4));
            for (n3 = 0; n3 < n4; ++n3) {
                oTByteArrayBuilder.setuint8(n2 + 4 + n3, this.data.getuint8(n6 + n3));
            }
        } else {
            oTByteArrayBuilder.setuint16(n2, 0);
        }
        if (n7 != 0) {
            n5 = this.data.getuint16(n7);
            n4 = n2 + n8;
            n3 = 0;
            int n9 = 0;
            oTByteArrayBuilder.ensureCapacity(n4 + n5 * 6 + 2);
            n8 += n5 * 6 + 2;
            oTByteArrayBuilder.setuint16(n2 + 2, n4 - n2);
            oTByteArrayBuilder.setuint16(n4, n5);
            for (int i = 0; i < n5; ++i) {
                int n10;
                int n11;
                for (n11 = 0; n11 < 4; ++n11) {
                    oTByteArrayBuilder.setuint8(n4 + 2 + i * 6 + n11, this.data.getuint8(n7 + 2 + i * 6 + n11));
                }
                int n12 = this.data.getOffset(n7, 2 + i * 6 + 4);
                for (n11 = 0; n11 < i && (n10 = this.data.getOffset(n7, 2 + n11 * 6 + 4)) != n12; ++n11) {
                }
                if (n11 == i) {
                    oTByteArrayBuilder.setuint16(n4 + 2 + i * 6 + 4, 2 + n5 * 6 + n9 + n3);
                    n9 += n3;
                    n3 = this.generateBaseScript(oTByteArrayBuilder, n2 + n8, this.data.getOffset(n7, 2 + i * 6 + 4));
                    n8 += n3;
                    continue;
                }
                oTByteArrayBuilder.setuint16(n4 + 2 + i * 6 + 4, oTByteArrayBuilder.getuint16(n4 + 2 + n11 * 6 + 4));
            }
        } else {
            oTByteArrayBuilder.setuint16(n2 + 2, 0);
        }
        return n8;
    }

    OTByteArray.OTByteArrayBuilder regenerateBaseTable() throws InvalidFontException {
        int n;
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance();
        oTByteArrayBuilder.ensureCapacity(8);
        oTByteArrayBuilder.setuint32(0, 65536);
        int n2 = this.data.getOffset(0, 4);
        int n3 = n2 == 0 ? 0 : 8;
        oTByteArrayBuilder.setuint16(4, n3);
        int n4 = 0;
        if (n3 != 0) {
            n4 = this.generateAxis(oTByteArrayBuilder, n2, n3);
        }
        if ((n = this.data.getOffset(0, 6)) == 0) {
            oTByteArrayBuilder.setuint16(6, 0);
        } else {
            oTByteArrayBuilder.setuint16(6, n4 + 8);
            this.generateAxis(oTByteArrayBuilder, n, n4 + 8);
        }
        return oTByteArrayBuilder;
    }

    public void subsetAndStream(Subset subset, Map map) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.baseNeedsRegenerated() ? this.regenerateBaseTable() : this.getDataAsByteArray();
        map.put(new Integer(1111577413), oTByteArrayBuilder);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1111577413), oTByteArrayBuilder);
    }
}

