/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.charset.CharsetEncoderICU;
import com.adobe.agl.text.UTF16;
import com.adobe.fontengine.CharsetUtil;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Cmap
extends Table {
    protected final int unicodeSubtableOffset;
    protected final int oldUnicodeSubtableOffset;
    protected final NonUnicodeCmap[] nonUnicodeSubtableIndices;
    protected final int symbolSubtableOffset;
    protected int paddingByte = 0;

    protected Cmap(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        int n = this.probe(3, 10);
        this.unicodeSubtableOffset = n != -1 ? n : ((n = this.probe(0, 4)) != -1 ? n : ((n = this.probe(3, 1)) != -1 ? n : ((n = this.probe(0, 3)) != -1 ? n : -1)));
        n = this.probe(0, 2);
        this.oldUnicodeSubtableOffset = n != -1 ? n : ((n = this.probe(0, 1)) != -1 ? n : ((n = this.probe(0, 0)) != -1 ? n : -1));
        n = this.probe(3, 0);
        if (n != -1) {
            this.symbolSubtableOffset = n;
            this.paddingByte = this.computeSymbolPad(this.symbolSubtableOffset);
        } else {
            this.symbolSubtableOffset = -1;
        }
        ArrayList<NonUnicodeCmap> arrayList = new ArrayList<NonUnicodeCmap>();
        n = this.probe(3, 2);
        if (n != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-932"));
        }
        if ((n = this.probe(3, 3)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-936"));
        }
        if ((n = this.probe(3, 4)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-950"));
        }
        if ((n = this.probe(3, 5)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-949"));
        }
        if ((n = this.probe(3, 6)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "ms1361"));
        }
        if ((n = this.probe(1, 0)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacRoman"));
        }
        if ((n = this.probe(1, 1)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacJapanese"));
        }
        if ((n = this.probe(1, 2)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacChineseTraditional"));
        }
        if ((n = this.probe(1, 3)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacKorean"));
        }
        if ((n = this.probe(1, 4)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacArabic"));
        }
        if ((n = this.probe(1, 5)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacHebrew"));
        }
        if ((n = this.probe(1, 6)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacGreek"));
        }
        if ((n = this.probe(1, 7)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacCyrillic"));
        }
        if ((n = this.probe(1, 8)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacSymbol"));
        }
        if ((n = this.probe(1, 21)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacThai"));
        }
        if ((n = this.probe(1, 25)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacChineseSimplified"));
        }
        this.nonUnicodeSubtableIndices = arrayList.toArray(new NonUnicodeCmap[0]);
    }

    private int computeSymbolPad(int n) throws UnsupportedFontException, InvalidFontException {
        int n2;
        int[] nArray = new int[]{61440, 61696, 61952, 0};
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = this.getMapping(n, 97 + nArray[n2]);
            if (n3 == 0) continue;
            return nArray[n2];
        }
        n2 = this.getLowestMappedCode(n);
        if (n2 >= 61440 && n2 < 62208) {
            return n2 & 0xFF00;
        }
        return 0;
    }

    public int probe(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.data.getuint16(2);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.data.getuint16(4 + 8 * i + 0);
            int n5 = this.data.getuint16(4 + 8 * i + 2);
            if (n4 != n || n5 != n2) continue;
            return this.data.getuint32asint(4 + 8 * i + 4, "Offset to cmap subtable is big");
        }
        return -1;
    }

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return this.symbolSubtableOffset != -1;
    }

    public void enumerateCmaps(CmapSelector cmapSelector) throws UnsupportedFontException, InvalidFontException {
        int n = this.data.getuint16(2);
        block14: for (int i = 0; i < n; ++i) {
            int n2 = this.data.getuint16(4 + 8 * i + 0);
            int n3 = this.data.getuint16(4 + 8 * i + 2);
            switch (n2) {
                case 1: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 21: 
                        case 25: {
                            cmapSelector.cmapFound(n2, n3, i);
                        }
                    }
                    continue block14;
                }
                case 3: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 10: {
                            cmapSelector.cmapFound(n2, n3, i);
                        }
                    }
                    continue block14;
                }
                case 0: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            cmapSelector.cmapFound(n2, n3, i);
                        }
                    }
                }
            }
        }
    }

    public int getCmapSubtableIndex(int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(2);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.data.getuint16(4 + 8 * i + 0);
            int n5 = this.data.getuint16(4 + 8 * i + 2);
            if (n4 != n || n5 != n2) continue;
            return i;
        }
        return -1;
    }

    int removeSymbolModifier(int n) throws UnsupportedFontException, InvalidFontException {
        int n2;
        if (this.symbolSubtableOffset != -1 && (n2 = n & 0xFF00) == this.paddingByte) {
            return n & 0xFF;
        }
        return n;
    }

    public int unicodeChar2glyph(int n) throws UnsupportedFontException, InvalidFontException {
        if (this.symbolSubtableOffset != -1) {
            int n2 = this.getMapping(this.symbolSubtableOffset, n);
            if (n2 == 0 && 0 <= n && n <= 255) {
                n2 = this.getMapping(this.symbolSubtableOffset, this.paddingByte | n);
            }
            return n2;
        }
        if (this.unicodeSubtableOffset != -1) {
            if (n == 65535) {
                return 0;
            }
            return this.getMapping(this.unicodeSubtableOffset, n);
        }
        if (this.nonUnicodeSubtableIndices != null) {
            return this.getNonUnicodeMapping(n);
        }
        return 0;
    }

    public int coolTypeUnicodeChar2glyph(int n) throws UnsupportedFontException, InvalidFontException {
        if (this.unicodeSubtableOffset != -1) {
            return this.getMapping(this.unicodeSubtableOffset, n);
        }
        if (this.oldUnicodeSubtableOffset != -1) {
            return this.getMapping(this.oldUnicodeSubtableOffset, n);
        }
        if (this.symbolSubtableOffset != -1) {
            int n2 = this.getMapping(this.symbolSubtableOffset, n);
            if (n2 == 0 && 0 <= n && n <= 255) {
                n2 = this.getMapping(this.symbolSubtableOffset, this.paddingByte | n);
            }
            return n2;
        }
        if (this.nonUnicodeSubtableIndices != null) {
            return this.getNonUnicodeMapping(n);
        }
        return 0;
    }

    int getNonUnicodeMapping(int n) throws UnsupportedFontException, InvalidFontException {
        char[] cArray = new char[2];
        UTF16.append((char[])cArray, (int)0, (int)n);
        CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, cArray[1] == '\u0000' ? 1 : 2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        for (NonUnicodeCmap nonUnicodeCmap : this.nonUnicodeSubtableIndices) {
            try {
                CoderResult coderResult;
                CharsetEncoder charsetEncoder = nonUnicodeCmap.getCharsetEncoder();
                if (charsetEncoder == null) {
                    int n2 = this.getMapping(nonUnicodeCmap.subtableOffset, n);
                    if (n2 == 0) continue;
                    return n2;
                }
                if (!charsetEncoder.canEncode((char)n) || (coderResult = CharsetUtil.encodeLoopNoExceptions(charBuffer, byteBuffer, charsetEncoder)).isError()) continue;
                if (byteBuffer.position() == 1) {
                    int n3 = byteBuffer.get(0) & 0xFF;
                    return this.getMapping(nonUnicodeCmap.subtableOffset, n3);
                }
                if (byteBuffer.position() != 2) continue;
                int n4 = (byteBuffer.get(0) & 0xFF) << 8 | byteBuffer.get(1) & 0xFF;
                return this.getMapping(nonUnicodeCmap.subtableOffset, n4);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int char2glyph(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint32asint(4 + 8 * n2 + 4, "Offset to cmap subtable is big");
        return this.getMapping(n3, n);
    }

    public int getLowestMappedCode(int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint16(n);
        switch (n2) {
            case 0: {
                return this.getLowestMappedCodeFormat0(n);
            }
            case 2: {
                return this.getLowestMappedCodeFormat2(n);
            }
            case 4: {
                return this.getLowestMappedCodeFormat4(n);
            }
            case 6: {
                return this.getLowestMappedCodeFormat6(n);
            }
            case 8: {
                return this.getLowestMappedCodeFormat8(n);
            }
            case 10: {
                return this.getLowestMappedCodeFormat10(n);
            }
            case 12: {
                return this.getLowestMappedCodeFormat12(n);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + n2);
    }

    public int getHighestMappedCode(int n, boolean bl) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint16(n);
        switch (n2) {
            case 0: {
                return this.getHighestMappedCodeFormat0(n);
            }
            case 2: {
                return this.getHighestMappedCodeFormat2(n);
            }
            case 4: {
                return this.getHighestMappedCodeFormat4(n);
            }
            case 6: {
                return this.getHighestMappedCodeFormat6(n);
            }
            case 8: {
                return this.getHighestMappedCodeFormat8(n, bl);
            }
            case 10: {
                return this.getHighestMappedCodeFormat10(n, bl);
            }
            case 12: {
                return this.getHighestMappedCodeFormat12(n, bl);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + n2);
    }

    public int getMapping(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint16(n);
        switch (n3) {
            case 0: {
                return this.getMappingFormat0(n, n2);
            }
            case 2: {
                return this.getMappingFormat2(n, n2);
            }
            case 4: {
                return this.getMappingFormat4(n, n2);
            }
            case 6: {
                return this.getMappingFormat6(n, n2);
            }
            case 8: {
                return this.getMappingFormat8(n, n2);
            }
            case 10: {
                return this.getMappingFormat10(n, n2);
            }
            case 12: {
                return this.getMappingFormat12(n, n2);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + n3);
    }

    public int getOffset(int n) throws InvalidFontException, UnsupportedFontException {
        return this.data.getuint32asint(4 + n * 8 + 4, "Offset to cmap subtable is big");
    }

    public int[] glyph2char(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3;
        int[] nArray = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = -1;
        }
        n3 = this.data.getuint32asint(4 + 8 * n2 + 4, "Offset to cmap subtable is big");
        int n4 = this.data.getuint16(n3);
        switch (n4) {
            case 0: {
                this.getInvertedMappingFormat0(nArray, n3);
                break;
            }
            case 2: {
                this.getInvertedMappingFormat2(nArray, n3);
                break;
            }
            case 4: {
                this.getInvertedMappingFormat4(nArray, n3);
                break;
            }
            case 6: {
                this.getInvertedMappingFormat6(nArray, n3);
                break;
            }
            case 8: {
                this.getInvertedMappingFormat8(nArray, n3);
                break;
            }
            case 10: {
                this.getInvertedMappingFormat10(nArray, n3);
                break;
            }
            case 12: {
                this.getInvertedMappingFormat12(nArray, n3);
                break;
            }
            default: {
                throw new UnsupportedFontException("cmap subtable format " + n4);
            }
        }
        return nArray;
    }

    protected int getLowestMappedCodeFormat0(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 2) - 6 - 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.data.getuint8(n + 6 + i);
            if (n3 <= 0) continue;
            return i;
        }
        return n2;
    }

    protected int getHighestMappedCodeFormat0(int n) throws InvalidFontException {
        for (int i = this.data.getuint16(n + 2) - 6 - 1; i >= 0; --i) {
            int n2 = this.data.getuint8(n + 6 + i);
            if (n2 <= 0) continue;
            return i;
        }
        return 0;
    }

    protected int getMappingFormat0(int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n + 2) - 6;
        if (0 <= n2 && n2 < n3) {
            return this.data.getuint8(n + 6 + n2);
        }
        return 0;
    }

    protected void getInvertedMappingFormat0(int[] nArray, int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 2) - 6;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.data.getuint8(n + 6 + n3);
            nArray[n4] = n3++;
        }
    }

    protected int getLowestMappedCodeFormat2(int n) throws InvalidFontException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 0; n10 <= 255; ++n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n7 = this.data.getuint16(n8);
            n6 = this.data.getuint16(n8 + 2) + n7 - 1;
            if (n7 > n10 || n10 > n6) continue;
            n5 = this.data.getuint16(n8 + 4);
            n4 = this.data.getuint16(n8 + 6);
            n3 = n8 + 6 + n4;
            n2 = this.data.getuint16(n3 + 2 * (n10 - n7));
            if (n2 == 0 || (n2 = (n2 + n5) % 65536) == 0) continue;
            return n10;
        }
        for (n10 = 1; n10 <= 255; ++n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n6 = n7 = this.data.getuint16(n8);
            n5 = this.data.getuint16(n8 + 2) + n7 - 1;
            while (n7 <= n5) {
                n4 = this.data.getuint16(n8 + 4);
                n3 = this.data.getuint16(n8 + 6);
                n2 = n8 + 6 + n3;
                int n11 = this.data.getuint16(n2 + 2 * (n7 - n6));
                if (n11 != 0 && (n11 = (n11 + n4) % 65536) != 0) {
                    return n10 << 8 | n7;
                }
                ++n7;
            }
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat2(int n) throws InvalidFontException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 255; n10 > 0; --n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n7 = this.data.getuint16(n8);
            for (n6 = this.data.getuint16(n8 + 2) + n7 - 1; n7 <= n6; --n6) {
                n5 = this.data.getuint16(n8 + 4);
                n4 = this.data.getuint16(n8 + 6);
                n3 = n8 + 6 + n4;
                n2 = this.data.getuint16(n3 + 2 * (n6 - n7));
                if (n2 == 0 || (n2 = (n2 + n5) % 65536) == 0) continue;
                return n10 << 8 | n6;
            }
        }
        for (n10 = 255; n10 >= 0; --n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n7 = this.data.getuint16(n8);
            n6 = this.data.getuint16(n8 + 2) + n7 - 1;
            if (n7 > n10 || n10 > n6) continue;
            n5 = this.data.getuint16(n8 + 4);
            n4 = this.data.getuint16(n8 + 6);
            n3 = n8 + 6 + n4;
            n2 = this.data.getuint16(n3 + 2 * (n10 - n7));
            if (n2 == 0 || (n2 = (n2 + n5) % 65536) == 0) continue;
            return n10;
        }
        return 0;
    }

    protected int getMappingFormat2(int n, int n2) throws InvalidFontException {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = n3 == 0 && this.data.getuint16(n + 6 + 2 * n4) == 0 ? n4 : n3;
        int n6 = n4;
        n3 = this.data.getuint16(n + 6 + 2 * n5) / 8;
        n4 = n + 518 + 8 * n3;
        int n7 = this.data.getuint16(n4);
        int n8 = this.data.getuint16(n4 + 2);
        if (n6 < n7 || n7 + n8 <= n6) {
            return 0;
        }
        int n9 = this.data.getuint16(n4 + 4);
        int n10 = this.data.getuint16(n4 + 6);
        int n11 = n4 + 6 + n10;
        int n12 = this.data.getuint16(n11 + 2 * (n6 - n7));
        if (n12 == 0) {
            return 0;
        }
        return (n12 + n9) % 65536;
    }

    protected void getInvertedMappingFormat2(int[] nArray, int n) throws InvalidFontException {
        for (int i = 0; i <= 255; ++i) {
            int n2;
            int n3 = this.data.getuint16(n + 6 + 2 * i) / 8;
            int n4 = n + 518 + n3 * 8;
            int n5 = this.data.getuint16(n4);
            int n6 = this.data.getuint16(n4 + 2);
            int n7 = this.data.getuint16(n4 + 4);
            int n8 = this.data.getuint16(n4 + 6);
            int n9 = n4 + 6 + n8;
            if (n3 == 0) {
                n2 = this.data.getuint16(n9 + 2 * (i - n5));
                if (n2 == 0) continue;
                nArray[(n2 + n7) % 65536] = i;
                continue;
            }
            for (n2 = n5; n2 < n5 + n6; ++n2) {
                int n10 = this.data.getuint16(n9 + 2 * (n2 - n5));
                if (n10 == 0) continue;
                nArray[(n10 + n7) % 65536] = (i << 8) + n2;
            }
        }
    }

    protected int getLowestMappedCodeFormat4(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6) / 2;
        int n3 = n2 - 1;
        for (n3 = 0; n3 <= n2 - 1; ++n3) {
            try {
                int n4;
                int n5 = n4 = this.data.getuint16(n + 16 + 2 * n2 + 2 * n3);
                int n6 = this.data.getuint16(n + 14 + 2 * n3);
                while (n4 <= n6) {
                    try {
                        int n7;
                        int n8;
                        int n9 = this.data.getuint16(n + 16 + 6 * n2 + 2 * n3);
                        int n10 = this.data.getint16(n + 16 + 4 * n2 + 2 * n3);
                        if (n9 == 0 && (n8 = n4 + n10 & 0xFFFF) != 0) {
                            return n4;
                        }
                        n8 = n + 16 + 6 * n2 + 2 * n3 + n9 + 2 * (n4 - n5);
                        int n11 = this.data.getuint16(n8);
                        if (n11 != 0 && (n7 = n11 + n10 & 0xFFFF) != 0) {
                            return n4;
                        }
                    }
                    catch (InvalidFontException invalidFontException) {
                        // empty catch block
                    }
                    ++n4;
                }
                continue;
            }
            catch (InvalidFontException invalidFontException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat4(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6) / 2;
        for (int i = n2 - 1; 0 <= i; --i) {
            try {
                int n3 = this.data.getuint16(n + 16 + 2 * n2 + 2 * i);
                for (int j = this.data.getuint16(n + 14 + 2 * i); j >= n3; --j) {
                    try {
                        int n4;
                        int n5;
                        int n6 = this.data.getuint16(n + 16 + 6 * n2 + 2 * i);
                        int n7 = this.data.getint16(n + 16 + 4 * n2 + 2 * i);
                        if (n6 == 0 && (n5 = j + n7 & 0xFFFF) != 0) {
                            return j;
                        }
                        n5 = n + 16 + 6 * n2 + 2 * i + n6 + 2 * (j - n3);
                        int n8 = this.data.getuint16(n5);
                        if (n8 == 0 || (n4 = n8 + n7 & 0xFFFF) == 0) continue;
                        return j;
                    }
                    catch (InvalidFontException invalidFontException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (InvalidFontException invalidFontException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected int getMappingFormat4(int n, int n2) {
        try {
            int n3 = this.data.getuint16(n + 6) / 2;
            int n4 = 0;
            int n5 = n3 - 1;
            while (n4 <= n5) {
                int n6 = (n4 + n5) / 2;
                int n7 = this.data.getuint16(n + 16 + 2 * n3 + 2 * n6);
                int n8 = this.data.getuint16(n + 14 + 2 * n6);
                if (n2 < n7) {
                    n5 = n6 - 1;
                    continue;
                }
                if (n8 < n2) {
                    n4 = n6 + 1;
                    continue;
                }
                int n9 = this.data.getuint16(n + 16 + 6 * n3 + 2 * n6);
                int n10 = this.data.getint16(n + 16 + 4 * n3 + 2 * n6);
                if (n9 == 0) {
                    return n2 + n10 & 0xFFFF;
                }
                int n11 = n + 16 + 6 * n3 + 2 * n6 + n9 + 2 * (n2 - n7);
                int n12 = this.data.getuint16(n11);
                if (n12 == 0) {
                    return 0;
                }
                return n12 + n10 & 0xFFFF;
            }
            return 0;
        }
        catch (InvalidFontException invalidFontException) {
            return 0;
        }
    }

    protected void getInvertedMappingFormat4(int[] nArray, int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6) / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.data.getuint16(n + 16 + 2 * n2 + 2 * i);
            int n4 = this.data.getuint16(n + 14 + 2 * i);
            int n5 = n + 16 + 6 * n2 + 2 * i;
            int n6 = this.data.getuint16(n5);
            int n7 = this.data.getint16(n + 16 + 4 * n2 + 2 * i);
            for (int j = n3; j <= n4; ++j) {
                int n8;
                int n9;
                if (n6 == 0) {
                    n9 = j + n7 & 0xFFFF;
                    if (n9 == 0 || n9 >= nArray.length) continue;
                    nArray[n9] = j;
                    continue;
                }
                n9 = n + 16 + 6 * n2 + 2 * i + n6 + 2 * (j - n3);
                int n10 = this.data.getuint16(n9);
                if (n10 == 0 || (n8 = n10 + n7 & 0xFFFF) == 0 || n8 >= nArray.length) continue;
                nArray[n8] = j;
            }
        }
    }

    protected int getLowestMappedCodeFormat6(int n) throws InvalidFontException {
        int n2;
        int n3 = n2 = this.data.getuint16(n + 6);
        int n4 = this.data.getuint16(n + 8) + n2 - 1;
        while (n2 <= n4) {
            int n5 = this.data.getuint16(n + 10 + (n2 - n3) * 2);
            if (n5 != 0) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat6(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6);
        for (int i = this.data.getuint16(n + 8) + n2 - 1; n2 <= i; --i) {
            int n3 = this.data.getuint16(n + 10 + (i - n2) * 2);
            if (n3 == 0) continue;
            return i;
        }
        return 0;
    }

    protected int getMappingFormat6(int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n + 6);
        int n4 = this.data.getuint16(n + 8);
        if (n3 <= n2 && n2 < n3 + n4) {
            return this.data.getuint16(n + 10 + (n2 - n3) * 2);
        }
        return 0;
    }

    protected void getInvertedMappingFormat6(int[] nArray, int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6);
        int n3 = this.data.getuint16(n + 8);
        for (int i = 0; i < n3; ++i) {
            int n4;
            nArray[this.data.getuint16((int)(n + 10 + i * 2))] = n4 = n2 + i;
        }
    }

    protected int getLowestMappedCodeFormat8(int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        int n3 = 65535;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.data.getuint32asint(n + 8208 + 12 * i, "cmap subtable, format 8, startCharCode is big");
            n3 = this.data.getuint32asint(n + 8208 + 12 * i + 4, "cmap subtable, format 8, endCharCode is big");
            for (int j = n4; j <= n3; ++j) {
                int n5 = this.data.getuint32asint(n + 8208 + 12 * i + 8, "cmap subtable, format 8, startGlyphID is big") + j - n4;
                if (n5 == 0 || j > 65535) continue;
                return j;
            }
        }
        return n3;
    }

    protected int getHighestMappedCodeFormat8(int n, boolean bl) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        for (int i = n2 - 1; 0 <= i; --i) {
            int n3 = this.data.getuint32asint(n + 8208 + 12 * i, "cmap subtable, format 8, startCharCode is big");
            for (int j = this.data.getuint32asint(n + 8208 + 12 * i + 4, "cmap subtable, format 8, endCharCode is big"); j >= n3; --j) {
                int n4 = this.data.getuint32asint(n + 8208 + 12 * i + 8, "cmap subtable, format 8, startGlyphID is big") + j - n3;
                if (n4 == 0 || bl && j > 65535) continue;
                return j;
            }
        }
        return 0;
    }

    protected int getMappingFormat8(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        int n4 = 0;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            int n7 = this.data.getuint32asint(n + 8208 + 12 * n6, "cmap subtable, format 8, startCharCode is big");
            int n8 = this.data.getuint32asint(n + 8208 + 12 * n6 + 4, "cmap subtable, format 8, endCharCode is big");
            if (n2 < n7) {
                n5 = n6 - 1;
                continue;
            }
            if (n8 < n2) {
                n4 = n6 + 1;
                continue;
            }
            int n9 = this.data.getuint32asint(n + 8208 + 12 * n6 + 8, "cmap subtable, format 8, startGlyphID is big");
            return n2 - n7 + n9;
        }
        return 0;
    }

    protected void getInvertedMappingFormat8(int[] nArray, int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        for (int i = 0; i < n2; ++i) {
            int n3 = this.data.getuint32asint(n + 8208 + 12 * i, "cmap subtable, format 8, startCharCode is big");
            int n4 = this.data.getuint32asint(n + 8208 + 12 * i + 4, "cmap subtable, format 8, endCharCode is big");
            int n5 = this.data.getuint32asint(n + 8208 + 12 * i + 8, "cmap subtable, format 8, startGlyphID is big");
            for (int j = n3; j <= n4; ++j) {
                nArray[n5 + j - n3] = j;
            }
        }
    }

    protected int getLowestMappedCodeFormat10(int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n3 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big") + n2 - 1;
        for (int i = n2; i <= n3; ++i) {
            int n4 = this.data.getuint16(n + 20 + 2 * (i - n2));
            if (n4 <= 0) continue;
            return i;
        }
        return n3;
    }

    protected int getHighestMappedCodeFormat10(int n, boolean bl) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n3 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big");
        for (int i = n2 + n3 - 1; n2 <= i; --i) {
            int n4 = this.data.getuint16(n + 20 + 2 * (i - n2));
            if (n4 <= 0 || bl && i > 65535) continue;
            return i;
        }
        return 0;
    }

    protected int getMappingFormat10(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n4 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big");
        if (n3 <= n2 && n2 < n3 + n4) {
            return this.data.getuint16(n + 20 + 2 * (n2 - n3));
        }
        return 0;
    }

    protected void getInvertedMappingFormat10(int[] nArray, int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n3 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big");
        for (int i = n2; i < n2 + n3; ++i) {
            nArray[this.data.getuint16((int)(n + 20 + 2 * (i - n2)))] = i;
        }
    }

    protected int getLowestMappedCodeFormat12(int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = (int)this.data.getuint32(n + 12);
        int n3 = 65535;
        for (int i = 0; i < n2; ++i) {
            int n4 = (int)this.data.getuint32(n + 16 + 12 * i);
            n3 = (int)this.data.getuint32(n + 16 + 12 * i + 4);
            for (int j = n4; j <= n3; ++j) {
                int n5 = (int)this.data.getuint32(n + 16 + 12 * i + 8);
                if ((n5 += j - n4) <= 0) continue;
                return j;
            }
        }
        return n3;
    }

    protected int getHighestMappedCodeFormat12(int n, boolean bl) throws InvalidFontException, UnsupportedFontException {
        int n2 = (int)this.data.getuint32(n + 12);
        for (int i = n2 - 1; 0 <= i; --i) {
            int n3 = (int)this.data.getuint32(n + 16 + 12 * i);
            for (int j = (int)this.data.getuint32(n + 16 + 12 * i + 4); j >= n3; --j) {
                int n4 = (int)this.data.getuint32(n + 16 + 12 * i + 8);
                if ((n4 += j - n3) <= 0 || bl && j > 65535) continue;
                return j;
            }
        }
        return 0;
    }

    protected int getMappingFormat12(int n, int n2) throws InvalidFontException {
        int n3 = (int)this.data.getuint32(n + 12);
        int n4 = 0;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            int n7 = (int)this.data.getuint32(n + 16 + 12 * n6);
            int n8 = (int)this.data.getuint32(n + 16 + 12 * n6 + 4);
            if (n2 < n7) {
                n5 = n6 - 1;
                continue;
            }
            if (n8 < n2) {
                n4 = n6 + 1;
                continue;
            }
            int n9 = (int)this.data.getuint32(n + 16 + 12 * n6 + 8);
            return n9 + (n2 - n7);
        }
        return 0;
    }

    protected void getInvertedMappingFormat12(int[] nArray, int n) throws InvalidFontException {
        int n2 = (int)this.data.getuint32(n + 12);
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)this.data.getuint32(n + 16 + 12 * i);
            int n4 = (int)this.data.getuint32(n + 16 + 12 * i + 4);
            int n5 = (int)this.data.getuint32(n + 16 + 12 * i + 8);
            for (int j = n3; j <= n4; ++j) {
                nArray[n5 + (j - n3)] = j;
            }
        }
    }

    public void subsetAndStream(Subset subset, SubsetSimpleTrueType subsetSimpleTrueType, Map map) throws UnsupportedFontException, InvalidFontException {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        if (subsetSimpleTrueType == null) {
            return;
        }
        int n5 = subsetSimpleTrueType.getPlatformID();
        int n6 = this.probe(n5, n4 = subsetSimpleTrueType.getPlatformSpecificID());
        if (n6 < 0) {
            throw new UnsupportedFontException("Unsupported cmap ID");
        }
        int n7 = this.data.getuint16(n6);
        if (n7 != 0 && n7 != 4 && n7 != 12) {
            throw new UnsupportedFontException("Unsupported cmap format");
        }
        if (n7 == 12) {
            n7 = 4;
        }
        ArrayList<MapElement> arrayList = new ArrayList<MapElement>();
        int n8 = this.offsetToIndex(n6);
        int[] nArray = subsetSimpleTrueType.getCodePoints();
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            int n9 = this.char2glyph(n3, n8);
            n2 = subset.getExistingSubsetGid(n9);
            if (n2 <= 0) {
                throw new InvalidFontException("Subset does not contain required codepoint");
            }
            object = new MapElement(n3, n2);
            arrayList.add((MapElement)object);
        }
        if (arrayList.size() == 0) {
            return;
        }
        MapElement mapElement = (MapElement)arrayList.get(0);
        if (mapElement.mCodePoint > 65535) {
            n7 = 12;
        }
        n3 = 1;
        while (n3 < arrayList.size()) {
            MapElement mapElement2 = (MapElement)arrayList.get(n3);
            if (mapElement2.mCodePoint == mapElement.mCodePoint) {
                arrayList.remove(n3);
                continue;
            }
            if (mapElement2.mCodePoint > 65535) {
                n7 = 12;
            }
            mapElement = mapElement2;
            ++n3;
        }
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(Math.max(1024, arrayList.size() * 32));
        oTByteArrayBuilder.setuint16(0, 0);
        oTByteArrayBuilder.setuint16(2, 1);
        int n10 = 4;
        oTByteArrayBuilder.setuint16(n10, n5);
        oTByteArrayBuilder.setuint16(n10 + 2, n4);
        oTByteArrayBuilder.setuint32(n10 + 4, n10 + 8);
        n2 = n10 += 8;
        object = new ArrayList();
        int n11 = 0;
        mapElement = (MapElement)arrayList.get(n11);
        if (n7 == 0) {
            oTByteArrayBuilder.setuint16(n10, 0);
            oTByteArrayBuilder.setuint16(n10 + 2, 262);
            oTByteArrayBuilder.setuint16(n10 + 4, 0);
            oTByteArrayBuilder.setuint8((n10 += 6) + 255, 0);
            for (int i = 0; i < arrayList.size(); ++i) {
                MapElement mapElement3 = (MapElement)arrayList.get(i);
                oTByteArrayBuilder.setuint8(n10 + mapElement3.mCodePoint, mapElement3.mGlyphID);
            }
        } else if (n7 == 4) {
            MapElement mapElement4;
            MapSegment mapSegment;
            int n12 = 0;
            if (((MapElement)arrayList.get((int)(arrayList.size() - 1))).mCodePoint != 65535) {
                arrayList.add(new MapElement(65535, 0));
            }
            while (n < arrayList.size()) {
                MapElement mapElement5 = (MapElement)arrayList.get(n);
                if (mapElement5.mCodePoint == mapElement.mCodePoint + 1) {
                    if (mapElement5.mGlyphID == mapElement.mGlyphID + 1) {
                        if (++n12 > 3 && n12 < n - n11) {
                            ((ArrayList)object).add(new MapSegment(n11, n - n12, false));
                            n11 = n - n12;
                        }
                    } else {
                        if (n12 > 3) {
                            ((ArrayList)object).add(new MapSegment(n11, n, true));
                            n11 = n;
                        }
                        n12 = 0;
                    }
                } else {
                    ((ArrayList)object).add(new MapSegment(n11, n, n - n11 == n12 + 1));
                    n11 = n;
                    n12 = 0;
                }
                mapElement = mapElement5;
                ++n;
            }
            ((ArrayList)object).add(new MapSegment(n11, n, n - n11 == n12 + 1));
            oTByteArrayBuilder.setuint16(n10, 4);
            int n13 = ((ArrayList)object).size();
            oTByteArrayBuilder.setuint16(n10 + 4, 0);
            oTByteArrayBuilder.setuint16(n10 + 6, n13 * 2);
            int n14 = 0;
            while (n13 != 0) {
                n13 >>= 1;
                ++n14;
            }
            n13 = ((ArrayList)object).size();
            oTByteArrayBuilder.setuint16(n10 + 8, 1 << n14);
            oTByteArrayBuilder.setuint16(n10 + 10, n14 - 1);
            oTByteArrayBuilder.setuint16(n10 + 12, n13 * 2 - (1 << n14));
            n10 += 14;
            for (n8 = 0; n8 < n13; ++n8) {
                mapSegment = (MapSegment)((ArrayList)object).get(n8);
                mapElement4 = (MapElement)arrayList.get(mapSegment.mEndIndex - 1);
                oTByteArrayBuilder.setuint16(n10 + n8 * 2, mapElement4.mCodePoint);
            }
            oTByteArrayBuilder.setuint16(n10 += n8 * 2, 0);
            n10 += 2;
            for (n8 = 0; n8 < n13; ++n8) {
                mapSegment = (MapSegment)((ArrayList)object).get(n8);
                mapElement4 = (MapElement)arrayList.get(mapSegment.mFirstIndex);
                oTByteArrayBuilder.setuint16(n10 + n8 * 2, mapElement4.mCodePoint);
            }
            n10 += n8 * 2;
            for (n8 = 0; n8 < n13; ++n8) {
                mapSegment = (MapSegment)((ArrayList)object).get(n8);
                n6 = 0;
                if (mapSegment.mOrdered) {
                    mapElement4 = (MapElement)arrayList.get(mapSegment.mFirstIndex);
                    n6 = mapElement4.mGlyphID - (short)mapElement4.mCodePoint;
                }
                oTByteArrayBuilder.setuint16(n10 + n8 * 2, n6);
            }
            int n15 = (n10 += n8 * 2) + n8 * 2;
            int n16 = 0;
            for (n8 = 0; n8 < n13; ++n8) {
                MapSegment mapSegment2 = (MapSegment)((ArrayList)object).get(n8);
                n6 = 0;
                if (!mapSegment2.mOrdered) {
                    n6 = (n13 - n8 + n16) * 2;
                    for (int i = mapSegment2.mFirstIndex; i < mapSegment2.mEndIndex; ++i) {
                        MapElement mapElement6 = (MapElement)arrayList.get(i);
                        oTByteArrayBuilder.setuint16(n15 + n16 * 2, mapElement6.mGlyphID);
                        ++n16;
                    }
                }
                oTByteArrayBuilder.setuint16(n10 + n8 * 2, n6);
            }
            oTByteArrayBuilder.setuint16(n2 + 2, n15 + n16 * 2 - n2);
        } else {
            for (n = 1; n < arrayList.size(); ++n) {
                MapElement mapElement7 = (MapElement)arrayList.get(n);
                if (mapElement7.mCodePoint != mapElement.mCodePoint + 1 || mapElement7.mGlyphID != mapElement.mGlyphID + 1) {
                    ((ArrayList)object).add(new MapSegment(n11, n, true));
                    n11 = n;
                }
                mapElement = mapElement7;
            }
            ((ArrayList)object).add(new MapSegment(n11, n, true));
            int n17 = ((ArrayList)object).size();
            oTByteArrayBuilder.setuint16(n10, 12);
            oTByteArrayBuilder.setuint16(n10 + 2, 0);
            oTByteArrayBuilder.setuint32(n10 + 4, 16 + n17 * 12);
            oTByteArrayBuilder.setuint32(n10 + 8, 0);
            oTByteArrayBuilder.setuint32(n10 + 12, n17);
            n10 += 16;
            for (n8 = 0; n8 < n17; ++n8) {
                MapSegment mapSegment = (MapSegment)((ArrayList)object).get(n8);
                MapElement mapElement8 = (MapElement)arrayList.get(mapSegment.mFirstIndex);
                MapElement mapElement9 = (MapElement)arrayList.get(mapSegment.mEndIndex - 1);
                oTByteArrayBuilder.setuint32(n10 + n8 * 12, mapElement8.mCodePoint);
                oTByteArrayBuilder.setuint32(n10 + n8 * 12 + 4, mapElement9.mCodePoint);
                oTByteArrayBuilder.setuint32(n10 + n8 * 12 + 8, mapElement8.mGlyphID);
            }
        }
        map.put(new Integer(1668112752), oTByteArrayBuilder);
    }

    public void subsetAndStreamForSWF(TreeSet treeSet, Subset subset, Map map, boolean bl) throws UnsupportedFontException, InvalidFontException {
        Iterator iterator = treeSet.iterator();
        boolean bl2 = true;
        int n = 1;
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance();
        int n2 = 0;
        if (bl) {
            n = 2;
        }
        while (iterator.hasNext()) {
            if ((Integer)iterator.next() <= 65535) continue;
            bl2 = false;
            break;
        }
        oTByteArrayBuilder.ensureCapacity(4 + 8 * n);
        oTByteArrayBuilder.setuint16(0, 0);
        oTByteArrayBuilder.setuint16(2, n);
        int n3 = 4 + 8 * n;
        if (bl2) {
            oTByteArrayBuilder.setuint16(4, 3);
            oTByteArrayBuilder.setuint16(6, this.symbolSubtableOffset != -1 ? 0 : 1);
            oTByteArrayBuilder.setuint32(8, n3);
            n2 = this.writeFormat4Subtable(oTByteArrayBuilder, n3, treeSet, subset, this.paddingByte);
        } else {
            oTByteArrayBuilder.setuint16(4, 3);
            oTByteArrayBuilder.setuint16(6, 10);
            oTByteArrayBuilder.setuint32(8, n3);
            n2 = this.writeFormat12Subtable(oTByteArrayBuilder, n3, treeSet, subset);
        }
        if (bl) {
            oTByteArrayBuilder.setuint16(12, 0);
            oTByteArrayBuilder.setuint16(14, 5);
            oTByteArrayBuilder.setuint32(16, n3 + n2);
            n2 = this.writeFormat14Subtable(oTByteArrayBuilder, n3 + n2, treeSet, subset, this.probe(0, 5));
        }
        map.put(new Integer(1668112752), oTByteArrayBuilder);
    }

    private int computeCodePointToEmit(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        return n2 | n & 0xFF;
    }

    private int writeFormat4Subtable(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, TreeSet treeSet, Subset subset, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3;
        int n4;
        Iterator iterator = treeSet.iterator();
        int n5 = 0;
        ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>();
        SegmentInfo segmentInfo = null;
        boolean bl = true;
        if (iterator.hasNext()) {
            n5 = (Integer)iterator.next();
            segmentInfo = new SegmentInfo();
            segmentInfo.startCode = n5;
            n4 = subset.getExistingSubsetGid(this.unicodeChar2glyph(n5));
            segmentInfo.idDelta = n4 - this.computeCodePointToEmit(n5, n2);
            arrayList.add(segmentInfo);
            if (n5 == 65535) {
                bl = false;
            }
        }
        while (iterator.hasNext()) {
            n4 = (Integer)iterator.next();
            if (n4 == 65535) {
                bl = false;
            }
            if (n4 != n5 + 1) {
                segmentInfo.endCode = n5;
                segmentInfo = new SegmentInfo();
                segmentInfo.startCode = n4;
                n3 = subset.getExistingSubsetGid(this.unicodeChar2glyph(n4));
                segmentInfo.idDelta = n3 - this.computeCodePointToEmit(n4, n2);
                arrayList.add(segmentInfo);
            } else if (segmentInfo.canUseIDDelta && (n3 = subset.getExistingSubsetGid(this.unicodeChar2glyph(n4))) - this.computeCodePointToEmit(n4, n2) != segmentInfo.idDelta) {
                segmentInfo.canUseIDDelta = false;
            }
            n5 = n4;
        }
        if (segmentInfo != null) {
            segmentInfo.endCode = n5;
        }
        n4 = arrayList.size();
        if (bl) {
            ++n4;
        }
        n3 = 16 + 8 * n4;
        oTByteArrayBuilder.ensureCapacity(n + n3);
        oTByteArrayBuilder.setuint16(n, 4);
        oTByteArrayBuilder.setuint16(n + 4, 0);
        oTByteArrayBuilder.setuint16(n + 6, n4 * 2);
        int n6 = (int)Math.floor(Cmap.log2(n4));
        int n7 = 2 * (int)Math.pow(2.0, n6);
        oTByteArrayBuilder.setuint16(n + 8, n7);
        oTByteArrayBuilder.setuint16(n + 10, n6);
        oTByteArrayBuilder.setuint16(n + 12, 2 * n4 - n7);
        oTByteArrayBuilder.setuint16(n + 14 + n4 * 2, 0);
        int n8 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            segmentInfo = (SegmentInfo)arrayList.get(i);
            oTByteArrayBuilder.setuint16(n + 14 + 2 * i, this.computeCodePointToEmit(segmentInfo.endCode, n2));
            oTByteArrayBuilder.setuint16(n + 16 + 2 * n4 + 2 * i, this.computeCodePointToEmit(segmentInfo.startCode, n2));
            oTByteArrayBuilder.setint16(n + 16 + 4 * n4 + 2 * i, segmentInfo.canUseIDDelta ? segmentInfo.idDelta : 0);
            oTByteArrayBuilder.setuint16(n + 16 + 6 * n4 + 2 * i, segmentInfo.canUseIDDelta ? 0 : (n8 + n4 - i) * 2);
            if (segmentInfo.canUseIDDelta) continue;
            oTByteArrayBuilder.ensureCapacity(n + 16 + 8 * n4 + 2 * (n8 + segmentInfo.endCode - segmentInfo.startCode + 1));
            int n9 = segmentInfo.startCode;
            while (n9 <= segmentInfo.endCode) {
                int n10 = subset.getExistingSubsetGid(this.unicodeChar2glyph(n9));
                oTByteArrayBuilder.setuint16(n + 16 + 8 * n4 + 2 * n8, n10);
                ++n9;
                ++n8;
            }
        }
        if (bl) {
            oTByteArrayBuilder.setuint16(n + 14 + 2 * arrayList.size(), 65535);
            oTByteArrayBuilder.setuint16(n + 16 + 4 * n4 - 2, 65535);
            oTByteArrayBuilder.setuint16(n + 16 + 6 * n4 - 2, 1);
            oTByteArrayBuilder.setuint16(n + 16 + 8 * n4 - 2, 0);
        }
        oTByteArrayBuilder.setuint16(n + 2, n3 += 2 * n8);
        if (n3 >= 65536) {
            throw new UnsupportedFontException("Format 4 cmap subtable is too big for format");
        }
        return n3;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    private int writeFormat12Subtable(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, TreeSet treeSet, Subset subset) throws UnsupportedFontException, InvalidFontException {
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 16;
        oTByteArrayBuilder.ensureCapacity(n + n5);
        if (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            n3 = subset.getExistingSubsetGid(this.unicodeChar2glyph(n2));
            oTByteArrayBuilder.ensureCapacity(n + (n5 += 12));
            oTByteArrayBuilder.setuint32(n + 16 + 12 * n4, n2);
            oTByteArrayBuilder.setuint32(n + 16 + 12 * n4 + 8, n3);
            ++n4;
        }
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            int n7 = subset.getExistingSubsetGid(this.unicodeChar2glyph(n6));
            if (n6 != n2 + 1 || n7 != n3 + 1) {
                oTByteArrayBuilder.setuint32(n + 16 + 12 * (n4 - 1) + 4, n2);
                oTByteArrayBuilder.ensureCapacity(n + (n5 += 12));
                oTByteArrayBuilder.setuint32(n + 16 + 12 * n4, n6);
                oTByteArrayBuilder.setuint32(n + 16 + 12 * n4 + 8, n7);
                ++n4;
            }
            n2 = n6;
            n3 = n7;
        }
        if (n4 > 0) {
            oTByteArrayBuilder.setuint32(n + 16 + 12 * (n4 - 1) + 4, n2);
        }
        oTByteArrayBuilder.setuint16(n, 12);
        oTByteArrayBuilder.setuint16(n + 2, 0);
        oTByteArrayBuilder.setuint32(n + 4, n5);
        oTByteArrayBuilder.setuint32(n + 8, 0);
        oTByteArrayBuilder.setuint32(n + 12, n4);
        return n5;
    }

    void iterateFormat14(int n, Format14Consumer format14Consumer) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 6, "Only 2^31 selectors supported");
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            boolean bl = false;
            int n7 = this.data.getuint24(n + 10 + 11 * i);
            int n8 = this.data.getuint32asint(n + 10 + 11 * i + 3, "Only 2^31 offsets supported");
            if (n8 != 0) {
                n6 = this.data.getuint32asint(n8 += n, "Only 2^31 UV ranges supported");
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = this.data.getuint24(n8 + 4 + 4 * n5);
                    n3 = this.data.getuint8(n8 + 4 + 4 * n5 + 3);
                    for (int j = 0; j <= n3; ++j) {
                        if (format14Consumer.defaultUV(n7, n4 + j)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) break;
                }
            }
            if ((n8 = this.data.getuint32asint(n + 10 + 11 * i + 7, "Only 2^31 offsets supported")) == 0) continue;
            n6 = this.data.getuint32asint(n8 += n, "Only 2^31 UV ranges supported");
            for (n5 = 0; n5 < n6 && format14Consumer.nonDefaultUV(n7, n4 = this.data.getuint24(n8 + 4 + 5 * n5), n3 = this.data.getuint16(n8 + 4 + 5 * n5 + 3)); ++n5) {
            }
        }
    }

    private int writeFormat14Subtable(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, TreeSet treeSet, Subset subset, int n2) throws UnsupportedFontException, InvalidFontException {
        Format14Writer format14Writer = new Format14Writer(subset, treeSet, oTByteArrayBuilder, n);
        this.iterateFormat14(n2, format14Writer);
        format14Writer.writeSubtable();
        return format14Writer.stSize;
    }

    boolean gatherPossibleMappings(Iterator iterator, Set set, Subset subset) throws UnsupportedFontException, InvalidFontException {
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = this.unicodeChar2glyph(n);
            if (n2 == 0) continue;
            set.add(n);
            subset.getSubsetGid(n2);
        }
        int n = this.probe(0, 5);
        if (n != -1) {
            Format14Harvester format14Harvester = new Format14Harvester(set, subset);
            this.iterateFormat14(n, format14Harvester);
            for (Integer n3 : format14Harvester.variationUVs) {
                int n4 = this.unicodeChar2glyph(n3);
                if (n4 == 0) continue;
                set.add(n3);
                subset.getSubsetGid(n4);
            }
            return format14Harvester.variationSequencesFound;
        }
        return false;
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1668112752), oTByteArrayBuilder);
    }

    private int generateRequiredCmap(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws UnsupportedFontException, InvalidFontException {
        if (this.nonUnicodeSubtableIndices.length == 0) {
            throw new UnsupportedFontException("Could not generate required cmap subtables");
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.nonUnicodeSubtableIndices.length; ++i) {
            if (this.nonUnicodeSubtableIndices[i].charsetName.equals("MacSymbol")) {
                if (this.nonUnicodeSubtableIndices.length != 1) continue;
                throw new UnsupportedFontException("Cannot generate a required cmap");
            }
            Charset charset = null;
            try {
                charset = CharsetUtil.forNameICU(this.nonUnicodeSubtableIndices[i].charsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new UnsupportedFontException("Could not generate required cmap subtables", unsupportedCharsetException);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new UnsupportedFontException("Could not generate required cmap subtables", illegalCharsetNameException);
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            int n3 = this.getHighestMappedCode(this.nonUnicodeSubtableIndices[i].subtableOffset, false);
            int n4 = this.getLowestMappedCode(this.nonUnicodeSubtableIndices[i].subtableOffset);
            int n5 = this.offsetToIndex(this.nonUnicodeSubtableIndices[i].subtableOffset);
            CharBuffer charBuffer = CharBuffer.allocate(1);
            ByteBuffer byteBuffer = ByteBuffer.allocate(2);
            for (int j = n4; j <= n3; ++j) {
                byteBuffer.rewind();
                charBuffer.rewind();
                int n6 = this.char2glyph(j, n5);
                if (n6 == 0) continue;
                if (j < 256) {
                    byteBuffer.put((byte)(j & 0xFF));
                } else if (j < 65536) {
                    byteBuffer.put((byte)(j >> 8));
                    byteBuffer.put((byte)(j & 0xFF));
                } else {
                    throw new UnsupportedFontException("Only 2-byte encodings supported");
                }
                byteBuffer.rewind();
                CoderResult coderResult = null;
                try {
                    coderResult = CharsetUtil.decodeLoopNoExceptions(byteBuffer, charBuffer, charsetDecoder);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (CoderMalfunctionError coderMalfunctionError) {
                    // empty catch block
                }
                if (coderResult.isError()) continue;
                charBuffer.rewind();
                treeSet.add(new Integer(charBuffer.get()));
            }
        }
        return this.writeFormat4Subtable(oTByteArrayBuilder, n, treeSet, new SubsetDefaultImpl(n2, false), 0);
    }

    private int copySubtable(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3;
        int n4 = this.data.getuint16(n2);
        switch (n4) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                n3 = this.data.getuint16(n2 + 2);
                break;
            }
            case 8: 
            case 10: {
                n3 = this.data.getuint32asint(n2 + 4, "Only signed int length cmap subtables supported");
                break;
            }
            case 12: {
                n3 = 16 + 12 * this.data.getuint32asint(n2 + 12, "Only signed int length cmap subtables supported");
                break;
            }
            case 14: {
                n3 = this.data.getuint32asint(n2 + 2, "Only signed int length cmap subtables supported");
                break;
            }
            default: {
                throw new UnsupportedFontException("Unsupported cmap format: " + n4);
            }
        }
        try {
            oTByteArrayBuilder.replace(n, this.data, n2, n3);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            oTByteArrayBuilder.replace(n, this.data, n2, this.data.getSize() - n2);
        }
        return n3;
    }

    public void streamForSWF(Map map, int n) throws UnsupportedFontException, InvalidFontException {
        SWFCmapSelector sWFCmapSelector = new SWFCmapSelector();
        this.enumerateCmaps(sWFCmapSelector);
        int n2 = 4;
        int n3 = sWFCmapSelector.cmapsToKeep.size() + (sWFCmapSelector.foundRequiredCmap ? 0 : 1);
        int n4 = n2 + 8 * n3;
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(n4);
        oTByteArrayBuilder.setuint16(0, 0);
        if (!sWFCmapSelector.foundRequiredCmap) {
            oTByteArrayBuilder.setuint16(n2, 3);
            oTByteArrayBuilder.setuint16(n2 + 2, 1);
            oTByteArrayBuilder.setuint32(n2 + 4, n4);
            n2 += 8;
            n4 += this.generateRequiredCmap(oTByteArrayBuilder, n4, n);
        }
        for (SWFCmapSelector.CmapInfo cmapInfo : sWFCmapSelector.cmapsToKeep) {
            int n5 = this.copySubtable(oTByteArrayBuilder, n4, cmapInfo.offset);
            if (n5 > 0) {
                oTByteArrayBuilder.setuint16(n2, cmapInfo.platformId);
                oTByteArrayBuilder.setuint16(n2 + 2, cmapInfo.platformEncoding);
                oTByteArrayBuilder.setuint32(n2 + 4, n4);
                n4 += n5;
                n2 += 8;
                continue;
            }
            --n3;
        }
        oTByteArrayBuilder.setuint16(2, n3);
        map.put(new Integer(1668112752), oTByteArrayBuilder);
    }

    int offsetToIndex(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(2);
        for (int i = 0; i < n2; ++i) {
            if ((long)n != this.data.getuint32(4 + i * 8 + 4)) continue;
            return i;
        }
        return -1;
    }

    private final class MapSegment {
        int mFirstIndex;
        int mEndIndex;
        boolean mOrdered;

        MapSegment(int n, int n2, boolean bl) {
            this.mFirstIndex = n;
            this.mEndIndex = n2;
            this.mOrdered = bl;
        }
    }

    private final class MapElement
    implements Comparable {
        int mCodePoint;
        int mGlyphID;

        MapElement(int n, int n2) {
            this.mCodePoint = n;
            this.mGlyphID = n2;
        }

        public int compareTo(Object object) {
            return this.mCodePoint - ((MapElement)object).mCodePoint;
        }
    }

    private class SWFCmapSelector
    implements CmapSelector {
        boolean foundRequiredCmap = false;
        List cmapsToKeep = new ArrayList();

        private SWFCmapSelector() {
        }

        private boolean alreadyOneWithThisOffset(int n) {
            for (CmapInfo cmapInfo : this.cmapsToKeep) {
                if (cmapInfo.offset != n) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void cmapFound(int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
            block15: {
                int n4 = Cmap.this.getOffset(n3);
                switch (n) {
                    case 0: {
                        switch (n2) {
                            case 3: {
                                if (this.alreadyOneWithThisOffset(n4)) break;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(n, n2, n4));
                                return;
                            }
                            case 4: {
                                if (this.alreadyOneWithThisOffset(n4)) break;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(n, n2, n4));
                                return;
                            }
                            case 5: {
                                this.cmapsToKeep.add(new CmapInfo(n, n2, n4));
                            }
                        }
                        return;
                    }
                    case 3: {
                        switch (n2) {
                            case 0: 
                            case 1: {
                                if (this.alreadyOneWithThisOffset(n4)) return;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(n, n2, n4));
                                break block15;
                            }
                            case 10: {
                                if (this.alreadyOneWithThisOffset(n4)) return;
                                this.foundRequiredCmap = true;
                                this.cmapsToKeep.add(new CmapInfo(n, n2, n4));
                            }
                        }
                    }
                }
            }
        }

        class CmapInfo {
            final int platformId;
            final int platformEncoding;
            final int offset;

            CmapInfo(int n, int n2, int n3) {
                this.platformId = n;
                this.platformEncoding = n2;
                this.offset = n3;
            }
        }
    }

    private static class Format14Harvester
    implements Format14Consumer {
        private final Set harvestedCPs;
        private final Subset harvestedGids;
        final Set variationUVs;
        boolean variationSequencesFound = false;

        public Format14Harvester(Set set, Subset subset) {
            this.harvestedCPs = set;
            this.harvestedGids = subset;
            this.variationUVs = new HashSet();
        }

        public boolean defaultUV(int n, int n2) {
            if (this.harvestedCPs.contains(new Integer(n2))) {
                this.variationUVs.add(new Integer(n));
                this.variationSequencesFound = true;
                return false;
            }
            return true;
        }

        public boolean nonDefaultUV(int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
            if (this.harvestedCPs.contains(new Integer(n2))) {
                Integer n4 = new Integer(n);
                if (!this.variationUVs.contains(n4)) {
                    this.variationUVs.add(n4);
                    this.variationSequencesFound = true;
                }
                this.harvestedGids.getSubsetGid(n3);
            }
            return true;
        }
    }

    private static class Format14Writer
    implements Format14Consumer {
        private final Subset subset;
        private final Set codepoints;
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int newSTOffset;
        private Integer lastVS = new Integer(-1);
        private Map vsToUnicode = new LinkedHashMap();
        int stSize = 0;

        Format14Writer(Subset subset, Set set, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n) {
            this.subset = subset;
            this.codepoints = set;
            this.builder = oTByteArrayBuilder;
            this.newSTOffset = n;
        }

        public boolean defaultUV(int n, int n2) {
            if (this.codepoints.contains(new Integer(n2))) {
                ArrayList<UVAndGid> arrayList;
                if (this.lastVS != n) {
                    this.lastVS = new Integer(n);
                }
                if ((arrayList = (ArrayList<UVAndGid>)this.vsToUnicode.get(this.lastVS)) == null) {
                    arrayList = new ArrayList<UVAndGid>();
                }
                UVAndGid uVAndGid = new UVAndGid(n2, -1);
                arrayList.add(uVAndGid);
                this.vsToUnicode.put(this.lastVS, arrayList);
            }
            return true;
        }

        public boolean nonDefaultUV(int n, int n2, int n3) {
            if (this.codepoints.contains(new Integer(n2))) {
                ArrayList<UVAndGid> arrayList;
                if (this.lastVS != n) {
                    this.lastVS = new Integer(n);
                }
                if ((arrayList = (ArrayList<UVAndGid>)this.vsToUnicode.get(this.lastVS)) == null) {
                    arrayList = new ArrayList<UVAndGid>();
                }
                UVAndGid uVAndGid = new UVAndGid(n2, n3);
                arrayList.add(uVAndGid);
                this.vsToUnicode.put(this.lastVS, arrayList);
            }
            return true;
        }

        void writeSubtable() throws UnsupportedFontException, InvalidFontException {
            this.stSize = 10 + 11 * this.vsToUnicode.size();
            this.builder.ensureCapacity(this.newSTOffset + this.stSize);
            this.builder.setuint16(this.newSTOffset, 14);
            this.builder.setuint32(this.newSTOffset + 6, this.vsToUnicode.size());
            int n = 0;
            for (Integer n2 : this.vsToUnicode.keySet()) {
                int n3 = 0;
                List list = (List)this.vsToUnicode.get(n2);
                n3 = this.writeDefaultUVSTable(this.newSTOffset + this.stSize, list);
                this.builder.setuint24(this.newSTOffset + 10 + 11 * n, n2);
                this.builder.setuint32(this.newSTOffset + 10 + 11 * n + 3, n3 == 0 ? 0 : this.stSize);
                this.stSize += n3;
                n3 = this.writeNonDefaultUVSTable(this.newSTOffset + this.stSize, list);
                this.builder.setuint32(this.newSTOffset + 10 + 11 * n + 7, n3 == 0 ? 0 : this.stSize);
                this.stSize += n3;
                ++n;
            }
            this.builder.setuint32(this.newSTOffset + 2, this.stSize);
        }

        private int writeDefaultUVSTable(int n, List list) {
            int n2 = -1;
            int n3 = 0;
            Iterator iterator = list.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                UVAndGid uVAndGid = (UVAndGid)iterator.next();
                if (uVAndGid.gid != -1) break;
                if (n2 + 1 != uVAndGid.uv) {
                    this.builder.ensureCapacity(n + 4 + 4 * (n3 + 1));
                    if (n3 > 0) {
                        this.builder.setuint8(n + 4 + 4 * (n3 - 1) + 3, n4);
                    }
                    this.builder.setuint24(n + 4 + 4 * n3, uVAndGid.uv);
                    n4 = 0;
                    ++n3;
                    continue;
                }
                ++n4;
            }
            if (n3 > 0) {
                this.builder.setuint8(n + 4 + 4 * (n3 - 1) + 3, n4);
                this.builder.setuint32(n, n3);
                return 4 + 4 * n3;
            }
            return 0;
        }

        private int writeNonDefaultUVSTable(int n, List list) throws UnsupportedFontException, InvalidFontException {
            int n2 = 0;
            for (UVAndGid uVAndGid : list) {
                if (uVAndGid.gid == -1) continue;
                this.builder.ensureCapacity(n + 4 + 5 * (n2 + 1));
                this.builder.setuint24(n + 4 + 5 * n2, uVAndGid.uv);
                this.builder.setuint16(n + 4 + 5 * n2 + 3, this.subset.getExistingSubsetGid(uVAndGid.gid));
                ++n2;
            }
            if (n2 > 0) {
                this.builder.setuint32(n, n2);
                return 4 + 5 * n2;
            }
            return 0;
        }

        static class UVAndGid {
            int uv;
            int gid;

            UVAndGid(int n, int n2) {
                this.uv = n;
                this.gid = n2;
            }
        }
    }

    static interface Format14Consumer {
        public boolean defaultUV(int var1, int var2);

        public boolean nonDefaultUV(int var1, int var2, int var3) throws UnsupportedFontException, InvalidFontException;
    }

    private class SegmentInfo {
        boolean canUseIDDelta = true;
        int idDelta;
        int startCode;
        int endCode;

        private SegmentInfo() {
        }
    }

    static class NonUnicodeCmap {
        final int subtableOffset;
        final String charsetName;
        Charset charset = null;

        public NonUnicodeCmap(int n, String string) {
            this.subtableOffset = n;
            this.charsetName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharsetEncoder getCharsetEncoder() throws UnsupportedCharsetException, IllegalCharsetNameException {
            Object object;
            if (this.charset == null && this.charsetName != null) {
                object = this;
                synchronized (object) {
                    if (this.charset == null && this.charsetName != null) {
                        this.charset = CharsetUtil.forNameICU(this.charsetName);
                    }
                }
            }
            object = null;
            if (this.charset != null && (object = this.charset.newEncoder()) instanceof CharsetEncoderICU) {
                ((CharsetEncoderICU)object).setFallbackUsed(true);
            }
            return object;
        }
    }

    public static interface CmapSelector {
        public void cmapFound(int var1, int var2, int var3) throws InvalidFontException, UnsupportedFontException;
    }

    public static final class MacEncodingID {
        public static final int ROMAN = 0;
        public static final int JAPANESE = 1;
        public static final int CHINESE_TRADITIONAL = 2;
        public static final int KOREAN = 3;
        public static final int ARABIC = 4;
        public static final int HEBREW = 5;
        public static final int GREEK = 6;
        public static final int RUSSIAN = 7;
        public static final int RSYMBOL = 8;
        public static final int DEVANAGARI = 9;
        public static final int GURMUKHI = 10;
        public static final int GUJARATI = 11;
        public static final int ORIYA = 12;
        public static final int BENGALI = 13;
        public static final int TAMIL = 14;
        public static final int TELUGU = 15;
        public static final int KANNADA = 16;
        public static final int MALAYALAM = 17;
        public static final int SINHALESE = 18;
        public static final int BURMESE = 19;
        public static final int KHMER = 20;
        public static final int THAI = 21;
        public static final int LAOTIAN = 22;
        public static final int GEORGIAN = 23;
        public static final int ARMENIAN = 24;
        public static final int CHINESE_SIMPLIFIED = 25;
        public static final int TIBETAN = 26;
        public static final int MONGOLIAN = 27;
        public static final int GEEZ = 28;
        public static final int SLAVIC = 29;
        public static final int VIETNAMESE = 30;
        public static final int SINDHI = 31;
        public static final int UNINTERPRETED = 32;
    }

    public static final class MS_EncodingID {
        public static final int SYMBOL = 0;
        public static final int UNICODE_BMP = 1;
        public static final int SHIFTJIS = 2;
        public static final int PRC = 3;
        public static final int BIG5 = 4;
        public static final int WANSUNG = 5;
        public static final int JOHAB = 6;
        public static final int UNICODE_FULL = 10;
    }

    public static final class UnicodeEncodingID {
        public static final int ID_1_0 = 0;
        public static final int ID_1_1 = 1;
        public static final int ID_10646_1993 = 2;
        public static final int ID_2_0_BMP = 3;
        public static final int ID_2_0_FULL = 4;
        public static final int UNI_VARIATION_SEQ = 5;
    }

    public static final class PlatformID {
        public static final int UNICODE = 0;
        public static final int MACINTOSH = 1;
        public static final int ISO = 2;
        public static final int MICROSOFT = 3;
        public static final int CUSTOM = 4;
    }
}

