/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.Arrays;

class LayoutTableSubsetter {
    protected final LayoutTable origTable;
    protected final OTByteArray.OTByteArrayBuilder builder;
    static int maxOffset = 65535;

    LayoutTableSubsetter(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder) {
        this.origTable = layoutTable;
        this.builder = oTByteArrayBuilder;
    }

    protected int writeByteArrayAtOffset(int n, OTByteArray oTByteArray) throws InvalidFontException {
        this.builder.replace(n, oTByteArray, 0, oTByteArray.getSize());
        return oTByteArray.getSize();
    }

    protected int writeClassDef(int n, int n2, int n3, int n4, Subset subset, int n5) throws InvalidFontException, UnsupportedFontException {
        ClassDefGenerator classDefGenerator = ClassDefGenerator.newInstance(this.origTable, this.origTable.data.getOffset(n, n2), subset, n5);
        this.builder.setuint16(n3 + n2, n4);
        OTByteArray oTByteArray = classDefGenerator.generateClass().toOTByteArray();
        return this.writeByteArrayAtOffset(n3 + n4, oTByteArray);
    }

    static class ClassCoveredBySubset
    implements LayoutTable.ClassConsumer {
        private final Subset subset;
        private boolean glyphFound;

        ClassCoveredBySubset(Subset subset) {
            this.subset = subset;
        }

        public boolean glyph(int n, int n2) throws UnsupportedFontException, InvalidFontException {
            if (this.subset.getExistingSubsetGid(n) != -1) {
                this.glyphFound = true;
                return false;
            }
            return true;
        }

        boolean classCoveredBySubset(LayoutTable layoutTable, int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
            this.glyphFound = false;
            layoutTable.iterateClass(n, n2, this, n3);
            return this.glyphFound;
        }
    }

    private static class CoverageFormat2Generator
    extends CoverageGenerator {
        private final int numRanges;
        private final boolean[] subsetGlyphInCoverage;

        public CoverageFormat2Generator(LayoutTable layoutTable, int n, Subset subset, int n2, boolean[] blArray) {
            super(layoutTable, n, subset);
            this.numRanges = n2;
            this.newCoverage = OTByteArray.getOTByteArrayBuilderInstance(4 + 6 * n2);
            this.newCoverage.setuint16(0, 2);
            this.newCoverage.setuint16(2, n2);
            this.subsetGlyphInCoverage = blArray;
        }

        private void writeRanges() {
            int n = 0;
            if (this.subsetGlyphInCoverage[0]) {
                this.newCoverage.setuint16(4, 0);
                ++this.numGlyphsFound;
            } else {
                n = -1;
            }
            for (int i = 1; i < this.subsetGlyphInCoverage.length; ++i) {
                if (this.subsetGlyphInCoverage[i]) {
                    ++this.numGlyphsFound;
                }
                if (!this.subsetGlyphInCoverage[i - 1] && this.subsetGlyphInCoverage[i]) {
                    this.newCoverage.setuint16(4 + 6 * ++n, i);
                    continue;
                }
                if (!this.subsetGlyphInCoverage[i - 1] || this.subsetGlyphInCoverage[i]) continue;
                this.newCoverage.setuint16(4 + 6 * n + 2, i - 1);
            }
            if (this.subsetGlyphInCoverage[this.subsetGlyphInCoverage.length - 1]) {
                this.newCoverage.setuint16(4 + 6 * n + 2, this.subsetGlyphInCoverage.length - 1);
            }
        }

        OTByteArray.OTByteArrayBuilder generateCoverage() throws InvalidFontException, UnsupportedFontException {
            this.writeRanges();
            if (this.numRanges != 0) {
                int n = 0;
                for (int i = 0; i < this.numRanges; ++i) {
                    int n2 = this.newCoverage.getuint16(4 + 6 * i);
                    int n3 = this.newCoverage.getuint16(4 + 6 * i + 2);
                    this.newCoverage.setuint16(4 + 6 * i + 4, n);
                    n += 1 + n3 - n2;
                }
            }
            return this.newCoverage;
        }
    }

    private static class CoverageFormat1Generator
    extends CoverageGenerator {
        private final boolean[] subsetGlyphInCoverage;

        CoverageFormat1Generator(LayoutTable layoutTable, int n, Subset subset, int n2, boolean[] blArray) {
            super(layoutTable, n, subset);
            this.newCoverage = OTByteArray.getOTByteArrayBuilderInstance(4 + 2 * n2);
            this.newCoverage.setuint16(0, 1);
            this.newCoverage.setuint16(2, n2);
            this.subsetGlyphInCoverage = blArray;
        }

        OTByteArray.OTByteArrayBuilder generateCoverage() throws InvalidFontException, UnsupportedFontException {
            int n = 0;
            for (int i = 0; i < this.subsetGlyphInCoverage.length; ++i) {
                if (!this.subsetGlyphInCoverage[i]) continue;
                this.newCoverage.setuint16(4 + 2 * n, i);
                ++n;
            }
            this.numGlyphsFound = n;
            return this.newCoverage;
        }
    }

    static abstract class CoverageGenerator {
        OTByteArray.OTByteArrayBuilder newCoverage;
        protected final LayoutTable origTable;
        protected final int origCoverageOffset;
        protected final Subset subset;
        protected int numGlyphsFound = 0;

        CoverageGenerator(LayoutTable layoutTable, int n, Subset subset) {
            this.origTable = layoutTable;
            this.origCoverageOffset = n;
            this.subset = subset;
        }

        static CoverageGenerator newInstance(LayoutTable layoutTable, int n, Subset subset) throws InvalidFontException, UnsupportedFontException {
            CoverageFormatDecider coverageFormatDecider = new CoverageFormatDecider(subset);
            layoutTable.iterateCoverage(n, null, coverageFormatDecider);
            int n2 = coverageFormatDecider.countRanges();
            int n3 = 2 * coverageFormatDecider.numGids;
            int n4 = 6 * n2;
            if (n3 < n4) {
                return new CoverageFormat1Generator(layoutTable, n, subset, coverageFormatDecider.numGids, coverageFormatDecider.subsetGlyphInCoverage);
            }
            return new CoverageFormat2Generator(layoutTable, n, subset, n2, coverageFormatDecider.subsetGlyphInCoverage);
        }

        abstract OTByteArray.OTByteArrayBuilder generateCoverage() throws InvalidFontException, UnsupportedFontException;
    }

    static class ClassDef2Generator
    extends ClassDefGenerator {
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int nRanges;

        ClassDef2Generator(int[] nArray, int n) {
            super(nArray);
            this.builder = OTByteArray.getOTByteArrayBuilderInstance(n);
            this.nRanges = (n - 4) / 6;
        }

        OTByteArray.OTByteArrayBuilder generateClass() throws InvalidFontException, UnsupportedFontException {
            int n;
            this.builder.setuint16(0, 2);
            this.builder.setuint16(2, this.nRanges);
            int n2 = 0;
            for (n = 0; n < this.subsetClasses.length && this.subsetClasses[n] == 0; ++n) {
            }
            if (n < this.subsetClasses.length) {
                this.builder.setuint16(4, n);
                this.builder.setuint16(8, this.subsetClasses[n]);
                ++n2;
            }
            ++n;
            while (n < this.subsetClasses.length) {
                while (n < this.subsetClasses.length && this.subsetClasses[n] == this.subsetClasses[n - 1]) {
                    ++n;
                }
                this.builder.setuint16(4 + 6 * (n2 - 1) + 2, n - 1);
                while (n < this.subsetClasses.length && this.subsetClasses[n] == 0) {
                    ++n;
                }
                if (n < this.subsetClasses.length) {
                    this.builder.setuint16(4 + 6 * n2, n);
                    this.builder.setuint16(4 + 6 * n2 + 4, this.subsetClasses[n]);
                    ++n2;
                }
                ++n;
            }
            return this.builder;
        }
    }

    static class ClassDef1Generator
    extends ClassDefGenerator {
        private final OTByteArray.OTByteArrayBuilder builder;

        ClassDef1Generator(int[] nArray, int n) {
            super(nArray);
            this.builder = OTByteArray.getOTByteArrayBuilderInstance(n);
        }

        OTByteArray.OTByteArrayBuilder generateClass() throws InvalidFontException, UnsupportedFontException {
            int n;
            int n2;
            for (n2 = 0; n2 < this.subsetClasses.length && this.subsetClasses[n2] == 0; ++n2) {
            }
            for (n = this.subsetClasses.length - 1; n >= 0 && this.subsetClasses[n] == 0; --n) {
            }
            this.builder.setuint16(0, 1);
            if (n2 <= n) {
                this.builder.setuint16(2, n2);
                this.builder.setuint16(4, n - n2 + 1);
            } else {
                this.builder.setuint16(2, 0);
                this.builder.setuint16(4, 0);
            }
            for (int i = 0; i <= n - n2; ++i) {
                this.builder.setuint16(6 + 2 * i, this.subsetClasses[n2 + i]);
            }
            return this.builder;
        }
    }

    static abstract class ClassDefGenerator {
        protected final int[] subsetClasses;

        ClassDefGenerator(int[] nArray) {
            this.subsetClasses = nArray;
        }

        static ClassDefGenerator newInstance(LayoutTable layoutTable, int n, Subset subset, int n2) throws InvalidFontException, UnsupportedFontException {
            ClassFormatDecider classFormatDecider = new ClassFormatDecider(subset);
            layoutTable.iterateClass(n, n2, classFormatDecider, -1);
            int n3 = classFormatDecider.getFormat1Size();
            int n4 = classFormatDecider.getFormat2Size();
            if (n3 < n4) {
                return new ClassDef1Generator(classFormatDecider.subsetClasses, n3);
            }
            return new ClassDef2Generator(classFormatDecider.subsetClasses, n4);
        }

        abstract OTByteArray.OTByteArrayBuilder generateClass() throws InvalidFontException, UnsupportedFontException;
    }

    private static class ClassFormatDecider
    implements LayoutTable.ClassConsumer {
        private final Subset subset;
        int[] subsetClasses;

        ClassFormatDecider(Subset subset) {
            this.subset = subset;
            this.subsetClasses = new int[subset.getNumGlyphs()];
        }

        public boolean glyph(int n, int n2) throws UnsupportedFontException, InvalidFontException {
            int n3 = this.subset.getExistingSubsetGid(n);
            if (n3 != -1) {
                this.subsetClasses[n3] = n2;
            }
            return true;
        }

        int getFormat1Size() {
            int n;
            int n2;
            for (n2 = 0; n2 < this.subsetClasses.length && this.subsetClasses[n2] == 0; ++n2) {
            }
            for (n = this.subsetClasses.length - 1; n > n2 && this.subsetClasses[n] == 0; --n) {
            }
            return 6 + 2 * (n - n2 + 1);
        }

        int getFormat2Size() {
            int n;
            int n2 = 0;
            for (n = 0; n < this.subsetClasses.length && this.subsetClasses[n] == 0; ++n) {
            }
            if (n < this.subsetClasses.length) {
                ++n2;
            }
            ++n;
            while (n < this.subsetClasses.length) {
                while (n < this.subsetClasses.length && this.subsetClasses[n] == this.subsetClasses[n - 1]) {
                    ++n;
                }
                while (n < this.subsetClasses.length && this.subsetClasses[n] == 0) {
                    ++n;
                }
                if (n < this.subsetClasses.length) {
                    ++n2;
                }
                ++n;
            }
            return 4 + 6 * n2;
        }
    }

    private static class CoverageFormatDecider
    implements LayoutTable.CoverageConsumer {
        private final Subset subset;
        boolean[] subsetGlyphInCoverage;
        int numGids = 0;

        CoverageFormatDecider(Subset subset) {
            this.subset = subset;
            this.subsetGlyphInCoverage = new boolean[subset.getNumGlyphs()];
            Arrays.fill(this.subsetGlyphInCoverage, false);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.subset.getExistingSubsetGid(n);
            if (n3 != -1) {
                this.subsetGlyphInCoverage[n3] = true;
                ++this.numGids;
            }
            return true;
        }

        int countRanges() {
            int n = this.subsetGlyphInCoverage[0] ? 1 : 0;
            for (int i = 1; i < this.subsetGlyphInCoverage.length; ++i) {
                if (this.subsetGlyphInCoverage[i - 1] || !this.subsetGlyphInCoverage[i]) continue;
                ++n;
            }
            return n;
        }
    }
}

