/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.IntGrowableArray;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class LookupTableHarvester {
    protected final int numGlyphs;
    final LookupTable lookupTable;

    LookupTableHarvester(LookupTable lookupTable, int n) {
        this.lookupTable = lookupTable;
        this.numGlyphs = n;
    }

    abstract List harvestSubtables(Subset var1, int var2, int var3, int var4, Map var5) throws InvalidFontException, UnsupportedFontException;

    protected IntGrowableArray getAllFeatureListFeatures() throws InvalidFontException {
        int n = this.lookupTable.getFeatureListOffset();
        int n2 = this.lookupTable.data.getuint16(n);
        IntGrowableArray intGrowableArray = new IntGrowableArray();
        for (int i = 0; i < n2; ++i) {
            int n3 = n + this.lookupTable.data.getuint16(n + 2 + i * 6 + 4);
            int n4 = this.lookupTable.data.getuint16(n3 + 2);
            for (int j = 0; j < n4; ++j) {
                intGrowableArray.set(this.lookupTable.data.getuint16(n3 + 4 + j * 2));
            }
        }
        Arrays.sort(intGrowableArray.getBuffer(), 0, intGrowableArray.getLength());
        return intGrowableArray;
    }

    protected void harvestAllFeatures(IntGrowableArray intGrowableArray, Map map, Subset subset) throws InvalidFontException, UnsupportedFontException {
        if (intGrowableArray.getLength() > 0) {
            this.harvest(subset, intGrowableArray.getBuffer()[0], map);
            for (int i = 1; i < intGrowableArray.getLength(); ++i) {
                if (intGrowableArray.get(i) == intGrowableArray.get(i - 1)) continue;
                this.harvest(subset, intGrowableArray.get(i), map);
            }
        }
    }

    protected void harvest(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        int n2;
        int n3;
        int n4 = this.lookupTable.getLookupListOffset();
        int n5 = this.lookupTable.data.getOffset(n4, 2 + 2 * n);
        List list = this.harvestSubtables(subset, n5, n3 = this.lookupTable.data.getuint16(n5), n2 = this.lookupTable.data.getuint16(n5 + 2), map);
        if (list != null) {
            map.put(new Integer(n), list);
        }
    }

    protected List gatherLookupsForCoverage(int n, int n2, Subset subset, List list, CoverageLookupHarvester coverageLookupHarvester, int n3) throws InvalidFontException, UnsupportedFontException {
        CoverageHarvester coverageHarvester = new CoverageHarvester(n, subset, list, coverageLookupHarvester, n3);
        this.lookupTable.iterateCoverage(this.lookupTable.data.getOffset(n, n2), subset, coverageHarvester);
        return coverageHarvester.subtables;
    }

    protected List gatherLookupsForCoverageAllSubtables(Subset subset, int n, CoverageLookupHarvester coverageLookupHarvester) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            list = this.gatherLookupsForCoverage(n3, 2, subset, list, coverageLookupHarvester, i);
        }
        return list;
    }

    protected class CoverageHarvester
    implements LayoutTable.CoverageConsumer {
        final int stOffset;
        final Subset gids;
        final CoverageLookupHarvester harvester;
        final int subtable;
        List subtables;

        CoverageHarvester(int n, Subset subset, List list, CoverageLookupHarvester coverageLookupHarvester, int n2) {
            this.stOffset = n;
            this.gids = subset;
            this.subtables = list;
            this.harvester = coverageLookupHarvester;
            this.subtable = n2;
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            if (this.harvester.lookupApplies(n, this.stOffset, n2, this.gids)) {
                Integer n3;
                if (this.subtables == null) {
                    this.subtables = new ArrayList();
                }
                if (!this.subtables.contains(n3 = new Integer(this.subtable))) {
                    this.subtables.add(n3);
                }
                return this.harvester.keepGoing();
            }
            return true;
        }
    }

    protected static interface CoverageLookupHarvester {
        public boolean lookupApplies(int var1, int var2, int var3, Subset var4) throws InvalidFontException, UnsupportedFontException;

        public boolean keepGoing();
    }
}

