/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.OrigFontType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PostscriptTokenParser {
    private static final Pattern origFontTypePattern = Pattern.compile("/OrigFontType\\s*/((?:" + OrigFontType.kTYPE1.toString() + ")|(?:" + OrigFontType.kTRUETYPE.toString() + ")|(?:" + OrigFontType.kOCF.toString() + ")|(?:" + OrigFontType.kCID.toString() + "))(\\s+def)", 0);
    private static final Pattern fsTypePattern = Pattern.compile("/FSType\\s*(-?\\d+)(\\s+def)", 0);

    public static Integer getFSType(String string) {
        Matcher matcher;
        if (string != null && (matcher = fsTypePattern.matcher(string)).find()) {
            int n = matcher.start(1);
            int n2 = matcher.start(2);
            return new Integer(Integer.parseInt(string.substring(n, n2)));
        }
        return null;
    }

    public static OrigFontType getOrigFontType(String string) {
        Matcher matcher;
        if (string != null && (matcher = origFontTypePattern.matcher(string)).find()) {
            int n;
            int n2 = matcher.start(1);
            String string2 = string.substring(n2, n = matcher.start(2));
            if (string2.equals(OrigFontType.kTYPE1.toString())) {
                return OrigFontType.kTYPE1;
            }
            if (string2.equals(OrigFontType.kTRUETYPE.toString())) {
                return OrigFontType.kTRUETYPE;
            }
            if (string2.equals(OrigFontType.kCID.toString())) {
                return OrigFontType.kCID;
            }
            if (string2.equals(OrigFontType.kOCF.toString())) {
                return OrigFontType.kOCF;
            }
        }
        return null;
    }
}

