/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.FontFactory;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.fontmanagement.URLFont;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Base14Font
extends URLFont {
    static final long serialVersionUID = 1L;
    private final String mBase14CSSName;
    private final String mBase14PSName;
    private static final HashMap<String, HashMap<String, Object>> mBase14DescCache;

    public Base14Font(String string, String string2, String string3) {
        super(Base14.class.getResource(string), 0);
        this.mBase14CSSName = string2;
        this.mBase14PSName = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized FontData retrieveFontData() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FontData fontData;
        block5: {
            fontData = null;
            try {
                fontData = (FontData)this.fontRef.get();
                if (fontData != null) break block5;
                FontInputStream fontInputStream = new FontInputStream(this.outlineFileURL.openStream());
                try {
                    OpenTypeFont[] openTypeFontArray = FontFactory.load(fontInputStream, this.mBase14CSSName, this.mBase14PSName);
                    fontData = openTypeFontArray[this.index];
                    this.fontRef = new SoftReference<FontData>(fontData);
                }
                finally {
                    fontInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new FontLoadingException(iOException);
            }
        }
        return fontData;
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public Object getCachedFontDescription(String string) {
        if (mBase14DescCache == null) {
            return null;
        }
        HashMap<String, Object> hashMap = mBase14DescCache.get(this.mBase14PSName);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string);
    }

    public Iterator<String> getCachedFontDescriptionIterator() {
        return null;
    }

    @Override
    public void setCachedFontDescription(String string, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        HashMap hashMap = null;
        try {
            inputStream = Base14.class.getResourceAsStream("Base14Cache");
            objectInputStream = new ObjectInputStream(inputStream);
            try {
                hashMap = (HashMap)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                } else if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        mBase14DescCache = hashMap;
    }
}

