/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.fxg;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontSearchAttributes;
import java.util.HashMap;

public class FXGFontResolverImpl
implements FXGFontResolver {
    private HashMap fxgFonts;
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private static final long serialVersionUID = 1L;

    public FXGFontResolverImpl() {
        this.fxgFonts = new HashMap();
    }

    public FXGFontResolverImpl(FXGFontResolverImpl fXGFontResolverImpl) {
        this.fxgFonts = (HashMap)fXGFontResolverImpl.fxgFonts.clone();
        this.resolutionPriority = fXGFontResolverImpl.resolutionPriority;
    }

    public void addFont(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FXGFontDescription[] fXGFontDescriptionArray = font.getFXGFontDescription();
        for (int i = 0; i < fXGFontDescriptionArray.length; ++i) {
            this.addFont(fXGFontDescriptionArray[i], font);
        }
    }

    public void addFont(FXGFontDescription fXGFontDescription, Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FXGKey fXGKey = new FXGKey(fXGFontDescription);
        FXGValue fXGValue = (FXGValue)this.fxgFonts.get(fXGKey);
        if (fXGValue != null) {
            Font font2;
            Font font3 = fXGValue.getFont();
            if (this.resolutionPriority == FontResolutionPriority.FIRST) {
                return;
            }
            if ((this.resolutionPriority == FontResolutionPriority.INTELLIGENT_LAST || this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST) && (font2 = IntelligentResolver.choosePreferredFont(font3, font, this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST)) == font3) {
                return;
            }
        }
        this.fxgFonts.put(fXGKey, new FXGValue(fXGFontDescription, font));
    }

    public Font findFont(FXGFontSearchAttributes fXGFontSearchAttributes) {
        FXGValue fXGValue = (FXGValue)this.fxgFonts.get(new FXGKey(fXGFontSearchAttributes));
        if (fXGValue == null) {
            return null;
        }
        return fXGValue.getFont();
    }

    public boolean isEmpty() {
        return this.fxgFonts.isEmpty();
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority fontResolutionPriority) {
        FontResolutionPriority fontResolutionPriority2 = this.resolutionPriority;
        this.resolutionPriority = fontResolutionPriority;
        return fontResolutionPriority2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.fxgFonts == null ? 0 : this.fxgFonts.hashCode());
        n = 31 * n + (this.resolutionPriority == null ? 0 : this.resolutionPriority.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FXGFontResolverImpl)) {
            return false;
        }
        FXGFontResolverImpl fXGFontResolverImpl = (FXGFontResolverImpl)object;
        if (this.fxgFonts == null ? fXGFontResolverImpl.fxgFonts != null : !this.fxgFonts.equals(fXGFontResolverImpl.fxgFonts)) {
            return false;
        }
        return !(this.resolutionPriority == null ? fXGFontResolverImpl.resolutionPriority != null : !this.resolutionPriority.equals(fXGFontResolverImpl.resolutionPriority));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FXG Fonts:\n");
        for (FXGKey fXGKey : this.fxgFonts.keySet()) {
            stringBuffer.append("  ");
            stringBuffer.append(fXGKey);
            stringBuffer.append(" = ");
            stringBuffer.append(((FXGValue)this.fxgFonts.get(fXGKey)).getFont().toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static final class FXGValue {
        private final FXGFontDescription fxgDescription;
        private final Font font;

        FXGValue(FXGFontDescription fXGFontDescription, Font font) {
            this.fxgDescription = fXGFontDescription;
            this.font = font;
        }

        FXGFontDescription getFXGDescription() {
            return this.fxgDescription;
        }

        Font getFont() {
            return this.font;
        }

        public String toString() {
            return new String(this.fxgDescription.toString() + "\n\t" + this.font.toString());
        }
    }

    private static final class FXGKey {
        private final String familyName;
        private final boolean isBold;
        private final boolean isItalic;

        protected FXGKey(FXGFontDescription fXGFontDescription) {
            this.familyName = fXGFontDescription.getFamilyName();
            this.isBold = fXGFontDescription.isBold();
            this.isItalic = fXGFontDescription.isItalic();
        }

        protected FXGKey(FXGFontSearchAttributes fXGFontSearchAttributes) {
            this.familyName = fXGFontSearchAttributes.getFamilyName();
            this.isBold = fXGFontSearchAttributes.isBold();
            this.isItalic = fXGFontSearchAttributes.isItalic();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.familyName == null ? 0 : this.familyName.hashCode());
            n = 31 * n + (this.isBold ? 1231 : 1237);
            n = 31 * n + (this.isItalic ? 1231 : 1237);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof FXGKey)) {
                return false;
            }
            FXGKey fXGKey = (FXGKey)object;
            if (this.familyName == null ? fXGKey.familyName != null : !this.familyName.equals(fXGKey.familyName)) {
                return false;
            }
            if (this.isBold != fXGKey.isBold) {
                return false;
            }
            return this.isItalic == fXGKey.isItalic;
        }

        public String toString() {
            return new String(this.familyName + (this.isBold ? ", bold" : "") + (this.isItalic ? ", italic" : ""));
        }
    }
}

