/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

public class Math2 {
    private static final int[] bits = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};

    public static double roundHalfUp(double d) {
        return Math.floor(d + 0.5);
    }

    public static double roundHalfDown(double d) {
        return Math.ceil(d - 0.5);
    }

    public static boolean epsilonEquals(float f, float f2) {
        float f3 = 1.0E-7f;
        return Math.abs(f - f2) < f3;
    }

    public static boolean epsilonEquals(double d, double d2) {
        double d3 = 1.0E-8;
        return Math.abs(d - d2) < d3;
    }

    public static int powerOf2(int n) {
        if ((long)n < 0L) {
            n = -n;
        }
        if (n < 65536) {
            if (n < 256) {
                if (n < 16) {
                    return bits[n];
                }
                return bits[n >> 4] + 4;
            }
            if (n < 4096) {
                return bits[n >> 8] + 8;
            }
            return bits[n >> 12] + 12;
        }
        if (n < 0x1000000) {
            if (n < 0x100000) {
                return bits[n >> 16] + 16;
            }
            return bits[n >> 20] + 20;
        }
        if (n < 0x10000000) {
            return bits[n >> 24] + 24;
        }
        return bits[n >> 28] + 28;
    }
}

