/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.NumberKeyframeAnimation;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    AnimatableIntegerValue(LottieComposition composition, Integer initialValue) {
        super(composition);
        this.initialValue = initialValue;
    }

    AnimatableIntegerValue(JSONObject json, int frameRate, LottieComposition composition, boolean isDp, boolean remap100To255) {
        super(json, frameRate, composition, isDp);
        if (remap100To255) {
            this.initialValue = (Integer)this.initialValue * 255 / 100;
            for (int i = 0; i < this.keyValues.size(); ++i) {
                this.keyValues.set(i, (Integer)this.keyValues.get(i) * 255 / 100);
            }
        }
    }

    @Override
    protected Integer valueFromObject(Object object, float scale) throws JSONException {
        if (object instanceof Float) {
            return Math.round(((Float)object).floatValue() * scale);
        }
        if (object instanceof Double) {
            return (int)Math.round((Double)object * (double)scale);
        }
        if (object instanceof Integer) {
            return Math.round((float)((Integer)object).intValue() * scale);
        }
        if (object instanceof JSONArray && ((JSONArray)object).get(0) instanceof Integer) {
            return Math.round((float)((JSONArray)object).getInt(0) * scale);
        }
        if (object instanceof JSONArray && ((JSONArray)object).get(0) instanceof Double) {
            return (int)Math.round(((JSONArray)object).getDouble(0) * (double)scale);
        }
        return null;
    }

    @Override
    public KeyframeAnimation<Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        NumberKeyframeAnimation<Integer> animation = new NumberKeyframeAnimation<Integer>(this.duration, this.composition, this.keyTimes, Integer.class, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public Integer getInitialValue() {
        return (Integer)this.initialValue;
    }
}

