/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ScaleXY;
import java.util.ArrayList;
import java.util.List;

class AnimatableLayer
extends Drawable {
    private final KeyframeAnimation.AnimationListener<Integer> integerChangedListener = new KeyframeAnimation.AnimationListener<Integer>(){

        @Override
        public void onValueChanged(Integer progress) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    private final KeyframeAnimation.AnimationListener<Float> floatChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float progress) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    private final KeyframeAnimation.AnimationListener<ScaleXY> scaleChangedListener = new KeyframeAnimation.AnimationListener<ScaleXY>(){

        @Override
        public void onValueChanged(ScaleXY progress) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    private final KeyframeAnimation.AnimationListener<PointF> pointChangedListener = new KeyframeAnimation.AnimationListener<PointF>(){

        @Override
        public void onValueChanged(PointF progress) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    final List<AnimatableLayer> layers = new ArrayList<AnimatableLayer>();
    @Nullable
    private AnimatableLayer parentLayer;
    private KeyframeAnimation<PointF> position;
    private KeyframeAnimation<PointF> anchorPoint;
    private KeyframeAnimation<ScaleXY> transform;
    private KeyframeAnimation<Integer> alpha = null;
    private KeyframeAnimation<Float> rotation;
    private final Paint solidBackgroundPaint = new Paint();
    @ColorInt
    private int backgroundColor;
    private final List<KeyframeAnimation<?>> animations = new ArrayList();
    @FloatRange(from=0.0, to=1.0)
    private float progress;

    AnimatableLayer(Drawable.Callback callback) {
        this.setCallback(callback);
        this.solidBackgroundPaint.setAlpha(0);
        this.solidBackgroundPaint.setStyle(Paint.Style.FILL);
    }

    void setBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
        this.solidBackgroundPaint.setColor(color);
        this.invalidateSelf();
    }

    void addAnimation(KeyframeAnimation<?> newAnimation) {
        this.animations.add(newAnimation);
    }

    void removeAnimation(KeyframeAnimation<?> animation) {
        this.animations.remove(animation);
    }

    public void draw(@NonNull Canvas canvas) {
        int saveCount = canvas.save();
        this.applyTransformForLayer(canvas, this);
        int backgroundAlpha = Color.alpha((int)this.backgroundColor);
        if (backgroundAlpha != 0) {
            int alpha = backgroundAlpha;
            if (this.alpha != null) {
                alpha = alpha * this.alpha.getValue() / 255;
            }
            this.solidBackgroundPaint.setAlpha(alpha);
            if (alpha > 0) {
                canvas.drawRect(this.getBounds(), this.solidBackgroundPaint);
            }
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    public void invalidateSelf() {
        if (this.parentLayer != null) {
            this.parentLayer.invalidateSelf();
        }
    }

    int saveCanvas(@Nullable Canvas canvas) {
        if (canvas == null) {
            return 0;
        }
        return canvas.save();
    }

    void restoreCanvas(@Nullable Canvas canvas, int count) {
        if (canvas == null) {
            return;
        }
        canvas.restoreToCount(count);
    }

    void applyTransformForLayer(@Nullable Canvas canvas, AnimatableLayer layer) {
        ScaleXY scale;
        float rotation;
        if (canvas == null) {
            return;
        }
        if (layer.position != null) {
            PointF position = layer.position.getValue();
            if (position.x != 0.0f || position.y != 0.0f) {
                canvas.translate(position.x, position.y);
            }
        }
        if (layer.rotation != null && (rotation = layer.rotation.getValue().floatValue()) != 0.0f) {
            canvas.rotate(rotation);
        }
        if (layer.transform != null && ((scale = layer.transform.getValue()).getScaleX() != 1.0f || scale.getScaleY() != 1.0f)) {
            canvas.scale(scale.getScaleX(), scale.getScaleY());
        }
        if (layer.anchorPoint != null) {
            PointF anchorPoint = layer.anchorPoint.getValue();
            if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
                canvas.translate(-anchorPoint.x, -anchorPoint.y);
            }
        }
    }

    public void setAlpha(int alpha) {
        throw new IllegalArgumentException("This shouldn't be used.");
    }

    void setAlpha(KeyframeAnimation<Integer> alpha) {
        if (this.alpha != null) {
            this.removeAnimation(this.alpha);
            this.alpha.removeUpdateListener(this.integerChangedListener);
        }
        this.alpha = alpha;
        this.addAnimation(alpha);
        alpha.addUpdateListener(this.integerChangedListener);
        this.invalidateSelf();
    }

    public int getAlpha() {
        float alpha = this.alpha == null ? 1.0f : (float)this.alpha.getValue().intValue() / 255.0f;
        float parentAlpha = this.parentLayer == null ? 1.0f : (float)this.parentLayer.getAlpha() / 255.0f;
        return (int)(alpha * parentAlpha * 255.0f);
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    void setAnchorPoint(KeyframeAnimation<PointF> anchorPoint) {
        if (this.anchorPoint != null) {
            this.removeAnimation(this.anchorPoint);
            this.anchorPoint.removeUpdateListener(this.pointChangedListener);
        }
        this.anchorPoint = anchorPoint;
        this.addAnimation(anchorPoint);
        anchorPoint.addUpdateListener(this.pointChangedListener);
    }

    void setPosition(KeyframeAnimation<PointF> position) {
        if (this.position != null) {
            this.removeAnimation(this.position);
            this.position.removeUpdateListener(this.pointChangedListener);
        }
        this.position = position;
        this.addAnimation(position);
        position.addUpdateListener(this.pointChangedListener);
    }

    void setTransform(KeyframeAnimation<ScaleXY> transform) {
        if (this.transform != null) {
            this.removeAnimation(this.transform);
            this.transform.removeUpdateListener(this.scaleChangedListener);
        }
        this.transform = transform;
        this.addAnimation(this.transform);
        transform.addUpdateListener(this.scaleChangedListener);
    }

    void setRotation(KeyframeAnimation<Float> rotation) {
        if (this.rotation != null) {
            this.removeAnimation(this.rotation);
            this.rotation.removeUpdateListener(this.floatChangedListener);
        }
        this.rotation = rotation;
        this.addAnimation(this.rotation);
        rotation.addUpdateListener(this.floatChangedListener);
    }

    public int getOpacity() {
        return -3;
    }

    void addLayer(AnimatableLayer layer) {
        layer.parentLayer = this;
        this.layers.add(layer);
        layer.setProgress(this.progress);
        this.invalidateSelf();
    }

    void clearLayers() {
        this.layers.clear();
        this.invalidateSelf();
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        int i;
        this.progress = progress;
        for (i = 0; i < this.animations.size(); ++i) {
            this.animations.get(i).setProgress(progress);
        }
        for (i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).setProgress(progress);
        }
    }

    public float getProgress() {
        return this.progress;
    }
}

