/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatablePointValue;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

class CircleShape {
    private final IAnimatablePathValue position;
    private final AnimatablePointValue size;

    CircleShape(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            this.position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(json.getJSONObject("p"), composition);
            this.size = new AnimatablePointValue(json.getJSONObject("s"), frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse circle " + json, e);
        }
    }

    public IAnimatablePathValue getPosition() {
        return this.position;
    }

    public AnimatablePointValue getSize() {
        return this.size;
    }
}

