/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LongSparseArray;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LayerView;
import com.airbnb.lottie.LottieComposition;
import java.util.ArrayList;

class LottieDrawable
extends AnimatableLayer {
    private LottieComposition composition;
    private final ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
    @Nullable
    private Bitmap mainBitmap = null;
    @Nullable
    private Bitmap maskBitmap = null;
    @Nullable
    private Bitmap matteBitmap = null;
    @Nullable
    private Bitmap mainBitmapForMatte = null;
    @Nullable
    private Bitmap maskBitmapForMatte = null;
    private boolean playAnimationWhenLayerAdded;
    private boolean systemAnimationsAreDisabled;

    LottieDrawable() {
        super(null);
        this.animator.setRepeatCount(0);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (LottieDrawable.this.systemAnimationsAreDisabled) {
                    LottieDrawable.this.animator.cancel();
                    LottieDrawable.this.setProgress(1.0f);
                } else {
                    LottieDrawable.this.setProgress(animation.getAnimatedFraction());
                }
            }
        });
    }

    void setComposition(LottieComposition composition) {
        if (this.getCallback() == null) {
            throw new IllegalStateException("You or your view must set a Drawable.Callback before setting the composition. This gets done automatically when added to an ImageView. Either call ImageView.setImageDrawable() before setComposition() or call setCallback(yourView.getCallback()) first.");
        }
        this.clearComposition();
        this.composition = composition;
        this.animator.setDuration(composition.getDuration());
        this.setBounds(0, 0, composition.getBounds().width(), composition.getBounds().height());
        this.buildLayersForComposition(composition);
        this.getCallback().invalidateDrawable((Drawable)this);
    }

    private void clearComposition() {
        this.recycleBitmaps();
        this.clearLayers();
    }

    private void buildLayersForComposition(LottieComposition composition) {
        int i;
        if (composition == null) {
            throw new IllegalStateException("Composition is null");
        }
        Rect bounds = composition.getBounds();
        if (composition.hasMasks() || composition.hasMattes()) {
            this.mainBitmap = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (composition.hasMasks()) {
            this.maskBitmap = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
        }
        if (composition.hasMattes()) {
            this.matteBitmap = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        ArrayList<LayerView> layers = new ArrayList<LayerView>(composition.getLayers().size());
        LayerView maskedLayer = null;
        for (i = composition.getLayers().size() - 1; i >= 0; --i) {
            LayerView layerView;
            Layer layer = composition.getLayers().get(i);
            if (maskedLayer == null) {
                layerView = new LayerView(layer, composition, this.getCallback(), this.mainBitmap, this.maskBitmap, this.matteBitmap);
            } else {
                if (this.mainBitmapForMatte == null) {
                    this.mainBitmapForMatte = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
                }
                if (this.maskBitmapForMatte == null && !layer.getMasks().isEmpty()) {
                    this.maskBitmapForMatte = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
                }
                layerView = new LayerView(layer, composition, this.getCallback(), this.mainBitmapForMatte, this.maskBitmapForMatte, null);
            }
            layerMap.put(layerView.getId(), (Object)layerView);
            if (maskedLayer != null) {
                maskedLayer.setMatteLayer(layerView);
                maskedLayer = null;
                continue;
            }
            layers.add(layerView);
            if (layer.getMatteType() != Layer.MatteType.Add) continue;
            maskedLayer = layerView;
        }
        for (i = 0; i < layers.size(); ++i) {
            LayerView layerView = (LayerView)((Object)layers.get(i));
            this.addLayer(layerView);
        }
        for (i = 0; i < layerMap.size(); ++i) {
            long key = layerMap.keyAt(i);
            LayerView layerView = (LayerView)((Object)layerMap.get(key));
            LayerView parentLayer = (LayerView)((Object)layerMap.get(layerView.getLayerModel().getParentId()));
            if (parentLayer == null) continue;
            layerView.setParentLayer(parentLayer);
        }
    }

    @Override
    public void invalidateSelf() {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.composition == null) {
            return;
        }
        Rect bounds = this.getBounds();
        Rect compBounds = this.composition.getBounds();
        int saveCount = canvas.save();
        if (!bounds.equals((Object)compBounds)) {
            float scaleX = (float)bounds.width() / (float)compBounds.width();
            float scaleY = (float)bounds.height() / (float)compBounds.height();
            canvas.scale(scaleX, scaleY);
        }
        super.draw(canvas);
        canvas.clipRect(this.getBounds());
        canvas.restoreToCount(saveCount);
    }

    void systemAnimationsAreDisabled() {
        this.systemAnimationsAreDisabled = true;
    }

    void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    boolean isAnimating() {
        return this.animator.isRunning();
    }

    void playAnimation() {
        if (this.layers.isEmpty()) {
            this.playAnimationWhenLayerAdded = true;
            return;
        }
        this.animator.setCurrentPlayTime((long)(this.getProgress() * (float)this.animator.getDuration()));
        this.animator.start();
    }

    void cancelAnimation() {
        this.playAnimationWhenLayerAdded = false;
        this.animator.cancel();
    }

    @Override
    void addLayer(AnimatableLayer layer) {
        super.addLayer(layer);
        if (this.playAnimationWhenLayerAdded) {
            this.playAnimationWhenLayerAdded = false;
            this.playAnimation();
        }
    }

    void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : this.composition.getBounds().width();
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : this.composition.getBounds().height();
    }

    @VisibleForTesting
    void recycleBitmaps() {
        if (this.mainBitmap != null) {
            this.mainBitmap.recycle();
            this.mainBitmap = null;
        }
        if (this.maskBitmap != null) {
            this.maskBitmap.recycle();
            this.maskBitmap = null;
        }
        if (this.matteBitmap != null) {
            this.matteBitmap.recycle();
            this.matteBitmap = null;
        }
        if (this.mainBitmapForMatte != null) {
            this.mainBitmapForMatte.recycle();
            this.mainBitmapForMatte = null;
        }
        if (this.maskBitmapForMatte != null) {
            this.maskBitmapForMatte.recycle();
            this.maskBitmapForMatte = null;
        }
    }
}

