/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableIntegerValue;
import com.airbnb.lottie.AnimatableShapeValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

class Mask {
    private final MaskMode maskMode;
    private final AnimatableShapeValue maskPath;

    Mask(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            boolean closed = false;
            if (json.has("cl")) {
                closed = json.getBoolean("cl");
            }
            String mode = json.getString("mode");
            switch (mode) {
                case "a": {
                    this.maskMode = MaskMode.MaskModeAdd;
                    break;
                }
                case "s": {
                    this.maskMode = MaskMode.MaskModeSubtract;
                    break;
                }
                case "i": {
                    this.maskMode = MaskMode.MaskModeIntersect;
                    break;
                }
                default: {
                    this.maskMode = MaskMode.MaskModeUnknown;
                }
            }
            this.maskPath = new AnimatableShapeValue(json.getJSONObject("pt"), frameRate, composition, closed);
            Object object = new AnimatableIntegerValue(json.getJSONObject("o"), frameRate, composition, false, true);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse mask. " + json, e);
        }
    }

    MaskMode getMaskMode() {
        return this.maskMode;
    }

    AnimatableShapeValue getMaskPath() {
        return this.maskPath;
    }

    private static enum MaskMode {
        MaskModeAdd,
        MaskModeSubtract,
        MaskModeIntersect,
        MaskModeUnknown;

    }
}

