/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.view.animation.Interpolator;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.MiscUtils;
import java.util.List;

class NumberKeyframeAnimation<T extends Number>
extends KeyframeAnimation<T> {
    private final List<T> values;
    private final Class<T> klass;

    NumberKeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, Class<T> klass, List<T> values, List<Interpolator> interpolators) {
        super(duration, composition, keyTimes, interpolators);
        this.klass = klass;
        if (keyTimes.size() != values.size()) {
            throw new IllegalArgumentException("Key times and values must be the same length " + keyTimes + " vs " + values);
        }
        this.values = values;
    }

    @Override
    T getValue() {
        if (this.progress <= 0.0f) {
            return (T)((Number)this.values.get(0));
        }
        if (this.progress >= 1.0f) {
            return (T)((Number)this.values.get(this.values.size() - 1));
        }
        int keyframeIndex = this.getKeyframeIndex();
        float startKeytime = ((Float)this.keyTimes.get(keyframeIndex)).floatValue();
        float endKeytime = ((Float)this.keyTimes.get(keyframeIndex + 1)).floatValue();
        float percentageIntoFrame = 0.0f;
        if (!this.isDiscrete) {
            percentageIntoFrame = (this.progress - startKeytime) / (endKeytime - startKeytime);
            if (this.interpolators != null) {
                percentageIntoFrame = ((Interpolator)this.interpolators.get(keyframeIndex)).getInterpolation(percentageIntoFrame);
            }
        }
        Number startValue = (Number)this.values.get(keyframeIndex);
        Number endValue = (Number)this.values.get(keyframeIndex + 1);
        if (this.klass.isAssignableFrom(Integer.class)) {
            return (T)((Number)this.klass.cast(MiscUtils.lerp(startValue.intValue(), endValue.intValue(), percentageIntoFrame)));
        }
        return (T)((Number)this.klass.cast(Float.valueOf(MiscUtils.lerp(startValue.floatValue(), endValue.floatValue(), percentageIntoFrame))));
    }
}

