/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatablePointValue;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

class RectangleShape {
    private static final String TAG = RectangleShape.class.getSimpleName();
    private final IAnimatablePathValue position;
    private final AnimatablePointValue size;
    private final AnimatableFloatValue cornerRadius;

    RectangleShape(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            JSONObject positionJson = json.getJSONObject("p");
            this.position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(positionJson, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse rectangle position.", e);
        }
        try {
            JSONObject cornerRadiusJson = json.getJSONObject("r");
            this.cornerRadius = new AnimatableFloatValue(cornerRadiusJson, frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse rectangle corner radius.", e);
        }
        try {
            JSONObject sizeJson = json.getJSONObject("s");
            this.size = new AnimatablePointValue(sizeJson, frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse rectangle size.", e);
        }
    }

    AnimatableFloatValue getCornerRadius() {
        return this.cornerRadius;
    }

    AnimatablePointValue getSize() {
        return this.size;
    }

    IAnimatablePathValue getPosition() {
        return this.position;
    }

    public String toString() {
        return "RectangleShape{cornerRadius=" + this.cornerRadius.getInitialValue() + ", position=" + this.position + ", size=" + this.size + '}';
    }
}

