/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

class ShapeTrimPath {
    private final AnimatableFloatValue start;
    private final AnimatableFloatValue end;
    private final AnimatableFloatValue offset;

    ShapeTrimPath(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            this.start = new AnimatableFloatValue(json.getJSONObject("s"), frameRate, composition, false);
            this.end = new AnimatableFloatValue(json.getJSONObject("e"), frameRate, composition, false);
            this.offset = new AnimatableFloatValue(json.getJSONObject("o"), frameRate, composition, false);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse trim path " + json, e);
        }
    }

    AnimatableFloatValue getEnd() {
        return this.end;
    }

    AnimatableFloatValue getStart() {
        return this.start;
    }

    AnimatableFloatValue getOffset() {
        return this.offset;
    }

    public String toString() {
        return "Trim Path: {start: " + this.start + ", end: " + this.end + ", offset: " + this.offset + "}";
    }
}

