/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.airbnb.lottie.ImageAsset;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;

class ImageAssetBitmapManager {
    private final Context context;
    private String imagesFolder;
    private final Map<String, ImageAsset> imageAssets;
    private final Map<String, Bitmap> bitmaps = new HashMap<String, Bitmap>();

    ImageAssetBitmapManager(Drawable.Callback callback, String imagesFolder, Map<String, ImageAsset> imageAssets) {
        Assert.assertNotNull((Object)callback);
        if (TextUtils.isEmpty((CharSequence)imagesFolder)) {
            throw new IllegalStateException("You must specify an image assets folder by calling setImageAssetsFolder on LottieAnimationView or LottieDrawable.");
        }
        this.imagesFolder = imagesFolder;
        if (this.imagesFolder.charAt(this.imagesFolder.length() - 1) != '/') {
            this.imagesFolder = this.imagesFolder + '/';
        }
        if (!(callback instanceof View)) {
            Log.w((String)"LOTTIE", (String)"LottieDrawable must be inside of a view for images to work.");
            this.imageAssets = new HashMap<String, ImageAsset>();
            this.context = null;
            return;
        }
        this.context = ((View)callback).getContext();
        this.imageAssets = imageAssets;
    }

    Bitmap bitmapForId(String id) {
        Bitmap bitmap = this.bitmaps.get(id);
        if (bitmap == null) {
            InputStream is;
            ImageAsset imageAsset = this.imageAssets.get(id);
            if (imageAsset == null) {
                return null;
            }
            try {
                if (TextUtils.isEmpty((CharSequence)this.imagesFolder)) {
                    throw new IllegalStateException("You must set an images folder before loading an image. Set it with LottieComposition#setImagesFolder or LottieDrawable#setImagesFolder");
                }
                is = this.context.getAssets().open(this.imagesFolder + imageAsset.getFileName());
            }
            catch (IOException e) {
                Log.w((String)"LOTTIE", (String)"Unable to open asset.", (Throwable)e);
                return null;
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inScaled = true;
            opts.inDensity = 160;
            bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
            this.bitmaps.put(id, bitmap);
        }
        return bitmap;
    }

    void recycleBitmaps() {
        Iterator<Map.Entry<String, Bitmap>> it = this.bitmaps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Bitmap> entry = it.next();
            entry.getValue().recycle();
            it.remove();
        }
    }

    boolean hasSameContext(Context context) {
        return context == null && this.context == null || context != null && this.context.equals(context);
    }
}

