/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.Mask;
import com.airbnb.lottie.ShapeGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

class Layer {
    private static final String TAG = Layer.class.getSimpleName();
    private final List<Object> shapes;
    private final LottieComposition composition;
    private final String layerName;
    private final long layerId;
    private final LayerType layerType;
    private final long parentId;
    @Nullable
    private final String refId;
    private final List<Mask> masks;
    private final AnimatableTransform transform;
    private final int solidWidth;
    private final int solidHeight;
    private final int solidColor;
    private final float timeStretch;
    private final float startProgress;
    private final int preCompWidth;
    private final int preCompHeight;
    private final List<Keyframe<Float>> inOutKeyframes;
    private final MatteType matteType;

    private Layer(List<Object> shapes, LottieComposition composition, String layerName, long layerId, LayerType layerType, long parentId, @Nullable String refId, List<Mask> masks, AnimatableTransform transform, int solidWidth, int solidHeight, int solidColor, float timeStretch, float startProgress, int preCompWidth, int preCompHeight, List<Keyframe<Float>> inOutKeyframes, MatteType matteType) {
        this.shapes = shapes;
        this.composition = composition;
        this.layerName = layerName;
        this.layerId = layerId;
        this.layerType = layerType;
        this.parentId = parentId;
        this.refId = refId;
        this.masks = masks;
        this.transform = transform;
        this.solidWidth = solidWidth;
        this.solidHeight = solidHeight;
        this.solidColor = solidColor;
        this.timeStretch = timeStretch;
        this.startProgress = startProgress;
        this.preCompWidth = preCompWidth;
        this.preCompHeight = preCompHeight;
        this.inOutKeyframes = inOutKeyframes;
        this.matteType = matteType;
    }

    LottieComposition getComposition() {
        return this.composition;
    }

    float getTimeStretch() {
        return this.timeStretch;
    }

    float getStartProgress() {
        return this.startProgress;
    }

    List<Keyframe<Float>> getInOutKeyframes() {
        return this.inOutKeyframes;
    }

    long getId() {
        return this.layerId;
    }

    String getName() {
        return this.layerName;
    }

    @Nullable
    String getRefId() {
        return this.refId;
    }

    int getPreCompWidth() {
        return this.preCompWidth;
    }

    int getPreCompHeight() {
        return this.preCompHeight;
    }

    List<Mask> getMasks() {
        return this.masks;
    }

    LayerType getLayerType() {
        return this.layerType;
    }

    MatteType getMatteType() {
        return this.matteType;
    }

    long getParentId() {
        return this.parentId;
    }

    List<Object> getShapes() {
        return this.shapes;
    }

    AnimatableTransform getTransform() {
        return this.transform;
    }

    int getSolidColor() {
        return this.solidColor;
    }

    int getSolidHeight() {
        return this.solidHeight;
    }

    int getSolidWidth() {
        return this.solidWidth;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(this.getName()).append("\n");
        Layer parent = this.composition.layerModelForId(this.getParentId());
        if (parent != null) {
            sb.append("\t\tParents: ").append(parent.getName());
            parent = this.composition.layerModelForId(parent.getParentId());
            while (parent != null) {
                sb.append("->").append(parent.getName());
                parent = this.composition.layerModelForId(parent.getParentId());
            }
            sb.append(prefix).append("\n");
        }
        if (!this.getMasks().isEmpty()) {
            sb.append(prefix).append("\tMasks: ").append(this.getMasks().size()).append("\n");
        }
        if (this.getSolidWidth() != 0 && this.getSolidHeight() != 0) {
            sb.append(prefix).append("\tBackground: ").append(String.format(Locale.US, "%dx%d %X\n", this.getSolidWidth(), this.getSolidHeight(), this.getSolidColor()));
        }
        if (!this.shapes.isEmpty()) {
            sb.append(prefix).append("\tShapes:\n");
            for (Object shape : this.shapes) {
                sb.append(prefix).append("\t\t").append(shape).append("\n");
            }
        }
        return sb.toString();
    }

    static class Factory {
        private Factory() {
        }

        static Layer newInstance(JSONObject json, LottieComposition composition) {
            JSONArray shapesJson;
            String layerName = json.optString("nm");
            String refId = json.optString("refId");
            long layerId = json.optLong("ind");
            int solidWidth = 0;
            int solidHeight = 0;
            int solidColor = 0;
            int preCompWidth = 0;
            int preCompHeight = 0;
            int layerTypeInt = json.optInt("ty", -1);
            LayerType layerType = layerTypeInt < LayerType.Unknown.ordinal() ? LayerType.values()[layerTypeInt] : LayerType.Unknown;
            long parentId = json.optLong("parent", -1L);
            if (layerType == LayerType.Solid) {
                solidWidth = (int)((float)json.optInt("sw") * composition.getScale());
                solidHeight = (int)((float)json.optInt("sh") * composition.getScale());
                solidColor = Color.parseColor((String)json.optString("sc"));
            }
            AnimatableTransform transform = AnimatableTransform.Factory.newInstance(json.optJSONObject("ks"), composition);
            MatteType matteType = MatteType.values()[json.optInt("tt")];
            ArrayList<Object> shapes = new ArrayList<Object>();
            ArrayList<Mask> masks = new ArrayList<Mask>();
            ArrayList<Keyframe<Float>> inOutKeyframes = new ArrayList<Keyframe<Float>>();
            JSONArray jsonMasks = json.optJSONArray("masksProperties");
            if (jsonMasks != null) {
                for (int i = 0; i < jsonMasks.length(); ++i) {
                    Mask mask = Mask.Factory.newMask(jsonMasks.optJSONObject(i), composition);
                    masks.add(mask);
                }
            }
            if ((shapesJson = json.optJSONArray("shapes")) != null) {
                for (int i = 0; i < shapesJson.length(); ++i) {
                    Object shape = ShapeGroup.shapeItemWithJson(shapesJson.optJSONObject(i), composition);
                    if (shape == null) continue;
                    shapes.add(shape);
                }
            }
            float timeStretch = (float)json.optDouble("sr", 1.0);
            float startFrame = (float)json.optDouble("st");
            float frames = composition.getDurationFrames();
            float startProgress = startFrame / frames;
            if (layerType == LayerType.PreComp) {
                preCompWidth = (int)((float)json.optInt("w") * composition.getScale());
                preCompHeight = (int)((float)json.optInt("h") * composition.getScale());
            }
            float inFrame = json.optLong("ip");
            float outFrame = json.optLong("op");
            if (inFrame > 0.0f) {
                Keyframe<Float> preKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(inFrame));
                inOutKeyframes.add(preKeyframe);
            }
            outFrame = outFrame > 0.0f ? outFrame : (float)(composition.getEndFrame() + 1L);
            Keyframe<Float> visibleKeyframe = new Keyframe<Float>(composition, Float.valueOf(1.0f), Float.valueOf(1.0f), null, inFrame, Float.valueOf(outFrame));
            inOutKeyframes.add(visibleKeyframe);
            if (outFrame <= composition.getDurationFrames()) {
                Keyframe<Float> outKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, outFrame, Float.valueOf(composition.getEndFrame()));
                inOutKeyframes.add(outKeyframe);
            }
            return new Layer(shapes, composition, layerName, layerId, layerType, parentId, refId, masks, transform, solidWidth, solidHeight, solidColor, timeStretch, startProgress, preCompWidth, preCompHeight, inOutKeyframes, matteType);
        }
    }

    static enum MatteType {
        None,
        Add,
        Invert,
        Unknown;

    }

    static enum LayerType {
        PreComp,
        Solid,
        Image,
        Null,
        Shape,
        Text,
        Unknown;

    }
}

