/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.FileCompositionLoader;
import com.airbnb.lottie.ImageAsset;
import com.airbnb.lottie.JsonCompositionLoader;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LottieComposition {
    private final Map<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
    private final Map<String, ImageAsset> images = new HashMap<String, ImageAsset>();
    private final LongSparseArray<Layer> layerMap = new LongSparseArray();
    private final List<Layer> layers = new ArrayList<Layer>();
    private final Rect bounds;
    private final long startFrame;
    private final long endFrame;
    private final int frameRate;
    private final float scale;

    private LottieComposition(Rect bounds, long startFrame, long endFrame, int frameRate, float scale) {
        this.bounds = bounds;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.frameRate = frameRate;
        this.scale = scale;
    }

    Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public long getDuration() {
        long frameDuration = this.endFrame - this.startFrame;
        return (long)((float)frameDuration / (float)this.frameRate * 1000.0f);
    }

    long getEndFrame() {
        return this.endFrame;
    }

    List<Layer> getLayers() {
        return this.layers;
    }

    @Nullable
    List<Layer> getPrecomps(String id) {
        return this.precomps.get(id);
    }

    boolean hasImages() {
        return !this.images.isEmpty();
    }

    Map<String, ImageAsset> getImages() {
        return this.images;
    }

    float getDurationFrames() {
        return (float)this.getDuration() * (float)this.frameRate / 1000.0f;
    }

    public float getScale() {
        return this.scale;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener loadedListener) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(context, stream, loadedListener);
        }

        public static Cancellable fromInputStream(Context context, InputStream stream, OnCompositionLoadedListener loadedListener) {
            FileCompositionLoader loader = new FileCompositionLoader(context.getResources(), loadedListener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new InputStream[]{stream});
            return loader;
        }

        static LottieComposition fromFileSync(Context context, String fileName) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(context.getResources(), stream);
        }

        public static Cancellable fromJson(Resources res, JSONObject json, OnCompositionLoadedListener loadedListener) {
            JsonCompositionLoader loader = new JsonCompositionLoader(res, loadedListener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new JSONObject[]{json});
            return loader;
        }

        static LottieComposition fromInputStream(Resources res, InputStream stream) {
            try {
                int size = stream.available();
                byte[] buffer = new byte[size];
                stream.read(buffer);
                String json = new String(buffer, "UTF-8");
                JSONObject jsonObject = new JSONObject(json);
                LottieComposition lottieComposition = Factory.fromJsonSync(res, jsonObject);
                return lottieComposition;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file.", e);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Unable to load JSON.", e);
            }
            finally {
                Utils.closeQuietly(stream);
            }
        }

        static LottieComposition fromJsonSync(Resources res, JSONObject json) {
            Rect bounds = null;
            float scale = res.getDisplayMetrics().density;
            int width = json.optInt("w", -1);
            int height = json.optInt("h", -1);
            if (width != -1 && height != -1) {
                int scaledWidth = (int)((float)width * scale);
                int scaledHeight = (int)((float)height * scale);
                bounds = new Rect(0, 0, scaledWidth, scaledHeight);
            }
            long startFrame = json.optLong("ip", 0L);
            long endFrame = json.optLong("op", 0L);
            int frameRate = json.optInt("fr", 0);
            LottieComposition composition = new LottieComposition(bounds, startFrame, endFrame, frameRate, scale);
            JSONArray assetsJson = json.optJSONArray("assets");
            Factory.parseImages(assetsJson, composition);
            Factory.parsePrecomps(assetsJson, composition);
            Factory.parseLayers(json, composition);
            return composition;
        }

        private static void parseLayers(JSONObject json, LottieComposition composition) {
            JSONArray jsonLayers = json.optJSONArray("layers");
            int length = jsonLayers.length();
            for (int i = 0; i < length; ++i) {
                Layer layer = Layer.Factory.newInstance(jsonLayers.optJSONObject(i), composition);
                Factory.addLayer(composition.layers, (LongSparseArray<Layer>)composition.layerMap, layer);
            }
        }

        private static void parsePrecomps(@Nullable JSONArray assetsJson, LottieComposition composition) {
            if (assetsJson == null) {
                return;
            }
            int length = assetsJson.length();
            for (int i = 0; i < length; ++i) {
                JSONObject assetJson = assetsJson.optJSONObject(i);
                JSONArray layersJson = assetJson.optJSONArray("layers");
                if (layersJson == null) continue;
                ArrayList<Layer> layers = new ArrayList<Layer>(layersJson.length());
                LongSparseArray layerMap = new LongSparseArray();
                for (int j = 0; j < layersJson.length(); ++j) {
                    Layer layer = Layer.Factory.newInstance(layersJson.optJSONObject(j), composition);
                    layerMap.put(layer.getId(), (Object)layer);
                    layers.add(layer);
                }
                String id = assetJson.optString("id");
                composition.precomps.put(id, layers);
            }
        }

        private static void parseImages(@Nullable JSONArray assetsJson, LottieComposition composition) {
            if (assetsJson == null) {
                return;
            }
            int length = assetsJson.length();
            for (int i = 0; i < length; ++i) {
                JSONObject assetJson = assetsJson.optJSONObject(i);
                if (!assetJson.has("p")) continue;
                ImageAsset image = ImageAsset.Factory.newInstance(assetJson);
                composition.images.put(image.getId(), image);
            }
        }

        private static void addLayer(List<Layer> layers, LongSparseArray<Layer> layerMap, Layer layer) {
            layers.add(layer);
            layerMap.put(layer.getId(), (Object)layer);
        }
    }
}

