/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.RectangleShape;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeLayer;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.StaticKeyframeAnimation;
import com.airbnb.lottie.Utils;
import java.util.ArrayList;

class RectLayer
extends AnimatableLayer {
    @Nullable
    private RectShapeLayer fillLayer;
    @Nullable
    private RectShapeLayer strokeLayer;

    RectLayer(RectangleShape rectShape, @Nullable ShapeFill fill, @Nullable ShapeStroke stroke, @Nullable ShapeTrimPath trim, AnimatableTransform transform, Drawable.Callback callback) {
        super(callback);
        this.setTransform(transform.createAnimation());
        if (fill != null) {
            this.fillLayer = new RectShapeLayer(this.getCallback());
            this.fillLayer.setColor((KeyframeAnimation<Integer>)fill.getColor().createAnimation());
            this.fillLayer.setShapeOpacity((KeyframeAnimation<Integer>)fill.getOpacity().createAnimation());
            this.fillLayer.setTransformOpacity((KeyframeAnimation<Integer>)transform.getOpacity().createAnimation());
            this.fillLayer.setRectCornerRadius((KeyframeAnimation<Float>)rectShape.getCornerRadius().createAnimation());
            this.fillLayer.setRectSize((KeyframeAnimation<PointF>)rectShape.getSize().createAnimation());
            this.fillLayer.setRectPosition(rectShape.getPosition().createAnimation());
            if (trim != null) {
                this.fillLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(this.fillLayer);
        }
        if (stroke != null) {
            this.strokeLayer = new RectShapeLayer(this.getCallback());
            this.strokeLayer.setIsStroke();
            this.strokeLayer.setColor((KeyframeAnimation<Integer>)stroke.getColor().createAnimation());
            this.strokeLayer.setShapeOpacity((KeyframeAnimation<Integer>)stroke.getOpacity().createAnimation());
            this.strokeLayer.setTransformOpacity((KeyframeAnimation<Integer>)transform.getOpacity().createAnimation());
            this.strokeLayer.setLineWidth((KeyframeAnimation<Float>)stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList dashPatternAnimations = new ArrayList(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                this.strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            this.strokeLayer.setLineCapType(stroke.getCapType());
            this.strokeLayer.setRectCornerRadius((KeyframeAnimation<Float>)rectShape.getCornerRadius().createAnimation());
            this.strokeLayer.setRectSize((KeyframeAnimation<PointF>)rectShape.getSize().createAnimation());
            this.strokeLayer.setRectPosition(rectShape.getPosition().createAnimation());
            this.strokeLayer.setLineJoinType(stroke.getJoinType());
            if (trim != null) {
                this.strokeLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(this.strokeLayer);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (this.fillLayer != null) {
            this.fillLayer.setAlpha(alpha);
        }
        if (this.strokeLayer != null) {
            this.strokeLayer.setAlpha(alpha);
        }
    }

    private static class RectShapeLayer
    extends ShapeLayer {
        private final BaseKeyframeAnimation.AnimationListener<PointF> sizeChangedListener = new BaseKeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                RectShapeLayer.this.onRectChanged();
            }
        };
        private final BaseKeyframeAnimation.AnimationListener<Float> cornerRadiusChangedListener = new BaseKeyframeAnimation.AnimationListener<Float>(){

            @Override
            public void onValueChanged(Float value) {
                RectShapeLayer.this.onRectChanged();
            }
        };
        private final BaseKeyframeAnimation.AnimationListener<PointF> positionChangedListener = new BaseKeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                RectShapeLayer.this.onRectChanged();
            }
        };
        private final Path path = new Path();
        private final RectF rect = new RectF();
        private BaseKeyframeAnimation<?, Float> rectCornerRadius;
        private BaseKeyframeAnimation<?, PointF> rectPosition;
        private BaseKeyframeAnimation<?, PointF> rectSize;
        private boolean updateRectOnNextDraw;

        RectShapeLayer(Drawable.Callback callback) {
            super(callback);
            this.setPath(new StaticKeyframeAnimation<Path>(this.path));
        }

        void setRectCornerRadius(KeyframeAnimation<Float> rectCornerRadius) {
            if (this.rectCornerRadius != null) {
                this.removeAnimation(rectCornerRadius);
                this.rectCornerRadius.removeUpdateListener(this.cornerRadiusChangedListener);
            }
            this.rectCornerRadius = rectCornerRadius;
            this.addAnimation(rectCornerRadius);
            rectCornerRadius.addUpdateListener(this.cornerRadiusChangedListener);
            this.onRectChanged();
        }

        void setRectSize(KeyframeAnimation<PointF> rectSize) {
            if (this.rectSize != null) {
                this.removeAnimation(this.rectSize);
                this.rectSize.removeUpdateListener(this.sizeChangedListener);
            }
            this.rectSize = rectSize;
            this.addAnimation(rectSize);
            rectSize.addUpdateListener(this.sizeChangedListener);
            this.onRectChanged();
        }

        void setRectPosition(BaseKeyframeAnimation<?, PointF> rectPosition) {
            if (this.rectPosition != null) {
                this.removeAnimation(this.rectPosition);
                this.rectPosition.removeUpdateListener(this.positionChangedListener);
            }
            this.rectPosition = rectPosition;
            this.addAnimation(rectPosition);
            rectPosition.addUpdateListener(this.positionChangedListener);
            this.onRectChanged();
        }

        private void onRectChanged() {
            this.updateRectOnNextDraw = true;
            this.invalidateSelf();
        }

        private void updateRect() {
            float halfHeight;
            float halfWidth;
            float maxRadius;
            this.path.reset();
            if (this.rectSize == null) {
                return;
            }
            PointF size = this.rectSize.getValue();
            float radius = this.rectCornerRadius == null ? 0.0f : this.rectCornerRadius.getValue().floatValue();
            if (radius > (maxRadius = Math.min(halfWidth = size.x / 2.0f, halfHeight = size.y / 2.0f))) {
                radius = maxRadius;
            }
            PointF position = this.rectPosition == null ? Utils.emptyPoint() : this.rectPosition.getValue();
            this.path.moveTo(position.x + halfWidth, position.y - halfHeight + radius);
            this.path.lineTo(position.x + halfWidth, position.y + halfHeight - radius);
            if (radius > 0.0f) {
                this.rect.set(position.x + halfWidth - 2.0f * radius, position.y + halfHeight - 2.0f * radius, position.x + halfWidth, position.y + halfHeight);
                this.path.arcTo(this.rect, 0.0f, 90.0f, false);
            }
            this.path.lineTo(position.x - halfWidth + radius, position.y + halfHeight);
            if (radius > 0.0f) {
                this.rect.set(position.x - halfWidth, position.y + halfHeight - 2.0f * radius, position.x - halfWidth + 2.0f * radius, position.y + halfHeight);
                this.path.arcTo(this.rect, 90.0f, 90.0f, false);
            }
            this.path.lineTo(position.x - halfWidth, position.y - halfHeight + 2.0f * radius);
            if (radius > 0.0f) {
                this.rect.set(position.x - halfWidth, position.y - halfHeight, position.x - halfWidth + 2.0f * radius, position.y - halfHeight + 2.0f * radius);
                this.path.arcTo(this.rect, 180.0f, 90.0f, false);
            }
            this.path.lineTo(position.x + halfWidth - 2.0f * radius, position.y - halfHeight);
            if (radius > 0.0f) {
                this.rect.set(position.x + halfWidth - 2.0f * radius, position.y - halfHeight, position.x + halfWidth, position.y - halfHeight + 2.0f * radius);
                this.path.arcTo(this.rect, 270.0f, 90.0f, false);
            }
            this.path.close();
            this.onPathChanged();
        }

        @Override
        public void draw(@NonNull Canvas canvas) {
            if (this.updateRectOnNextDraw) {
                this.updateRectOnNextDraw = false;
                this.updateRect();
            }
            super.draw(canvas);
        }
    }
}

