/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.IntegerKeyframeAnimation;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONObject;

class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    private AnimatableIntegerValue() {
        super(100);
    }

    AnimatableIntegerValue(List<Keyframe<Integer>> keyframes, Integer initialValue) {
        super(keyframes, initialValue);
    }

    public KeyframeAnimation<Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new IntegerKeyframeAnimation(this.keyframes);
    }

    @Override
    public Integer getInitialValue() {
        return (Integer)this.initialValue;
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<Integer> {
        private static final ValueFactory INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public Integer valueFromObject(Object object, float scale) {
            return Math.round(JsonUtils.valueFromObject(object) * scale);
        }
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableIntegerValue newInstance() {
            return new AnimatableIntegerValue();
        }

        static AnimatableIntegerValue newInstance(JSONObject json, LottieComposition composition) {
            AnimatableValueParser.Result<Integer> result = AnimatableValueParser.newInstance(json, 1.0f, composition, ValueFactory.INSTANCE).parseJson();
            Integer initialValue = (Integer)result.initialValue;
            return new AnimatableIntegerValue(result.keyframes, initialValue);
        }
    }
}

