/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.CircleShape;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.TrimPathContent;
import com.airbnb.lottie.Utils;
import java.util.List;

class EllipseContent
implements PathContent,
BaseKeyframeAnimation.AnimationListener {
    private static final float ELLIPSE_CONTROL_POINT_PERCENTAGE = 0.55228f;
    private final Path path = new Path();
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation<?, PointF> sizeAnimation;
    private final BaseKeyframeAnimation<?, PointF> positionAnimation;
    @Nullable
    private TrimPathContent trimPath;
    private boolean isPathValid;

    EllipseContent(LottieDrawable lottieDrawable, BaseLayer layer, CircleShape circleShape) {
        this.lottieDrawable = lottieDrawable;
        this.sizeAnimation = circleShape.getSize().createAnimation();
        this.positionAnimation = circleShape.getPosition().createAnimation();
        layer.addAnimation(this.sizeAnimation);
        layer.addAnimation(this.positionAnimation);
        this.sizeAnimation.addUpdateListener(this);
        this.positionAnimation.addUpdateListener(this);
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsBefore.size(); ++i) {
            Content content = contentsBefore.get(i);
            if (!(content instanceof TrimPathContent) || ((TrimPathContent)content).getType() != ShapeTrimPath.Type.Simultaneously) continue;
            this.trimPath = (TrimPathContent)content;
            this.trimPath.addListener(this);
        }
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        PointF size = this.sizeAnimation.getValue();
        float halfWidth = size.x / 2.0f;
        float halfHeight = size.y / 2.0f;
        float cpW = halfWidth * 0.55228f;
        float cpH = halfHeight * 0.55228f;
        this.path.reset();
        this.path.moveTo(0.0f, -halfHeight);
        this.path.cubicTo(0.0f + cpW, -halfHeight, halfWidth, 0.0f - cpH, halfWidth, 0.0f);
        this.path.cubicTo(halfWidth, 0.0f + cpH, 0.0f + cpW, halfHeight, 0.0f, halfHeight);
        this.path.cubicTo(0.0f - cpW, halfHeight, -halfWidth, 0.0f + cpH, -halfWidth, 0.0f);
        this.path.cubicTo(-halfWidth, 0.0f - cpH, 0.0f - cpW, -halfHeight, 0.0f, -halfHeight);
        PointF position = this.positionAnimation.getValue();
        this.path.offset(position.x, position.y);
        this.path.close();
        Utils.applyTrimPathIfNeeded(this.path, this.trimPath);
        this.isPathValid = true;
        return this.path;
    }
}

