/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.TrimPathContent;
import com.airbnb.lottie.Utils;
import java.util.List;

class ShapeContent
implements PathContent,
BaseKeyframeAnimation.AnimationListener {
    private final Path path = new Path();
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation<?, Path> shapeAnimation;
    private boolean isPathValid;
    @Nullable
    private TrimPathContent trimPath;

    ShapeContent(LottieDrawable lottieDrawable, BaseLayer layer, ShapePath shape) {
        this.lottieDrawable = lottieDrawable;
        this.shapeAnimation = shape.getShapePath().createAnimation();
        layer.addAnimation(this.shapeAnimation);
        this.shapeAnimation.addUpdateListener(this);
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsBefore.size(); ++i) {
            Content content = contentsBefore.get(i);
            if (!(content instanceof TrimPathContent) || ((TrimPathContent)content).getType() != ShapeTrimPath.Type.Simultaneously) continue;
            this.trimPath = (TrimPathContent)content;
            this.trimPath.addListener(this);
        }
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        this.path.set(this.shapeAnimation.getValue());
        this.path.setFillType(Path.FillType.EVEN_ODD);
        Utils.applyTrimPathIfNeeded(this.path, this.trimPath);
        this.isPathValid = true;
        return this.path;
    }
}

