/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.annotation.TargetApi;
import android.graphics.Path;
import android.os.Build;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.ContentGroup;
import com.airbnb.lottie.MergePaths;
import com.airbnb.lottie.PathContent;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=19)
class MergePathsContent
implements PathContent {
    private final Path firstPath = new Path();
    private final Path remainderPath = new Path();
    private final Path path = new Path();
    private final String name;
    private final List<PathContent> pathContents = new ArrayList<PathContent>();
    private final MergePaths mergePaths;

    MergePathsContent(MergePaths mergePaths) {
        if (Build.VERSION.SDK_INT < 19) {
            throw new IllegalStateException("Merge paths are not supported pre-KitKat.");
        }
        this.name = mergePaths.getName();
        this.mergePaths = mergePaths;
    }

    void addContentIfNeeded(Content content) {
        if (content instanceof PathContent) {
            this.pathContents.add((PathContent)content);
        }
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < this.pathContents.size(); ++i) {
            this.pathContents.get(i).setContents(contentsBefore, contentsAfter);
        }
    }

    @Override
    public Path getPath() {
        this.path.reset();
        switch (this.mergePaths.getMode()) {
            case Merge: {
                this.addPaths();
                break;
            }
            case Add: {
                this.opFirstPathWithRest(Path.Op.UNION);
                break;
            }
            case Subtract: {
                this.opFirstPathWithRest(Path.Op.REVERSE_DIFFERENCE);
                break;
            }
            case Intersect: {
                this.opFirstPathWithRest(Path.Op.INTERSECT);
                break;
            }
            case ExcludeIntersections: {
                this.opFirstPathWithRest(Path.Op.XOR);
            }
        }
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void addPaths() {
        for (int i = 0; i < this.pathContents.size(); ++i) {
            this.path.addPath(this.pathContents.get(i).getPath());
        }
    }

    @TargetApi(value=19)
    private void opFirstPathWithRest(Path.Op op) {
        this.remainderPath.reset();
        this.firstPath.reset();
        for (int i = this.pathContents.size() - 1; i >= 1; --i) {
            PathContent content = this.pathContents.get(i);
            if (content instanceof ContentGroup) {
                List<PathContent> pathList = ((ContentGroup)content).getPathList();
                for (int j = pathList.size() - 1; j >= 0; --j) {
                    Path path = pathList.get(j).getPath();
                    path.transform(((ContentGroup)content).getTransformationMatrix());
                    this.remainderPath.addPath(path);
                }
                continue;
            }
            this.remainderPath.addPath(content.getPath());
        }
        PathContent lastContent = this.pathContents.get(0);
        if (lastContent instanceof ContentGroup) {
            List<PathContent> pathList = ((ContentGroup)lastContent).getPathList();
            for (int j = 0; j < pathList.size(); ++j) {
                Path path = pathList.get(j).getPath();
                path.transform(((ContentGroup)lastContent).getTransformationMatrix());
                this.firstPath.addPath(path);
            }
        } else {
            this.firstPath.set(lastContent.getPath());
        }
        this.path.op(this.firstPath, this.remainderPath, op);
    }
}

