/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.PathKeyframe;
import com.airbnb.lottie.PathKeyframeAnimation;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class AnimatablePathValue
implements AnimatableValue<PointF> {
    private final List<PathKeyframe> keyframes = new ArrayList<PathKeyframe>();
    private PointF initialPoint;

    static AnimatableValue<PointF> createAnimatablePathOrSplitDimensionPath(JSONObject json, LottieComposition composition) {
        if (json.has("k")) {
            return new AnimatablePathValue(json.opt("k"), composition);
        }
        return new AnimatableSplitDimensionPathValue(AnimatableFloatValue.Factory.newInstance(json.optJSONObject("x"), composition), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("y"), composition));
    }

    AnimatablePathValue() {
        this.initialPoint = new PointF(0.0f, 0.0f);
    }

    AnimatablePathValue(Object json, LottieComposition composition) {
        if (this.hasKeyframes(json)) {
            JSONArray jsonArray = (JSONArray)json;
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject jsonKeyframe = jsonArray.optJSONObject(i);
                PathKeyframe keyframe = PathKeyframe.Factory.newInstance(jsonKeyframe, composition, ValueFactory.INSTANCE);
                this.keyframes.add(keyframe);
            }
            Keyframe.setEndFrames(this.keyframes);
        } else {
            this.initialPoint = JsonUtils.pointFromJsonArray((JSONArray)json, composition.getDpScale());
        }
    }

    private boolean hasKeyframes(Object json) {
        if (!(json instanceof JSONArray)) {
            return false;
        }
        Object firstObject = ((JSONArray)json).opt(0);
        return firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t");
    }

    public KeyframeAnimation<PointF> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<PointF>(this.initialPoint);
        }
        return new PathKeyframeAnimation((List<? extends Keyframe<PointF>>)this.keyframes);
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyframes.isEmpty();
    }

    public String toString() {
        return "initialPoint=" + this.initialPoint;
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<PointF> {
        private static final AnimatableValue.Factory<PointF> INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public PointF valueFromObject(Object object, float scale) {
            return JsonUtils.pointFromJsonArray((JSONArray)object, scale);
        }
    }
}

